/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.business;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.common.utils.DeviceUtil;
import com.hpplay.imsdk.IMConnectBean;
import com.hpplay.imsdk.IMEntrance;
import com.hpplay.imsdk.OnConnectServerListener;
import com.hpplay.imsdk.OnReceiveMessageListener;
import com.hpplay.sdk.source.bean.DramaInfoBean;
import com.hpplay.sdk.source.bean.OutParameter;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.business.BusinessEntity;
import com.hpplay.sdk.source.business.IMQueue;
import com.hpplay.sdk.source.business.cloud.AuthSDK;
import com.hpplay.sdk.source.business.cloud.CapbilityBean;
import com.hpplay.sdk.source.business.cloud.CloudAPI;
import com.hpplay.sdk.source.business.cloud.RightsManager;
import com.hpplay.sdk.source.business.cloud.SourceDataReport;
import com.hpplay.sdk.source.common.store.Preference;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.common.utils.HapplayUtils;
import com.hpplay.sdk.source.d.a;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.pass.NetCastPassSender;
import com.hpplay.sdk.source.pass.Parser;
import com.hpplay.sdk.source.pass.Pass;
import com.hpplay.sdk.source.pass.bean.NetPassBean;
import com.hpplay.sdk.source.pass.sinktouch.SinkTouchEventIMChannel;
import com.hpplay.sdk.source.process.ConnectManager;
import com.hpplay.sdk.source.process.LelinkSdkManager;
import com.hpplay.sdk.source.protocol.browser.ble.BleProxy;
import com.hpplay.sdk.source.protocol.connect.AbsIMMsgReceiveListener;
import com.hpplay.sdk.source.protocol.connect.ConnectBridge;
import com.hpplay.sdk.source.protocol.connect.OnConnectIMListener;
import com.hpplay.sdk.source.protocol.connect.OnConnectSinkListener;
import com.hpplay.sdk.source.protocol.connect.OnPlayStateListener;
import com.hpplay.sdk.source.utils.Encode;
import com.hpplay.sdk.source.utils.Feature;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class PublicCastClient {
    public static final int PLAY_STATE_PROGRESS = 0;
    public static final int PLAY_STATE_START = 1;
    public static final int PLAY_STATE_PAUSE = 2;
    public static final int PLAY_STATE_STOP = 3;
    public static final int PLAY_STATE_ERROR = 4;
    public static final int CONNECT_WAITING = 1;
    public static final int CONNECT_ALLOW = 2;
    public static final int CONNECT_REJECT = 3;
    public static final int CONNECT_DEFAULT = 0;
    public static final int CONNECT_DETAIL_TIMEOUT = 1;
    public static final int CONNECT_DETAIL_MANUAL = 2;
    public static final int CONNECT_DETAIL_IN_LIST = 3;
    private static final String TAG = "PublicCastClient";
    private static final int ACTION_PUSH = 33554943;
    private static final int ACTION_MIRROR = 0x20002FF;
    private static final int ACTION_PLAY_STATUS = 33555455;
    private static final int ACTION_PLAY_CONTROL = 33555711;
    private static final int ACTION_CONNECT = 33555967;
    private static final int ACTION_GET_TV_INFO = 33556735;
    private static final int ACTION_INTERACTIVE = 33559295;
    private static final int ACTION_CONNECT_MESSAGE = 33556479;
    private static final int ACTION_PASS = 33560575;
    private static final int ACTION_UPLOAD_LOG = 33566975;
    private static final int ACTION_REVERSE_EVENT = 33567999;
    private static final int ACTION_SINK_SERVICE_MESSAGE = 33568255;
    private static final int ACTION_SINK_ACCEPT_MEETING = 34605055;
    private static final int ACTION_MEETING_KICK_OFF = 34604031;
    private static final int ACTION_MEETING_CLOSE = 34604287;
    private static final int ACTION_APP_MSG_START = 0x30000FF;
    private static final int ACTION_APP_MSG_END = 0x4FFFFFF;
    private static final int ACTION_DEVICE_RIGHTS_UPDATE = 33568511;
    private static final String CONNECT_ACTION = "/Connect";
    private static final String PUSH_ACTION = "/PushUrl";
    private static final String COMMAND_CONNECT = "020005ff";
    private static final String COMMAND_PUSH = "020001ff";
    private static final String COMMAND_PLAY_CONTROL = "020004ff";
    private static final String COMMAND_PUSH_LIST = "020037ff";
    private static final String COMMAND_DISCONNECT = "020038ff";
    private static final String KEY_UID = "uid";
    private static final String KEY_U = "u";
    private static final String KEY_APPID = "appid";
    private static final String KEY_TOKEN = "token";
    private static final String KEY_CONTENT = "content";
    private static final String KEY_RECEIVER_APPID = "ra";
    private static final String KEY_PROTOCOL_VERSION = "ver";
    private static final String KEY_USERINFO = "user_info";
    private static final String KEY_PASSTHROUGH_CONTENT = "pc";
    private static final int PLAY_ACTION_START = 1;
    private static final int PLAY_ACTION_PAUSE = 2;
    private static final int PLAY_ACTION_STOP = 3;
    private static final int PLAY_ACTION_SEEK = 4;
    private static final int PLAY_ACTION_VOLUME_TO = 5;
    private static final int PLAY_ACTION_VOLUME_ADD = 6;
    private static final int PLAY_ACTION_VOLUME_REDUCE = 7;
    private static final int PLAY_ACTION_SET_PLAY_ID = 8;
    private static final int PLAY_ACTION_NEXt_DRAMA = 9;
    private static final int PLAY_ACTION_PRE_DRAMA = 10;
    private static final int PLAY_ACTION_SELECT_TRACK = 11;
    private static final int PLAY_CALLBACK_PLAYING = 0;
    private static final int PLAY_CALLBACK_START = 1;
    private static final int PLAY_CALLBACK_PAUSE = 2;
    private static final int PLAY_CALLBACK_STOP = 3;
    private static final int PLAY_CALLBACK_ERROR = 4;
    private static final int WHAT_CONNECT_TIMEOUT_CHECK = 1;
    private static PublicCastClient mInstance;
    private static int mRCEventCount;
    private final int IM_AUTH_RESULT_SUCCESS = 0;
    private final int IM_AUTH_RESULT_FAIL = 1;
    private final int IM_AUTH_RESULT_SERVER_FULL = 2;
    private Context mContext;
    private String mUrl;
    private String mToken;
    private String mFe;
    private NetCastPassSender mNetCastPassSender;
    private OnConnectSinkListener mTVConnectListener = null;
    private List<OnConnectIMListener> mIMListenerList = new ArrayList<OnConnectIMListener>();
    private OnPlayStateListener mPlayStateListener = null;
    private BrowserInfo mIMInfo;
    private List<AbsIMMsgReceiveListener> mIMMsgReceiveListenerList = new ArrayList<AbsIMMsgReceiveListener>();
    private Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    SourceLog.w(PublicCastClient.TAG, "WHAT_CONNECT_TIMEOUT_CHECK");
                    if (PublicCastClient.this.mTVConnectListener == null) break;
                    PublicCastClient.this.mTVConnectListener.onDisconnect(212014);
                }
            }
            return false;
        }
    });
    private OnReceiveMessageListener mMsgListener = new OnReceiveMessageListener(){

        @Override
        public void onMsg(long l2, String string) {
            SourceLog.i(PublicCastClient.TAG, "OnReceiveMessageListener action\uff1a" + l2);
            switch ((int)l2) {
                case 0x20002FF: {
                    try {
                        JSONObject jSONObject = new JSONObject(string);
                        String string2 = jSONObject.optString("pol");
                        String string3 = jSONObject.optString("app_id");
                        String string4 = jSONObject.optString("sid");
                        String string5 = jSONObject.optString("suid");
                        String string6 = jSONObject.optString("roomid");
                        String string7 = jSONObject.optString("username");
                        String string8 = jSONObject.optString("uri");
                        if (LelinkSdkManager.getInstance().mOuterCloudMirrorPlayListener == null) {
                            SourceLog.w(PublicCastClient.TAG, "ACTION_MIRROR ignore");
                            return;
                        }
                        SourceLog.i(PublicCastClient.TAG, "ACTION_MIRROR");
                        LelinkSdkManager.getInstance().mOuterCloudMirrorPlayListener.onCloudMirrorStart(true, string7, string6, string5, string4, string8);
                        SourceDataReport.getInstance().onReceiveCloudMirrorConnectRequest(string4, string4, string8, string6);
                    }
                    catch (Exception exception) {
                        SourceLog.w(PublicCastClient.TAG, exception);
                    }
                    break;
                }
                case 33560575: {
                    SourceLog.i(PublicCastClient.TAG, "ACTION_PASS " + string);
                    NetPassBean netPassBean = NetPassBean.formJson(string);
                    if (null == netPassBean) break;
                    PublicCastClient.this.processPassMsg(netPassBean.pc);
                    break;
                }
                case 33566975: {
                    SourceLog.i(PublicCastClient.TAG, "ACTION_UPLOAD_LOG");
                    break;
                }
                case 33559295: {
                    SourceLog.i(PublicCastClient.TAG, "ACTION_INTERACTIVE do nothing");
                    break;
                }
                case 33556479: {
                    PublicCastClient.this.resolveConnectMsg(string);
                    break;
                }
                case 33555455: {
                    PublicCastClient.this.resolvePlayStateMsg(string);
                    break;
                }
                case 33567999: {
                    SourceLog.i(PublicCastClient.TAG, "ACTION_REVERSE_EVENT");
                    PublicCastClient.this.reverseEventMsg(string);
                    break;
                }
                case 33568255: {
                    SourceLog.i(PublicCastClient.TAG, "ACTION_SINK_SERVICE_MESSAGE");
                    PublicCastClient.this.reveiveSinkServiceMsg(1, string);
                    break;
                }
                case 34605055: {
                    PublicCastClient.this.reveiveSinkServiceMsg(2, string);
                    break;
                }
                case 34604031: {
                    PublicCastClient.this.reveiveSinkServiceMsg(3, string);
                    break;
                }
                case 34604287: {
                    PublicCastClient.this.reveiveSinkServiceMsg(4, string);
                    break;
                }
                case 33568511: {
                    SourceLog.i(PublicCastClient.TAG, "ACTION_DEVICE_RIGHTS_UPDATE");
                    RightsManager.getInstance().vipAuth();
                    break;
                }
                default: {
                    if (l2 < 0x30000FFL || l2 > 0x4FFFFFFL) break;
                    SourceLog.i(PublicCastClient.TAG, "onMsg IM app msg");
                }
            }
        }
    };
    private boolean isCallbackSeverFailed = false;
    private OnConnectServerListener mServerListener = new OnConnectServerListener(){

        @Override
        public void onConnectSuccess() {
            SourceLog.i(PublicCastClient.TAG, "onConnectSuccess");
            BleProxy.startPublish(PublicCastClient.this.mContext, Preference.getInstance().get("key_device_id"));
            PublicCastClient.this.isCallbackSeverFailed = false;
            for (OnConnectIMListener onConnectIMListener : PublicCastClient.this.mIMListenerList) {
                onConnectIMListener.onConnectSuccess();
            }
        }

        @Override
        public void onConnectFailed() {
            if (PublicCastClient.this.isCallbackSeverFailed) {
                SourceLog.i(PublicCastClient.TAG, "onConnectFailed ignore");
                return;
            }
            for (OnConnectIMListener onConnectIMListener : PublicCastClient.this.mIMListenerList) {
                PublicCastClient.this.isCallbackSeverFailed = true;
                onConnectIMListener.onConnectFailed();
            }
        }

        @Override
        public void onRestart() {
            SourceLog.i(PublicCastClient.TAG, "onRestart");
            PublicCastClient.this.reconnect();
        }

        @Override
        public void onAuthCallback(String string) {
            SourceLog.i(PublicCastClient.TAG, "authResult,result: " + string);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                try {
                    JSONObject jSONObject = new JSONObject(string);
                    int n2 = jSONObject.optInt("code");
                    if (n2 == 2) {
                        AuthSDK.getInstance().updateIMRootUrl();
                    }
                }
                catch (Exception exception) {
                    SourceLog.w(PublicCastClient.TAG, exception);
                }
            }
        }
    };

    private PublicCastClient(Context context) {
        this.mContext = context;
        this.mNetCastPassSender = new NetCastPassSender(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context context) {
        Class<PublicCastClient> clazz = PublicCastClient.class;
        synchronized (PublicCastClient.class) {
            if (mInstance == null) {
                mInstance = new PublicCastClient(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized PublicCastClient getInstance() {
        if (mInstance == null) {
            PublicCastClient.init((Context)HapplayUtils.getApplication());
        }
        return mInstance;
    }

    public void reconnect() {
        if (TextUtils.isEmpty((CharSequence)this.mUrl) || TextUtils.isEmpty((CharSequence)this.mToken)) {
            SourceLog.w(TAG, "reconnect ignore");
            return;
        }
        SourceLog.i(TAG, "reconnect");
        this.connectServer(this.mUrl, this.mToken, null);
    }

    public void connectServer(String string, String string2, OnConnectIMListener onConnectIMListener) {
        Object object;
        String string3;
        if (Feature.isDisableIM()) {
            return;
        }
        if (onConnectIMListener != null && !this.mIMListenerList.contains(onConnectIMListener)) {
            this.mIMListenerList.add(onConnectIMListener);
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            SourceLog.i(TAG, "connectServer ignore,invalid url");
            return;
        }
        this.isCallbackSeverFailed = false;
        this.mUrl = string;
        this.mToken = string2;
        SourceLog.i(TAG, "connectServer: " + string);
        IMEntrance.getInstance().disconnect();
        CapbilityBean capbilityBean = new CapbilityBean();
        capbilityBean.localip = DeviceUtil.getIPAddress(this.mContext);
        try {
            capbilityBean.pol = Feature.cloudMirrorSupportProtocol();
            capbilityBean.fe = "10000000";
            capbilityBean.name = !TextUtils.isEmpty((CharSequence)DeviceUtil.getBluetoothName()) ? URLEncoder.encode(DeviceUtil.getBluetoothName(), "utf-8") : "uk";
            try {
                string3 = null;
                try {
                    object = (WifiManager)this.mContext.getApplicationContext().getSystemService("wifi");
                    WifiInfo wifiInfo = object.getConnectionInfo();
                    string3 = wifiInfo.getBSSID();
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    capbilityBean.bssid = URLEncoder.encode(string3, "utf-8");
                }
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        capbilityBean.localport = Session.getInstance().serverPort + "";
        string3 = capbilityBean.encode().toString();
        object = new IMConnectBean();
        object.imUrl = this.mUrl;
        object.uid = Session.getInstance().getUID();
        object.appid = Session.getInstance().appKey;
        object.sdkVersion = 40719;
        object.token = this.mToken;
        object.capability = string3;
        IMEntrance.getInstance().setReceiveMessageListener(this.mMsgListener);
        IMEntrance.getInstance().setOnConnectListener(this.mServerListener);
        IMEntrance.getInstance().connect((IMConnectBean)object);
    }

    public void removeConnectIMListener(OnConnectIMListener onConnectIMListener) {
        if (this.mIMListenerList.contains(onConnectIMListener)) {
            this.mIMListenerList.remove(onConnectIMListener);
        }
    }

    private boolean isServerConnected() {
        return IMEntrance.getInstance().isConnected();
    }

    public void disconnectServer() {
        SourceLog.i(TAG, "disconnectServer");
        IMEntrance.getInstance().disconnect();
    }

    public void setOnPlayStateListener(OnPlayStateListener onPlayStateListener) {
        this.mPlayStateListener = onPlayStateListener;
    }

    public void connectTV(BrowserInfo browserInfo, String string, String string2, String string3, OnConnectSinkListener onConnectSinkListener) {
        this.mTVConnectListener = onConnectSinkListener;
        this.mFe = null;
        if (!this.isServerConnected()) {
            SourceLog.w(TAG, "connectTV ignore, is not connect server yet");
            return;
        }
        this.mIMInfo = browserInfo;
        JSONObject jSONObject = new JSONObject();
        try {
            CharSequence charSequence;
            jSONObject.put("sid", (Object)string3);
            jSONObject.put("suid", (Object)Session.getInstance().getUID());
            jSONObject.put("shid", (Object)Session.getInstance().getHID());
            if (!TextUtils.isEmpty((CharSequence)string)) {
                jSONObject.put("sname", (Object)string);
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                jSONObject.put("sicon", (Object)string2);
            }
            jSONObject.put("sdkv", (Object)"4.07.19");
            jSONObject.put("app_id", (Object)"2004");
            jSONObject.put("mac", (Object)Session.getInstance().getMac());
            jSONObject.put("sm", (Object)Pass.SM_PASS_THROUGH);
            jSONObject.put("vuuid", (Object)Preference.getInstance().get("key_uuid"));
            jSONObject.put("vsession", (Object)Preference.getInstance().get("key_session"));
            jSONObject.put("tid", (Object)Session.getInstance().tid);
            try {
                charSequence = Session.getInstance().getIMEI();
                jSONObject.put("sdid", (Object)charSequence);
                jSONObject.put("uuid", (Object)Session.getInstance().getIMEI());
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
            jSONObject.put("sc", (Object)Session.getInstance().appKey);
            jSONObject.put("s_oaid", (Object)DeviceUtil.getOAID(this.mContext));
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(COMMAND_CONNECT).append(",").append(jSONObject.toString());
            JSONObject jSONObject2 = this.genConnectContent(((StringBuffer)charSequence).toString(), browserInfo.getUid());
            AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sGLSBRoot + CONNECT_ACTION, jSONObject2.toString());
            asyncHttpParameter.in.requestMethod = 1;
            IMQueue.getInstance().addTask(asyncHttpParameter, new AsyncHttpRequestListener(){

                @Override
                public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                    if (asyncHttpParameter.out != null && asyncHttpParameter.out.resultType == 2) {
                        return;
                    }
                    if (asyncHttpParameter.out == null || TextUtils.isEmpty((CharSequence)asyncHttpParameter.out.result)) {
                        if (PublicCastClient.this.mTVConnectListener != null) {
                            PublicCastClient.this.mTVConnectListener.onDisconnect(212011);
                        }
                        return;
                    }
                    String string = asyncHttpParameter.out.result;
                    SourceLog.debug(PublicCastClient.TAG, "connectTV onRequestResult " + string);
                    try {
                        JSONObject jSONObject = new JSONObject(string);
                        int n2 = jSONObject.optInt("status");
                        if (n2 == 200) {
                            SourceLog.w(PublicCastClient.TAG, "send connectTV success");
                            return;
                        }
                        if (n2 == 403) {
                            SourceLog.w(PublicCastClient.TAG, "connectTV onRequestResult " + string);
                            if (PublicCastClient.this.mTVConnectListener != null) {
                                PublicCastClient.this.mTVConnectListener.onDisconnect(212018);
                            }
                            return;
                        }
                        SourceLog.w(PublicCastClient.TAG, "connectTV onRequestResult " + string);
                    }
                    catch (Exception exception) {
                        SourceLog.w(PublicCastClient.TAG, exception);
                    }
                    if (PublicCastClient.this.mTVConnectListener != null) {
                        PublicCastClient.this.mTVConnectListener.onDisconnect(212011);
                    }
                }
            });
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private JSONObject genConnectContent(String string, String string2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(KEY_UID, (Object)Session.getInstance().getUID());
            jSONObject.put(KEY_U, (Object)string2);
            jSONObject.put(KEY_APPID, (Object)Session.getInstance().appKey);
            jSONObject.put(KEY_TOKEN, (Object)a.a());
            jSONObject.put(KEY_USERINFO, (Object)string);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return jSONObject;
    }

    public void play(OutParameter outParameter, String string, AsyncHttpRequestListener asyncHttpRequestListener) {
        StringBuffer stringBuffer = new StringBuffer();
        JSONObject jSONObject = new JSONObject();
        try {
            Object object;
            String string2 = outParameter.currentBrowserInfo.getUid();
            try {
                jSONObject.put("url", (Object)URLEncoder.encode(outParameter.getPlayUrl(), "utf-8"));
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
            jSONObject.put("suid", (Object)Session.getInstance().getUID());
            jSONObject.put("uri", (Object)outParameter.urlID);
            jSONObject.put("timeout", (Object)"5");
            jSONObject.put("sdkv", (Object)"4.07.19");
            jSONObject.put("app_id", (Object)Session.getInstance().appKey);
            jSONObject.put("sid", (Object)outParameter.session);
            jSONObject.put("pos", outParameter.startPosition);
            jSONObject.put("mt", outParameter.mimeType);
            jSONObject.put(KEY_PASSTHROUGH_CONTENT, (Object)string);
            SourceLog.i(TAG, "SID" + outParameter.session);
            if (outParameter.urls != null && outParameter.urls.length > 0) {
                object = new JSONArray();
                for (DramaInfoBean dramaInfoBean : outParameter.urls) {
                    object.put((Object)dramaInfoBean.toJson());
                }
                jSONObject.put("playid", (Object)outParameter.dramaID);
                jSONObject.put("period", outParameter.period);
                jSONObject.put("playlist", object);
                jSONObject.put("prop-type", (Object)"set-playlist");
                jSONObject.put("headduration", outParameter.headLength);
                jSONObject.put("tailduration", outParameter.tailLength);
                stringBuffer.append(COMMAND_PUSH_LIST).append(",").append(jSONObject.toString());
            } else {
                try {
                    jSONObject.put("url", (Object)URLEncoder.encode(outParameter.getPlayUrl(), "utf-8"));
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
                stringBuffer.append(COMMAND_PUSH).append(",").append(jSONObject.toString());
            }
            object = null;
            try {
                object = outParameter.currentBrowserInfo.getExtras().get("a");
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
            JSONObject jSONObject2 = this.genPostContent(stringBuffer.toString(), (String)object, string2);
            SourceLog.i(TAG, "play push: " + jSONObject2.toString());
            AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sGLSBRoot + PUSH_ACTION, jSONObject2.toString());
            asyncHttpParameter.in.requestMethod = 1;
            IMQueue.getInstance().addTask(asyncHttpParameter, asyncHttpRequestListener);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void setPlayList(OutParameter outParameter, String string, DramaInfoBean[] jSONObject, int n2, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer();
        JSONObject jSONObject2 = new JSONObject();
        try {
            Object object;
            String string2 = outParameter.currentBrowserInfo.getUid();
            jSONObject2.put("suid", (Object)Session.getInstance().getUID());
            jSONObject2.put("uri", (Object)outParameter.urlID);
            jSONObject2.put("timeout", (Object)"5");
            jSONObject2.put("sdkv", (Object)"4.07.19");
            jSONObject2.put("app_id", (Object)Session.getInstance().appKey);
            jSONObject2.put("sid", (Object)outParameter.session);
            jSONObject2.put("pos", outParameter.startPosition);
            jSONObject2.put("mt", outParameter.mimeType);
            jSONObject2.put(KEY_PASSTHROUGH_CONTENT, (Object)"");
            if (!"clear-playlist".equals(string)) {
                object = new JSONArray();
                for (DramaInfoBean dramaInfoBean : jSONObject) {
                    object.put((Object)dramaInfoBean.toJson());
                }
                jSONObject2.put("period", n2);
                jSONObject2.put("playlist", object);
                jSONObject2.put("headduration", n3);
                jSONObject2.put("tailduration", n4);
            }
            jSONObject2.put("prop-type", (Object)string);
            stringBuffer.append(COMMAND_PUSH_LIST).append(",").append(jSONObject2.toString());
            object = null;
            try {
                object = outParameter.currentBrowserInfo.getExtras().get("a");
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
            JSONObject jSONObject3 = this.genPostContent(stringBuffer.toString(), (String)object, string2);
            SourceLog.i(TAG, "setPlayList:" + jSONObject3.toString());
            AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sGLSBRoot + PUSH_ACTION, jSONObject3.toString());
            asyncHttpParameter.in.requestMethod = 1;
            IMQueue.getInstance().addTask(asyncHttpParameter, new AsyncHttpRequestListener(){

                @Override
                public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                    if (asyncHttpParameter == null || asyncHttpParameter.out == null || asyncHttpParameter.out.result == null) {
                        SourceLog.w(PublicCastClient.TAG, "setPlayList onRequestResult failed ");
                        return;
                    }
                    String string = asyncHttpParameter.out.result;
                    SourceLog.debug(PublicCastClient.TAG, "setPlayList onRequestResult " + string);
                }
            });
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private JSONObject genPostContent(String string, String string2, String string3) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(KEY_UID, (Object)Session.getInstance().getUID());
            jSONObject.put(KEY_U, (Object)string3);
            jSONObject.put(KEY_APPID, (Object)Session.getInstance().appKey);
            jSONObject.put(KEY_RECEIVER_APPID, (Object)string2);
            jSONObject.put(KEY_PROTOCOL_VERSION, (Object)"2.1");
            jSONObject.put(KEY_TOKEN, (Object)a.a());
            jSONObject.put(KEY_CONTENT, (Object)string);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return jSONObject;
    }

    public void pause(OutParameter outParameter) {
        this.playControl(outParameter, 2, -1, -1, null, -1);
    }

    public void playDrama(OutParameter outParameter, String string) {
        this.playControl(outParameter, 8, -1, -1, string, -1);
    }

    public void playNextDrama(OutParameter outParameter) {
        this.playControl(outParameter, 9, -1, -1, null, -1);
    }

    public void playPreDrama(OutParameter outParameter) {
        this.playControl(outParameter, 10, -1, -1, null, -1);
    }

    public void resume(OutParameter outParameter) {
        this.playControl(outParameter, 1, -1, -1, null, -1);
    }

    public void seekTo(OutParameter outParameter, int n2) {
        this.playControl(outParameter, 4, n2, -1, null, -1);
    }

    public void setVolume(OutParameter outParameter, int n2) {
        this.playControl(outParameter, 5, -1, n2, null, -1);
    }

    public void addVolume(OutParameter outParameter) {
        this.playControl(outParameter, 6, -1, -1, null, -1);
    }

    public void subVolume(OutParameter outParameter) {
        this.playControl(outParameter, 7, -1, -1, null, -1);
    }

    public void stop(OutParameter outParameter) {
        this.playControl(outParameter, 3, -1, -1, null, -1);
    }

    public void selectTrack(OutParameter outParameter, int n2) {
        this.playControl(outParameter, 11, -1, -1, null, n2);
    }

    private void playControl(OutParameter outParameter, final int n2, int n3, int n4, String string, int n5) {
        StringBuffer stringBuffer = new StringBuffer();
        JSONObject jSONObject = new JSONObject();
        try {
            String string2 = outParameter.currentBrowserInfo.getUid();
            jSONObject.put("sid", (Object)outParameter.session);
            jSONObject.put("st", n2);
            jSONObject.put("uri", (Object)outParameter.urlID);
            switch (n2) {
                case 4: {
                    jSONObject.put("seekto", n3);
                    break;
                }
                case 5: {
                    jSONObject.put("vt", n4);
                    break;
                }
                case 8: {
                    jSONObject.put("dramaid", (Object)string);
                    break;
                }
                case 11: {
                    jSONObject.put("trackIndex", n5);
                }
            }
            stringBuffer.append(COMMAND_PLAY_CONTROL).append(",").append(jSONObject.toString());
            JSONObject jSONObject2 = this.genPostContent(stringBuffer.toString(), string2);
            AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sGLSBRoot + PUSH_ACTION, jSONObject2.toString());
            asyncHttpParameter.in.requestMethod = 1;
            asyncHttpParameter.in.connectTimeout = 2000;
            asyncHttpParameter.in.readTimeout = 2000;
            IMQueue.getInstance().addTask(asyncHttpParameter, new AsyncHttpRequestListener(){

                @Override
                public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                    if (asyncHttpParameter == null || asyncHttpParameter.out == null || asyncHttpParameter.out.result == null) {
                        SourceLog.w(PublicCastClient.TAG, "playControl " + n2 + " failed");
                        return;
                    }
                    SourceLog.debug(PublicCastClient.TAG, "playControl " + n2 + " " + asyncHttpParameter.out.result);
                }
            });
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private JSONObject genPostContent(String string, String string2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(KEY_UID, (Object)Session.getInstance().getUID());
            jSONObject.put(KEY_U, (Object)string2);
            jSONObject.put(KEY_APPID, (Object)Session.getInstance().appKey);
            jSONObject.put(KEY_TOKEN, (Object)a.a());
            jSONObject.put(KEY_CONTENT, (Object)string);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return jSONObject;
    }

    public boolean isConnectedServer() {
        return IMEntrance.getInstance().isConnected();
    }

    public void disconnectTV(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        JSONObject jSONObject = new JSONObject();
        String string2 = "";
        try {
            if (this.mIMInfo != null) {
                string2 = this.mIMInfo.getUid();
            }
            jSONObject.put("sid", (Object)string);
            jSONObject.put("suid", (Object)Session.getInstance().getUID());
            jSONObject.put(KEY_UID, (Object)string2);
            stringBuffer.append(COMMAND_DISCONNECT).append(",").append(jSONObject.toString());
            JSONObject jSONObject2 = this.genPostContent(stringBuffer.toString(), string2);
            AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sGLSBRoot + PUSH_ACTION, jSONObject2.toString());
            asyncHttpParameter.in.requestMethod = 1;
            asyncHttpParameter.in.connectTimeout = 2000;
            asyncHttpParameter.in.readTimeout = 2000;
            IMQueue.getInstance().addTask(asyncHttpParameter, new AsyncHttpRequestListener(){

                @Override
                public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                    if (asyncHttpParameter == null || asyncHttpParameter.out == null || asyncHttpParameter.out.result == null) {
                        SourceLog.w(PublicCastClient.TAG, "disconnectTV  failed");
                        return;
                    }
                    SourceLog.debug(PublicCastClient.TAG, "disconnectTV result \uff1a" + asyncHttpParameter.out.result);
                }
            });
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private void resolveConnectMsg(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            this.mFe = jSONObject.optString("fe");
            int n2 = jSONObject.optInt("st");
            int n3 = jSONObject.optInt("std");
            int n4 = jSONObject.optInt("plat");
            String string2 = jSONObject.optString("sm");
            int n5 = jSONObject.optInt("time");
            if (this.mIMInfo != null) {
                ConnectBridge connectBridge = ConnectManager.getInstance().getConnectBridge(this.mIMInfo.getUid());
                if (connectBridge != null) {
                    connectBridge.setSinkSM(string2);
                    connectBridge.saveConnectBean(string);
                }
                RightsManager.getInstance().handleNetConnectMessage(this.mIMInfo.getUid(), string);
            }
            switch (n2) {
                case 2: {
                    this.mHandler.removeMessages(1);
                    if (this.mTVConnectListener != null) {
                        this.mTVConnectListener.onConnect(n4, string);
                    }
                    break;
                }
                case 1: {
                    if (this.mTVConnectListener != null) {
                        this.mTVConnectListener.onDisconnect(212012);
                    }
                    if (n5 <= 0) {
                        n5 = 15;
                    }
                    this.mHandler.removeMessages(1);
                    this.mHandler.sendEmptyMessageDelayed(1, (long)(n5 * 1000));
                    break;
                }
                default: {
                    this.mHandler.removeMessages(1);
                    if (n3 == 1) {
                        if (this.mTVConnectListener != null) {
                            this.mTVConnectListener.onDisconnect(212014);
                        }
                    } else if (n3 == 3) {
                        if (this.mTVConnectListener != null) {
                            this.mTVConnectListener.onDisconnect(212015);
                        }
                    } else if (this.mTVConnectListener != null) {
                        this.mTVConnectListener.onDisconnect(212013);
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private void resolvePlayStateMsg(String string) {
        try {
            Object object;
            JSONObject jSONObject = new JSONObject(string);
            int n2 = Integer.parseInt(jSONObject.optString("st"));
            String string2 = jSONObject.optString("uri");
            String string3 = jSONObject.optString("dramaid");
            if (!TextUtils.isEmpty((CharSequence)string3) && (object = BusinessEntity.getInstance().getCurrentPlayInfo()) != null) {
                ((OutParameter)object).dramaID = string3;
            }
            switch (n2) {
                case 0: {
                    if (this.mPlayStateListener == null) break;
                    int n3 = jSONObject.optInt("period");
                    int n4 = jSONObject.optInt("duration");
                    this.mPlayStateListener.onPlaying(string2, n4, n3);
                    break;
                }
                case 1: {
                    if (this.mPlayStateListener == null) break;
                    this.mPlayStateListener.onStart(string2);
                    break;
                }
                case 2: {
                    if (this.mPlayStateListener == null) break;
                    this.mPlayStateListener.onPause(string2);
                    break;
                }
                case 3: {
                    if (this.mPlayStateListener == null) break;
                    int n5 = jSONObject.optInt("std");
                    this.mPlayStateListener.onStop(string2, n5);
                    break;
                }
                case 4: {
                    object = jSONObject.optString("er");
                    SourceLog.i(TAG, "resolvePlayStateMsg PLAY_CALLBACK_ERROR:" + (String)object);
                }
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private void processPassMsg(String string) {
        SourceLog.i(TAG, "processPassMsg");
        if (TextUtils.isEmpty((CharSequence)string)) {
            SourceLog.i(TAG, "processPassMsg error:data is empty");
            return;
        }
        String string2 = this.decodeXORData(string);
        try {
            string2 = URLDecoder.decode(string2, "utf-8");
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            SourceLog.i(TAG, "processPassMsg error:decodeXORData is empty");
            return;
        }
        Parser parser = Parser.getInstance();
        try {
            JSONArray jSONArray = new JSONArray(string2);
            if (jSONArray != null && jSONArray.length() > 0) {
                for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                    parser.parseByNetCast(jSONArray.optString(i2));
                }
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private String decodeXORData(String string) {
        String string2 = Session.getInstance().appSecret;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            SourceLog.i(TAG, "decodeXORData appsecret is empty");
        }
        return Encode.decode(string, string2);
    }

    private String encodeXORData(String string) {
        String string2 = Session.getInstance().appSecret;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            SourceLog.i(TAG, "encodeXORData appsecret is empty");
        }
        try {
            string = URLEncoder.encode(string, "utf-8");
            return Encode.encode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SourceLog.w(TAG, unsupportedEncodingException);
            return null;
        }
    }

    public boolean sendPass(String string, String string2) {
        try {
            String string3 = this.encodeXORData(string2);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                SourceLog.i(TAG, "sendPass encrypt xor data is empty");
                return false;
            }
            NetPassBean netPassBean = new NetPassBean();
            netPassBean.pc = string3;
            this.mNetCastPassSender.sendMsg(string, 33560575, netPassBean.toJson().toString());
            return true;
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return false;
        }
    }

    private void reverseEventMsg(String string) {
        SourceLog.i(TAG, "reverseEventMsg " + string);
        String string2 = null;
        try {
            JSONObject jSONObject = new JSONObject(string);
            string2 = jSONObject.optString("m");
            String string3 = jSONObject.optString("ts");
            int n2 = Integer.parseInt(string3);
            SourceLog.i(TAG, "reverseEventMsg ts:" + string3 + "mRCEventCount:" + mRCEventCount + ", count:" + n2);
            if (n2 < mRCEventCount) {
                mRCEventCount = 0;
                return;
            }
            mRCEventCount = n2;
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        SinkTouchEventIMChannel.getInstance().onReceiveIMTouchEvent(string2);
    }

    public String getFeature() {
        return this.mFe;
    }

    public void setIMMsgReceiveListener(AbsIMMsgReceiveListener absIMMsgReceiveListener) {
        if (!this.mIMMsgReceiveListenerList.contains(absIMMsgReceiveListener)) {
            this.mIMMsgReceiveListenerList.add(absIMMsgReceiveListener);
        }
    }

    public void removeIMMsgReceiveListener(AbsIMMsgReceiveListener absIMMsgReceiveListener) {
        if (this.mIMMsgReceiveListenerList.contains(absIMMsgReceiveListener)) {
            this.mIMMsgReceiveListenerList.remove(absIMMsgReceiveListener);
        }
    }

    private void reveiveSinkServiceMsg(int n2, String string) {
        SourceLog.i(TAG, "reveiveSinkServiceMsg " + string);
        for (AbsIMMsgReceiveListener absIMMsgReceiveListener : this.mIMMsgReceiveListenerList) {
            absIMMsgReceiveListener.onMsgReceive(n2, string);
        }
    }

    static {
        mRCEventCount = 0;
    }
}

