/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.connection;

import android.text.TextUtils;
import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.protocol.IConnector;
import com.hpplay.component.common.protocol.ProtocolListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.modulelinker.api.ModuleLinker;
import com.hpplay.component.protocol.connection.DLNAConnection;
import com.hpplay.component.protocol.connection.DisconnectionMonitor;
import com.hpplay.component.protocol.connection.IConnection;
import com.hpplay.component.protocol.connection.IMConnection;
import com.hpplay.component.protocol.connection.LelinkConnection;
import com.hpplay.component.protocol.connection.LelinkV2Connection;
import com.hpplay.component.protocol.passthrough.LelinkPassthroughChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConnectTask
extends IConnector
implements Runnable {
    private static final String TAG = "ConnectorImp";
    private static final int AUTO_CHECK_INTERVAL = 5000;
    private static final int LOCK_LONG_TIME = 0;
    private static final int CHECK_MAX_COUNT = 2;
    private LelinkPassthroughChannel mLelinkPassthroughChannel;
    private ParamsMap mMap;
    private IConnection mConnection;
    private ProtocolListener mProtocolListener;
    private boolean isConnected = false;
    private int mFailedCount = 0;
    private ProtocolListener mCheckconnectionListener;
    private Object mLock = new Object();
    private AtomicBoolean isLock = new AtomicBoolean();
    private AtomicBoolean isAppPause = new AtomicBoolean();
    private boolean isActiveCheck;
    private int mConnectType = 0;
    private boolean isDisconnected;
    private String mFeature = "";
    private DisconnectionMonitor mDiscMonitor;
    private final ProtocolListener protocolListener = new ProtocolListener(){

        @Override
        public void onResult(int n2, String ... stringArray) {
            try {
                if (20 == n2 && stringArray != null) {
                    CLog.i(ConnectTask.TAG, "requestNewDevice ========>" + stringArray[0]);
                    ConnectTask.this.mMap = ParamsMap.create(stringArray[0]);
                    JSONArray jSONArray = new JSONArray();
                    JSONArray jSONArray2 = (JSONArray)ConnectTask.this.mMap.getParam("connect_support", jSONArray);
                    if (jSONArray2.length() > 0) {
                        int[] nArray = new int[jSONArray2.length()];
                        for (int i2 = 0; i2 < jSONArray2.length(); ++i2) {
                            nArray[i2] = (Integer)jSONArray2.get(i2);
                        }
                        ConnectTask.this.mMap.putParam("connect_support", nArray);
                    }
                } else {
                    CLog.i(ConnectTask.TAG, "requestNewDevice ========>   match current device failed");
                }
            }
            catch (Exception exception) {
                CLog.w(ConnectTask.TAG, exception);
            }
            ConnectTask.this.unLockThread();
        }
    };
    private final ProtocolListener mDisconnectedListener = new ProtocolListener(){

        @Override
        public void onResult(int n2, String ... stringArray) {
            CLog.i(ConnectTask.TAG, "keep alive disconnect");
            try {
                if (ConnectTask.this.mProtocolListener != null) {
                    ConnectTask.this.mProtocolListener.onResult(n2, stringArray);
                }
            }
            catch (Exception exception) {
                CLog.w(ConnectTask.TAG, exception);
            }
            ConnectTask.this.disConnect();
        }
    };

    @Override
    public void run() {
        String string = "";
        try {
            this.isConnected = this.startConnect();
            if (!this.isConnected && !this.isDisconnected) {
                CLog.i(TAG, "connect failed try research connect ");
                this.isConnected = this.researchConnect();
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception.toString());
            string = CLog.getExceptionStr(exception);
        }
        CLog.i(TAG, "connect state " + this.isConnected + " errMsg: " + string);
        while (this.isConnected && !this.isDisconnected) {
            boolean bl = false;
            try {
                bl = this.mConnection.checkConnection();
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
            if (!bl) {
                ++this.mFailedCount;
                CLog.i(TAG, "connection keep alive failed " + this.mFailedCount);
            } else {
                this.mFailedCount = 0;
                CLog.i(TAG, " state online ");
            }
            if (this.isActiveCheck) {
                if (!bl) {
                    try {
                        bl = this.researchConnect();
                    }
                    catch (Exception exception) {
                        CLog.w(TAG, exception);
                    }
                }
                if (this.mCheckconnectionListener != null) {
                    this.mMap.putParam("protocol_type", this.mConnectType);
                    this.mCheckconnectionListener.onResult(20, bl ? this.mMap.toJason() : null);
                }
                this.isActiveCheck = false;
                if (!bl) {
                    if (this.mProtocolListener == null) break;
                    this.mProtocolListener.onResult(11, "connection_disconnect");
                    break;
                }
            }
            if (this.mFailedCount > 2) {
                if (this.mProtocolListener != null) {
                    this.mProtocolListener.onResult(11, "connection_disconnect");
                }
                this.disConnect();
                break;
            }
            try {
                this.lockThread(this.isAppPause.get() ? 0L : 5000L);
                this.isLock.set(false);
            }
            catch (InterruptedException interruptedException) {
                CLog.w(TAG, interruptedException);
                break;
            }
        }
        if (!this.isConnected && this.mProtocolListener != null) {
            int n2 = 120102102;
            switch (this.mConnectType) {
                case 1: {
                    if (this.mConnectType == 1 && TextUtils.equals((CharSequence)this.mMap.getVV(), (CharSequence)"2")) {
                        n2 = 120102102;
                        break;
                    }
                    n2 = 120102101;
                    break;
                }
                case 3: {
                    n2 = 120102103;
                }
            }
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("errCode", n2);
                jSONObject.put("errMsg", (Object)string);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            this.mProtocolListener.onResult(11, "failed", String.valueOf(this.mConnectType), jSONObject.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockThread(long l2) {
        CLog.i(TAG, "lock connect Thread ...");
        if (!this.isLock.get()) {
            Object object = this.mLock;
            synchronized (object) {
                if (l2 > 0L) {
                    this.isLock.set(true);
                    this.mLock.wait(l2);
                } else {
                    this.isLock.set(true);
                    this.mLock.wait();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unLockThread() {
        CLog.i(TAG, "unlock connect Thread ...");
        if (this.isLock.get()) {
            Object object = this.mLock;
            synchronized (object) {
                this.mLock.notify();
                this.isLock.set(false);
            }
        }
    }

    private void requestNewDevice() {
        ModuleLinker.getInstance().callMethod("52D2A158F93972986496FB8AC7EE672C", this.mMap, this.protocolListener);
    }

    private boolean researchConnect() {
        CLog.i(TAG, "researchConnect ~~~~");
        this.requestNewDevice();
        this.unLockThread();
        this.lockThread(0L);
        this.isLock.set(false);
        this.isConnected = this.startConnect();
        return this.isConnected;
    }

    private boolean startConnect() {
        CLog.i(TAG, "startConnect ~~~~");
        int[] nArray = new int[]{};
        if (this.mMap == null) {
            return false;
        }
        nArray = (int[])this.mMap.getParam("connect_support", nArray);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        block5: for (int i2 = 0; i2 < nArray.length; ++i2) {
            switch (nArray[i2]) {
                case 1: {
                    bl = true;
                    continue block5;
                }
                case 3: {
                    bl2 = true;
                    continue block5;
                }
                case 4: {
                    bl3 = true;
                }
            }
        }
        if (bl) {
            this.isConnected = this.connectByType(1);
            this.mConnectType = 1;
        }
        if (!this.isConnected && bl2) {
            this.isConnected = this.connectByType(3);
            this.mConnectType = 3;
        }
        if (!this.isConnected && bl3) {
            this.isConnected = this.connectByType(4);
            this.mConnectType = 4;
        }
        if (this.isConnected) {
            if (this.mProtocolListener != null) {
                this.mProtocolListener.onResult(11, "successful", String.valueOf(this.mConnectType), this.mFeature);
            }
            if (this.mConnectType == 1 && TextUtils.equals((CharSequence)this.mMap.getVV(), (CharSequence)"2")) {
                this.mLelinkPassthroughChannel = new LelinkPassthroughChannel(this.mMap, this.mConnection.getSessionId(), 5, this.mProtocolListener);
                this.mLelinkPassthroughChannel.startPassthroughChannel();
            }
        }
        return this.isConnected;
    }

    private boolean connectByType(int n2) {
        if (1 == n2) {
            this.mConnection = TextUtils.equals((CharSequence)this.mMap.getVV(), (CharSequence)"2") ? new LelinkV2Connection(this.mMap) : new LelinkConnection(this.mMap);
        } else if (3 == n2) {
            this.mConnection = new DLNAConnection(this.mMap);
        } else if (4 == n2) {
            this.mConnection = new IMConnection(this.mMap, this.mProtocolListener);
        }
        boolean bl = this.mConnection.startConnect();
        if (bl && 1 == n2) {
            this.releaseDiscMonitor();
            this.mDiscMonitor = new DisconnectionMonitor(this.mConnection.getProtocolSender(), this.mDisconnectedListener);
            this.mDiscMonitor.start();
        }
        if (bl && this.mConnection instanceof LelinkV2Connection) {
            this.mFeature = ((LelinkV2Connection)this.mConnection).getFeature();
        }
        return bl;
    }

    protected void setProtocolListener(ProtocolListener protocolListener) {
        this.mProtocolListener = protocolListener;
    }

    @Override
    public void connect(ParamsMap paramsMap, ProtocolListener protocolListener) {
        CLog.i(TAG, "start connect connect ~~~~");
        this.mMap = paramsMap;
        this.mProtocolListener = protocolListener;
    }

    @Override
    public void checkConnection(ProtocolListener protocolListener) {
        CLog.i(TAG, "checkConnection ~~~~");
        if (this.isActiveCheck) {
            return;
        }
        this.isActiveCheck = true;
        this.mCheckconnectionListener = protocolListener;
        this.unLockThread();
    }

    @Override
    public String getConnectSessionId() {
        if (this.mConnection != null) {
            return this.mConnection.getSessionId();
        }
        return "";
    }

    @Override
    public void onAppResume() {
        if (this.isAppPause.get()) {
            CLog.i(TAG, "=========onAppResume=============");
            this.isAppPause.set(false);
            this.unLockThread();
        }
    }

    @Override
    public void onAppPause() {
        CLog.i(TAG, "=========onAppPause=============");
        if (!this.isAppPause.get()) {
            this.isAppPause.set(true);
        }
    }

    @Override
    public boolean sendPassthroughData(int n2, String string, String string2, ProtocolListener protocolListener) {
        if (this.mLelinkPassthroughChannel == null) {
            return false;
        }
        return this.mLelinkPassthroughChannel.sendPassthData(n2, string, string2, protocolListener);
    }

    @Override
    public void disConnect() {
        CLog.i(TAG, "disConnect");
        this.unLockThread();
        if (this.mConnection != null) {
            this.mConnection.disConnect();
        }
        if (this.mLelinkPassthroughChannel != null) {
            this.mLelinkPassthroughChannel.release();
        }
        this.isDisconnected = true;
        this.isConnected = false;
        this.releaseDiscMonitor();
    }

    private void releaseDiscMonitor() {
        if (this.mDiscMonitor != null) {
            this.mDiscMonitor.release();
            this.mDiscMonitor = null;
        }
    }
}

