/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp.control;

import com.hpplay.cybergarage.http.HTTPRequest;
import com.hpplay.cybergarage.soap.SOAP;
import com.hpplay.cybergarage.soap.SOAPResponse;
import com.hpplay.cybergarage.upnp.Action;
import com.hpplay.cybergarage.upnp.Argument;
import com.hpplay.cybergarage.upnp.ArgumentList;
import com.hpplay.cybergarage.upnp.Service;
import com.hpplay.cybergarage.upnp.control.ActionResponse;
import com.hpplay.cybergarage.upnp.control.ControlRequest;
import com.hpplay.cybergarage.xml.Node;

public class ActionRequest
extends ControlRequest {
    public ActionRequest(String string) {
        this.setHeader("User-Agent", "UPnP/1.0");
    }

    public ActionRequest(HTTPRequest hTTPRequest) {
        this.set(hTTPRequest);
    }

    public Node getActionNode() {
        Node node = this.getBodyNode();
        if (node == null) {
            return null;
        }
        if (!node.hasNodes()) {
            return null;
        }
        return node.getNode(0);
    }

    public String getActionName() {
        Node node = this.getActionNode();
        if (node == null) {
            return "";
        }
        String string = node.getName();
        if (string == null) {
            return "";
        }
        int n2 = string.indexOf(":") + 1;
        if (n2 < 0) {
            return "";
        }
        return string.substring(n2, string.length());
    }

    public ArgumentList getArgumentList() {
        Node node = this.getActionNode();
        int n2 = node.getNNodes();
        ArgumentList argumentList = new ArgumentList();
        for (int i2 = 0; i2 < n2; ++i2) {
            Argument argument = new Argument();
            Node node2 = node.getNode(i2);
            argument.setName(node2.getName());
            argument.setValue(node2.getValue());
            argumentList.add(argument);
        }
        return argumentList;
    }

    public void setRequest(Action action, ArgumentList argumentList) {
        Service service = action.getService();
        this.setRequestHost(service);
        this.setEnvelopeNode(SOAP.createEnvelopeBodyNode());
        Node node = this.getEnvelopeNode();
        Node node2 = this.getBodyNode();
        Node node3 = this.createContentNode(service, action, argumentList);
        node2.addNode(node3);
        this.setContent(node);
        String string = service.getServiceType();
        String string2 = action.getName();
        String string3 = "\"" + string + "#" + string2 + "\"";
        this.setSOAPAction(string3);
    }

    private Node createContentNode(Service service, Action action, ArgumentList argumentList) {
        String string = action.getName();
        String string2 = service.getServiceType();
        Node node = new Node();
        node.setName("u", string);
        node.setNameSpace("u", string2);
        int n2 = argumentList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Argument argument = argumentList.getArgument(i2);
            Node node2 = new Node();
            node2.setName(argument.getName());
            node2.setValue(argument.getValue());
            node.addNode(node2);
        }
        return node;
    }

    public ActionResponse post() {
        SOAPResponse sOAPResponse = this.postMessage(this.getRequestHost(), this.getRequestPort());
        return new ActionResponse(sOAPResponse);
    }
}

