/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.http;

import com.hpplay.component.common.utils.CLog;
import com.hpplay.cybergarage.http.HTTPRequestListener;
import com.hpplay.cybergarage.http.HTTPServer;
import com.hpplay.cybergarage.net.HostInterface;
import java.net.InetAddress;
import java.util.Vector;

public class HTTPServerList
extends Vector {
    private static final String TAG = "HTTPServerList";
    private InetAddress[] binds = null;
    private int port = 4004;

    public HTTPServerList() {
    }

    public HTTPServerList(InetAddress[] inetAddressArray, int n2) {
        this.binds = inetAddressArray;
        this.port = n2;
    }

    public void addRequestListener(HTTPRequestListener hTTPRequestListener) {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            HTTPServer hTTPServer = this.getHTTPServer(i2);
            hTTPServer.addRequestListener(hTTPRequestListener);
        }
    }

    public HTTPServer getHTTPServer(int n2) {
        return (HTTPServer)this.get(n2);
    }

    public void close() {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            HTTPServer hTTPServer = this.getHTTPServer(i2);
            hTTPServer.close();
        }
    }

    public int open() {
        int n2;
        int n3;
        String[] stringArray;
        InetAddress[] inetAddressArray = this.binds;
        if (inetAddressArray != null) {
            stringArray = new String[inetAddressArray.length];
            for (n3 = 0; n3 < inetAddressArray.length; ++n3) {
                stringArray[n3] = inetAddressArray[n3].getHostAddress();
            }
        } else {
            n3 = HostInterface.getNHostAddresses();
            stringArray = new String[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                stringArray[n2] = HostInterface.getHostAddress(n2);
            }
        }
        n3 = 0;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            HTTPServer hTTPServer = new HTTPServer();
            if (stringArray[n2] == null || !hTTPServer.open(stringArray[n2], this.port)) {
                if (n3 != 0) continue;
                this.close();
                this.clear();
                continue;
            }
            this.add(hTTPServer);
            ++n3;
        }
        return n3;
    }

    public boolean open(int n2) {
        this.port = n2;
        return this.open() != 0;
    }

    public void start() {
        int n2 = this.size();
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                HTTPServer hTTPServer = this.getHTTPServer(i2);
                hTTPServer.start();
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    public boolean isRuning() {
        if (this.size() > 0 && this.getHTTPServer(0) != null) {
            return this.getHTTPServer(0).isRunning();
        }
        return false;
    }

    public void stop() {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            HTTPServer hTTPServer = this.getHTTPServer(i2);
            hTTPServer.stop();
        }
    }
}

