/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.mirror.rtsp;

import android.os.Build;
import android.text.TextUtils;
import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.ProtocolBuilder;
import com.hpplay.component.protocol.ProtocolSender;
import com.hpplay.component.protocol.ProtocolUtils;
import com.hpplay.component.protocol.encrypt.MirrorFrameEcrypto;
import com.hpplay.component.protocol.mirror.VideoSender;
import com.hpplay.component.protocol.mirror.rtsp.RTSPPacket;
import com.hpplay.component.protocol.mirror.rtsp.RtspClient;
import com.hpplay.component.protocol.plist.NSArray;
import com.hpplay.component.protocol.plist.NSDictionary;
import com.hpplay.component.protocol.plist.NSNumber;
import com.hpplay.component.protocol.plist.PropertyListParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LelinkRtspClient
extends RtspClient {
    private static final String TAG = "LelinkRtspClient";
    private static final String HAPPY_CAST = "Happycast/1.0";
    private static final String HAPPY_VALUE = "happyplay";
    private VideoSender mVideoDataSender;
    private ProtocolSender mProtocolSender;
    private int mMirrorPort = 0;
    private double mRefreshRate = 60.0;
    private boolean mEncrypt;
    private int mRepoPort;
    private String mDeviceId;
    private String mDeviceName;
    private String mSinkName;
    private String mLocalip;
    private int mUdpServerPort = 0;
    private String mScreenCode;
    private String mUri;
    private String versoinName;
    private String mIp;
    int cseq = 0;

    public LelinkRtspClient(ParamsMap paramsMap) {
        this.mScreenCode = paramsMap.getStringParam("screencode");
        this.mRepoPort = Integer.parseInt(TextUtils.isEmpty((CharSequence)paramsMap.getStringParam("raop_port")) ? "0" : paramsMap.getStringParam("raop_port"));
        this.mUri = paramsMap.getStringParam("uri");
        try {
            this.mIDWidth = Integer.parseInt(paramsMap.getStringParam("phone_width"));
            this.mIDHeight = Integer.parseInt(paramsMap.getStringParam("phone_height"));
        }
        catch (Exception exception) {
            this.mIDWidth = 1080;
            this.mIDHeight = 1920;
            CLog.w(TAG, exception);
        }
        this.versoinName = paramsMap.getStringParam("channel_version");
        this.mSinkName = paramsMap.getStringParam("sink_name");
        this.mDeviceId = "0x" + paramsMap.getStringParam("mac");
        this.mIp = paramsMap.getStringParam("ip");
        CLog.d(TAG, " report  " + this.mRepoPort);
        this.mDeviceName = Build.MANUFACTURER + " " + Build.MODEL;
        this.mMirrorPort = Integer.parseInt(paramsMap.getParam("mirror_port", "0").toString());
    }

    @Override
    public int exeLelinkRtsp(boolean bl, String ... stringArray) {
        int n2 = 0;
        try {
            int n3 = Integer.parseInt(stringArray[0]);
            CLog.i(TAG, "start  running");
            n2 = 120105101;
            boolean bl2 = this.sendRequestGetMirrorPort();
            if (!bl2) {
                return n2;
            }
            CLog.i(TAG, "start  get mirror info");
            n2 = 120105102;
            n2 = this.sendRequestGetMirrorInfo();
            if (n2 == 10) {
                return 211026;
            }
            n2 = 120105106;
            bl2 = this.sendRequestAnnounce();
            CLog.i(TAG, "Announce" + bl2);
            n2 = this.sendRequestVideoSetup(n3, 0);
            CLog.i(TAG, "Video Setup" + bl2);
            if (bl) {
                n2 = 120105106;
                bl2 = this.sendRequestAudioSetup();
                CLog.i(TAG, "AudioSetup" + bl2);
                if (!bl2) {
                    return n2;
                }
            }
            n2 = 120105107;
            bl2 = this.sendRequestRecord();
            CLog.i(TAG, "tRecord" + bl2);
            if (!bl2) {
                return n2;
            }
            bl2 = this.sendRequestGetParamter();
            CLog.i(TAG, "GetParameter" + bl2);
            if (!bl2) {
                return n2;
            }
            bl2 = this.sendRequestSetParamter();
            CLog.i(TAG, "SetParameter start " + bl2);
            if (bl2) {
                return 1;
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            this.mErrorMsg = CLog.getExceptionStr(exception);
        }
        return n2;
    }

    @Override
    public boolean sendRequestGetMirrorPort() {
        boolean bl = false;
        if (this.mMirrorPort == 0) {
            this.mProtocolSender = new ProtocolSender();
            this.mProtocolSender.setConnectInfo(this.mIp, this.mRepoPort);
            bl = this.mProtocolSender.connectServer();
            CLog.d(TAG, "create socket " + bl);
            if (bl) {
                byte[] byArray = new ProtocolBuilder().getMirrorPortCmd().setAplleDevid(this.mDeviceId).setAppleDevName(this.mDeviceName).setApplePrcVs("0").setAppleClientName(this.mDeviceName).setContentLength("0").setHapplay(HAPPY_VALUE).getProtocal(true);
                byte[] byArray2 = new byte[]{};
                byArray2 = this.mProtocolSender.interactiveData(new byte[][]{byArray});
                if (byArray2 != null) {
                    this.parseMirrorPort(byArray2);
                    return true;
                }
                return false;
            }
        } else {
            this.mVideoDataSender = new VideoSender();
            bl = this.mVideoDataSender.connect(this.mIp, this.mMirrorPort, 2);
            String string = HAPPY_CAST;
            String string2 = Build.VERSION.SDK_INT >= 24 ? ProtocolUtils.getDateTime(System.currentTimeMillis()) : "20180319000900";
            this.mMirrorFrameEcrypto = new MirrorFrameEcrypto(ProtocolUtils.Encrypt(HAPPY_CAST), ProtocolUtils.Encrypt(string2));
            byte[] byArray = this.versoinName.contains("5.3.2.9") ? new ProtocolBuilder().getMirrorInfoCmd().setLelinkDeviceId(this.mDeviceId).setLelinkDevNameCmd(this.mDeviceName).setLelinkprotocolVersion("0").setLelinkClientName(this.mSinkName).setStreamTime(string2).setUserAgent(string).setContentLength("0").setAutorization(this.mScreenCode).setHapplay(HAPPY_VALUE).getProtocal(true) : new ProtocolBuilder().getMirrorInfoCmd().setAplleDevid(this.mDeviceId).setAppleDevName(this.mDeviceName).setApplePrcVs("0").setAppleClientName(this.mSinkName).setStreamTime(string2).setUserAgent(string).setContentLength("0").setAutorization(this.mScreenCode).setHapplay(HAPPY_VALUE).getProtocal(true);
            byte[] byArray3 = new byte[]{};
            byArray3 = this.mVideoDataSender.interactiveData(new byte[][]{byArray});
            if (byArray3 != null) {
                int n2 = this.parseMirrorInfo(new String(byArray3));
                if (n2 != 1) {
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public int sendRequestGetMirrorInfo() {
        if (this.mVideoDataSender != null) {
            this.mProtocolSender = new ProtocolSender();
            this.mProtocolSender.setConnectInfo(this.mIp, this.mRepoPort);
            boolean bl = false;
            bl = this.mProtocolSender.connectServer();
            CLog.d(TAG, "create socket " + bl);
            if (bl) {
                byte[] byArray = new ProtocolBuilder().getMirrorPortCmd().setAplleDevid(this.mDeviceId).setAppleDevName(this.mDeviceName).setApplePrcVs("0").setAppleClientName(this.mSinkName).setContentLength("0").setHapplay(HAPPY_VALUE).getProtocal(true);
                byte[] byArray2 = new byte[]{};
                try {
                    byArray2 = this.mProtocolSender.interactiveData(new byte[][]{byArray});
                }
                catch (Exception exception) {
                    CLog.w(TAG, exception);
                }
                if (byArray2 != null) {
                    this.parseMirrorPort(byArray2);
                }
            }
            if (!bl) {
                return 0;
            }
            return 1;
        }
        this.mVideoDataSender = new VideoSender();
        boolean bl = this.mVideoDataSender.connect(this.mIp, this.mMirrorPort, 2);
        if (!bl) {
            return 0;
        }
        String string = HAPPY_CAST;
        String string2 = Build.VERSION.SDK_INT >= 24 ? ProtocolUtils.getDateTime(System.currentTimeMillis()) : "20180319000900";
        this.mMirrorFrameEcrypto = new MirrorFrameEcrypto(ProtocolUtils.Encrypt(HAPPY_CAST), ProtocolUtils.Encrypt(string2));
        this.mScreenCode = !TextUtils.isEmpty((CharSequence)this.mScreenCode) ? ProtocolBuilder.makeAuthorization(this.mScreenCode) : null;
        byte[] byArray = this.versoinName.contains("5.3.2.9") ? new ProtocolBuilder().getMirrorInfoCmd().setLelinkDeviceId(this.mDeviceId).setLelinkDevNameCmd(this.mDeviceName).setLelinkprotocolVersion("0").setLelinkClientName(this.mSinkName).setStreamTime(string2).setUserAgent(string).setContentLength("0").setAutorization(this.mScreenCode).setHapplay(HAPPY_VALUE).getProtocal(true) : new ProtocolBuilder().getMirrorInfoCmd().setAplleDevid(this.mDeviceId).setAppleDevName(this.mDeviceName).setApplePrcVs("0").setAppleClientName(this.mSinkName).setStreamTime(string2).setUserAgent(string).setContentLength("0").setAutorization(this.mScreenCode).setHapplay(HAPPY_VALUE).getProtocal(true);
        byte[] byArray3 = this.mVideoDataSender.interactiveData(new byte[][]{byArray});
        if (byArray3 != null) {
            int n2 = this.parseMirrorInfo(new String(byArray3));
            return n2;
        }
        return 0;
    }

    @Override
    public boolean sendRequestAnnounce() {
        this.mLocalip = ProtocolUtils.getLoaclIp();
        this.cseq = 0;
        String string = new ProtocolBuilder().getSdp(this.mLocalip, this.mDeviceName);
        String string2 = new ProtocolBuilder().getAunounce(this.mLocalip).setLelinkClientName(this.mDeviceName).setRtspSeq(this.cseq + "").setLelinkDeviceId(this.mDeviceId).setRtspDacp("8A3D47D2C13675B8").setRtsActiveRemote("2317505163").setContentType("application/sdp").setContentLength(string.length() + "").setUserAgent("AirPlay/150.33").getString(true) + string;
        CLog.d(TAG, "------announce ---" + string2);
        ++this.cseq;
        byte[] byArray = new byte[]{};
        try {
            byArray = this.mProtocolSender.interactiveData(new byte[][]{string2.getBytes()});
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        if (byArray == null) {
            this.mProtocolSender.release();
            return false;
        }
        return true;
    }

    @Override
    public int sendRequestVideoSetup(int n2, int n3) {
        ++this.cseq;
        byte[] byArray = new ProtocolBuilder().getVideoSetUpCmd(this.mLocalip).setTransport("RTP/AVP/TCP;unicast;mode=record").setRtspSeq(this.cseq + "").setLelinkDeviceId(this.mDeviceId).setRtspDacp("8A3D47D2C13675B8").setContentLength("0").setRtsActiveRemote("2317505163").setUserAgent("AirPlay/150.33").getProtocal(true);
        byte[] byArray2 = this.mProtocolSender.interactiveData(new byte[][]{byArray});
        if (byArray2 == null) {
            this.mProtocolSender.release();
            return 0;
        }
        CLog.i(TAG, "SETUP call back agin ----->" + new String(byArray2));
        return 1;
    }

    @Override
    public boolean sendRequestAudioSetup() {
        byte[] byArray = new ProtocolBuilder().getAudioSetUpCmd(this.mLocalip).setTransport("RTP/AVP/UDP;unicast;mode=screen;timing_port=49944;x-events;control_port=56986;redundant=2").setRtspSeq(this.cseq + "").setLelinkDeviceId(this.mDeviceId).setRtspDacp("8A3D47D2C13675B8").setContentLength("0").setRtsActiveRemote("2317505163").setUserAgent("AirPlay/150.33").getProtocal(true);
        CLog.i(TAG, "1 --- > \n\n " + new String(byArray) + "   \n\n " + byArray.length);
        byte[] byArray2 = new byte[]{};
        byArray2 = this.mProtocolSender.interactiveData(new byte[][]{byArray});
        String string = "";
        if (byArray2 != null) {
            string = new String(byArray2, 0, byArray2.length);
            CLog.i(TAG, "SETUP audio = \r\n" + string);
        }
        CLog.i(TAG, "SETUP call back" + string);
        string = string.substring(0, string.indexOf("\r\n\r\n"));
        RTSPPacket rTSPPacket = new RTSPPacket();
        rTSPPacket.parseRTSPPacket(string, null, string.length());
        rTSPPacket.valueOfHeader("Transport");
        Pattern pattern = Pattern.compile(";control_port=(\\d+)");
        Matcher matcher = pattern.matcher(string);
        pattern = Pattern.compile(";timing_port=(\\d+)");
        matcher = pattern.matcher(string);
        pattern = Pattern.compile(";server_port=(\\d+)");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            try {
                this.mUdpServerPort = Integer.valueOf(matcher.group(1));
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
        }
        pattern = Pattern.compile(";mode=(\\w+)");
        matcher = pattern.matcher(string);
        return true;
    }

    @Override
    public boolean sendRequestRecord() {
        ++this.cseq;
        byte[] byArray = new ProtocolBuilder().getRecordCmd(this.mLocalip).setRange("npt=0-").setRtpinfo("seq=1920;rtptime=0").setRtspSeq(this.cseq + "").setLelinkDeviceId(this.mDeviceId).setRtspDacp("8A3D47D2C13675B8").setRtsActiveRemote("2317505163").setUserAgent("AirPlay/150.33").getProtocal(true);
        byte[] byArray2 = new byte[]{};
        byArray2 = this.mProtocolSender.interactiveData(new byte[][]{byArray});
        if (byArray2 == null) {
            this.mProtocolSender.release();
            return false;
        }
        CLog.i(TAG, " RECORD call back  ----->" + new String(byArray2));
        return true;
    }

    @Override
    public boolean sendRequestGetParamter() {
        ++this.cseq;
        String string = "volume";
        String string2 = new ProtocolBuilder().getParameterCmd(this.mLocalip).setRtspSeq(this.cseq + "").setLelinkDeviceId(this.mDeviceId).setRtspDacp("8A3D47D2C13675B8").setRtsActiveRemote("2317505163").setContentLength("8").setUserAgent("AirPlay/150.33").getString(true);
        string2 = string2 + string + "\r\n";
        byte[] byArray = new byte[]{};
        try {
            byArray = this.mProtocolSender.interactiveData(new byte[][]{string2.getBytes()});
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        if (byArray == null) {
            this.mProtocolSender.release();
            return false;
        }
        CLog.i(TAG, "GET_PARAMETER call back ----->" + new String(byArray));
        return true;
    }

    @Override
    public boolean sendRequestSetParamter() {
        ++this.cseq;
        String string = "volume: -3.000000";
        String string2 = new ProtocolBuilder().getSetParameterCmd(this.mLocalip).setRtspSeq(this.cseq + "").setLelinkDeviceId(this.mDeviceId).setRtspDacp("8A3D47D2C13675B8").setRtsActiveRemote("2317505163").setContentLength("19").setUserAgent("AirPlay/150.33").getString(true);
        string2 = string2 + string + "\r\n";
        CLog.i(TAG, "SET_PARAMETER call back ----->" + new String(string2));
        byte[] byArray = new byte[]{};
        try {
            byArray = this.mProtocolSender.interactiveData(new byte[][]{string2.getBytes()});
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        if (byArray == null) {
            this.mProtocolSender.release();
            return false;
        }
        return true;
    }

    @Override
    public boolean sendRequestSetOptions() {
        ++this.cseq;
        byte[] byArray = new ProtocolBuilder().getOptionsCmd().setRtspSeq(this.cseq + "").setLelinkDeviceId(this.mDeviceId).setRtspDacp("8A3D47D2C13675B8").setRtsActiveRemote("2317505163").setContentLength("0").setUserAgent("AirPlay/150.33").getProtocal(true);
        if (this.mProtocolSender == null) {
            return false;
        }
        byte[] byArray2 = new byte[]{};
        try {
            byArray2 = this.mProtocolSender.interactiveData(new byte[][]{byArray});
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        if (byArray2 == null) {
            CLog.i(TAG, "Session End");
        } else {
            try {
                CLog.i(TAG, "startCapture in options exe keep-alive-->" + new String(byArray2));
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
        }
        return true;
    }

    @Override
    public boolean sendRequestSetTeardown() {
        if (this.mProtocolSender != null) {
            ++this.cseq;
            byte[] byArray = new ProtocolBuilder().getTearDown(this.mLocalip).setRtspSeq(this.cseq + "").setLelinkDeviceId(this.mDeviceId).setUserAgent("AirPlay/150.33").getProtocal(true);
            byte[] byArray2 = new byte[]{};
            try {
                byArray2 = this.mProtocolSender.interactiveData(new byte[][]{byArray});
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
            if (byArray2 != null) {
                CLog.i(TAG, "sendRequestSetTeardown result -->" + new String(byArray2));
            }
            this.release();
        }
        return true;
    }

    @Override
    public boolean setMirrorMode(String string) {
        return false;
    }

    @Override
    public boolean isEncrypt() {
        return this.mEncrypt;
    }

    @Override
    public double getRefreshRate() {
        return this.mRefreshRate;
    }

    @Override
    public int getBitRate() {
        return this.mBitrate;
    }

    @Override
    public int getSinkWidth() {
        return this.mWidth;
    }

    @Override
    public int getSinkHeight() {
        return this.mHeight;
    }

    @Override
    public void setSinkWidth(int n2) {
        this.mWidth = n2;
    }

    @Override
    public void setSinkHeight(int n2) {
        this.mHeight = n2;
    }

    @Override
    public int getTvWidth() {
        return this.mTvWidth;
    }

    @Override
    public int getTvHeight() {
        return this.mTvHeight;
    }

    @Override
    public VideoSender getVideoDataSender() {
        return this.mVideoDataSender;
    }

    @Override
    public int getAudioPort() {
        return this.mUdpServerPort;
    }

    @Override
    public String getAudioServerIp() {
        return this.mIp;
    }

    @Override
    public String getEncodeType() {
        return this.mEncodeType;
    }

    @Override
    public void release() {
        if (this.mVideoDataSender != null) {
            this.mVideoDataSender.release();
        }
        if (this.mProtocolSender != null) {
            this.mProtocolSender.release();
        }
    }

    private void parseMirrorPort(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        CLog.d(TAG, "------->" + new String(byArray));
        NSDictionary nSDictionary = null;
        try {
            NSDictionary nSDictionary2;
            NSArray nSArray;
            byte[] byArray2 = ProtocolUtils.removeHeader(byArray);
            nSDictionary = (NSDictionary)PropertyListParser.parse(byArray2);
            if (nSDictionary != null && (nSArray = (NSArray)nSDictionary.objectForKey("streams")) != null && (nSDictionary2 = (NSDictionary)nSArray.objectAtIndex(0)) != null) {
                NSNumber nSNumber = (NSNumber)nSDictionary2.objectForKey("dataPort");
                this.mMirrorPort = nSNumber != null ? nSNumber.intValue() : 7100;
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            this.mMirrorPort = 7100;
        }
    }

    public int parseMirrorInfo(String string) {
        block10: {
            String[] stringArray = null;
            stringArray = string.split("\r\n");
            String string2 = stringArray[0];
            if (!TextUtils.isEmpty((CharSequence)string2) && string2.contains("200")) {
                if (string.contains("happycast")) {
                    this.mEncrypt = true;
                }
                byte[] byArray = ProtocolUtils.removeHeader(string.getBytes());
                try {
                    NSDictionary nSDictionary = (NSDictionary)PropertyListParser.parse(byArray);
                    if (nSDictionary == null) break block10;
                    this.mTvWidth = ((NSNumber)nSDictionary.objectForKey("width")).intValue();
                    this.mTvHeight = ((NSNumber)nSDictionary.objectForKey("height")).intValue();
                    this.adjustScreenSize();
                    try {
                        double d2 = ((NSNumber)nSDictionary.objectForKey("refreshRate")).doubleValue();
                        if (d2 < 1.0) {
                            d2 = 1.0 / d2;
                        }
                        this.mRefreshRate = d2;
                    }
                    catch (Exception exception) {
                        CLog.w(TAG, exception);
                    }
                    CLog.i(TAG, "" + this.mTvWidth + "x" + this.mTvHeight + "@" + this.mRefreshRate);
                    return 1;
                }
                catch (Exception exception) {
                    CLog.w(TAG, exception);
                }
            } else if (!TextUtils.isEmpty((CharSequence)string2) && string2.contains("401")) {
                String string3;
                String[] stringArray2 = string.split("\r\n");
                if (stringArray2 != null && stringArray2.length > 0 && !TextUtils.isEmpty((CharSequence)(string3 = stringArray2[stringArray2.length - 1]))) {
                    int n2 = string3.indexOf("=");
                    int n3 = string3.indexOf(",");
                    String string4 = string3.substring(n2 + 1, n3 - 1).replace("\"", "");
                    String string5 = string3.substring(n3 + 1);
                    n2 = string5.indexOf("=");
                    String string6 = string5.substring(n2 + 1).replace("\"", "");
                    ProtocolBuilder.mRealm = string4;
                    ProtocolBuilder.mNonce = string6;
                    CLog.d(TAG, "author  :  " + string3);
                }
                return 10;
            }
        }
        return 0;
    }
}

