/*
 * Decompiled with CFR 0.152.
 */
package com.unisound.edu.oraleval.sdk.sep15.handlers;

import android.media.AudioRecord;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import au.com.ds.ef.EasyFlow;
import au.com.ds.ef.EventEnum;
import au.com.ds.ef.FlowBuilder;
import au.com.ds.ef.StateEnum;
import au.com.ds.ef.StatefulContext;
import au.com.ds.ef.call.ContextHandler;
import com.unisound.edu.oraleval.sdk.sep15.IOralEvalSDK;
import com.unisound.edu.oraleval.sdk.sep15.SDKError;
import com.unisound.edu.oraleval.sdk.sep15.handlers.Arbitrator;
import com.unisound.edu.oraleval.sdk.sep15.intf.IHandler;
import com.unisound.edu.oraleval.sdk.sep15.intf.ISDK;
import com.unisound.edu.oraleval.sdk.sep15.intf.MessageProcessor;
import com.unisound.edu.oraleval.sdk.sep15.utils.LogBuffer;
import com.unisound.edu.oraleval.sdk.sep15.utils.SDKErrorException;
import com.unisound.edu.oraleval.sdk.sep15.utils.Utils;
import com.unisound.jni.UniVadnn;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;

public class VoiceSource
implements IHandler<Events> {
    static final String TAG = "VoiceSource";
    boolean _adrHStopped = false;
    EasyFlow<Context> _sm;
    Context _cxt;
    UniVadnn _vadnn;
    boolean isAfter = false;
    boolean isEnd = false;
    private int end_time = 2000;
    private int no_voice_time = 0;
    Handler _adrH;
    boolean isOpusStream;
    static final int MSG_READ = 1;
    static final int MSG_START = 2;
    public static VoiceSource THIS;
    public static int AUDIO_INTERVAL;
    public static int PCM_PACK_LEN;

    @Override
    public void trigger(Events event, HashMap<String, Object> params) {
        if (this._adrHStopped) {
            return;
        }
        if (event.equals(Events.stop)) {
            LogBuffer.ONE.i("LJ", "VoiceSource stop");
            this._cxt.safeTrigger(Events.stop);
        }
    }

    @Override
    public void quit() {
        LogBuffer.ONE.i(TAG, "quit VoiceSource");
        this._adrHStopped = true;
        this._cxt.deinit();
        if (this._vadnn != null) {
            this._vadnn.release();
            this._vadnn = null;
        }
    }

    public VoiceSource(final ISDK parent, final InputStream customSource, boolean isOpusStream) {
        Log.i((String)TAG, (String)("new " + this.getClass().getSimpleName() + "@ t" + Thread.currentThread().getId() + " VadAfterMs = " + parent.getCfg().getVadAfterMs() + " VadBeforeMs = " + parent.getCfg().getVadBeforeMs()));
        THIS = this;
        VoiceSource.THIS.isOpusStream = isOpusStream;
        this._adrH = parent.newHandler(this.getClass().getSimpleName(), new MessageProcessor(){

            @Override
            public void handleMessage(Message msg) {
                if (VoiceSource.this._adrHStopped) {
                    LogBuffer.ONE.w(VoiceSource.TAG, "received message " + msg.what + " after handler stopped");
                    return;
                }
                try {
                    switch (msg.what) {
                        case 2: {
                            VoiceSource.this._sm.start(true, VoiceSource.this._cxt);
                            break;
                        }
                        case 1: {
                            VoiceSource.this._cxt.trigger(Events.readTick);
                            break;
                        }
                        default: {
                            LogBuffer.ONE.e(VoiceSource.TAG, "unknown msg " + msg.what);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    LogBuffer.ONE.e(VoiceSource.TAG, "process message " + msg.what, e);
                }
            }
        });
        this._cxt = new Context();
        this._sm = FlowBuilder.from(States.endpoint).transit(FlowBuilder.on(Events.initOk).to(States.initialized).transit(FlowBuilder.on(Events.readTick).to(States.reading).transit(FlowBuilder.on(Events.readTick).to(States.initialized), FlowBuilder.on(Events.stop).finish(States.stopped), FlowBuilder.on(Events.readFail).finish(States.stopped)), FlowBuilder.on(Events.stop).finish(States.stopped)), FlowBuilder.on(Events.initFail).finish(States.stopped), FlowBuilder.on(Events.stop).finish(States.stopped));
        this._sm.whenEnter(States.endpoint, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(VoiceSource.TAG, "SM>>" + States.endpoint.toString());
                SDKError e = _this.init(customSource);
                if (e != null) {
                    _this._lastError = e;
                    _this.trigger(Events.initFail);
                } else {
                    _this.trigger(Events.initOk);
                }
                if (parent.getCfg().isVadEnable()) {
                    VoiceSource.this._vadnn = new UniVadnn(parent.get_cxt().getApplicationContext(), parent.getCfg().getVadBeforeMs(), parent.getCfg().getVadAfterMs());
                    VoiceSource.this._vadnn.uniVadSetOption(4, parent.getCfg().getLowEnergy());
                    VoiceSource.this._vadnn.uniVadSetOption(5, Float.valueOf(parent.getCfg().getLowEnergyPenalty()));
                    VoiceSource.this.end_time = parent.getCfg().getVadBeforeMs();
                    if (VoiceSource.this.end_time < 1000) {
                        VoiceSource.this.end_time = 1000;
                    }
                    VoiceSource.this.isAfter = false;
                    VoiceSource.this.no_voice_time = 0;
                }
            }
        });
        this._sm.whenEnter(States.initialized, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(VoiceSource.TAG, "SM>>" + States.initialized.toString());
                VoiceSource.this._adrH.sendEmptyMessageDelayed(1, (long)_this.getAudioProcessDelay());
            }
        });
        this._sm.whenEnter(States.stopped, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(VoiceSource.TAG, "SM>>" + States.stopped.toString());
                VoiceSource.this._adrHStopped = true;
                _this.deinit();
                if (_this._lastError != null) {
                    Arbitrator.THIS.trigger(Arbitrator.ExternalEvents.exVoiceSourceError, Utils.getParam(_this._lastError, "error"));
                } else {
                    Arbitrator.THIS.trigger(Arbitrator.ExternalEvents.exVoiceSourceEnd, Utils.getParam((Object)_this._endReason, "reason"));
                }
            }
        });
        this._sm.whenEnter(States.reading, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(VoiceSource.TAG, "SM>>" + States.reading.toString());
                try {
                    HashMap<String, Object> param;
                    byte[] b = new byte[PCM_PACK_LEN];
                    boolean end = _this.read(b);
                    VoiceSource.this._adrH.sendEmptyMessage(1);
                    if (VoiceSource.THIS.isOpusStream) {
                        param = Utils.getParam(b, "voiceData");
                        param.put("audioSessionId", VoiceSource.this._cxt._audioSessionId);
                        Arbitrator.THIS.trigger(Arbitrator.ExternalEvents.exOpusData, param);
                        if (end) {
                            VoiceSource.this._cxt.setEndReason(IOralEvalSDK.EndReason.InputStreamEnd);
                            _this.trigger(Events.stop);
                            return;
                        }
                    } else {
                        param = Utils.getParam(b, "voiceData");
                        param.put("audioSessionId", VoiceSource.this._cxt._audioSessionId);
                        Arbitrator.THIS.trigger(Arbitrator.ExternalEvents.exVoiceData, param);
                        if (end) {
                            VoiceSource.this._cxt.setEndReason(IOralEvalSDK.EndReason.InputStreamEnd);
                            _this.trigger(Events.stop);
                            return;
                        }
                    }
                    if (VoiceSource.this._vadnn != null) {
                        int i = 0;
                        while ((i + 1) * 320 < b.length) {
                            byte[] data = new byte[320];
                            System.arraycopy(b, i * 320, data, 0, 320);
                            if (data.length == 320) {
                                int code = VoiceSource.this._vadnn.deal(data);
                                Log.d((String)VoiceSource.TAG, (String)String.valueOf(code));
                                if (!VoiceSource.this.isAfter) {
                                    if (code == 1001) {
                                        VoiceSource.this._cxt.setEndReason(IOralEvalSDK.EndReason.NoVoice);
                                        LogBuffer.ONE.d(VoiceSource.TAG, "SM>>" + IOralEvalSDK.EndReason.NoVoice.name());
                                        _this.trigger(Events.stop);
                                        return;
                                    }
                                    if (code < 0) {
                                        VoiceSource.this.isAfter = true;
                                        VoiceSource.this.isEnd = false;
                                        VoiceSource.this.no_voice_time = 0;
                                        VoiceSource.this.end_time = parent.getCfg().getVadAfterMs();
                                        if (VoiceSource.this.end_time > 6000) {
                                            VoiceSource.this.end_time = 6000;
                                        }
                                        if (VoiceSource.this.end_time < 20) {
                                            VoiceSource.this.end_time = 20;
                                        }
                                    }
                                } else if (code > 0) {
                                    VoiceSource.this._cxt.setEndReason(IOralEvalSDK.EndReason.VoiceEnd);
                                    LogBuffer.ONE.d(VoiceSource.TAG, "SM>>" + IOralEvalSDK.EndReason.VoiceEnd.name());
                                    _this.trigger(Events.stop);
                                    return;
                                }
                            }
                            ++i;
                        }
                    }
                }
                catch (SDKErrorException re) {
                    _this._lastError = re.sdkError();
                    _this.trigger(Events.readFail);
                    LogBuffer.ONE.e(VoiceSource.TAG, "reading", re.sdkError().exp);
                }
            }
        });
        this._adrH.sendEmptyMessage(2);
    }

    static {
        AUDIO_INTERVAL = 200;
        PCM_PACK_LEN = AUDIO_INTERVAL * 32000 / 1000;
    }

    static class Context
    extends StatefulContext {
        private IOralEvalSDK.EndReason _endReason = IOralEvalSDK.EndReason.UserAction;
        AudioRecord _ar;
        InputStream _is;
        int _audioSessionId = -1;
        static final byte[] EMPTY = new byte[PCM_PACK_LEN];
        int allZeroAudioDataCheckCount = 5;
        int readFailedCheckCount = 3;
        long _lastReadDoneTime;
        SDKError _lastError;

        Context() {
            super("cVoiceSource");
        }

        SDKError init(InputStream is) {
            if (is != null) {
                this._is = is;
                return null;
            }
            try {
                this._ar = new AudioRecord(0, 16000, 16, 2, 32000);
                for (int waitTimes = 2; this._ar.getState() != 1 && waitTimes > 0; --waitTimes) {
                    Thread.sleep(50L);
                }
                this._ar.startRecording();
                this._audioSessionId = -1;
                try {
                    if (this._ar != null && Build.VERSION.SDK_INT >= 16) {
                        Method m = this._ar.getClass().getDeclaredMethod("getAudioSessionId", new Class[0]);
                        this._audioSessionId = (Integer)m.invoke((Object)this._ar, new Object[0]);
                    }
                }
                catch (Exception ee) {
                    LogBuffer.ONE.e(VoiceSource.TAG, "getting audio session id", ee);
                }
            }
            catch (IllegalStateException e) {
                return new SDKError(SDKError.Category.Device, -1001, e);
            }
            catch (Exception e) {
                return new SDKError(SDKError.Category.Device, -1001, e);
            }
            return null;
        }

        boolean read(byte[] b) throws SDKErrorException {
            int rd;
            for (int left = b.length; left > 0; left -= rd) {
                rd = 0;
                if (this._is != null) {
                    try {
                        rd = this._is.read(b, b.length - left, left);
                    }
                    catch (IOException ioe) {
                        throw new SDKErrorException(new SDKError(SDKError.Category.Device, -1002, ioe));
                    }
                    if (rd > 0) continue;
                    LogBuffer.ONE.i(VoiceSource.TAG, "input voice stream ended with read return " + rd);
                    System.arraycopy(EMPTY, 0, b, b.length - left, left);
                    return true;
                }
                try {
                    rd = this._ar.read(b, b.length - left, left);
                    if (rd <= 0) {
                        if (this.readFailedCheckCount > 0) {
                            --this.readFailedCheckCount;
                        }
                        if (this.readFailedCheckCount <= 0) {
                            throw new SDKErrorException(new SDKError(SDKError.Category.Device, -1001, new RuntimeException("read returns " + rd)));
                        }
                        LogBuffer.ONE.w(VoiceSource.TAG, "read returns " + rd + " time -" + this.readFailedCheckCount);
                        if (rd == -3) {
                            int arState = this._ar.getState();
                            LogBuffer.ONE.w(VoiceSource.TAG, "audio record status:" + arState);
                            arState = this._ar.getRecordingState();
                            LogBuffer.ONE.w(VoiceSource.TAG, "is audio recording?" + (arState == 3));
                        }
                        System.arraycopy(EMPTY, 0, b, 0, b.length);
                    }
                    if (this.allZeroAudioDataCheckCount <= 0) continue;
                    boolean allZero = true;
                    for (int i = b.length - left; i < b.length - left + rd; ++i) {
                        if (b[i] == 0) continue;
                        allZero = false;
                        break;
                    }
                    if (!allZero) {
                        this.allZeroAudioDataCheckCount = -1;
                        continue;
                    }
                    --this.allZeroAudioDataCheckCount;
                    if (this.allZeroAudioDataCheckCount != 0) continue;
                    throw new SDKErrorException(new SDKError(SDKError.Category.Device, -1001, new RuntimeException("all zero data from microphone")));
                }
                catch (SDKErrorException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new SDKErrorException(new SDKError(SDKError.Category.Device, -1001, e));
                }
            }
            this._lastReadDoneTime = System.currentTimeMillis();
            return false;
        }

        int getAudioProcessDelay() {
            long cur = System.currentTimeMillis();
            long passed = cur - this._lastReadDoneTime;
            if (passed > (long)AUDIO_INTERVAL) {
                return 0;
            }
            return (int)((long)AUDIO_INTERVAL - passed - 10L);
        }

        void deinit() {
            if (this._is != null) {
                try {
                    this._is.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this._is = null;
                return;
            }
            if (this._ar != null) {
                try {
                    this._ar.stop();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this._ar.release();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._ar = null;
            }
        }

        public void setEndReason(IOralEvalSDK.EndReason inputStreamEnd) {
            this._endReason = inputStreamEnd;
        }
    }

    public static enum Events implements EventEnum
    {
        initOk,
        initFail,
        readTick,
        readFail,
        stop;

    }

    public static enum States implements StateEnum
    {
        endpoint,
        initialized,
        reading,
        stopped;

    }
}

