/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.dlna;

import android.text.TextUtils;
import com.hpplay.component.common.dlna.IDLNAController;
import com.hpplay.component.common.protocol.ProtocolListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.dlna.DLNASender;
import com.hpplay.component.dlna.UPNPSubscriber;
import com.hpplay.cybergarage.upnp.Device;
import com.hpplay.cybergarage.upnp.UPnP;
import com.hpplay.cybergarage.upnp.event.EventListener;
import com.hpplay.cybergarage.xml.Node;
import com.hpplay.cybergarage.xml.Parser;
import com.hpplay.cybergarage.xml.XML;
import com.hpplay.cybergarage.xml.parser.XmlPullParser;
import java.io.ByteArrayInputStream;
import org.json.JSONObject;

public class DLNAControllerImp
implements IDLNAController {
    private static final String TAG = "DLNAControllerImp";
    private static final String CMD_TAG = "LLL@BBB";
    private Device mCurrentDevce;
    private DLNASender mDlnaSender;
    private int mMaxVolume = 100;
    private int mCurrentVolume;
    public static final String RESULT_SUCCESSFUL = "successful";
    public static final String RESULT_FAILED = "failed";
    public static final String PLAYING = "PLAYING";
    public static final String STOPPED = "STOPPED";
    public static final String LOADING = "loading";
    public static final String PAUSED = "PAUSED_PLAYBACK";
    private ProtocolListener mProtocolListener;
    private boolean isPlaying;
    private int instanceId;
    private String mUuid;
    private String mCurrentUrl;
    private static boolean isRetryHttp;
    private final EventListener eventListener = new EventListener(){

        @Override
        public void eventNotifyReceived(String string, long l2, String string2, String string3) {
            CLog.i(DLNAControllerImp.TAG, " ====================>> value:" + string2 + " uuid " + string);
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                if (string3.contains(DLNAControllerImp.PLAYING)) {
                    if (DLNAControllerImp.this.mProtocolListener != null && !DLNAControllerImp.this.isPlaying) {
                        DLNAControllerImp.this.isPlaying = true;
                        DLNAControllerImp.this.mProtocolListener.onResult(13, DLNAControllerImp.this.parseUrl(string3), string, String.valueOf(DLNAControllerImp.this.instanceId));
                    }
                    CLog.i(DLNAControllerImp.TAG, " PLAYING " + DLNAControllerImp.this.instanceId);
                } else if (string3.contains(DLNAControllerImp.PAUSED)) {
                    CLog.i(DLNAControllerImp.TAG, " PAUSED ");
                    DLNAControllerImp.this.isPlaying = false;
                    if (DLNAControllerImp.this.mProtocolListener != null) {
                        DLNAControllerImp.this.mProtocolListener.onResult(15, new String[0]);
                    }
                } else if (string3.contains(DLNAControllerImp.STOPPED)) {
                    CLog.i(DLNAControllerImp.TAG, " STOPPED " + DLNAControllerImp.this.instanceId);
                    DLNAControllerImp.this.isPlaying = false;
                    if (DLNAControllerImp.this.mProtocolListener != null) {
                        DLNAControllerImp.this.mProtocolListener.onResult(16, DLNAControllerImp.this.parseUrl(string3), string, String.valueOf(DLNAControllerImp.this.instanceId));
                    }
                }
                DLNAControllerImp.this.mUuid = string;
            }
        }
    };

    @Override
    public boolean connect(String string, String string2, ProtocolListener protocolListener) {
        try {
            this.instanceId = this.hashCode();
            CLog.i(TAG, "--------------------------- >  connect");
            Parser parser = UPnP.getXMLParser();
            Node node = parser.parseUrl(string);
            this.mCurrentDevce = this.getDevice(node);
            if (this.mCurrentDevce != null) {
                this.mCurrentDevce.setLocation(string);
                CLog.i(TAG, this.mCurrentDevce.getFriendlyName() + " " + this.mCurrentDevce.getManufacture() + "  " + this.mCurrentDevce.getManufactureURL() + "is huawei ");
                this.mDlnaSender = new DLNASender(this.mCurrentDevce, string2);
                this.mDlnaSender.retryHttpSwitch(isRetryHttp);
                this.mProtocolListener = protocolListener;
                this.init(string2);
                return true;
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        return false;
    }

    private void init(String string) {
        this.mCurrentVolume = this.mDlnaSender.getVoice();
        UPNPSubscriber.getInstance().startSubscribeServ(string);
        UPNPSubscriber.getInstance().setSubscribeEventListener(this.eventListener);
        CLog.i(TAG, " subscribePlayEvent ----------- >  " + UPNPSubscriber.getInstance().subscribePlayEvent(this.mCurrentDevce));
    }

    private String parseUrl(String string) {
        String string2 = "";
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            Node node = new XmlPullParser().parse(byteArrayInputStream);
            Node node2 = node.getNode("InstanceID");
            Node node3 = node2.getNode("AVTransportURI");
            if (node3 != null) {
                string2 = node3.getAttribute("val").getValue();
                CLog.i(TAG, string2);
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        return string2;
    }

    private Device getDevice(Node node) {
        if (node == null) {
            return null;
        }
        Node node2 = node.getNode("device");
        if (node2 == null) {
            return null;
        }
        return new Device(node, node2);
    }

    @Override
    public String[] sendAction(String string) {
        boolean bl = false;
        CLog.i(TAG, "play url " + this.mCurrentUrl + "  mateData =========> " + string);
        String[] stringArray = new String[1];
        try {
            Object object;
            if (string.startsWith("Play")) {
                try {
                    object = string.split(CMD_TAG);
                    this.mCurrentUrl = object[1];
                    bl = this.mDlnaSender.play(this.mCurrentUrl, (String)object[2]);
                    if (!bl) {
                        String string2 = this.mDlnaSender.getDesc();
                        String string3 = this.mDlnaSender.getErrMsg();
                        String string4 = this.mDlnaSender.getLocation();
                        int n2 = this.mDlnaSender.getErrCode();
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("location_uri").append("\r\n").append(string4).append("\r\n").append("desc").append("\r\n").append(string2).append("\r\n").append(string3);
                        JSONObject jSONObject = new JSONObject();
                        jSONObject.put("errMsg", (Object)stringBuilder.toString());
                        jSONObject.put("errCode", n2);
                        stringArray = new String[]{RESULT_FAILED, jSONObject.toString()};
                        return stringArray;
                    }
                    if (((Object)object).length > 3) {
                        this.mDlnaSender.setStartPosition(Integer.parseInt((String)object[3]));
                    }
                }
                catch (Exception exception) {
                    CLog.w(TAG, exception);
                }
            } else if (string.startsWith("SetVolume")) {
                object = string.split(CMD_TAG);
                bl = this.mDlnaSender.setVoice(Integer.parseInt(object[1]));
            } else if (string.startsWith("Seek")) {
                object = string.split(CMD_TAG);
                int n3 = Integer.parseInt((String)object[1]);
                bl = this.mDlnaSender.seek(String.valueOf(n3 * 1000));
            }
            switch (string) {
                case "Pause": {
                    bl = this.mDlnaSender.pause();
                    break;
                }
                case "Resume": {
                    bl = this.mDlnaSender.resume();
                    break;
                }
                case "GetPositionInfo": {
                    stringArray[0] = this.mDlnaSender.getPositionInfo();
                    break;
                }
                case "GetTransportInfo": {
                    stringArray = new String[]{this.mDlnaSender.getTransportState(), this.mCurrentUrl, this.mUuid};
                    break;
                }
                case "Stop": {
                    bl = this.mDlnaSender.stop();
                    break;
                }
                case "incvloume": {
                    if (this.mCurrentVolume >= this.mMaxVolume) {
                        this.mCurrentVolume = this.mMaxVolume;
                    } else {
                        this.mCurrentVolume += 10;
                        CLog.i(TAG, "add volume " + this.mMaxVolume + " " + this.mCurrentVolume);
                    }
                    bl = this.mDlnaSender.setVoice(this.mCurrentVolume);
                    break;
                }
                case "decvolume": {
                    if (this.mCurrentVolume <= 0) {
                        this.mCurrentVolume = 0;
                    }
                    this.mCurrentVolume -= 10;
                    if (this.mCurrentVolume < 0) {
                        this.mCurrentVolume = 0;
                    }
                    CLog.i(TAG, " remain volume " + this.mMaxVolume + " " + this.mCurrentVolume);
                    bl = this.mDlnaSender.setVoice(this.mCurrentVolume);
                }
            }
            if (!(string.contains("GetMediaInfo") || string.contains("GetPositionInfo") || string.contains("GetTransportInfo"))) {
                stringArray[0] = bl ? RESULT_SUCCESSFUL : RESULT_FAILED;
            }
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
        CLog.i(TAG + Thread.currentThread().getName(), stringArray[0]);
        return stringArray;
    }

    public String escapeXMLChars(String string) {
        return XML.escapeXMLChars(string);
    }

    public void retryHttp(boolean bl) {
        isRetryHttp = bl;
    }

    @Override
    public String close() {
        CLog.i(TAG, " close " + this.instanceId);
        UPNPSubscriber.getInstance().removeSubscribeEventListener(this.eventListener);
        UPNPSubscriber.getInstance().unSubscribe(this.mCurrentDevce);
        this.isPlaying = false;
        this.mDlnaSender = null;
        this.mCurrentDevce = null;
        return null;
    }
}

