/*
 * Decompiled with CFR 0.152.
 */
package au.com.ds.ef;

import au.com.ds.ef.EasyFlow;
import au.com.ds.ef.EventEnum;
import au.com.ds.ef.StateEnum;
import au.com.ds.ef.StatefulContext;
import au.com.ds.ef.Transition;

public class FlowBuilder<C extends StatefulContext> {
    private EasyFlow<C> flow;

    private FlowBuilder(StateEnum startState) {
        this.flow = new EasyFlow(startState);
    }

    public static <C extends StatefulContext> FlowBuilder<C> from(StateEnum startState) {
        return new FlowBuilder<C>(startState);
    }

    public static ToHolder on(EventEnum event) {
        return new ToHolder(event);
    }

    public <C1 extends StatefulContext> EasyFlow<C1> transit(Transition ... transitions) {
        return this.transit(false, transitions);
    }

    public <C1 extends StatefulContext> EasyFlow<C1> transit(boolean skipValidation, Transition ... transitions) {
        for (Transition transition : transitions) {
            transition.setStateFrom(this.flow.getStartState());
        }
        this.flow.processAllTransitions(skipValidation);
        return this.flow;
    }

    public static class ToHolder {
        private EventEnum event;

        private ToHolder(EventEnum event) {
            this.event = event;
        }

        public Transition to(StateEnum state) {
            return new Transition(this.event, state, false);
        }

        public Transition finish(StateEnum state) {
            return new Transition(this.event, state, true);
        }
    }
}

