/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.srp6.cli;

import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.srp6.BigIntegerUtils;
import com.hpplay.component.protocol.srp6.SRP6ClientSession;
import com.hpplay.component.protocol.srp6.XRoutineWithUserIdentity;
import com.hpplay.component.protocol.srp6.cli.ClientEvidenceRoutineImpl;
import com.hpplay.component.protocol.srp6.cli.HashedKeysRoutineImpl;
import com.hpplay.component.protocol.srp6.cli.ServerEvidenceRoutineImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;

public class ClientSessionImpl
extends SRP6ClientSession {
    private final String TAG = "ClientSessionImpl";

    public ClientSessionImpl() {
        this.setClientEvidenceRoutine(new ClientEvidenceRoutineImpl(this));
        this.setServerEvidenceRoutine(new ServerEvidenceRoutineImpl(this));
        this.setXRoutine(new XRoutineWithUserIdentity());
        this.setHashedKeysRoutine(new HashedKeysRoutineImpl());
    }

    @Override
    public byte[] getSessionKeyHash() {
        if (this.S == null) {
            return null;
        }
        MessageDigest messageDigest = this.config.getMessageDigestInstance();
        if (messageDigest == null) {
            throw new IllegalArgumentException("Unsupported hash algorithm 'H': " + this.config.H);
        }
        messageDigest.update(BigIntegerUtils.bigIntegerToBytes(this.S));
        messageDigest.update(new byte[]{0, 0, 0, 0});
        byte[] byArray = messageDigest.digest();
        messageDigest.update(BigIntegerUtils.bigIntegerToBytes(this.S));
        messageDigest.update(new byte[]{0, 0, 0, 1});
        byte[] byArray2 = messageDigest.digest();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(byArray2);
        }
        catch (IOException iOException) {
            CLog.w("ClientSessionImpl", iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

