/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.push;

import android.text.TextUtils;
import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.protocol.IConnector;
import com.hpplay.component.common.protocol.IPushController;
import com.hpplay.component.common.protocol.ProtocolListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.LelinkReverseChannel;
import com.hpplay.component.protocol.ProtocolSender;
import com.hpplay.component.protocol.push.DLNAPushHandler;
import com.hpplay.component.protocol.push.IPushHandler;
import com.hpplay.component.protocol.push.LelinkPushHandler;
import com.hpplay.component.protocol.push.LelinkV2PushHandler;
import java.util.concurrent.atomic.AtomicBoolean;

public class PushControllerImpl
extends IPushController {
    private static final String TAG = "PushControllerImpl";
    private static final int TYPE_PLAY_SINGLE = 1;
    private static final int TYPE_PLAY_LIST = 2;
    private static final int RETRY_PLAY_MAX_COUNT = 2;
    private int retryCount = 0;
    private int mPlayType;
    private int mType = 0;
    private ProtocolSender mProtocolSender;
    private IPushHandler mPushBuilder;
    private LelinkReverseChannel mReverseChannel;
    private ProtocolListener mProtocolListener;
    private String mUrl;
    private ParamsMap mParams;
    private IConnector mConnector;
    private AtomicBoolean mConnection = new AtomicBoolean(true);
    private String mLocation = "";
    private final ProtocolListener mConnectProtocolListener = new ProtocolListener(){

        @Override
        public void onResult(int n2, String ... stringArray) {
            if (!PushControllerImpl.this.getConnectionState()) {
                CLog.i(PushControllerImpl.TAG, " the push connection is disconnect  ");
                return;
            }
            CLog.i(PushControllerImpl.TAG, "==============> " + n2 + "  ");
            try {
                if (PushControllerImpl.this.mType == 3) {
                    if (n2 == 11 && !stringArray[0].contains("successful")) {
                        PushControllerImpl.this.eventCallback(n2, stringArray);
                    }
                } else if (stringArray[0].contains("successful") && PushControllerImpl.this.mConnection.get()) {
                    CLog.i(PushControllerImpl.TAG, "the main connection is connected ");
                    if (PushControllerImpl.this.mReverseChannel != null) {
                        PushControllerImpl.this.mReverseChannel.stopReceive();
                        PushControllerImpl.this.mReverseChannel.setRecevelistenerAndProtocol(PushControllerImpl.this.mReverseProtocolListener, PushControllerImpl.this.mPushBuilder.getReverseData().getBytes());
                        PushControllerImpl.this.mReverseChannel.startReceive();
                    }
                } else if (stringArray[0].contains("603")) {
                    PushControllerImpl.this.eventCallback(1, "603");
                } else if (stringArray[0].contains("453")) {
                    PushControllerImpl.this.eventCallback(1, "453");
                } else if (PushControllerImpl.this.mConnection.get()) {
                    PushControllerImpl.this.retryPush();
                }
            }
            catch (Exception exception) {
                CLog.w(PushControllerImpl.TAG, exception);
            }
        }
    };
    ProtocolListener mSenderProtocolListener = new ProtocolListener(){

        @Override
        public void onResult(int n2, String ... stringArray) {
            if (PushControllerImpl.this.mProtocolListener != null) {
                PushControllerImpl.this.mProtocolListener.onResult(n2, stringArray);
            }
        }
    };
    ProtocolListener mReverseProtocolListener = new ProtocolListener(){

        @Override
        public void onResult(int n2, String ... stringArray) {
            if (PushControllerImpl.this.mPushBuilder != null) {
                PushControllerImpl.this.mPushBuilder.parseReversePlist(PushControllerImpl.this, stringArray);
            }
        }
    };

    private void sendProtocol(String string, ProtocolListener protocolListener) {
        if (this.mProtocolSender != null && string != null) {
            this.mProtocolSender.protocolEnqueue(protocolListener, new byte[][]{string.getBytes()});
        }
    }

    @Override
    public void setProtocolListener(ProtocolListener protocolListener) {
        this.mProtocolListener = protocolListener;
    }

    @Override
    public void getPlayInfo() {
        if (this.checkPushBuilderIsNull()) {
            return;
        }
        try {
            this.sendProtocol(this.mPushBuilder.buildGetPlayInfo(), this.mPushBuilder.getProtocolListener(8, this.mSenderProtocolListener));
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    @Override
    public void getStateInfo() {
        if (this.checkPushBuilderIsNull()) {
            return;
        }
        try {
            this.sendProtocol(this.mPushBuilder.buildGetStateInfo(), this.mPushBuilder.getProtocolListener(9, this.mSenderProtocolListener));
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    @Override
    public void selectPlay(ParamsMap paramsMap) {
        if (this.checkPushBuilderIsNull()) {
            return;
        }
        try {
            this.sendProtocol(this.mPushBuilder.buildSelectPlay(paramsMap), this.mPushBuilder.getProtocolListener(25, this.mSenderProtocolListener));
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    @Override
    public void push(String string, ParamsMap paramsMap) {
        this.retryCount = 0;
        this.mPlayType = 1;
        this.setConnectionState(true);
        this.genPushConnection(string, paramsMap);
    }

    @Override
    public void setPlayList(ParamsMap paramsMap) {
        this.setConnectionState(true);
        this.mPlayType = 2;
        this.genPushConnection(null, paramsMap);
    }

    @Override
    public void addPlayList(ParamsMap paramsMap) {
        if (this.checkPushBuilderIsNull()) {
            return;
        }
        try {
            this.sendProtocol(this.mPushBuilder.buildAddPlayList(paramsMap), this.mPushBuilder.getProtocolListener(21, this.mSenderProtocolListener));
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    @Override
    public void playNext() {
        if (this.checkPushBuilderIsNull()) {
            return;
        }
        try {
            this.sendProtocol(this.mPushBuilder.buildPlayNext(), this.mPushBuilder.getProtocolListener(22, this.mSenderProtocolListener));
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    @Override
    public void playPrevious() {
        if (this.checkPushBuilderIsNull()) {
            return;
        }
        try {
            this.sendProtocol(this.mPushBuilder.buildPlayPre(), this.mPushBuilder.getProtocolListener(23, this.mSenderProtocolListener));
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    @Override
    public void clearPlayList() {
        if (this.checkPushBuilderIsNull()) {
            return;
        }
        try {
            this.sendProtocol(this.mPushBuilder.buildClearList(), this.mPushBuilder.getProtocolListener(24, this.mSenderProtocolListener));
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    private void genPushConnection(String string, ParamsMap paramsMap) {
        this.mUrl = string;
        this.mParams = paramsMap;
        if (this.mProtocolSender == null) {
            this.mConnectProtocolListener.cmdType = 11;
            this.mProtocolSender = new ProtocolSender();
        }
        String string2 = paramsMap.getStringParam("sessionId");
        String string3 = (String)paramsMap.get("ip");
        int n2 = 0;
        if (paramsMap.get("lelink_port") != null && paramsMap.get("lelink_port").toString().length() > 0) {
            n2 = Integer.parseInt(paramsMap.get("lelink_port").toString());
        }
        this.mType = Integer.parseInt(paramsMap.get("protocol_type").toString());
        this.stopReverse();
        switch (this.mType) {
            case 1: {
                this.mPushBuilder = new LelinkPushHandler(paramsMap);
                this.mReverseChannel = new LelinkReverseChannel(string3, n2);
                this.mProtocolSender.setConnectInfo(string3, n2);
                this.mProtocolSender.startConnect(null, null, this.mType, this.mConnectProtocolListener);
                break;
            }
            case 5: {
                this.mPushBuilder = new LelinkV2PushHandler(paramsMap);
                this.mReverseChannel = new LelinkReverseChannel(string3, n2, string2);
                this.mProtocolSender.setConnectInfo(string3, n2);
                this.mProtocolSender.startConnect(string2, paramsMap.getStringParam("screencode"), this.mType, this.mConnectProtocolListener);
                break;
            }
            case 3: {
                String string4 = (String)paramsMap.get("location_uri");
                this.mPushBuilder = new DLNAPushHandler(paramsMap);
                if (this.mProtocolSender.isConnect() && TextUtils.equals((CharSequence)this.mLocation, (CharSequence)string4)) break;
                this.mLocation = string4;
                this.mProtocolSender.startConnect(string4, this.mPushBuilder.mUid, this.mType, this.mConnectProtocolListener);
            }
        }
        this.pushPlay();
    }

    private void pushPlay() {
        if (this.getConnectionState()) {
            if (this.mPlayType == 1) {
                this.sendProtocol(this.mPushBuilder.buildPush(this.mUrl, this.mParams), this.mPushBuilder.getProtocolListener(1, this.mSenderProtocolListener));
            } else {
                this.sendProtocol(this.mPushBuilder.buildSetPlayList(this.mParams), this.mPushBuilder.getProtocolListener(1, this.mSenderProtocolListener));
            }
        }
    }

    private void retryPush() {
        if (this.mConnector != null) {
            this.mConnector.checkConnection(new ProtocolListener(){

                @Override
                public void onResult(int n2, String ... stringArray) {
                    if (!PushControllerImpl.this.getConnectionState()) {
                        return;
                    }
                    try {
                        if (stringArray != null && !TextUtils.isEmpty((CharSequence)stringArray[0]) && PushControllerImpl.this.retryCount < 2) {
                            CLog.i(PushControllerImpl.TAG, " reconnect push success ");
                            PushControllerImpl.this.retryCount++;
                            ParamsMap paramsMap = ParamsMap.create(stringArray[0]);
                            PushControllerImpl.this.mParams.putParam("protocol_type", paramsMap.getParam("protocol_type", 0));
                            PushControllerImpl.this.mParams.putParam("ip", paramsMap.getIp());
                            PushControllerImpl.this.mParams.putParam("location_uri", paramsMap.getStringParam("location_uri"));
                            PushControllerImpl.this.mParams.putParam("lelink_port", paramsMap.getPort());
                            PushControllerImpl.this.genPushConnection(PushControllerImpl.this.mUrl, PushControllerImpl.this.mParams);
                        } else {
                            CLog.i(PushControllerImpl.TAG, " reconnect push failed ");
                            PushControllerImpl.this.eventCallback(1, "failed");
                        }
                    }
                    catch (Exception exception) {
                        CLog.w(PushControllerImpl.TAG, exception);
                    }
                }
            });
        } else {
            CLog.i(TAG, " start push failed ");
            this.eventCallback(1, "failed");
        }
    }

    @Override
    public void pause() {
        if (this.checkPushBuilderIsNull()) {
            return;
        }
        try {
            this.sendProtocol(this.mPushBuilder.buildPause(), this.mPushBuilder.getProtocolListener(2, this.mSenderProtocolListener));
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    @Override
    public void resume() {
        if (this.checkPushBuilderIsNull()) {
            return;
        }
        try {
            this.sendProtocol(this.mPushBuilder.buildResume(), this.mPushBuilder.getProtocolListener(3, this.mSenderProtocolListener));
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    @Override
    public void seekTo(int n2) {
        if (this.checkPushBuilderIsNull()) {
            return;
        }
        try {
            this.sendProtocol(this.mPushBuilder.buildSeekTo(n2), this.mPushBuilder.getProtocolListener(4, this.mSenderProtocolListener));
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    @Override
    public void increaseVolume() {
        if (this.checkPushBuilderIsNull()) {
            return;
        }
        this.sendProtocol(this.mPushBuilder.buildIncreaseVolume(), this.mPushBuilder.getProtocolListener(5, this.mSenderProtocolListener));
    }

    @Override
    public void decreaseVolume() {
        if (this.checkPushBuilderIsNull()) {
            return;
        }
        this.sendProtocol(this.mPushBuilder.buildDecreaseVolume(), this.mPushBuilder.getProtocolListener(6, this.mSenderProtocolListener));
    }

    @Override
    public void stopPlay() {
        if (this.checkPushBuilderIsNull()) {
            return;
        }
        try {
            this.sendProtocol(this.mPushBuilder.buildStopPlay(), this.mPushBuilder.getProtocolListener(7, this.mSenderProtocolListener));
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    @Override
    public void setConnector(IConnector iConnector) {
        this.mConnector = iConnector;
    }

    @Override
    public void onAppResume() {
        if (this.mConnector != null) {
            this.mConnector.onAppResume();
        }
    }

    @Override
    public void onAppPause() {
        if (this.mConnector != null) {
            this.mConnector.onAppPause();
        }
    }

    @Override
    public void DLNARetryHttp(boolean bl) {
        if (!this.checkPushBuilderIsNull() && this.mPushBuilder instanceof DLNAPushHandler) {
            ((DLNAPushHandler)this.mPushBuilder).retryHttp(bl);
        }
    }

    @Override
    public void selectAudiotrack(int n2) {
        if (this.checkPushBuilderIsNull()) {
            return;
        }
        this.sendProtocol(this.mPushBuilder.buildAudiotrack(n2), this.mPushBuilder.getProtocolListener(27, this.mSenderProtocolListener));
    }

    boolean checkPushBuilderIsNull() {
        if (this.mPushBuilder == null || !this.getConnectionState()) {
            CLog.i(TAG, "you must be start push");
            return true;
        }
        return false;
    }

    @Override
    public void disConnect() {
        CLog.i(TAG, "disConnect");
        this.setConnectionState(false);
        if (this.mProtocolSender != null) {
            this.mProtocolSender.release();
            this.mProtocolSender = null;
        }
        this.mPushBuilder = null;
        this.mConnector = null;
        this.stopReverse();
    }

    private void stopReverse() {
        if (this.mReverseChannel != null) {
            this.mReverseChannel.stopReceive();
            this.mReverseChannel = null;
        }
    }

    private boolean getConnectionState() {
        try {
            if (this.mConnection == null) {
                this.mConnection = new AtomicBoolean();
                this.mConnection.set(false);
            }
            return this.mConnection.get();
        }
        catch (Exception exception) {
            this.mConnection = new AtomicBoolean();
            CLog.w(TAG, exception);
            return false;
        }
    }

    private void setConnectionState(boolean bl) {
        try {
            if (this.mConnection == null) {
                this.mConnection = new AtomicBoolean();
            }
            this.mConnection.set(bl);
        }
        catch (Exception exception) {
            this.mConnection = new AtomicBoolean();
            CLog.w(TAG, exception);
        }
    }

    public void eventCallback(int n2, String ... stringArray) {
        if (this.mProtocolListener != null) {
            this.mProtocolListener.onResult(n2, stringArray);
        }
    }
}

