/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lame;

import java.io.IOException;
import java.io.InputStream;

public class Lame {
    private static final int MP3_BUFFER_SIZE = 1024;
    public static final int LAME_PRESET_DEFAULT = 0;
    public static final int LAME_PRESET_MEDIUM = 1;
    public static final int LAME_PRESET_STANDARD = 2;
    public static final int LAME_PRESET_EXTREME = 3;
    private static final String LAME_LIB = "lame";

    public static native int initializeEncoder(int var0, int var1);

    public static native void setEncoderPreset(int var0);

    public static native int encode(byte[] var0, byte[] var1, int var2, byte[] var3, int var4);

    public static native int flushEncoder(byte[] var0, int var1);

    public static native int closeEncoder();

    public static native int initializeDecoder();

    public static native int getDecoderSampleRate();

    public static native int getDecoderChannels();

    public static native int getDecoderDelay();

    public static native int getDecoderPadding();

    public static native int getDecoderTotalFrames();

    public static native int getDecoderFrameSize();

    public static native int getDecoderBitrate();

    public static int configureDecoder(InputStream input) throws IOException {
        int size = 100;
        byte[] buf = new byte[size];
        if (input.read(buf, 0, 4) != 4) {
            return -1;
        }
        if (Lame.isId3Header(buf)) {
            if (input.read(buf, 0, 6) != 6) {
                return -1;
            }
            buf[2] = (byte)(buf[2] & 0x7F);
            buf[3] = (byte)(buf[3] & 0x7F);
            buf[4] = (byte)(buf[4] & 0x7F);
            buf[5] = (byte)(buf[5] & 0x7F);
            int id3Length = (((buf[2] << 7) + buf[3] << 7) + buf[4] << 7) + buf[5];
            input.skip(id3Length);
            if (input.read(buf, 0, 4) != 4) {
                return -1;
            }
        }
        if (Lame.isAidHeader(buf)) {
            if (input.read(buf, 0, 2) != 2) {
                return -1;
            }
            int aidLength = buf[0] + 256 * buf[1];
            input.skip(aidLength);
            if (input.read(buf, 0, 4) != 4) {
                return -1;
            }
        }
        while (!Lame.isMp123SyncWord(buf)) {
            for (int i = 0; i < 3; ++i) {
                buf[i] = buf[i + 1];
            }
            int val = input.read();
            if (val == -1) {
                return -1;
            }
            buf[3] = (byte)val;
        }
        do {
            if (Lame.nativeConfigureDecoder(buf, size = input.read(buf)) != 0) continue;
            return 0;
        } while (size > 0);
        return -1;
    }

    private static boolean isId3Header(byte[] buf) {
        return buf[0] == 73 && buf[1] == 68 && buf[2] == 51;
    }

    private static boolean isAidHeader(byte[] buf) {
        return buf[0] == 65 && buf[1] == 105 && buf[2] == 68 && buf[3] == 1;
    }

    private static boolean isMp123SyncWord(byte[] buf) {
        char[] abl2 = new char[]{'\u0000', '\u0007', '\u0007', '\u0007', '\u0000', '\u0007', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\b', '\b', '\b', '\b', '\b'};
        if ((buf[0] & 0xFF) != 255) {
            return false;
        }
        if ((buf[1] & 0xE0) != 224) {
            return false;
        }
        if ((buf[1] & 0x18) == 8) {
            return false;
        }
        if ((buf[1] & 6) == 0) {
            return false;
        }
        if ((buf[2] & 0xF0) == 240) {
            return false;
        }
        if ((buf[2] & 0xC) == 12) {
            return false;
        }
        if ((buf[1] & 0x18) == 24 && (buf[1] & 6) == 4 && (abl2[buf[2] >> 4] & 1 << (buf[3] >> 6)) != 0) {
            return false;
        }
        return (buf[3] & 3) != 2;
    }

    private static native int nativeConfigureDecoder(byte[] var0, int var1);

    public static int decodeFrame(InputStream input, short[] pcmLeft, short[] pcmRight) throws IOException {
        int len = 0;
        int samplesRead = 0;
        byte[] buf = new byte[1024];
        samplesRead = Lame.nativeDecodeFrame(buf, len, pcmLeft, pcmRight);
        if (samplesRead != 0) {
            return samplesRead;
        }
        do {
            if ((len = input.read(buf)) != -1) continue;
            samplesRead = Lame.nativeDecodeFrame(buf, len, pcmLeft, pcmRight);
            break;
        } while ((samplesRead = Lame.nativeDecodeFrame(buf, len, pcmLeft, pcmRight)) <= 0);
        return samplesRead;
    }

    private static native int nativeDecodeFrame(byte[] var0, int var1, short[] var2, short[] var3);

    public static native int closeDecoder();

    static {
        System.loadLibrary(LAME_LIB);
    }
}

