/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns;

import com.hpplay.sdk.source.mdns.MulticastDNSQuerier;
import com.hpplay.sdk.source.mdns.Response;
import com.hpplay.sdk.source.mdns.xbill.dns.Header;
import com.hpplay.sdk.source.mdns.xbill.dns.Message;
import com.hpplay.sdk.source.mdns.xbill.dns.MulticastDNSUtils;
import com.hpplay.sdk.source.mdns.xbill.dns.Options;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.Resolver;
import com.hpplay.sdk.source.mdns.xbill.dns.ResolverListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class Resolution
implements ResolverListener {
    private WeakReference<Message> messageWeakReference = null;
    private WeakReference<ResolverListener> listenerWeakReference = null;
    private final LinkedList responses = new LinkedList();
    private int requestsSent;
    private final List requestIDs = new ArrayList();
    private boolean mdnsVerbose = false;
    private WeakReference<MulticastDNSQuerier> dnsQuerierWeakReference;

    public Resolution(MulticastDNSQuerier multicastDNSQuerier, Message message, ResolverListener resolverListener) {
        this.dnsQuerierWeakReference = new WeakReference<MulticastDNSQuerier>(multicastDNSQuerier);
        this.messageWeakReference = new WeakReference<Message>(message);
        this.listenerWeakReference = new WeakReference<ResolverListener>(resolverListener);
        this.mdnsVerbose = Options.check("mdns_verbose");
    }

    public Message getResponse(int n2) {
        Message message = (Message)((Message)this.messageWeakReference.get()).clone();
        Header header = message.getHeader();
        try {
            Message[] messageArray = this.getResults(true, n2);
            boolean bl = false;
            if (messageArray != null && messageArray.length > 0) {
                header.setRcode(0);
                header.setOpcode(0);
                header.setFlag(0);
                for (Message message2 : messageArray) {
                    Header header2 = message2.getHeader();
                    if (header2.getRcode() != 0) continue;
                    if (header2.getFlag(5)) {
                        header.setFlag(5);
                    }
                    if (header2.getFlag(10)) {
                        header.setFlag(10);
                    }
                    for (int n3 : new int[]{1, 3, 2}) {
                        Record[] recordArray = message2.getSectionArray(n3);
                        if (recordArray == null || recordArray.length <= 0) continue;
                        for (Record record : recordArray) {
                            if (message.findRecord(record)) continue;
                            message.addRecord(record, n3);
                            bl = true;
                        }
                    }
                }
            }
            if (!bl) {
                header.setRcode(3);
            }
            return message;
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            IOException iOException = new IOException(exception.getMessage());
            iOException.setStackTrace(exception.getStackTrace());
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message[] getResults(boolean bl, int n2) {
        Object object;
        if (bl) {
            long l2 = System.currentTimeMillis();
            long l3 = l2 + (long)n2;
            while (!this.hasResults() && (l2 = System.currentTimeMillis()) < l3) {
                object = this.responses;
                synchronized (object) {
                    if (!this.hasResults()) {
                        try {
                            this.responses.wait(l3 - l2);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (this.responses.size() > 0) {
            LinkedList<Message> linkedList = new LinkedList<Message>();
            LinkedList<Exception> linkedList2 = new LinkedList<Exception>();
            for (Object e2 : this.responses) {
                object = (Response)e2;
                if (((Response)object).inError()) {
                    linkedList2.add(((Response)object).getException());
                    continue;
                }
                linkedList.add(((Response)object).getMessage());
            }
            if (linkedList.size() > 0) {
                return linkedList.toArray(new Message[linkedList.size()]);
            }
            if (linkedList2.size() > 0) {
                throw (Exception)linkedList2.get(0);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleException(Object object, Exception exception) {
        if (!(this.requestIDs.size() == 0 || this.requestIDs.contains(object) && this == object && this.equals(object))) {
            LinkedList linkedList = this.responses;
            synchronized (linkedList) {
                Response response = new Response(object, exception);
                this.responses.add(response);
                this.responses.notifyAll();
            }
            if (this.listenerWeakReference.get() != null) {
                ((ResolverListener)this.listenerWeakReference.get()).handleException(this, exception);
            }
        } else if (this.mdnsVerbose) {
            String string = "!!!!! Exception Disgarded ";
            if (this.requestIDs.size() == 0 || this.requestIDs.contains(object) && this == object && this.equals(object)) {
                string = string + "[Request ID does not match Response ID - " + object + " ] ";
            }
        }
    }

    public boolean hasResults() {
        return this.responses.size() >= this.requestsSent;
    }

    public boolean inError() {
        for (Object e2 : this.responses) {
            Response response = (Response)e2;
            if (response.inError()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveMessage(Object object, Message message) {
        if (this.requestIDs.size() == 0 || this.requestIDs.contains(object) || this == object || this.equals(object) || MulticastDNSUtils.answersAny((Message)this.messageWeakReference.get(), message)) {
            LinkedList linkedList = this.responses;
            synchronized (linkedList) {
                this.responses.add(new Response((Object)this, message));
                this.responses.notifyAll();
            }
            if (this.listenerWeakReference.get() != null) {
                ((ResolverListener)this.listenerWeakReference.get()).receiveMessage(this, message);
            }
        } else if (this.mdnsVerbose) {
            String string = "!!!!! Message Disgarded ";
            if (!(this.requestIDs.size() == 0 || this.requestIDs.contains(object) && this == object && this.equals(object))) {
                string = string + "[Request ID does not match Response ID] ";
            }
            if (!MulticastDNSUtils.answersAny((Message)this.messageWeakReference.get(), message)) {
                string = string + "[Response does not answer Query]";
            }
        }
    }

    public Object start() {
        this.requestsSent = 0;
        this.requestIDs.clear();
        boolean bl = false;
        boolean bl2 = false;
        if (this.dnsQuerierWeakReference == null || this.dnsQuerierWeakReference.get() == null) {
            return null;
        }
        if (Resolution.hasUnicastDomains((Message)this.messageWeakReference.get()) && ((MulticastDNSQuerier)this.dnsQuerierWeakReference.get()).mUnicastResolvers != null && ((MulticastDNSQuerier)this.dnsQuerierWeakReference.get()).mUnicastResolvers.length > 0) {
            for (Resolver resolver : ((MulticastDNSQuerier)this.dnsQuerierWeakReference.get()).mUnicastResolvers) {
                bl = true;
                this.requestIDs.add(resolver.sendAsync((Message)this.messageWeakReference.get(), this));
                ++this.requestsSent;
            }
        }
        if (Resolution.hasMulticastDomains((Message)this.messageWeakReference.get()) && ((MulticastDNSQuerier)this.dnsQuerierWeakReference.get()).multicastResponders != null && ((MulticastDNSQuerier)this.dnsQuerierWeakReference.get()).multicastResponders.length > 0) {
            for (Resolver resolver : ((MulticastDNSQuerier)this.dnsQuerierWeakReference.get()).multicastResponders) {
                bl2 = true;
                this.requestIDs.add(resolver.sendAsync((Message)this.messageWeakReference.get(), this));
                ++this.requestsSent;
            }
        }
        return this;
    }

    public static boolean hasMulticastDomains(Message message) {
        Record[] recordArray = MulticastDNSUtils.extractRecords(message, 0, 1, 2, 3);
        if (recordArray != null) {
            for (Record record : recordArray) {
                if (!MulticastDNSQuerier.isMulticastDomain(record.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasUnicastDomains(Message message) {
        Record[] recordArray = MulticastDNSUtils.extractRecords(message, 0, 1, 2, 3);
        if (recordArray != null) {
            for (Record record : recordArray) {
                if (MulticastDNSQuerier.isMulticastDomain(record.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

