/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.business.cloud;

import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.sdk.source.bean.PassSinkAuthBean;
import com.hpplay.sdk.source.bean.VipAuthResultBean;
import com.hpplay.sdk.source.bean.VipAuthSetting;
import com.hpplay.sdk.source.business.cloud.CloudAPI;
import com.hpplay.sdk.source.common.store.Preference;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.common.utils.HapplayUtils;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.pass.PassSender;
import com.hpplay.sdk.source.utils.AppContextUtils;
import com.hpplay.sdk.source.utils.Feature;
import com.hpplay.sdk.source.utils.HpplayUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class RightsManager {
    private static final String TAG = "RightsManager";
    public static final String VIP_KEY_LEBO_CLOUDMIRROR = "LEBO_CLOUDMIRROR_QY";
    private static RightsManager singleInstance = null;
    private static Session mSession;
    private List<VipAuthResultBean.VipAuthDataEntity.AuthInfo> mSourceAuthInfo;
    private Map<String, List<VipAuthResultBean.VipAuthDataEntity.AuthInfo>> mSinkAuthInfoMap = new HashMap<String, List<VipAuthResultBean.VipAuthDataEntity.AuthInfo>>();
    private Map<String, PassSinkAuthBean> mPassSinkAuthMap = new HashMap<String, PassSinkAuthBean>();

    private RightsManager() {
        mSession = Session.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized RightsManager getInstance() {
        if (singleInstance != null) return singleInstance;
        Class<RightsManager> clazz = RightsManager.class;
        synchronized (RightsManager.class) {
            if (singleInstance != null) return singleInstance;
            singleInstance = new RightsManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleInstance;
        }
    }

    public void vipAuth() {
        SourceLog.i(TAG, "vipAuth");
        this.vipAuth(2);
    }

    private void vipAuth(int n2) {
        String string = Preference.getInstance().get("key_uuid", "");
        String string2 = Preference.getInstance().get("key_session", "");
        VipAuthSetting vipAuthSetting = new VipAuthSetting();
        vipAuthSetting.uuid = string;
        vipAuthSetting.ssid = string2;
        this.loginVipAuth(vipAuthSetting, n2);
    }

    public void loginVipAuth(VipAuthSetting vipAuthSetting) {
        this.loginVipAuth(vipAuthSetting, 2);
    }

    private void loginVipAuth(VipAuthSetting vipAuthSetting, int n2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("uid", mSession.getUID());
        hashMap.put("appid", RightsManager.mSession.appKey);
        hashMap.put("token", mSession.getToken());
        hashMap.put("tid", RightsManager.mSession.tid);
        hashMap.put("uuid", vipAuthSetting == null ? "" : vipAuthSetting.uuid);
        hashMap.put("ssid", vipAuthSetting == null ? "" : vipAuthSetting.ssid);
        hashMap.put("hid", mSession.getHID());
        hashMap.put("sdk_ver", String.valueOf(40719));
        hashMap.put("ehid", Preference.getInstance().get("super_device_id", ""));
        hashMap.put("prot_ver", "1.0");
        SourceLog.i(TAG, "loginVipAuth " + CloudAPI.sVipAuth + "," + HapplayUtils.getJsonParams(hashMap));
        final AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sVipAuth, HapplayUtils.getJsonParams(hashMap), n2);
        asyncHttpParameter.in.requestMethod = 1;
        asyncHttpParameter.in.connectTimeout = 10000;
        asyncHttpParameter.in.readTimeout = 10000;
        AsyncHttpRequestListener asyncHttpRequestListener = new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter2) {
                SourceLog.debug(RightsManager.TAG, "loginVipAuth onRequestResult = " + asyncHttpParameter2.out.result);
                if (asyncHttpParameter2.out.resultType == 2) {
                    SourceLog.w(RightsManager.TAG, "loginVipAuth cancel request");
                    return;
                }
                if (asyncHttpParameter2.out.resultType == 0) {
                    try {
                        JSONObject jSONObject = new JSONObject(asyncHttpParameter2.out.result);
                        VipAuthResultBean vipAuthResultBean = new VipAuthResultBean(jSONObject);
                        if (vipAuthResultBean.status != 200 && asyncHttpParameter2.out.requestTryCount < asyncHttpParameter.in.tryCount) {
                            SourceLog.i(RightsManager.TAG, "loginVipAuth status illgeal,request again: " + asyncHttpParameter2.out.requestTryCount);
                            RightsManager.this.vipAuth(asyncHttpParameter.in.tryCount - asyncHttpParameter2.out.requestTryCount);
                            return;
                        }
                        if (vipAuthResultBean.status == 404) {
                            RightsManager.this.logout();
                            return;
                        }
                        if (vipAuthResultBean.status != 200 || vipAuthResultBean.data == null) {
                            SourceLog.i(RightsManager.TAG, "loginVipAuth data is illegal argument");
                            return;
                        }
                        if (!(TextUtils.isEmpty((CharSequence)vipAuthResultBean.data.sign) || vipAuthResultBean.data.sign.equalsIgnoreCase(HpplayUtil.getVipAuthInfoSign(AppContextUtils.getInstance().getAppContext(), vipAuthResultBean.data.stime, asyncHttpParameter2.out.result)) || vipAuthResultBean.data.sign.equalsIgnoreCase(HpplayUtil.getVipAuthInfoLeBoSign(AppContextUtils.getInstance().getAppContext(), vipAuthResultBean.data.stime, asyncHttpParameter2.out.result)))) {
                            SourceLog.i(RightsManager.TAG, "loginVipAuth sign not pass ");
                            return;
                        }
                        RightsManager.this.mSourceAuthInfo = vipAuthResultBean.data.authinfo;
                    }
                    catch (Exception exception) {
                        SourceLog.w(RightsManager.TAG, exception);
                    }
                }
            }
        };
        AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, asyncHttpRequestListener);
    }

    public void getSinkTempRights(String string, int n2, int n3) {
        if (n3 == 4) {
            this.requestSinkTempVipInfo(string, String.valueOf(n2));
        } else {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("uid", (Object)string);
            }
            catch (JSONException jSONException) {
                SourceLog.w(TAG, jSONException);
            }
            PassSender.getInstance().sendVIPQuery(jSONObject.toString());
        }
    }

    private void requestSinkTempVipInfo(final String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Session session = Session.getInstance();
        hashMap.put("appid", session.appKey);
        hashMap.put("uid", session.getUID());
        hashMap.put("ruid", string);
        hashMap.put("rappid", string2);
        hashMap.put("token", session.getToken());
        hashMap.put("sdkVer", String.valueOf(40719));
        SourceLog.i(TAG, "requestSinkVipInfo " + CloudAPI.sTemporaryAuth + "?" + HapplayUtils.getJsonParams(hashMap));
        AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sTemporaryAuth, HapplayUtils.getJsonParams(hashMap));
        asyncHttpParameter.in.requestMethod = 1;
        AsyncHttpRequestListener asyncHttpRequestListener = new AsyncHttpRequestListener(){

            @Override
            public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                SourceLog.debug(RightsManager.TAG, "requestSinkVipInfo result: " + asyncHttpParameter.out.result);
                if (asyncHttpParameter.out.resultType == 2) {
                    SourceLog.i(RightsManager.TAG, "requestSinkVipInfo onRequestResult,cancel request");
                    return;
                }
                try {
                    JSONObject jSONObject = new JSONObject(asyncHttpParameter.out.result);
                    VipAuthResultBean vipAuthResultBean = new VipAuthResultBean(jSONObject);
                    if (vipAuthResultBean.status != 200 || vipAuthResultBean.data == null) {
                        SourceLog.i(RightsManager.TAG, "requestSinkVipInfo data is illegal argument");
                        return;
                    }
                    if (!(TextUtils.isEmpty((CharSequence)vipAuthResultBean.data.sign) || vipAuthResultBean.data.sign.equalsIgnoreCase(HpplayUtil.getVipAuthInfoSign(AppContextUtils.getInstance().getAppContext(), vipAuthResultBean.data.stime, asyncHttpParameter.out.result)) || vipAuthResultBean.data.sign.equalsIgnoreCase(HpplayUtil.getVipAuthInfoLeBoSign(AppContextUtils.getInstance().getAppContext(), vipAuthResultBean.data.stime, asyncHttpParameter.out.result)))) {
                        SourceLog.i(RightsManager.TAG, "requestSinkVipInfo sign not pass ");
                        return;
                    }
                    RightsManager.this.mSinkAuthInfoMap.put(string, vipAuthResultBean.data.authinfo);
                }
                catch (Exception exception) {
                    SourceLog.w(RightsManager.TAG, exception);
                }
            }
        };
        AsyncManager.getInstance().exeHttpTaskWithoutParallel(asyncHttpParameter, asyncHttpRequestListener);
    }

    public void logout() {
        SourceLog.i(TAG, "logout");
        this.mSourceAuthInfo = null;
        Preference.getInstance().put("key_uuid", "");
        Preference.getInstance().put("key_session", "");
    }

    public void handleRightMessage(String string, String string2) {
        try {
            SourceLog.i(TAG, "handleRightMessage: " + string + " / " + string2);
            JSONObject jSONObject = new JSONObject(string2);
            PassSinkAuthBean passSinkAuthBean = new PassSinkAuthBean(jSONObject);
            this.mPassSinkAuthMap.put(string, passSinkAuthBean);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void handleNetConnectMessage(String string, String string2) {
        try {
            SourceLog.i(TAG, "handleNetConnectMessage: " + string + " / " + string2);
            JSONObject jSONObject = new JSONObject(string2);
            PassSinkAuthBean passSinkAuthBean = new PassSinkAuthBean(jSONObject);
            this.mPassSinkAuthMap.put(string, passSinkAuthBean);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public void removeSinkRights(String string) {
        SourceLog.i(TAG, "removeSinkRights:" + string);
        this.mSinkAuthInfoMap.remove(string);
        this.mPassSinkAuthMap.remove(string);
    }

    public boolean hasVipFeature(String string, String string2) {
        if (Feature.isLeboApp()) {
            return true;
        }
        boolean bl = false;
        PassSinkAuthBean passSinkAuthBean = this.mPassSinkAuthMap.get(string);
        if (passSinkAuthBean != null) {
            bl = passSinkAuthBean.enterprise;
            if (VIP_KEY_LEBO_CLOUDMIRROR.equals(string2)) {
                bl = bl || passSinkAuthBean.cm;
            }
        }
        return bl || this.hasVipFeatureInAuthInfo(string2, this.mSourceAuthInfo) || this.hasVipFeatureInAuthInfo(string2, this.mSinkAuthInfoMap.get(string));
    }

    private boolean hasVipFeatureInAuthInfo(String string, List<VipAuthResultBean.VipAuthDataEntity.AuthInfo> list) {
        if (list == null || string == null) {
            return false;
        }
        for (VipAuthResultBean.VipAuthDataEntity.AuthInfo authInfo : list) {
            if (!string.equalsIgnoreCase(authInfo.key)) continue;
            return true;
        }
        return false;
    }
}

