/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.device.pincode;

import android.content.Context;
import com.hpplay.sdk.source.browse.api.IServiceInfoParseListener;
import com.hpplay.sdk.source.device.pincode.CodeParser;
import com.hpplay.sdk.source.device.pincode.ConferenceCodeParser;
import com.hpplay.sdk.source.device.pincode.IConferenceFuzzyMatchingPinCodeListener;
import com.hpplay.sdk.source.device.pincode.LelinkCodeParser;
import com.hpplay.sdk.source.device.pincode.PinCodeInfo;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.utils.Feature;

public class PinCodeParser
implements CodeParser {
    private final String TAG = "PinCodeParser";
    private CodeParser mCodeParser;

    @Override
    public void setCodeCallback(IServiceInfoParseListener iServiceInfoParseListener) {
        if (null != this.mCodeParser) {
            this.mCodeParser.setCodeCallback(iServiceInfoParseListener);
        }
    }

    @Override
    public void setConferenceFuzzyMatchingPinCodeCallback(IConferenceFuzzyMatchingPinCodeListener iConferenceFuzzyMatchingPinCodeListener) {
        if (null != this.mCodeParser) {
            this.mCodeParser.setConferenceFuzzyMatchingPinCodeCallback(iConferenceFuzzyMatchingPinCodeListener);
        }
    }

    public PinCodeParser(Context context) {
        if (this.mCodeParser != null) {
            SourceLog.i("PinCodeParser", "PinCodeParser is initiated");
            return;
        }
        this.mCodeParser = Feature.isConferenceSDK() ? new ConferenceCodeParser() : new LelinkCodeParser(context);
    }

    @Override
    public void parsePinCode(PinCodeInfo pinCodeInfo) {
        if (null != this.mCodeParser) {
            this.mCodeParser.parsePinCode(pinCodeInfo);
        }
    }

    @Override
    public void release() {
        if (null != this.mCodeParser) {
            this.mCodeParser.release();
        }
    }
}

