/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.common.utils;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import com.hpplay.common.utils.EncryptUtil;
import com.hpplay.sdk.source.log.SourceLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class HapplayUtils {
    private static final String TAG = "HapplayUtils";
    private static final char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] NUMBERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final boolean USE_LOOPBACK_ADDR = false;
    private static final boolean USE_ONLY_IPV4_ADDR = true;
    private static final boolean USE_ONLY_IPV6_ADDR = false;
    private static HashMap<String, String> mfMap = new HashMap();

    public static HashMap<String, String> getConfigMaps() {
        return mfMap;
    }

    public static String getLoaclIp() {
        String string = null;
        String string2 = null;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            InetAddress inetAddress = null;
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                String string3 = networkInterface.getDisplayName();
                while (enumeration2.hasMoreElements()) {
                    String string4;
                    inetAddress = enumeration2.nextElement();
                    if (inetAddress instanceof Inet6Address || "127.0.0.1".equals(string4 = inetAddress.getHostAddress())) continue;
                    String string5 = inetAddress.getHostAddress();
                    if ("wlan0".equals(string3)) {
                        string = string5;
                    } else {
                        string2 = string5;
                    }
                    SourceLog.i(TAG, "getLoaclIp " + string5 + "/" + string3);
                }
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        if (!TextUtils.isEmpty(string)) {
            return string;
        }
        return string2;
    }

    public static boolean getSystemPropertiesBoolean(String string, boolean bl) {
        try {
            Method method = Class.forName("android.os.SystemProperties").getMethod("getBoolean", String.class, Boolean.TYPE);
            boolean bl2 = (Boolean)method.invoke(null, string, bl);
            SourceLog.i(TAG, " get boolean SystemProperties ----> " + bl2);
            return bl2;
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return bl;
        }
    }

    public static String getMapParams(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        if (map != null) {
            for (String string : map.keySet()) {
                String string2 = map.get(string);
                stringBuilder.append(string).append("=").append(string2).append("&");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)stringBuilder.toString()) && stringBuilder.length() > 1) {
            stringBuilder = new StringBuilder(stringBuilder.substring(0, stringBuilder.length() - 1));
        }
        return stringBuilder.toString();
    }

    public static String getMapParamsWithoutEmpty(Map<String, String> map) {
        String string = "";
        if (map != null) {
            for (String string2 : map.keySet()) {
                String string3 = map.get(string2);
                if (TextUtils.isEmpty((CharSequence)string3)) continue;
                string = string + string2 + "=" + string3 + "&";
            }
        }
        if (!TextUtils.isEmpty((CharSequence)string) && string.length() > 1) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String getJsonParams(Map<String, String> map) {
        JSONObject jSONObject = new JSONObject();
        if (map != null) {
            for (String string : map.keySet()) {
                try {
                    String string2 = map.get(string);
                    jSONObject.put(string, (Object)string2);
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
            }
        }
        return jSONObject.toString();
    }

    public static int getAppVersion(Context context) {
        int n2 = 0;
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            n2 = packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            SourceLog.w(TAG, nameNotFoundException);
        }
        return n2;
    }

    public static int parsePort(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return 0;
        }
    }

    public static String getWifiIp() {
        String string;
        block4: {
            string = null;
            try {
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    NetworkInterface networkInterface = enumeration.nextElement();
                    Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                    if (!networkInterface.getDisplayName().contains("wlan0")) continue;
                    while (enumeration2.hasMoreElements()) {
                        InetAddress inetAddress = enumeration2.nextElement();
                        if (!(inetAddress instanceof Inet4Address)) continue;
                        string = inetAddress.getHostAddress();
                        break block4;
                    }
                    break;
                }
            }
            catch (SocketException socketException) {
                SourceLog.w(TAG, socketException);
            }
        }
        return string;
    }

    public static boolean isNetworkConnected(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        try {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo.getType() == 1;
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return false;
        }
    }

    public static final int getHostCount() {
        int n2 = 0;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (!HapplayUtils.isUsableAddress(inetAddress)) continue;
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return n2;
    }

    private static final boolean isUsableAddress(InetAddress inetAddress) {
        if (inetAddress.isLoopbackAddress()) {
            return false;
        }
        return !(inetAddress instanceof Inet6Address);
    }

    public static final String getIpStr(int n2) {
        int n3 = 0;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (!HapplayUtils.isUsableAddress(inetAddress)) continue;
                    if (n3 < n2) {
                        ++n3;
                        continue;
                    }
                    String string = inetAddress.getHostAddress();
                    return string;
                }
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return "";
    }

    @Deprecated
    public static String getMac() {
        return "02:00:00:00:00:00";
    }

    public static void initManufacture(Context context) {
        try {
            if (mfMap.size() == 0) {
                String string;
                InputStream inputStream = context.getAssets().open("mfConfig");
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                StringBuilder stringBuilder = new StringBuilder();
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string).append(",");
                }
                String[] stringArray = stringBuilder.toString().split(",");
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if ((i2 + 1) % 2 != 0 || i2 + 1 >= stringArray.length) continue;
                    mfMap.put(stringArray[i2], stringArray[i2 - 1]);
                    SourceLog.i(TAG, "key " + stringArray[i2] + "  value " + stringArray[i2 - 1]);
                }
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    public static String getAppName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            int n2 = packageInfo.applicationInfo.labelRes;
            return context.getResources().getString(n2);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
            return null;
        }
    }

    public static Application getApplication() {
        Application application = null;
        try {
            Class<?> clazz = Class.forName("android.app.ActivityThread");
            Method method = clazz.getMethod("currentActivityThread", new Class[0]);
            Object object = method.invoke(null, (Object[])null);
            Method method2 = clazz.getMethod("getApplication", new Class[0]);
            application = (Application)method2.invoke(object, (Object[])null);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return application;
    }

    public static boolean checkLoaclPort(int n2) {
        boolean bl = true;
        try {
            bl = HapplayUtils.isPortUsing("127.0.0.1", n2);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortUsing(String string, int n2) {
        boolean bl = false;
        InetAddress inetAddress = InetAddress.getByName(string);
        Socket socket = null;
        try {
            socket = new Socket(inetAddress, n2);
            bl = true;
        }
        catch (IOException iOException) {
            SourceLog.w(TAG, "isPortUsing IOException " + n2);
        }
        finally {
            if (null != socket) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    SourceLog.w(TAG, iOException);
                }
            }
        }
        return bl;
    }

    public static String getMcMd5() {
        String string = HapplayUtils.getMac();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        String string2 = EncryptUtil.md5EncryData(string.toUpperCase());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "";
        }
        return string2.toUpperCase();
    }
}

