/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.upnp.control;

import com.hpplay.cybergarage.http.HTTPRequest;
import com.hpplay.cybergarage.soap.SOAP;
import com.hpplay.cybergarage.soap.SOAPResponse;
import com.hpplay.cybergarage.upnp.Service;
import com.hpplay.cybergarage.upnp.StateVariable;
import com.hpplay.cybergarage.upnp.control.ControlRequest;
import com.hpplay.cybergarage.upnp.control.QueryResponse;
import com.hpplay.cybergarage.xml.Node;

public class QueryRequest
extends ControlRequest {
    public QueryRequest() {
    }

    public QueryRequest(HTTPRequest hTTPRequest) {
        this.set(hTTPRequest);
    }

    private Node getVarNameNode() {
        Node node = this.getBodyNode();
        if (node == null) {
            return null;
        }
        if (!node.hasNodes()) {
            return null;
        }
        Node node2 = node.getNode(0);
        if (node2 == null) {
            return null;
        }
        if (!node2.hasNodes()) {
            return null;
        }
        return node2.getNode(0);
    }

    public String getVarName() {
        Node node = this.getVarNameNode();
        if (node == null) {
            return "";
        }
        return node.getValue();
    }

    public void setRequest(StateVariable stateVariable) {
        Service service = stateVariable.getService();
        String string = service.getControlURL();
        this.setRequestHost(service);
        this.setEnvelopeNode(SOAP.createEnvelopeBodyNode());
        Node node = this.getEnvelopeNode();
        Node node2 = this.getBodyNode();
        Node node3 = this.createContentNode(stateVariable);
        node2.addNode(node3);
        this.setContent(node);
        this.setSOAPAction("urn:schemas-upnp-org:control-1-0#QueryStateVariable");
    }

    private Node createContentNode(StateVariable stateVariable) {
        Node node = new Node();
        node.setName("u", "QueryStateVariable");
        node.setNameSpace("u", "urn:schemas-upnp-org:control-1-0");
        Node node2 = new Node();
        node2.setName("u", "varName");
        node2.setValue(stateVariable.getName());
        node.addNode(node2);
        return node;
    }

    public QueryResponse post() {
        SOAPResponse sOAPResponse = this.postMessage(this.getRequestHost(), this.getRequestPort());
        return new QueryResponse(sOAPResponse);
    }
}

