/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.protocol;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.common.utils.DeviceUtil;
import com.hpplay.component.screencapture.view.SecondMirrorView;
import com.hpplay.sdk.source.bean.AudioFrameBean;
import com.hpplay.sdk.source.bean.OutParameter;
import com.hpplay.sdk.source.bean.StopInfo;
import com.hpplay.sdk.source.bean.VideoFrameBean;
import com.hpplay.sdk.source.browse.api.OptionCentral;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.business.PublicCastClient;
import com.hpplay.sdk.source.business.cloud.CloudAPI;
import com.hpplay.sdk.source.business.cloud.SourceDataReport;
import com.hpplay.sdk.source.cloud.mirror.youme.OnCloudMirrorListener;
import com.hpplay.sdk.source.cloud.mirror.youme.YimConfigBean;
import com.hpplay.sdk.source.common.store.Preference;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.d.a;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.mirror.yim.YimMirror;
import com.hpplay.sdk.source.pass.PassSender;
import com.hpplay.sdk.source.pass.bean.BaseBean;
import com.hpplay.sdk.source.pass.bean.MirrorStateBean;
import com.hpplay.sdk.source.pass.bean.SinkKeyEventRegisterBean;
import com.hpplay.sdk.source.pass.bean.SinkTouchEventRegisterBean;
import com.hpplay.sdk.source.pass.sinktouch.SinkTouchEventMonitor;
import com.hpplay.sdk.source.process.ConnectManager;
import com.hpplay.sdk.source.process.LelinkSdkManager;
import com.hpplay.sdk.source.protocol.AbsBridge;
import com.hpplay.sdk.source.protocol.CaptureBridge;
import com.hpplay.sdk.source.protocol.connect.AbsConnectBridge;
import com.hpplay.sdk.source.protocol.connect.OnPlayStateListener;
import com.hpplay.sdk.source.utils.CastUtil;
import com.hpplay.sdk.source.utils.CreateUtil;
import com.hpplay.sdk.source.utils.Feature;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class YimBridge
extends AbsBridge {
    private static final String TAG = "YimBridge";
    public static final int CLOUD_MIRROR_SINK_WAIT = 0;
    public static final int CLOUD_MIRROR_SINK_START = 1;
    private static final int WHAT_CAPTURE = 1;
    private static final int WHAT_REQUEST_FIR = 2;
    private static final int LOW_BITRATE_EXP_FRAME = 17;
    private static final int CLOUD_MIRROR_DEFAULT_BITRATE = 1500000;
    private CaptureBridge mScreenCapture;
    private int captureWidth = 1280;
    private int captureHeight = 720;
    private static final int AUDIO_SAMPLE_RATE = 48000;
    private int mFrameCount = -1;
    private String mLocalConnectionIP;
    private int mLocalConnectionPort;
    private IOnSinkChangeListener mSinkChangeListener;
    private YimConfigBean mBean = new YimConfigBean();
    private Timer mTimer = new Timer();
    private DelayNotifySinkTask mDelayNotifySinkTask;
    private boolean isChangeExpandView = false;
    private boolean hasRegisterSinkTouchEvent = false;
    private boolean isFrozen = false;
    private BrowserInfo mIMInfo;
    private boolean isCallPrepared = false;
    private int mNotifyCount;
    private Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    if (YimBridge.this.mScreenCapture == null) break;
                    if (!YimBridge.this.mPlayInfo.isGroup) {
                        YimBridge.this.setExternalMirrorData();
                    }
                    YimBridge.this.mScreenCapture.onSinkPrepared(4, YimBridge.this, YimBridge.this.captureWidth, YimBridge.this.captureHeight, 30, 1500000, "video/avc");
                    break;
                }
                case 2: {
                    if (YimBridge.this.mScreenCapture == null) break;
                    YimBridge.this.mScreenCapture.requestKeyFrame();
                }
            }
            return false;
        }
    });
    private long mPrintFrameTime = 0L;
    private final OnPlayStateListener mStateListener = new OnPlayStateListener(){

        @Override
        public void onStart(String string) {
            if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.equals((CharSequence)string, (CharSequence)YimBridge.this.mPlayInfo.urlID)) {
                SourceLog.w(YimBridge.TAG, "onStart ignore, " + string + "/" + YimBridge.this.mPlayInfo.urlID);
                return;
            }
            if (!YimBridge.this.isCallPrepared) {
                YimBridge.this.isCallPrepared = true;
                if (YimBridge.this.mPreparedListener != null) {
                    YimBridge.this.mPreparedListener.onPrepared(null);
                }
                return;
            }
            if (YimBridge.this.mStateChangeListener != null) {
                YimBridge.this.mStateChangeListener.onStateChanged(null, 3);
            }
        }

        @Override
        public void onPause(String string) {
            if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.equals((CharSequence)string, (CharSequence)YimBridge.this.mPlayInfo.urlID)) {
                SourceLog.w(YimBridge.TAG, "onPause ignore, " + string + "/" + YimBridge.this.mPlayInfo.urlID);
                return;
            }
            if (YimBridge.this.mStateChangeListener != null) {
                YimBridge.this.mStateChangeListener.onStateChanged(null, 4);
            }
        }

        @Override
        public void onPlaying(String string, int n2, int n3) {
            if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.equals((CharSequence)string, (CharSequence)YimBridge.this.mPlayInfo.urlID)) {
                SourceLog.w(YimBridge.TAG, "onPlaying ignore, " + string + "/" + YimBridge.this.mPlayInfo.urlID);
                return;
            }
            if (YimBridge.this.mInfoListener != null) {
                YimBridge.this.mInfoListener.onInfo(null, 100, n2, n3);
            }
        }

        @Override
        public void onError(String string, String string2) {
            if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.equals((CharSequence)string, (CharSequence)YimBridge.this.mPlayInfo.urlID)) {
                SourceLog.w(YimBridge.TAG, "onError ignore, " + string + "/" + YimBridge.this.mPlayInfo.urlID);
                return;
            }
            if (YimBridge.this.mErrorListener != null) {
                YimBridge.this.mErrorListener.onError(null, 210010, 210011, null);
            }
        }

        @Override
        public void onStop(String string, int n2) {
            if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.equals((CharSequence)string, (CharSequence)YimBridge.this.mPlayInfo.urlID)) {
                SourceLog.w(YimBridge.TAG, "onStop ignore, " + string + "/" + YimBridge.this.mPlayInfo.urlID);
                return;
            }
            if (n2 == 0) {
                if (YimBridge.this.mCompletionListener != null) {
                    YimBridge.this.mCompletionListener.onComplete(null);
                }
            } else {
                SourceLog.i(YimBridge.TAG, " STOP_NORMAL stop ");
                if (YimBridge.this.mPlayInfo != null && !YimBridge.this.isFrozen) {
                    if (YimBridge.this.mStopListener != null) {
                        StopInfo stopInfo = new StopInfo();
                        stopInfo.type = 1;
                        YimBridge.this.mStopListener.onStop(null, stopInfo);
                    }
                    YimBridge.this.stop(YimBridge.this.mPlayInfo.getKey());
                }
            }
        }
    };
    private long mRequestFirMark;
    private OnCloudMirrorListener mYimListener = new OnCloudMirrorListener(){

        public void onEventCallback(int n2, Object ... objectArray) {
            SourceLog.i(YimBridge.TAG, " onEventCallback " + n2);
            switch (n2) {
                case 1: {
                    int n3 = Integer.parseInt(objectArray[0].toString());
                    if (n3 == -1) {
                        SourceLog.w(YimBridge.TAG, "login failed");
                        YimBridge.this.callbackError(211000, 211050);
                    }
                    SourceDataReport.getInstance().onYimInit(701, YimBridge.this.mPlayInfo, n3 == 1, null, null);
                    break;
                }
                case 2: {
                    int n4 = Integer.parseInt(objectArray[0].toString());
                    if (n4 == -1) {
                        SourceLog.w(YimBridge.TAG, "join room failed");
                        YimBridge.this.callbackError(211000, 211050);
                        break;
                    }
                    if (n4 != 1 || YimBridge.this.mHandler == null) break;
                    YimBridge.this.mHandler.obtainMessage(1).sendToTarget();
                    break;
                }
                case 3: {
                    int n5 = Integer.parseInt(objectArray[0].toString());
                    StopInfo stopInfo = new StopInfo();
                    stopInfo.type = n5 == 2 ? 2 : 1;
                    YimBridge.this.stop(YimBridge.this.mPlayInfo.getKey());
                    if (YimBridge.this.mStopListener == null) break;
                    YimBridge.this.mStopListener.onStop(null, stopInfo);
                    break;
                }
                case 500: {
                    String string = objectArray[0].toString();
                    try {
                        JSONObject jSONObject = new JSONObject(string);
                        boolean bl = jSONObject.optBoolean("fir");
                        int n6 = jSONObject.optInt("bitrate");
                        int n7 = jSONObject.optInt("fps");
                        if (YimBridge.this.mScreenCapture == null || YimBridge.this.isFrozen) break;
                        if (bl) {
                            if (System.currentTimeMillis() - YimBridge.this.mRequestFirMark < 1000L) {
                                YimBridge.this.mScreenCapture.requestKeyFrame();
                                YimBridge.this.mRequestFirMark = System.currentTimeMillis();
                            } else {
                                SourceLog.i(YimBridge.TAG, "++++++++++++++++++++++++++++===delay request key f");
                                YimBridge.this.mRequestFirMark = System.currentTimeMillis();
                                YimBridge.this.mHandler.removeMessages(2);
                                YimBridge.this.mHandler.sendEmptyMessageDelayed(2, 1000L);
                            }
                        }
                        if (n6 > 0) {
                            YimBridge.this.mScreenCapture.setBitRate(4, n6 * 1024);
                        }
                        if (n7 > 0) {
                            if (YimBridge.this.mScreenCapture.getBitrate() / 1024 <= 1000) {
                                YimBridge.this.mScreenCapture.setFrameRate(4, 17);
                            } else {
                                YimBridge.this.mScreenCapture.setFrameRate(4, n7);
                            }
                        }
                        try {
                            boolean bl2 = jSONObject.getBoolean("pause_encode");
                            if (bl2) {
                                SourceLog.i(YimBridge.TAG, "=============pause encoder======");
                                YimBridge.this.mScreenCapture.pauseEncode(false);
                                break;
                            }
                            SourceLog.i(YimBridge.TAG, "=============resume encoder======");
                            YimBridge.this.mScreenCapture.resumeEncode();
                        }
                        catch (JSONException jSONException) {}
                        break;
                    }
                    catch (Exception exception) {
                        SourceLog.w(YimBridge.TAG, "EVENT_VIDEO_ENCODE_PARAM_REPORT :" + exception);
                    }
                }
            }
        }
    };
    private AsyncHttpRequestListener getRoomIdListener = new AsyncHttpRequestListener(){

        @Override
        public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
            if (asyncHttpParameter.out == null) {
                return;
            }
            SourceLog.i(YimBridge.TAG, "get roomid onRequestResult = " + asyncHttpParameter.out.result);
            if (asyncHttpParameter.out.resultType == 2) {
                return;
            }
            if (TextUtils.isEmpty((CharSequence)asyncHttpParameter.out.result)) {
                return;
            }
            try {
                JSONObject jSONObject = new JSONObject(asyncHttpParameter.out.result);
                int n2 = jSONObject.optInt("status");
                if (n2 == 200) {
                    String string;
                    JSONObject jSONObject2 = jSONObject.getJSONObject("data");
                    String string2 = jSONObject2.optString("pol");
                    String string3 = jSONObject2.optString("server");
                    YimBridge.this.mPlayInfo.roomID = string = jSONObject2.optString("roomid");
                    ((YimBridge)YimBridge.this).mBean.userID = CreateUtil.createYimUserID();
                    ((YimBridge)YimBridge.this).mBean.roomID = string;
                    ((YimBridge)YimBridge.this).mBean.inputWidth = YimBridge.this.captureWidth;
                    ((YimBridge)YimBridge.this).mBean.inputHeight = YimBridge.this.captureHeight;
                    ((YimBridge)YimBridge.this).mBean.sampleRate = 48000;
                    ((YimBridge)YimBridge.this).mBean.ip = YimBridge.this.mLocalConnectionIP;
                    ((YimBridge)YimBridge.this).mBean.port = YimBridge.this.mLocalConnectionPort;
                    YimMirror.getInstance().initSource(YimBridge.this.mContext);
                    YimMirror.getInstance().setCloudMirrorListener(YimBridge.this.mYimListener);
                    YimMirror.getInstance().login(YimBridge.this.mBean);
                    SourceDataReport.getInstance().onGetRoomSuccess(YimBridge.this.mPlayInfo, string);
                    if (YimBridge.this.mLoadingListener != null) {
                        YimBridge.this.mLoadingListener.onLoading(null, null);
                    }
                } else {
                    if (n2 == 410 || n2 == 411) {
                        if (YimBridge.this.mErrorListener != null) {
                            YimBridge.this.mErrorListener.onError(null, 211000, 211055, null);
                        }
                    } else if (n2 == 403) {
                        if (YimBridge.this.mErrorListener != null) {
                            YimBridge.this.mErrorListener.onError(null, 211000, 210004, null);
                        }
                    } else {
                        SourceLog.w(YimBridge.TAG, "onError " + n2);
                        if (YimBridge.this.mErrorListener != null) {
                            YimBridge.this.mErrorListener.onError(null, 211000, 211050, null);
                        }
                    }
                    SourceDataReport.getInstance().onGetRoomFailed(YimBridge.this.mPlayInfo, null);
                }
            }
            catch (Exception exception) {
                SourceLog.w(YimBridge.TAG, exception);
                YimBridge.this.callbackError(211000, 211050);
            }
        }
    };
    private AbsConnectBridge.OnPassReceivedListener onPassReceivedListener = new AbsConnectBridge.OnPassReceivedListener(){

        @Override
        public void onPassReversed(int n2, BaseBean baseBean) {
            if (n2 == 26) {
                MirrorStateBean mirrorStateBean = (MirrorStateBean)baseBean;
                if (mirrorStateBean.action == 0) {
                    YimBridge.this.pause(YimBridge.this.mPlayInfo.getKey());
                } else {
                    YimBridge.this.resume(YimBridge.this.mPlayInfo.getKey());
                }
            }
        }
    };
    private AsyncHttpRequestListener mChangeListenerHttpParameter = new AsyncHttpRequestListener(){

        @Override
        public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
            YimBridge.this.mNotifyCount++;
            if (asyncHttpParameter.out == null) {
                SourceLog.i(YimBridge.TAG, "notify change  onRequestResult null  mNotifyCount " + YimBridge.this.mNotifyCount);
                if (YimBridge.this.mNotifyCount < 5) {
                    YimBridge.this.delayNotify(1000L);
                } else if (YimBridge.this.mSinkChangeListener != null) {
                    YimBridge.this.mSinkChangeListener.onChange(0);
                }
                return;
            }
            SourceLog.i(YimBridge.TAG, "notify change  onRequestResult: " + asyncHttpParameter.out.result + "  mNotifyCount " + YimBridge.this.mNotifyCount);
            if (asyncHttpParameter.out.resultType == 2 || TextUtils.isEmpty((CharSequence)asyncHttpParameter.out.result)) {
                if (YimBridge.this.mNotifyCount < 5) {
                    YimBridge.this.delayNotify(1000L);
                    return;
                }
                if (YimBridge.this.mSinkChangeListener != null) {
                    YimBridge.this.mSinkChangeListener.onChange(0);
                }
                return;
            }
            if (YimBridge.this.mSinkChangeListener != null) {
                YimBridge.this.mSinkChangeListener.onChange(1);
            }
        }
    };

    public YimBridge(Context context, OutParameter outParameter) {
        super(context, outParameter);
        BrowserInfo browserInfo = CastUtil.getBrowserInfo(outParameter.serviceInfo, 4);
        if (browserInfo == null) {
            SourceLog.w(TAG, "has no im info, never should be here");
            return;
        }
        this.mIMInfo = browserInfo;
        this.mLocalConnectionIP = browserInfo.getIp();
        BrowserInfo browserInfo2 = outParameter.serviceInfo.getBrowserInfos().get(1);
        String string = null;
        if (browserInfo2 != null) {
            string = browserInfo2.getExtras().get("mirror");
        }
        this.mLocalConnectionPort = !TextUtils.isEmpty(string) ? Integer.parseInt(string) : 7100;
        this.mScreenCapture = CaptureBridge.getInstance();
        this.mScreenCapture.init();
        this.mScreenCapture.setPlayInfo(outParameter);
    }

    @Override
    public void play(String string) {
        SourceLog.i(TAG, "play " + string);
        this.isCallPrepared = false;
        PublicCastClient.getInstance().setOnPlayStateListener(this.mStateListener);
        ConnectManager.getInstance().getLastConnectBridge().addOnPassReceivedListener(this, this.onPassReceivedListener);
        int n2 = Preference.getInstance().get("c_mirror_width", 0);
        int n3 = Preference.getInstance().get("c_mirror_height", 0);
        if (n2 > 0 & n3 > 0) {
            this.captureWidth = n2;
            this.captureHeight = n3;
        }
        ConnectManager.getInstance().getLastConnectBridge().addOnPassReceivedListener(this, this.onPassReceivedListener);
        this.requestPushMirror(this.mPlayInfo.connectProtocol == 6 ? 0 : 1, this.getRoomIdListener);
    }

    private void initExternalVideo() {
        OptionCentral.setOnVideoUpdateListener(new OptionCentral.OnVideoUpdateListener(){

            @Override
            public void onVideoUpdate(byte[] byArray, VideoFrameBean videoFrameBean) {
                switch (videoFrameBean.type) {
                    case 1: {
                        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                        YimMirror.getInstance().sendH264Data(byteBuffer, videoFrameBean.width, videoFrameBean.height, videoFrameBean.pts);
                        break;
                    }
                    case 2: {
                        YimMirror.getInstance().sendRGBData(byArray, videoFrameBean.width, videoFrameBean.height, 0, videoFrameBean.pts / 1000L, 1);
                    }
                }
            }
        });
    }

    private void monitorExternalAudio() {
        OptionCentral.setOnExternalAudioStateChangedListener(new OptionCentral.OnExternalAudioStateChangedListener(){

            @Override
            public void onStateChanged(boolean bl) {
                SourceLog.i(YimBridge.TAG, "onStateChanged: isEnable: " + bl);
                int n2 = 0;
                n2 = bl ? 1 : CaptureBridge.getInstance().getAudioCaptureType(YimBridge.this.mPlayInfo);
                if (YimBridge.this.mScreenCapture != null) {
                    YimBridge.this.mScreenCapture.setAudioSwitch(n2, 0, YimBridge.this.mPlayInfo.requestAudioFocus, true);
                }
            }
        });
    }

    private void initExternalAudioSource() {
        OptionCentral.setOnPCMUpdateListener(new OptionCentral.OnPCMUpdateListener(){

            @Override
            public void onAudioUpdate(byte[] byArray, AudioFrameBean audioFrameBean) {
                SourceLog.w(YimBridge.TAG, "onAudioUpdate " + byArray.length + "  " + audioFrameBean.channel + "  / " + audioFrameBean.sampleRate);
                int n2 = 2;
                if (audioFrameBean.channel == 16) {
                    n2 = 1;
                }
                YimMirror.getInstance().sendAudio(byArray, byArray.length, System.currentTimeMillis(), n2);
            }
        });
    }

    @Override
    public void setExternalMirrorData() {
        SourceLog.i(TAG, "setExternalMirrorData");
        this.initExternalVideo();
        this.initExternalAudioSource();
        this.monitorExternalAudio();
        this.registerSinkKeyEvent();
        this.registerSinkTouchEvent();
    }

    @Override
    public void sendVideoData(ByteBuffer byteBuffer, int n2, int n3, int n4, long l2) {
        ++this.mFrameCount;
        if ((float)byteBuffer.remaining() / 1024.0f >= 10.0f && this.mScreenCapture.getBitrate() < 1000000) {
            SourceLog.i(TAG, "  onVideoDataCallback big frame size : " + (float)byteBuffer.remaining() / 1024.0f);
        }
        if (System.currentTimeMillis() - this.mPrintFrameTime >= 5000L) {
            SourceLog.i(TAG, "sendVideoData " + l2 + "/  fps : " + this.mFrameCount / 5);
            this.mPrintFrameTime = System.currentTimeMillis();
            this.mFrameCount = 0;
            this.sendNoneAudioFrame();
        }
        try {
            YimMirror.getInstance().sendH264Data(byteBuffer, n2, n3, System.currentTimeMillis());
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private void sendNoneAudioFrame() {
        if (CaptureBridge.getInstance().getAudioSwitch() == 0) {
            byte[] byArray = new byte[2048];
            this.sendAudioData(byArray, 0, byArray.length);
        }
    }

    @Override
    public void sendAudioData(byte[] byArray, int n2, int n3) {
        if (!OptionCentral.isEnableExternalAudio()) {
            YimMirror.getInstance().sendAudio(byArray, n3, System.currentTimeMillis(), 2);
        }
    }

    @Override
    public void screenshot(int n2) {
    }

    @Override
    public void onCaptureStop(int n2) {
        if (this.isFrozen) {
            return;
        }
    }

    @Override
    public void onCaptureStart(int n2) {
        if (this.isFrozen) {
            return;
        }
        if (!this.isCallPrepared) {
            this.isCallPrepared = true;
            if (this.mPreparedListener != null) {
                this.mPreparedListener.onPrepared(null);
            }
        } else if (this.mStateChangeListener != null) {
            this.mStateChangeListener.onStateChanged(null, 3);
        }
        SinkTouchEventMonitor.getInstance().createIMMonitorChannel();
    }

    @Override
    public void onInfo(int n2, String string) {
        SourceLog.i(TAG, "Capture onInfo " + n2 + "/" + string);
        if (LelinkSdkManager.getInstance().getRetryMirrorOnce().get()) {
            LelinkSdkManager.getInstance().getRetryMirrorOnce().set(false);
            SourceLog.i(TAG, "Capture onInfo retried.");
            return;
        }
        LelinkSdkManager.getInstance().getRetryMirrorOnce().set(true);
        if (n2 == 211010 && !TextUtils.isEmpty((CharSequence)string) && string.equals(String.valueOf(211013)) && !this.mPlayInfo.isGroup) {
            LelinkSdkManager.getInstance().clearPermissionIntentAndRetryMirror();
        }
    }

    public void notifySinkChange(IOnSinkChangeListener iOnSinkChangeListener) {
        if (this.isFrozen) {
            return;
        }
        SinkTouchEventMonitor.getInstance().createIMMonitorChannel();
        SourceLog.i(TAG, " start notify sink Change");
        this.mNotifyCount = 0;
        this.mSinkChangeListener = iOnSinkChangeListener;
        this.requestPushMirror(1, this.mChangeListenerHttpParameter);
    }

    private void delayNotify(long l2) {
        this.stopTask();
        this.mDelayNotifySinkTask = new DelayNotifySinkTask();
        this.mTimer.schedule((TimerTask)this.mDelayNotifySinkTask, l2);
    }

    public void stopTask() {
        SourceLog.i(TAG, " stopTask ");
        if (this.mDelayNotifySinkTask != null) {
            this.mDelayNotifySinkTask.cancel();
            this.mTimer.purge();
        }
    }

    private void requestPushMirror(int n2, AsyncHttpRequestListener asyncHttpRequestListener) {
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("uid", (Object)Session.getInstance().getUID());
            jSONObject.put("u", (Object)this.mIMInfo.getUid());
            jSONObject.put("ra", (Object)this.mIMInfo.getExtras().get("a"));
            jSONObject.put("appid", (Object)Session.getInstance().appKey);
            jSONObject.put("token", (Object)a.a());
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("pol", (Object)Feature.cloudMirrorSupportProtocol());
            jSONObject2.put("server", (Object)"");
            jSONObject2.put("suid", (Object)Session.getInstance().getUID());
            jSONObject2.put("timeout", (Object)"10");
            jSONObject2.put("sdkv", (Object)"4.07.19");
            jSONObject2.put("app_id", (Object)Session.getInstance().appKey);
            jSONObject2.put("sa", (Object)"15");
            jSONObject2.put("sid", (Object)this.mPlayInfo.connectSession);
            jSONObject2.put("uri", (Object)this.mPlayInfo.urlID);
            String string = "";
            try {
                string = Preference.getInstance().get("key_username");
                string = TextUtils.isEmpty((CharSequence)string) ? URLEncoder.encode(DeviceUtil.getBluetoothName()) : URLEncoder.encode(string);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
            jSONObject2.put("username", (Object)string);
            jSONObject2.put("scene", n2);
            if (n2 == 1) {
                jSONObject2.put("roomid", (Object)this.mBean.roomID);
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("020002ff,").append(jSONObject2.toString());
            jSONObject.put("content", (Object)stringBuilder.toString());
            jSONObject.put("ver", (Object)"2.1");
            SourceLog.i(TAG, "requestPushMirror " + CloudAPI.sPushMirror + " / " + jSONObject.toString());
            AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sPushMirror, jSONObject.toString());
            asyncHttpParameter.in.connectTimeout = (int)TimeUnit.SECONDS.toMillis(10L);
            asyncHttpParameter.in.readTimeout = (int)TimeUnit.SECONDS.toMillis(10L);
            asyncHttpParameter.in.requestMethod = 1;
            AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, asyncHttpRequestListener);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    @Override
    public void resume(String string) {
        if (this.mScreenCapture == null) {
            return;
        }
        SourceLog.i(TAG, "resume");
        PassSender.getInstance().sendMirrorState(MirrorStateBean.createResumeBean(this.mPlayInfo.urlID).toJson(), this.mPlayInfo.session);
        this.mScreenCapture.resumeEncode();
    }

    @Override
    public void pause(String string) {
        if (this.mScreenCapture == null) {
            return;
        }
        SourceLog.i(TAG, "pause");
        PassSender.getInstance().sendMirrorState(MirrorStateBean.createPauseBean(this.mPlayInfo.urlID).toJson(), this.mPlayInfo.session);
        this.mScreenCapture.pauseEncode(true);
        if (this.mStateChangeListener != null) {
            this.mStateChangeListener.onStateChanged(null, 4);
        }
    }

    @Override
    public boolean switchExpansionScreen(boolean bl) {
        if (this.mScreenCapture == null) {
            return false;
        }
        this.mPlayInfo.isExpandMirror = bl;
        this.isChangeExpandView = true;
        this.mScreenCapture.setExpansionScreenInfo(this.mPlayInfo.expandActivity, this.mPlayInfo.expandView);
        this.mScreenCapture.switchExpansionScreen(bl);
        return true;
    }

    @Override
    public void setSecondMirrorView(SecondMirrorView secondMirrorView) {
        super.setSecondMirrorView(secondMirrorView);
        if (this.mScreenCapture == null) {
            return;
        }
        this.mScreenCapture.setSecondMirrorView(secondMirrorView);
    }

    @Override
    public void seekTo(int n2) {
    }

    @Override
    public void stop(String string) {
        SourceLog.i(TAG, "stop " + string);
        YimMirror.getInstance().setCloudMirrorListener(null);
        if (this.mScreenCapture != null) {
            this.mScreenCapture.removeAbsBridge(4);
            this.mScreenCapture.release(2);
        }
        YimMirror.getInstance().stop();
        ConnectManager.getInstance().getLastConnectBridge().removeOnPassReceivedListener(this);
        OptionCentral.setOnSinkKeyEventRegisterListener(null);
        OptionCentral.setOnSinkTouchEventRegisterListener(null);
        this.doUnregisterSinkTouchEvent();
        PassSender.getInstance().sendSinkKeyRegister(SinkKeyEventRegisterBean.createUnregisterBean().toJson(), this.mPlayInfo.session);
    }

    private void callbackError(int n2, int n3) {
        if (this.mErrorListener != null) {
            this.mErrorListener.onError(null, n2, n3, null);
        }
    }

    private void registerSinkKeyEvent() {
        SourceLog.i(TAG, "registerSinkKeyEvent isRegister:" + OptionCentral.isRegisterSinkKeyEvent());
        if (OptionCentral.isRegisterSinkKeyEvent()) {
            PassSender.getInstance().sendSinkKeyRegister(SinkKeyEventRegisterBean.createRegisterBean().toJson(), this.mPlayInfo.session);
        }
        OptionCentral.setOnSinkKeyEventRegisterListener(new OptionCentral.OnSinkKeyEventRegisterListener(){

            @Override
            public void onRegister() {
                PassSender.getInstance().sendSinkKeyRegister(SinkKeyEventRegisterBean.createRegisterBean().toJson(), YimBridge.this.mPlayInfo.session);
            }

            @Override
            public void onUnregister() {
                PassSender.getInstance().sendSinkKeyRegister(SinkKeyEventRegisterBean.createUnregisterBean().toJson(), YimBridge.this.mPlayInfo.session);
            }
        });
    }

    private void registerSinkTouchEvent() {
        if (OptionCentral.isRegistSinkTouchEvent()) {
            this.doRegisterSinkTouchEvent();
        }
        OptionCentral.setOnSinkTouchEventRegisterListener(new OptionCentral.OnSinkTouchEventRegisterListener(){

            @Override
            public void onRegister() {
                SourceLog.i(YimBridge.TAG, "onRegister: ");
                YimBridge.this.doRegisterSinkTouchEvent();
            }

            @Override
            public void onUnregister() {
                YimBridge.this.doUnregisterSinkTouchEvent();
            }
        });
    }

    private void doRegisterSinkTouchEvent() {
        SourceLog.i(TAG, "doRegisterSinkTouchEvent: hasRegisterSinkTouchEvent\uff1a " + this.hasRegisterSinkTouchEvent);
        if (!this.hasRegisterSinkTouchEvent) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    SinkTouchEventMonitor.getInstance().startMonitor(YimBridge.this.mContext, YimBridge.this.mPlayInfo.session, true);
                }
            }, 1000L);
            PassSender.getInstance().sendSinkTouchRegister(SinkTouchEventRegisterBean.createRegisterBean().toJson(), this.mPlayInfo.session);
            this.hasRegisterSinkTouchEvent = true;
        }
    }

    private void doUnregisterSinkTouchEvent() {
        SourceLog.i(TAG, "doUnregisterSinkTouchEvent: ");
        this.hasRegisterSinkTouchEvent = false;
        SinkTouchEventMonitor.getInstance().stopMonitor();
        PassSender.getInstance().sendSinkTouchRegister(SinkTouchEventRegisterBean.createUnregisterBean().toJson(), this.mPlayInfo.session);
    }

    @Override
    public void frozen(boolean bl) {
        super.frozen(bl);
        SourceLog.i(TAG, "+++++++++++++++++++++++ frozen " + bl);
        this.isFrozen = bl;
        this.mHandler.removeCallbacksAndMessages(null);
    }

    @Override
    public void release() {
        SourceLog.i(TAG, "release");
        PublicCastClient.getInstance().setOnPlayStateListener(null);
    }

    @Override
    public void setWatermarkVisible(boolean bl) {
        if (this.mScreenCapture == null) {
            SourceLog.w(TAG, "setWatermarkVisible ignore");
            return;
        }
        SourceLog.i(TAG, "setWatermarkVisible");
        this.mScreenCapture.setWatermarkVisible(bl);
    }

    @Override
    public void setMirrorScreenSecret(boolean bl) {
        if (this.mScreenCapture == null) {
            SourceLog.w(TAG, "setMirrorScreenSecret ignore");
            return;
        }
        this.mScreenCapture.setMirrorScreenSecret(bl);
    }

    class DelayNotifySinkTask
    extends TimerTask {
        DelayNotifySinkTask() {
        }

        @Override
        public void run() {
            SourceLog.i(YimBridge.TAG, "start mDelayNotifySinkTask ");
            YimBridge.this.notifySinkChange(YimBridge.this.mSinkChangeListener);
        }
    }

    public static interface IOnSinkChangeListener {
        public static final int SUCCESS = 1;
        public static final int FAILED = 0;

        public void onChange(int var1);
    }
}

