/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.Compression;
import com.hpplay.sdk.source.mdns.xbill.dns.DNAMERecord;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSInput;
import com.hpplay.sdk.source.mdns.xbill.dns.DNSOutput;
import com.hpplay.sdk.source.mdns.xbill.dns.Options;
import java.io.Serializable;
import java.text.DecimalFormat;

public class Name
implements Serializable,
Comparable {
    private static final long serialVersionUID = -7257019940971525644L;
    private static final int LABEL_NORMAL = 0;
    private static final int LABEL_COMPRESSION = 192;
    private static final int LABEL_MASK = 192;
    private byte[] name;
    private long offsets;
    private int hashcode;
    private static final byte[] emptyLabel = new byte[]{0};
    private static final byte[] wildLabel = new byte[]{1, 42};
    public static final Name root;
    public static final Name empty;
    private static final int MAXNAME = 255;
    private static final int MAXLABEL = 63;
    private static final int MAXLABELS = 128;
    private static final int MAXOFFSETS = 7;
    private static final DecimalFormat byteFormat;
    private static final byte[] lowercase;
    private static final Name wild;

    private Name() {
    }

    private final void setoffset(int n2, int n3) {
        if (n2 < 7) {
            int n4 = 8 * (7 - n2);
            this.offsets &= 255L << n4 ^ 0xFFFFFFFFFFFFFFFFL;
            this.offsets |= (long)n3 << n4;
        }
    }

    private final int offset(int n2) {
        if (n2 == 0 && this.getlabels() == 0) {
            return 0;
        }
        if (n2 >= 0 && n2 < this.getlabels()) {
            if (n2 < 7) {
                int n3 = 8 * (7 - n2);
                return (int)(this.offsets >>> n3) & 0xFF;
            }
            int n4 = this.offset(6);
            for (int i2 = 6; i2 < n2; ++i2) {
                n4 += this.name[n4] + 1;
            }
            return n4;
        }
        throw new IllegalArgumentException("label out of range");
    }

    private final void setlabels(int n2) {
        this.offsets &= 0xFFFFFFFFFFFFFF00L;
        this.offsets |= (long)n2;
    }

    private final int getlabels() {
        return (int)(this.offsets & 0xFFL);
    }

    private static final void copy(Name name, Name name2) {
        if (name.offset(0) == 0) {
            name2.name = name.name;
            name2.offsets = name.offsets;
        } else {
            int n2 = name.offset(0);
            int n3 = name.name.length - n2;
            int n4 = name.labels();
            name2.name = new byte[n3];
            System.arraycopy(name.name, n2, name2.name, 0, n3);
            for (int i2 = 0; i2 < n4 && i2 < 7; ++i2) {
                name2.setoffset(i2, name.offset(i2) - n2);
            }
            name2.setlabels(n4);
        }
    }

    private final void append(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6 = this.name == null ? 0 : this.name.length - this.offset(0);
        int n7 = 0;
        int n8 = n2;
        for (n5 = 0; n5 < n3; ++n5) {
            byte by = byArray[n8];
            if (by > 63) {
                throw new IllegalStateException("invalid label");
            }
            n4 = by + 1;
            n8 += n4;
            n7 += n4;
        }
        n5 = n6 + n7;
        if (n5 > 255) {
            throw new Exception();
        }
        n8 = this.getlabels();
        n4 = n8 + n3;
        if (n4 > 128) {
            throw new IllegalStateException("too many labels");
        }
        byte[] byArray2 = new byte[n5];
        if (n6 != 0) {
            System.arraycopy(this.name, this.offset(0), byArray2, 0, n6);
        }
        System.arraycopy(byArray, n2, byArray2, n6, n7);
        this.name = byArray2;
        int n9 = n6;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.setoffset(n8 + i2, n9);
            n9 += byArray2[n9] + 1;
        }
        this.setlabels(n4);
    }

    private static Exception parseException(String string, String string2) {
        return new Exception("'" + string + "': " + string2);
    }

    private final void appendFromString(String string, byte[] byArray, int n2, int n3) {
        try {
            this.append(byArray, n2, n3);
        }
        catch (Exception exception) {
            throw Name.parseException(string, "Name too long");
        }
    }

    private final void appendSafe(byte[] byArray, int n2, int n3) {
        try {
            this.append(byArray, n2, n3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Name(String string, Name name) {
        if (string.equals("")) {
            throw Name.parseException(string, "empty name");
        }
        if (string.equals("@")) {
            if (name == null) {
                Name.copy(empty, this);
            } else {
                Name.copy(name, this);
            }
        } else if (string.equals(".")) {
            Name.copy(root, this);
        } else {
            int n2 = -1;
            int n3 = 1;
            byte[] byArray = new byte[64];
            boolean bl = false;
            int n4 = 0;
            int n5 = 0;
            boolean bl2 = false;
            for (int i2 = 0; i2 < string.length(); ++i2) {
                byte by = (byte)string.charAt(i2);
                if (!bl) {
                    if (by == 92) {
                        bl = true;
                        n4 = 0;
                        n5 = 0;
                        continue;
                    }
                    if (by == 46) {
                        byArray[0] = (byte)(n3 - 1);
                        this.appendFromString(string, byArray, 0, 1);
                        n2 = -1;
                        n3 = 1;
                        continue;
                    }
                    if (n2 == -1) {
                        n2 = i2;
                    }
                    if (n3 > 63) {
                        throw Name.parseException(string, "label too long");
                    }
                    byArray[n3++] = by;
                    continue;
                }
                if (by >= 48 && by <= 57 && n4 < 3) {
                    ++n4;
                    n5 *= 10;
                    if ((n5 += by - 48) > 255) {
                        throw Name.parseException(string, "bad escape");
                    }
                    if (n4 < 3) continue;
                    by = (byte)n5;
                } else if (n4 > 0 && n4 < 3) {
                    throw Name.parseException(string, "bad escape");
                }
                if (n3 > 63) {
                    throw Name.parseException(string, "label too long");
                }
                n2 = n3;
                byArray[n3++] = by;
                bl = false;
            }
            if (n4 > 0 && n4 < 3) {
                throw Name.parseException(string, "bad escape");
            }
            if (bl) {
                throw Name.parseException(string, "bad escape");
            }
            if (n2 == -1) {
                this.appendFromString(string, emptyLabel, 0, 1);
                bl2 = true;
            } else {
                byArray[0] = (byte)(n3 - 1);
                this.appendFromString(string, byArray, 0, 1);
            }
            if (name != null && !bl2) {
                this.appendFromString(string, name.name, name.offset(0), name.getlabels());
            }
        }
    }

    public Name(String string) {
        this(string, null);
    }

    public static Name fromString(String string, Name name) {
        if (string.equals("@") && name != null) {
            return name;
        }
        return string.equals(".") ? root : new Name(string, name);
    }

    public static Name fromString(String string) {
        return Name.fromString(string, null);
    }

    public static Name fromConstantString(String string) {
        try {
            return Name.fromString(string, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid name '" + string + "'");
        }
    }

    public Name(DNSInput dNSInput) {
        boolean bl = false;
        byte[] byArray = new byte[64];
        boolean bl2 = false;
        block4: while (!bl) {
            int n2 = dNSInput.readU8();
            switch (n2 & 0xC0) {
                case 0: {
                    if (this.getlabels() >= 128) {
                        throw new Exception("too many labels");
                    }
                    if (n2 == 0) {
                        this.append(emptyLabel, 0, 1);
                        bl = true;
                        continue block4;
                    }
                    byArray[0] = (byte)n2;
                    dNSInput.readByteArray(byArray, 1, n2);
                    this.append(byArray, 0, 1);
                    continue block4;
                }
                case 192: {
                    int n3 = dNSInput.readU8();
                    n3 += (n2 & 0xFFFFFF3F) << 8;
                    if (Options.check("verbosecompression")) {
                        System.err.println("currently " + dNSInput.current() + ", pointer to " + n3);
                    }
                    if (n3 >= dNSInput.current() - 2) {
                        throw new Exception("bad compression");
                    }
                    if (!bl2) {
                        dNSInput.save();
                        bl2 = true;
                    }
                    dNSInput.jump(n3);
                    if (!Options.check("verbosecompression")) continue block4;
                    System.err.println("current name '" + this + "', seeking to " + n3);
                    continue block4;
                }
            }
            throw new Exception("bad label type");
        }
        if (bl2) {
            dNSInput.restore();
        }
    }

    public Name(byte[] byArray) {
        this(new DNSInput(byArray));
    }

    public Name(Name name, int n2) {
        int n3 = name.labels();
        if (n2 > n3) {
            throw new IllegalArgumentException("attempted to remove too many labels");
        }
        this.name = name.name;
        this.setlabels(n3 - n2);
        for (int i2 = 0; i2 < 7 && i2 < n3 - n2; ++i2) {
            this.setoffset(i2, name.offset(i2 + n2));
        }
    }

    public static Name concatenate(Name name, Name name2) {
        if (name.isAbsolute()) {
            return name;
        }
        Name name3 = new Name();
        Name.copy(name, name3);
        name3.append(name2.name, name2.offset(0), name2.getlabels());
        return name3;
    }

    public Name relativize(Name name) {
        if (name != null && this.subdomain(name)) {
            Name name2 = new Name();
            Name.copy(this, name2);
            int n2 = this.length() - name.length();
            int n3 = name2.labels() - name.labels();
            name2.setlabels(n3);
            name2.name = new byte[n2];
            System.arraycopy(this.name, this.offset(0), name2.name, 0, n2);
            return name2;
        }
        return this;
    }

    public Name wild(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("must replace 1 or more labels");
        }
        try {
            Name name = new Name();
            Name.copy(wild, name);
            name.append(this.name, this.offset(n2), this.getlabels() - n2);
            return name;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Name.wild: concatenate failed");
        }
    }

    public Name canonicalize() {
        boolean bl = true;
        for (int i2 = 0; i2 < this.name.length; ++i2) {
            if (lowercase[this.name[i2] & 0xFF] == this.name[i2]) continue;
            bl = false;
            break;
        }
        if (bl) {
            return this;
        }
        Name name = new Name();
        name.appendSafe(this.name, this.offset(0), this.getlabels());
        for (int i3 = 0; i3 < name.name.length; ++i3) {
            name.name[i3] = lowercase[name.name[i3] & 0xFF];
        }
        return name;
    }

    public Name fromDNAME(DNAMERecord dNAMERecord) {
        Name name = dNAMERecord.getName();
        Name name2 = dNAMERecord.getTarget();
        if (!this.subdomain(name)) {
            return null;
        }
        int n2 = this.labels() - name.labels();
        int n3 = this.length() - name.length();
        int n4 = this.offset(0);
        int n5 = name2.labels();
        short s2 = name2.length();
        if (n3 + s2 > 255) {
            throw new Exception();
        }
        Name name3 = new Name();
        name3.setlabels(n2 + n5);
        name3.name = new byte[n3 + s2];
        System.arraycopy(this.name, n4, name3.name, 0, n3);
        System.arraycopy(name2.name, 0, name3.name, n3, s2);
        int n6 = 0;
        for (int i2 = 0; i2 < 7 && i2 < n2 + n5; ++i2) {
            name3.setoffset(i2, n6);
            n6 += name3.name[n6] + 1;
        }
        return name3;
    }

    public boolean isWild() {
        if (this.labels() == 0) {
            return false;
        }
        return this.name[0] == 1 && this.name[1] == 42;
    }

    public boolean isAbsolute() {
        int n2 = this.labels();
        if (n2 == 0) {
            return false;
        }
        return this.name[this.offset(n2 - 1)] == 0;
    }

    public short length() {
        return this.getlabels() == 0 ? (short)0 : (short)(this.name.length - this.offset(0));
    }

    public int labels() {
        return this.getlabels();
    }

    public boolean subdomain(Name name) {
        int n2 = this.labels();
        int n3 = name.labels();
        if (n3 > n2) {
            return false;
        }
        return n3 == n2 ? this.equals(name) : name.equals(this.name, this.offset(n2 - n3));
    }

    private String byteString(byte[] byArray, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        byte by = byArray[n2++];
        for (int i2 = n2; i2 < n2 + by; ++i2) {
            int n3 = byArray[i2] & 0xFF;
            if (n3 > 32 && n3 < 127) {
                if (n3 != 34 && n3 != 40 && n3 != 41 && n3 != 46 && n3 != 59 && n3 != 92 && n3 != 64 && n3 != 36) {
                    stringBuffer.append((char)n3);
                    continue;
                }
                stringBuffer.append('\\');
                stringBuffer.append((char)n3);
                continue;
            }
            stringBuffer.append('\\');
            stringBuffer.append(byteFormat.format(n3));
        }
        return stringBuffer.toString();
    }

    public String toString(boolean bl) {
        int n2 = this.labels();
        if (n2 == 0) {
            return "@";
        }
        if (n2 == 1 && this.name[this.offset(0)] == 0) {
            return ".";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = this.offset(0);
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = this.name[n3];
            if (by > 63) {
                throw new IllegalStateException("invalid label");
            }
            if (by == 0) {
                if (bl) break;
                stringBuffer.append('.');
                break;
            }
            if (i2 > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(this.byteString(this.name, n3));
            n3 += 1 + by;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public byte[] getLabel(int n2) {
        int n3 = this.offset(n2);
        byte by = (byte)(this.name[n3] + 1);
        byte[] byArray = new byte[by];
        System.arraycopy(this.name, n3, byArray, 0, by);
        return byArray;
    }

    public String getLabelString(int n2) {
        int n3 = this.offset(n2);
        return this.byteString(this.name, n3);
    }

    public void toWire(DNSOutput dNSOutput, Compression compression) {
        if (!this.isAbsolute()) {
            throw new IllegalArgumentException("toWire() called on non-absolute name");
        }
        int n2 = this.labels();
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            Name name = i2 == 0 ? this : new Name(this, i2);
            int n3 = -1;
            if (compression != null) {
                n3 = compression.get(name);
            }
            if (n3 >= 0) {
                dNSOutput.writeU16(n3 |= 0xC000);
                return;
            }
            if (compression != null) {
                compression.add(dNSOutput.current(), name);
            }
            int n4 = this.offset(i2);
            dNSOutput.writeByteArray(this.name, n4, this.name[n4] + 1);
        }
        dNSOutput.writeU8(0);
    }

    public byte[] toWire() {
        DNSOutput dNSOutput = new DNSOutput();
        this.toWire(dNSOutput, null);
        return dNSOutput.toByteArray();
    }

    public void toWireCanonical(DNSOutput dNSOutput) {
        byte[] byArray = this.toWireCanonical();
        dNSOutput.writeByteArray(byArray);
    }

    public byte[] toWireCanonical() {
        int n2 = this.labels();
        if (n2 == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[this.name.length - this.offset(0)];
        int n3 = this.offset(0);
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5 = this.name[n3];
            if (n5 > 63) {
                throw new IllegalStateException("invalid label");
            }
            byArray[n4++] = this.name[n3++];
            for (int i3 = 0; i3 < n5; ++i3) {
                byArray[n4++] = lowercase[this.name[n3++] & 0xFF];
            }
        }
        return byArray;
    }

    public void toWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        if (bl) {
            this.toWireCanonical(dNSOutput);
        } else {
            this.toWire(dNSOutput, compression);
        }
    }

    private final boolean equals(byte[] byArray, int n2) {
        int n3 = this.labels();
        int n4 = this.offset(0);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.name[n4] != byArray[n2]) {
                return false;
            }
            int n5 = this.name[n4++];
            ++n2;
            if (n5 > 63) {
                throw new IllegalStateException("invalid label");
            }
            for (int i3 = 0; i3 < n5; ++i3) {
                if (lowercase[this.name[n4++] & 0xFF] == lowercase[byArray[n2++] & 0xFF]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof Name) {
            Name name = (Name)object;
            if (name.hashcode == 0) {
                name.hashCode();
            }
            if (this.hashcode == 0) {
                this.hashCode();
            }
            if (name.hashcode != this.hashcode) {
                return false;
            }
            return name.labels() != this.labels() ? false : this.equals(name.name, name.offset(0));
        }
        return false;
    }

    public int hashCode() {
        if (this.hashcode != 0) {
            return this.hashcode;
        }
        int n2 = 0;
        for (int i2 = this.offset(0); i2 < this.name.length; ++i2) {
            n2 += (n2 << 3) + lowercase[this.name[i2] & 0xFF];
        }
        this.hashcode = n2;
        return this.hashcode;
    }

    public int compareTo(Object object) {
        int n2;
        Name name = (Name)object;
        if (this == name) {
            return 0;
        }
        int n3 = this.labels();
        int n4 = n3 > (n2 = name.labels()) ? n2 : n3;
        for (int i2 = 1; i2 <= n4; ++i2) {
            int n5 = this.offset(n3 - i2);
            int n6 = name.offset(n2 - i2);
            int n7 = this.name[n5];
            byte by = name.name[n6];
            for (int i3 = 0; i3 < n7 && i3 < by; ++i3) {
                int n8 = lowercase[this.name[i3 + n5 + 1] & 0xFF] - lowercase[name.name[i3 + n6 + 1] & 0xFF];
                if (n8 == 0) continue;
                return n8;
            }
            if (n7 == by) continue;
            return n7 - by;
        }
        return n3 - n2;
    }

    static {
        byteFormat = new DecimalFormat();
        lowercase = new byte[256];
        byteFormat.setMinimumIntegerDigits(3);
        for (int i2 = 0; i2 < lowercase.length; ++i2) {
            Name.lowercase[i2] = i2 >= 65 && i2 <= 90 ? (byte)(i2 - 65 + 97) : (byte)i2;
        }
        root = new Name();
        root.appendSafe(emptyLabel, 0, 1);
        empty = new Name();
        Name.empty.name = new byte[0];
        wild = new Name();
        wild.appendSafe(wildLabel, 0, 1);
    }
}

