/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.xbill.dns.CNAMERecord;
import com.hpplay.sdk.source.mdns.xbill.dns.DNAMERecord;
import com.hpplay.sdk.source.mdns.xbill.dns.RRset;
import java.util.ArrayList;
import java.util.List;

public class SetResponse {
    private static final SetResponse unknown = new SetResponse(0);
    private static final SetResponse nxdomain = new SetResponse(1);
    private static final SetResponse nxrrset = new SetResponse(2);
    private int type;
    private Object data;

    private SetResponse() {
    }

    SetResponse(int n2, RRset rRset) {
        if (n2 < 0 || n2 > 6) {
            throw new IllegalArgumentException("invalid type");
        }
        this.type = n2;
        this.data = rRset;
    }

    SetResponse(int n2) {
        if (n2 < 0 || n2 > 6) {
            throw new IllegalArgumentException("invalid type");
        }
        this.type = n2;
        this.data = null;
    }

    static SetResponse ofType(int n2) {
        switch (n2) {
            case 0: {
                return unknown;
            }
            case 1: {
                return nxdomain;
            }
            case 2: {
                return nxrrset;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                SetResponse setResponse = new SetResponse();
                setResponse.type = n2;
                setResponse.data = null;
                return setResponse;
            }
        }
        throw new IllegalArgumentException("invalid type");
    }

    void addRRset(RRset rRset) {
        if (this.data == null) {
            this.data = new ArrayList();
        }
        List list = (List)this.data;
        list.add(rRset);
    }

    public boolean isUnknown() {
        return this.type == 0;
    }

    public boolean isNXDOMAIN() {
        return this.type == 1;
    }

    public boolean isNXRRSET() {
        return this.type == 2;
    }

    public boolean isDelegation() {
        return this.type == 3;
    }

    public boolean isCNAME() {
        return this.type == 4;
    }

    public boolean isDNAME() {
        return this.type == 5;
    }

    public boolean isSuccessful() {
        return this.type == 6;
    }

    public RRset[] answers() {
        if (this.type != 6) {
            return null;
        }
        List list = (List)this.data;
        return list.toArray(new RRset[list.size()]);
    }

    public CNAMERecord getCNAME() {
        return (CNAMERecord)((RRset)this.data).first();
    }

    public DNAMERecord getDNAME() {
        return (DNAMERecord)((RRset)this.data).first();
    }

    public RRset getNS() {
        return (RRset)this.data;
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                return "unknown";
            }
            case 1: {
                return "NXDOMAIN";
            }
            case 2: {
                return "NXRRSET";
            }
            case 3: {
                return "delegation: " + this.data;
            }
            case 4: {
                return "CNAME: " + this.data;
            }
            case 5: {
                return "DNAME: " + this.data;
            }
            case 6: {
                return "successful";
            }
        }
        throw new IllegalStateException();
    }
}

