/*
 * Decompiled with CFR 0.152.
 */
package com.unisound.edu.oraleval.sdk.sep15.utils;

import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogBuffer {
    static final String W = "war";
    static final String I = "inf";
    static final String V = "veb";
    static final String E = "err";
    static final String D = "dbg";
    StringWriter sw;
    PrintWriter pw;
    private final int _initCap;
    public static LogBuffer ONE = new LogBuffer(0);
    static final DateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd HH:mm:ss.SSS");

    public static synchronized void SETONE(boolean logon) {
        ONE = logon ? new LogBuffer(102400) : new LogBuffer(0);
    }

    public LogBuffer(int initCap) {
        this._initCap = initCap;
        this.sw = new StringWriter(this._initCap);
        this.pw = new PrintWriter(this.sw);
    }

    public synchronized String getString() {
        this.pw.close();
        String ret = this.sw.getBuffer().toString();
        this.i("LogBuffer", "to reset");
        this.sw = new StringWriter(this._initCap);
        this.pw = new PrintWriter(this.sw);
        return ret;
    }

    private synchronized void append(String level, String tag, Throwable tr, String msg) {
        if (this._initCap <= 0) {
            return;
        }
        this.pw.print(Thread.currentThread().getId());
        this.pw.print('\t');
        this.pw.print(DATE_FORMAT.format(new Date()));
        this.pw.print('\t');
        this.pw.print(level);
        this.pw.print('\t');
        this.pw.print(tag);
        if (msg != null) {
            this.pw.print('\t');
            this.pw.print(msg);
        }
        if (tr != null) {
            this.pw.print('\t');
            tr.printStackTrace(this.pw);
        }
        this.pw.println();
    }

    public int d(String tag, String msg) {
        this.append(D, tag, null, msg);
        return Log.d((String)tag, (String)msg);
    }

    public int d(String tag, String msg, Throwable tr) {
        this.append(D, tag, tr, msg);
        return Log.d((String)tag, (String)msg, (Throwable)tr);
    }

    public int e(String tag, String msg) {
        this.append(E, tag, null, msg);
        return Log.e((String)tag, (String)msg);
    }

    public int e(String tag, String msg, Throwable tr) {
        this.append(E, tag, tr, msg);
        return Log.e((String)tag, (String)msg, (Throwable)tr);
    }

    public int i(String tag, String msg) {
        this.append(I, tag, null, msg);
        return Log.i((String)tag, (String)msg);
    }

    public int i(String tag, String msg, Throwable tr) {
        this.append(I, tag, tr, msg);
        return Log.i((String)tag, (String)msg, (Throwable)tr);
    }

    public int v(String tag, String msg, Throwable tr) {
        this.append(V, tag, tr, msg);
        return Log.v((String)tag, (String)msg, (Throwable)tr);
    }

    public int v(String tag, String msg) {
        this.append(V, tag, null, msg);
        return Log.v((String)tag, (String)msg);
    }

    public int w(String tag, Throwable tr) {
        this.append(W, tag, tr, null);
        return Log.w((String)tag, (Throwable)tr);
    }

    public int w(String tag, String msg, Throwable tr) {
        this.append(W, tag, tr, msg);
        return Log.w((String)tag, (String)msg, (Throwable)tr);
    }

    public int w(String tag, String msg) {
        this.append(W, tag, null, msg);
        return Log.w((String)tag, (String)msg);
    }
}

