/*
 * Decompiled with CFR 0.152.
 */
package com.unisound.edu.oraleval.sdk.sep15.handlers;

import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import au.com.ds.ef.EasyFlow;
import au.com.ds.ef.EventEnum;
import au.com.ds.ef.FlowBuilder;
import au.com.ds.ef.StateEnum;
import au.com.ds.ef.StatefulContext;
import au.com.ds.ef.call.ContextHandler;
import com.unisound.edu.oraleval.sdk.sep15.SDKError;
import com.unisound.edu.oraleval.sdk.sep15.handlers.Arbitrator;
import com.unisound.edu.oraleval.sdk.sep15.intf.IHandler;
import com.unisound.edu.oraleval.sdk.sep15.intf.ISDK;
import com.unisound.edu.oraleval.sdk.sep15.intf.MessageProcessor;
import com.unisound.edu.oraleval.sdk.sep15.privprotocol.Attribute;
import com.unisound.edu.oraleval.sdk.sep15.privprotocol.Request;
import com.unisound.edu.oraleval.sdk.sep15.privprotocol.Response;
import com.unisound.edu.oraleval.sdk.sep15.utils.LogBuffer;
import com.unisound.edu.oraleval.sdk.sep15.utils.OnlineHostAddressPool;
import com.unisound.edu.oraleval.sdk.sep15.utils.OralEvalEnum;
import com.unisound.edu.oraleval.sdk.sep15.utils.SDKErrorException;
import com.unisound.edu.oraleval.sdk.sep15.utils.Store;
import com.unisound.edu.oraleval.sdk.sep15.utils.Utils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class OnlinePriv
implements IHandler<ExternalEvents> {
    static final String TAG = "OnlinePriv";
    public static final int CONNECT_FAIL = -1;
    public static final int SEND_START_FAIL = -2;
    public static final int SEND_VOICE_FAIL = -3;
    public static final int SEND_STOP_FAIL = -4;
    public static final int READ_START_FAIL = -5;
    public static final int READ_STOP_FAIL = -6;
    private String _host;
    private int _port;
    private boolean k_port_ok = false;
    private boolean isAsyncRecognize = false;
    EasyFlow<Context> _sm;
    Context _cxt;
    Handler _adrH;
    boolean _adrHStopped = false;
    static final int MSG_STOP = 1;
    static final int MSG_CHECK_DNS = 2;
    static final int MSG_CHECK_CONNECT = 3;
    static final int MSG_CHECK_START = 4;
    static final int MSG_CHECK_RESULT = 5;
    static final int MSG_SEND_VOICE = 6;
    static final int MSG_CONTINUE_STOP = 7;
    public static OnlinePriv THIS;
    int _dnsCheckTime = 0;
    int _connectCheckTime = 0;
    int _startCheckTime = 0;
    int _stopCheckTime = 0;
    static final int DNS_CHECK_INTERVAL = 50;
    static final int CONNECT_CHECK_INTERVAL = 100;
    static final int NETWORK_READ_INTERVAL = 200;
    static final int NETWORK_WRITE_INTERVAL = 350;
    static final int START_CHECK_MIN = 1000;
    static final int START_CHECK_PER_10_CHARACTERS = 500;
    static final int RESULT_CHECK_PER_10_CHARACTERS = 1000;

    @Override
    public void trigger(ExternalEvents event, HashMap<String, Object> params) {
        if (this._adrHStopped) {
            LogBuffer.ONE.i(TAG, "ignore evternal event:" + (Object)((Object)event));
            if (this.isAsyncRecognize) {
                SDKError err = new SDKError(SDKError.Category.Network, -1, new RuntimeException("connect timeout " + this._connectCheckTime * 100));
                Arbitrator.THIS.trigger(Arbitrator.ExternalEvents.exCancel, Utils.getParam(err, "error"));
            }
            return;
        }
        LogBuffer.ONE.i(TAG, "to handle evternal event:" + (Object)((Object)event));
        if (ExternalEvents.eGetResult.equals((Object)event)) {
            this._cxt.needResult(true);
            this._cxt.safeTrigger(Events.getResult);
        } else {
            LogBuffer.ONE.w(TAG, "unhandled event:" + (Object)((Object)event));
        }
    }

    @Override
    public void quit() {
        this._adrHStopped = true;
        this._cxt.deinit();
    }

    public OnlinePriv(final ISDK parent, String host, final int port, boolean k_port) {
        Log.i((String)TAG, (String)("new " + this.getClass().getSimpleName() + "@ t" + Thread.currentThread().getId()));
        LogBuffer.ONE.i(TAG, "host : " + host + " port : " + port);
        Arbitrator.THIS.getUploadLogBean().setHost(host + ":" + port);
        this._host = host;
        this._port = port;
        this.k_port_ok = k_port;
        this.isAsyncRecognize = parent.getCfg().isAsyncRecognize();
        THIS = this;
        this._adrH = parent.newHandler(this.getClass().getSimpleName(), new MessageProcessor(){

            @Override
            public void handleMessage(Message msg) {
                if (OnlinePriv.this._adrHStopped) {
                    LogBuffer.ONE.w(OnlinePriv.TAG, "received message " + msg.what + " after handler stopped");
                    return;
                }
                try {
                    switch (msg.what) {
                        case 2: {
                            if (OnlinePriv.this._cxt.resolvedDns() != null) {
                                OnlinePriv.this._cxt.trigger(Events.dnsOK);
                                break;
                            }
                            if (OnlinePriv.this._dnsCheckTime < 20) {
                                OnlinePriv.this._adrH.sendEmptyMessageDelayed(2, 50L);
                                ++OnlinePriv.this._dnsCheckTime;
                                break;
                            }
                            OnlinePriv.this._cxt.setLastError(new SDKError(SDKError.Category.Network, -1, new RuntimeException("resolve domain timeout")));
                            OnlinePriv.this._cxt.trigger(Events.dnsFailed);
                            break;
                        }
                        case 3: {
                            boolean isConnected = false;
                            try {
                                isConnected = OnlinePriv.this._cxt.isConnected();
                            }
                            catch (Exception ioe) {
                                OnlinePriv.this._cxt.setLastError(new SDKError(SDKError.Category.Network, -1, ioe));
                                OnlinePriv.this._cxt.trigger(Events.connectFailed);
                                return;
                            }
                            if (isConnected) {
                                OnlinePriv.this._cxt.trigger(Events.connectOK);
                                break;
                            }
                            if (OnlinePriv.this._connectCheckTime * 100 < parent.getCfg().getConnectTimeout()) {
                                ++OnlinePriv.this._connectCheckTime;
                                OnlinePriv.this._adrH.sendEmptyMessageDelayed(3, 100L);
                                break;
                            }
                            OnlinePriv.this._cxt.setLastError(new SDKError(SDKError.Category.Network, -1, new RuntimeException("connect timeout " + OnlinePriv.this._connectCheckTime * 100)));
                            OnlinePriv.this._cxt.trigger(Events.connectFailed);
                            break;
                        }
                        case 7: {
                            if (!OnlinePriv.this._cxt.toStop()) {
                                OnlinePriv.this._adrH.sendEmptyMessageDelayed(7, 200L);
                            }
                            break;
                        }
                        case 5: {
                            if (OnlinePriv.this._adrH.hasMessages(4)) {
                                OnlinePriv.this._adrH.sendEmptyMessageDelayed(5, 200L);
                                break;
                            }
                            Response rsp = new Response();
                            SDKError err = OnlinePriv.this._cxt.toReadStopResponse(rsp);
                            if (err != null) {
                                OnlinePriv.this._cxt.setLastError(err);
                                OnlinePriv.this._cxt.trigger(Events.getResultFailed);
                            }
                            if (rsp.FillDone) {
                                if (rsp.Code == 0) {
                                    OnlinePriv.this._cxt.setResult(rsp.Value);
                                    if (OnlinePriv.this.isAsyncRecognize) {
                                        Context cfr_ignored_0 = OnlinePriv.this._cxt;
                                        OnlinePriv.this._cxt.setResult("AsyncResult_Code");
                                    }
                                    OnlinePriv.this._cxt.trigger(Events.gotResult);
                                    break;
                                }
                                OnlinePriv.this._cxt.setLastError(new SDKError(SDKError.Category.Server, rsp.Code, new RuntimeException("stop response error, code:" + rsp.Code)));
                                OnlinePriv.this._cxt.trigger(Events.getResultFailed);
                                break;
                            }
                            if (OnlinePriv.this._cxt.isStopTimeout(OnlinePriv.this._stopCheckTime * 200)) {
                                OnlinePriv.this._cxt.setLastError(new SDKError(SDKError.Category.Network, -6, new RuntimeException("stop timeout in " + OnlinePriv.this._stopCheckTime * 200)));
                                OnlinePriv.this._cxt.trigger(Events.getResultFailed);
                                break;
                            }
                            ++OnlinePriv.this._stopCheckTime;
                            OnlinePriv.this._adrH.sendEmptyMessageDelayed(5, 200L);
                            break;
                        }
                        case 1: {
                            OnlinePriv.this._cxt.trigger(Events.getResult);
                            break;
                        }
                        case 6: {
                            SDKError err = OnlinePriv.this._cxt.toSendVoice();
                            if (err != null) {
                                OnlinePriv.this._cxt.setLastError(err);
                                OnlinePriv.this._cxt.trigger(Events.sendVoiceFailed);
                                break;
                            }
                            if (OnlinePriv.this._cxt.isNeedResult()) {
                                OnlinePriv.this._cxt.trigger(Events.getResult);
                                break;
                            }
                            OnlinePriv.this._adrH.sendEmptyMessageDelayed(6, 350L);
                            break;
                        }
                        case 4: {
                            Response rsp = new Response();
                            SDKError err = OnlinePriv.this._cxt.toReadStartResponse(rsp);
                            if (err != null) {
                                OnlinePriv.this._cxt.setLastError(err);
                                OnlinePriv.this._cxt.trigger(Events.startFailed);
                                break;
                            }
                            if (rsp.FillDone) {
                                if (rsp.Code == 0) {
                                    OnlinePriv.this._cxt.setURL(rsp.getMp3URL());
                                    if (OnlinePriv.this.isAsyncRecognize) {
                                        OnlinePriv.this._cxt.setResultURL(rsp.getResultURL());
                                    }
                                    OnlinePriv.this._cxt.trigger(Events.startOK);
                                    break;
                                }
                                if (rsp.Code == 57350) {
                                    OnlinePriv.this._cxt.setLastError(new SDKError(SDKError.Category.Unknown_word, -2001, new RuntimeException("start response error, code:" + rsp.Code)));
                                } else {
                                    OnlinePriv.this._cxt.setLastError(new SDKError(SDKError.Category.Server, rsp.Code, new RuntimeException("start response error, code:" + rsp.Code)));
                                }
                                OnlinePriv.this._cxt.trigger(Events.startFailed);
                                break;
                            }
                            if (OnlinePriv.this._cxt.isStartTimeout(OnlinePriv.this._startCheckTime * 200)) {
                                OnlinePriv.this._cxt.setLastError(new SDKError(SDKError.Category.Network, -5, new RuntimeException("start timeout in " + OnlinePriv.this._startCheckTime * 200)));
                                OnlinePriv.this._cxt.trigger(Events.startFailed);
                                break;
                            }
                            ++OnlinePriv.this._startCheckTime;
                            OnlinePriv.this._adrH.sendEmptyMessageDelayed(4, 200L);
                            break;
                        }
                        default: {
                            LogBuffer.ONE.e(OnlinePriv.TAG, "unknown msg " + msg.what);
                        }
                    }
                }
                catch (Exception e) {
                    LogBuffer.ONE.e(OnlinePriv.TAG, "process message " + msg.what, e);
                }
            }
        });
        try {
            this._cxt = new Context(this._host, this._port);
            this._cxt.setIsAsyncRecog(this.isAsyncRecognize);
            this._cxt.setSocket_timeout(parent.getCfg().getSocket_timeout());
        }
        catch (Exception e) {
            SDKError err = new SDKError(SDKError.Category.Device, -1003, e);
            Arbitrator.THIS.trigger(Arbitrator.ExternalEvents.exOnlinePrivError_other, Utils.getParam(err, "error"));
            return;
        }
        this._sm = FlowBuilder.from(States.dnsing).transit(FlowBuilder.on(Events.dnsOK).to(States.connecting).transit(FlowBuilder.on(Events.connectOK).to(States.starting).transit(FlowBuilder.on(Events.startOK).to(States.sendingVoice).transit(FlowBuilder.on(Events.getResult).to(States.gettingResult).transit(FlowBuilder.on(Events.gotResult).finish(States.stopped), FlowBuilder.on(Events.getResultFailed).finish(States.stopped)), FlowBuilder.on(Events.sendVoiceFailed).finish(States.stopped)), FlowBuilder.on(Events.startFailed).finish(States.stopped)), FlowBuilder.on(Events.connectFailed).finish(States.stopped)), FlowBuilder.on(Events.dnsFailed).finish(States.stopped));
        this._sm.whenEnter(States.dnsing, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(OnlinePriv.TAG, "SM>>" + States.dnsing.toString());
                if (_this.resolvedDns() != null) {
                    _this.trigger(Events.dnsOK);
                } else {
                    OnlinePriv.this._adrH.sendEmptyMessageDelayed(2, 50L);
                }
            }
        });
        this._sm.whenEnter(States.connecting, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(OnlinePriv.TAG, "SM>>" + States.connecting.toString());
                SDKError e = _this.toConnect();
                if (e != null) {
                    _this.setLastError(e);
                    _this.trigger(Events.connectFailed);
                } else {
                    OnlinePriv.this._adrH.sendEmptyMessageDelayed(3, 100L);
                }
            }
        });
        this._sm.whenEnter(States.starting, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(OnlinePriv.TAG, "SM>>" + States.starting.toString());
                LogBuffer.ONE.d(OnlinePriv.TAG, "SM>>INFO : host-> " + OnlinePriv.this._host + ":" + OnlinePriv.this._port + " deviceID-> " + parent.getDeviceID() + " appkey-> " + parent.getCfg().getAppKey() + " secret-> " + parent.getCfg().getSecret() + " type-> " + parent.getCfg().getServiceType());
                String sessionID = UUID.randomUUID().toString();
                Arbitrator.THIS.getUploadLogBean().setSID(sessionID);
                SDKError e = _this.toStart(parent.getDeviceInfo(), parent.getDeviceID(), parent.getCfg().getUid(), sessionID, TextUtils.isEmpty((CharSequence)parent.getCfg().getSecret()) ? parent.getCfg().getAppKey() : parent.getCfg().getAppKey() + "@" + parent.getCfg().getSecret(), parent.getCfg().getOralText(), parent.getCfg().getServiceType(), OnlinePriv.this._host, OnlinePriv.this._port);
                if (e != null) {
                    _this.setLastError(e);
                    _this.trigger(Events.startFailed);
                } else {
                    OnlinePriv.this._adrH.sendEmptyMessageDelayed(4, 200L);
                }
            }
        });
        this._sm.whenEnter(States.sendingVoice, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(OnlinePriv.TAG, "SM>>" + States.sendingVoice.toString());
                OnlinePriv.this._adrH.sendEmptyMessageDelayed(6, 350L);
            }
        });
        this._sm.whenEnter(States.gettingResult, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(OnlinePriv.TAG, "SM>>" + States.gettingResult.toString());
                OnlinePriv.this._adrH.removeMessages(6);
                _this.toSendVoice();
                _this.stopSendVoice();
                try {
                    if (!_this.toStop()) {
                        OnlinePriv.this._adrH.sendEmptyMessageDelayed(7, 200L);
                    }
                    OnlinePriv.this._adrH.sendEmptyMessageDelayed(5, 200L);
                }
                catch (Exception e) {
                    _this.trigger(Events.getResultFailed);
                }
            }
        });
        this._sm.whenEnter(States.stopped, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(OnlinePriv.TAG, "SM>>" + States.stopped.toString());
                OnlinePriv.this._adrHStopped = true;
                if (_this.getLastError() != null) {
                    LogBuffer.ONE.e(OnlinePriv.TAG, "error:" + _this.getLastError(), _this.getLastError().exp);
                    HashMap<String, Object> param = Utils.getParam(_this.getLastError(), "error");
                    param.put("dns", _this.resolvedDns());
                    param.put("port", parent.getCfg().getOralEvalMode() == OralEvalEnum.OnlineCH ? OnlinePriv.this.k_port_ok : port != OnlineHostAddressPool.CURRENT_PORT(parent.getCfg().getOralEvalMode() == OralEvalEnum.OnlineCH));
                    if (_this.getLastEvent().equals(Events.dnsFailed)) {
                        Arbitrator.THIS.trigger(Arbitrator.ExternalEvents.exOnlinePrivError_dns, param);
                    } else if (_this.getLastEvent().equals(Events.connectFailed)) {
                        Arbitrator.THIS.trigger(Arbitrator.ExternalEvents.exOnlinePrivError_conn, param);
                    } else {
                        Arbitrator.THIS.trigger(Arbitrator.ExternalEvents.exOnlinePrivError_other, param);
                    }
                    return;
                }
                if (_this.getResult() == null) {
                    LogBuffer.ONE.e(OnlinePriv.TAG, "nor error neither result");
                    Arbitrator.THIS.trigger(Arbitrator.ExternalEvents.exOnlinePrivError_other, Utils.getParam(new SDKError(SDKError.Category.Network, -1, new RuntimeException("unknown")), "error"));
                } else {
                    LogBuffer.ONE.i(OnlinePriv.TAG, "result:" + _this.getResult());
                    HashMap<String, Object> p = Utils.getParam(_this.getResult(), "result");
                    p.put("url", _this.getURL());
                    p.put("online_result_url", _this.getResultURL());
                    p.put("dns", _this.resolvedDns());
                    p.put("port", parent.getCfg().getOralEvalMode() == OralEvalEnum.OnlineCH ? OnlinePriv.this.k_port_ok : port != OnlineHostAddressPool.CURRENT_PORT(parent.getCfg().getOralEvalMode() == OralEvalEnum.OnlineCH));
                    Arbitrator.THIS.trigger(Arbitrator.ExternalEvents.exOnlinePrivResult, p);
                }
            }
        });
        this._sm.start(this._cxt);
    }

    static class Context
    extends StatefulContext {
        static Pattern IP4 = Pattern.compile("([0-9.]+){4}");
        SocketChannel _sc;
        final ConcurrentHashMap<String, InetSocketAddress> _addr = new ConcurrentHashMap(1);
        ByteBuffer _lastSendBB = ByteBuffer.allocate(1200);
        ByteBuffer _lastRecvBody = null;
        ByteBuffer _lastRecvHead = ByteBuffer.wrap(new byte[8]);
        boolean _lastSendBBDone = true;
        int _nextOpusIdx;
        int startTimeout = 1000;
        int stopTimeout;
        private int socket_timeout = 0;
        private boolean _needResult;
        private String _result;
        private boolean isAsyncRecog = false;
        static final String AsyncResult_Code = "AsyncResult_Code";
        SDKError lastError;
        private String _mp3URL;
        private String _resultURL;

        public boolean isAsyncRecog() {
            return this.isAsyncRecog;
        }

        public void setIsAsyncRecog(boolean isAsyncRecog) {
            this.isAsyncRecog = isAsyncRecog;
        }

        public int getSocket_timeout() {
            return this.socket_timeout;
        }

        public void setSocket_timeout(int socket_timeout) {
            this.socket_timeout = socket_timeout;
        }

        public SDKError getLastError() {
            return this.lastError;
        }

        public void setLastError(SDKError lastError) {
            this.lastError = lastError;
        }

        Context(final String host, final int port) {
            super("cOnlinePriv");
            if (IP4.matcher(host).matches()) {
                this._addr.put(host, new InetSocketAddress(host, port));
            } else {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Context.this._addr.put(host, new InetSocketAddress(host, port));
                        }
                        catch (Exception e) {
                            LogBuffer.ONE.e(OnlinePriv.TAG, "resolve dns", e);
                        }
                    }
                }).start();
            }
        }

        String resolvedDns() {
            try {
                Iterator<InetSocketAddress> iterator;
                if (this._addr.size() > 0 && (iterator = this._addr.values().iterator()).hasNext()) {
                    InetSocketAddress d = iterator.next();
                    return d.getAddress().getHostAddress();
                }
            }
            catch (Exception e) {
                return null;
            }
            return null;
        }

        public static boolean tryFullWrite(ByteChannel chan, ByteBuffer bb) throws IOException {
            int wr = chan.write(bb);
            if (wr > 0) {
                LogBuffer.ONE.i(OnlinePriv.TAG, "wrote " + wr + " bytes to network as required " + bb.limit());
            }
            return bb.limit() == bb.position();
        }

        public boolean tryFullRead(ByteChannel chan, ByteBuffer bb) throws IOException {
            int rd = chan.read(bb);
            if (rd > 0) {
                LogBuffer.ONE.i(OnlinePriv.TAG, "read " + rd + " bytes from network");
            }
            return bb.limit() == bb.position();
        }

        boolean isStartTimeout(int duration) {
            return duration > this.startTimeout;
        }

        boolean isStopTimeout(int duration) {
            return duration > this.stopTimeout;
        }

        SDKError toReadStopResponse(Response rsp) {
            try {
                if (!this.tryFullRead(this._sc, this._lastRecvHead)) {
                    return null;
                }
                rsp.setHead(this._lastRecvHead.array());
                if (this._lastRecvBody == null) {
                    this._lastRecvBody = ByteBuffer.wrap(new byte[rsp.BodyLen]);
                }
                if (!this.tryFullRead(this._sc, this._lastRecvBody)) {
                    return null;
                }
                byte[] body = this._lastRecvBody.array();
                rsp.setBody(body);
                return null;
            }
            catch (Exception ioe) {
                return new SDKError(SDKError.Category.Network, -6, ioe);
            }
        }

        SDKError toReadStartResponse(Response rsp) {
            try {
                if (!this.tryFullRead(this._sc, this._lastRecvHead)) {
                    return null;
                }
                rsp.setHead(this._lastRecvHead.array());
                if (this._lastRecvBody == null) {
                    this._lastRecvBody = ByteBuffer.wrap(new byte[rsp.BodyLen]);
                }
                if (!this.tryFullRead(this._sc, this._lastRecvBody)) {
                    return null;
                }
                byte[] body = this._lastRecvBody.array();
                rsp.setBody(body);
                this._lastRecvHead.clear();
                this._lastRecvBody = null;
                return null;
            }
            catch (Exception ioe) {
                return new SDKError(SDKError.Category.Network, -5, ioe);
            }
        }

        SDKError toSendVoice() {
            try {
                if (!this._lastSendBBDone) {
                    this._lastSendBBDone = Context.tryFullWrite(this._sc, this._lastSendBB);
                }
                while (this._lastSendBBDone && this._nextOpusIdx < Store.THIS.opus.packCount()) {
                    byte[] opus;
                    int leftSpace = 1182;
                    this._lastSendBB.clear();
                    Request.putVoiceHeadButLeaveBodyLengthUnknown(this._lastSendBB);
                    while (this._nextOpusIdx < Store.THIS.opus.packCount() && leftSpace > (opus = Store.THIS.opus.get(this._nextOpusIdx, Store.Consumer.onlinePriv)).length) {
                        this._lastSendBB.put(opus);
                        leftSpace -= opus.length;
                        ++this._nextOpusIdx;
                    }
                    Request.putVoiceTail(this._lastSendBB);
                    Request.setFinalBodyLen(this._lastSendBB);
                    this._lastSendBB.flip();
                    this._lastSendBBDone = Context.tryFullWrite(this._sc, this._lastSendBB);
                }
            }
            catch (Exception ioe) {
                return new SDKError(SDKError.Category.Network, -3, ioe);
            }
            return null;
        }

        void stopSendVoice() {
            this._lastSendBBDone = false;
            this._lastSendBB = null;
        }

        boolean toStop() throws SDKErrorException {
            if (this._lastSendBBDone) {
                return true;
            }
            try {
                int wr;
                if (this._lastSendBB == null) {
                    int code = 16;
                    if (this.isAsyncRecog) {
                        code = 224;
                    }
                    Request req = new Request(code, new HashSet<Attribute>());
                    byte[] load = req.ToBytes();
                    this._lastSendBB = ByteBuffer.wrap(load);
                }
                if ((wr = this._sc.write(this._lastSendBB)) != this._lastSendBB.limit()) {
                    LogBuffer.ONE.w(OnlinePriv.TAG, "short wrote for stop:" + wr);
                    this._lastSendBBDone = false;
                } else {
                    this._lastSendBBDone = true;
                }
            }
            catch (Exception ioe) {
                throw new SDKErrorException(new SDKError(SDKError.Category.Network, -4, ioe));
            }
            return this._lastSendBBDone;
        }

        SDKError toStart(String info, String did, String uid, String sessionid, String appkey, String text, String serviceType, String host, int port) {
            HashSet<Attribute> attrs = new HashSet<Attribute>(10);
            attrs.add(new Attribute(2, "opus"));
            attrs.add(new Attribute(19, info));
            attrs.add(new Attribute(18, did));
            if (uid != null) {
                attrs.add(new Attribute(12, uid));
            } else {
                attrs.add(new Attribute(12, did));
            }
            attrs.add(new Attribute(29, "1"));
            attrs.add(new Attribute(24, text));
            attrs.add(new Attribute(25, serviceType));
            attrs.add(new Attribute(28, sessionid));
            attrs.add(new Attribute(-38, host + ":" + String.valueOf(port)));
            for (Attribute a : attrs) {
                LogBuffer.ONE.i(OnlinePriv.TAG, String.format("%x:%s", a.Code, a.Value));
            }
            attrs.add(new Attribute(13, appkey));
            try {
                Request req = new Request(1, attrs);
                byte[] load = req.ToBytes();
                int wr = this._sc.write(ByteBuffer.wrap(load));
                if (wr != load.length) {
                    return new SDKError(SDKError.Category.Network, -2, new RuntimeException("short write for start:" + wr));
                }
            }
            catch (Exception ioe) {
                return new SDKError(SDKError.Category.Network, -2, ioe);
            }
            int newTimeout = 500 * ((text.length() + 9) / 10);
            if (newTimeout > this.startTimeout) {
                this.startTimeout = newTimeout;
            }
            this.stopTimeout = this.socket_timeout != 0 ? this.socket_timeout : 1000 * ((text.length() + 9) / 10);
            return null;
        }

        SDKError toConnect() {
            try {
                this._sc = SocketChannel.open();
                this._sc.configureBlocking(false);
                Iterator<InetSocketAddress> iterator = this._addr.values().iterator();
                if (iterator.hasNext()) {
                    SocketAddress a = iterator.next();
                    this._sc.connect(a);
                }
            }
            catch (Exception ioe) {
                return new SDKError(SDKError.Category.Network, -1, ioe);
            }
            return null;
        }

        boolean isConnected() throws IOException {
            return this._sc.finishConnect();
        }

        public void needResult(boolean b) {
            this._needResult = b;
        }

        public boolean isNeedResult() {
            return this._needResult;
        }

        public void deinit() {
            if (this._sc != null) {
                try {
                    this._sc.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this._sc = null;
            }
        }

        void setResult(String result) {
            this._result = result;
        }

        String getResult() {
            return this._result;
        }

        public void setURL(String mp3URL) {
            this._mp3URL = mp3URL;
        }

        public String getURL() {
            return this._mp3URL;
        }

        public String getResultURL() {
            return this._resultURL;
        }

        public void setResultURL(String _resultURL) {
            this._resultURL = _resultURL;
        }
    }

    public static enum ExternalEvents {
        eGetResult;

    }

    public static enum Events implements EventEnum
    {
        dnsFailed,
        dnsOK,
        connectFailed,
        connectOK,
        startOK,
        startFailed,
        sendVoiceFailed,
        getResult,
        gotResult,
        getResultFailed;

    }

    public static enum States implements StateEnum
    {
        dnsing,
        connecting,
        starting,
        sendingVoice,
        gettingResult,
        stopped;

    }
}

