/*
 * Decompiled with CFR 0.152.
 */
package com.unisound.edu.oraleval.sdk.sep15;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import cn.yunzhisheng.oralEdu;
import com.unisound.edu.oraleval.sdk.sep15.IOralEvalSDK;
import com.unisound.edu.oraleval.sdk.sep15.OralEvalSDK;
import com.unisound.edu.oraleval.sdk.sep15.handlers.VoiceSource;
import com.unisound.edu.oraleval.sdk.sep15.utils.OralEvalEnum;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class OralEvalSDKFactory {
    static final String TAG = "OralEvalSDKFactory";
    public static final String SDK_VERSION = "3.6.54";
    public static final String WORKINGDIR = Environment.getExternalStorageDirectory() + "/yunzhisheng/";
    public static final String WORKINGDIRFILE = WORKINGDIR + "vadnn.dat";
    public static final String LOGFILE = "log.dat";
    public static final String LOG_TEMP_FILE = "log_temp.dat";
    private static IOralEvalSDK mIOralEvalSDK;
    public static String OFFLINE_SDK_WORKING_DIR;

    public static void cleanupOfflineSDK(Context context) {
        oralEdu.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IOralEvalSDK.OfflineSDKError initOfflineSDK(Context context, String workingDir) {
        try {
            Object is;
            FileOutputStream fos;
            if (TextUtils.isEmpty((CharSequence)workingDir)) {
                workingDir = context.getExternalFilesDir(null).getAbsolutePath();
            }
            File workingDirFile = new File(workingDir);
            DataInputStream dis = null;
            int currentVersion = 0;
            int subFileCount = 0;
            try {
                dis = new DataInputStream(context.getAssets().open("usc/version"));
                currentVersion = dis.readInt();
                subFileCount = dis.readInt();
                dis.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"file not found", (Throwable)e);
                try {
                    dis.close();
                    return IOralEvalSDK.OfflineSDKError.WRONG_MODEL;
                }
                catch (Exception ee) {
                    // empty catch block
                }
                return IOralEvalSDK.OfflineSDKError.WRONG_MODEL;
            }
            File f = new File(workingDir + "/ver" + currentVersion);
            if (f.exists()) {
                OFFLINE_SDK_WORKING_DIR = workingDir;
                return oralEdu.getError(oralEdu.init(workingDir, (short)0));
            }
            OralEvalSDKFactory.deleteFolder(workingDirFile);
            workingDirFile.mkdirs();
            File modelZipFile = new File(workingDirFile, "model.zip");
            try {
                fos = new FileOutputStream(modelZipFile);
            }
            catch (FileNotFoundException e) {
                Log.e((String)TAG, (String)"creating model.zip", (Throwable)e);
                return IOralEvalSDK.OfflineSDKError.CANNT_WRITE_DIR;
            }
            byte[] tmp = new byte[10240];
            try {
                for (int i = 0; i < subFileCount; ++i) {
                    int len;
                    is = context.getAssets().open("usc/m" + i);
                    while ((len = ((InputStream)is).read(tmp)) != -1) {
                        try {
                            fos.write(tmp, 0, len);
                        }
                        catch (IOException e) {
                            Log.e((String)TAG, (String)"writing model.zip", (Throwable)e);
                            IOralEvalSDK.OfflineSDKError offlineSDKError = IOralEvalSDK.OfflineSDKError.CANNT_WRITE_DIR;
                            try {
                                fos.close();
                                return offlineSDKError;
                            }
                            catch (Exception ee) {
                                // empty catch block
                            }
                            return offlineSDKError;
                        }
                    }
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"reading assets", (Throwable)e);
                is = IOralEvalSDK.OfflineSDKError.WRONG_MODEL;
                return is;
            }
            finally {
                try {
                    fos.close();
                }
                catch (Exception ee) {}
            }
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(modelZipFile);
                Enumeration<? extends ZipEntry> zList = zipFile.entries();
                while (zList.hasMoreElements()) {
                    int len;
                    ZipEntry entry = zList.nextElement();
                    File saveFile = new File(workingDirFile, entry.getName());
                    if (entry.isDirectory()) {
                        if (saveFile.exists()) continue;
                        saveFile.mkdirs();
                        continue;
                    }
                    InputStream is2 = zipFile.getInputStream(entry);
                    fos = new FileOutputStream(saveFile);
                    while ((len = is2.read(tmp)) != -1) {
                        fos.write(tmp, 0, len);
                    }
                    is2.close();
                    fos.close();
                }
            }
            catch (ZipException e) {
                Log.e((String)TAG, (String)"extract model", (Throwable)e);
                IOralEvalSDK.OfflineSDKError offlineSDKError = IOralEvalSDK.OfflineSDKError.WRONG_MODEL;
                return offlineSDKError;
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"extract model", (Throwable)e);
                IOralEvalSDK.OfflineSDKError offlineSDKError = IOralEvalSDK.OfflineSDKError.CANNT_WRITE_DIR;
                return offlineSDKError;
            }
            finally {
                try {
                    zipFile.close();
                }
                catch (Exception ee) {}
            }
            f = new File(workingDir + "/ver" + currentVersion);
            f.createNewFile();
            OFFLINE_SDK_WORKING_DIR = workingDir;
            return oralEdu.getError(oralEdu.init(workingDir, (short)0));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"preparing offline sdk", (Throwable)e);
            return IOralEvalSDK.OfflineSDKError.UNKNOWN;
        }
    }

    private static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    OralEvalSDKFactory.deleteFolder(f);
                    continue;
                }
                f.delete();
            }
        }
        folder.delete();
    }

    public static void initVadnn(Context context) {
        File file;
        File filePath = new File(WORKINGDIR);
        if (!filePath.exists()) {
            filePath.mkdirs();
        }
        if ((file = new File(WORKINGDIRFILE)).exists()) {
            if (file.length() != 0L) {
                return;
            }
            file.delete();
        }
        FileOutputStream fos = null;
        byte[] tmp = new byte[10240];
        try {
            int len;
            file.createNewFile();
            fos = new FileOutputStream(file);
            InputStream is = context.getAssets().open("vadnn.dat");
            while ((len = is.read(tmp)) != -1) {
                fos.write(tmp, 0, len);
            }
            is.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("vadnn.dat is not exist");
        }
        finally {
            try {
                fos.close();
            }
            catch (Exception ee) {}
        }
    }

    public static IOralEvalSDK start(Context context, StartConfig cfg, IOralEvalSDK.ICallback cb) {
        if (cfg.isVadEnable()) {
            OralEvalSDKFactory.initVadnn(context);
        }
        if (cfg == null) {
            throw new IllegalArgumentException("config can not be null");
        }
        if (cb == null) {
            throw new IllegalArgumentException("callback can not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("context can not be null");
        }
        if (VoiceSource.THIS != null && mIOralEvalSDK != null) {
            mIOralEvalSDK.setNewOralEvalObject(false);
            return mIOralEvalSDK;
        }
        mIOralEvalSDK = new OralEvalSDK(context, cfg, cb);
        mIOralEvalSDK.setNewOralEvalObject(true);
        return mIOralEvalSDK;
    }

    public static void initServerAndPort(String server, int port) {
        try {
            OralEvalSDK.SERVER = server;
            OralEvalSDK.PORT = port;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class StartConfig {
        private String uid;
        private boolean vadEnable;
        private int vadBeforeMs;
        private int vadAfterMs;
        private int lowEnergy;
        private float lowEnergyPenalty;
        private String oralText;
        private String serviceType;
        private int connectTimeout;
        private int socket_timeout = 0;
        private int autoStopTimeout;
        private InputStream audioStream;
        private boolean mp3Audio = false;
        private boolean reTry = false;
        private boolean _useOfflineWhenFailedToConnectToServer;
        private boolean asyncRecognize = false;
        private String secret;
        private String appKey;
        private String online_ip;
        private String host_ip;
        private OralEvalEnum oralEvalMode = OralEvalEnum.OnlineUS;
        private float _scoreAdjuest = 1.0f;
        private boolean bufferLog = false;
        private boolean volumeReport = true;

        public boolean isVadEnable() {
            return this.vadEnable;
        }

        public void setVadEnable(boolean vadEnable) {
            this.vadEnable = vadEnable;
        }

        public String getUid() {
            return this.uid;
        }

        public void setUid(String uid) {
            this.uid = uid;
        }

        public OralEvalEnum getOralEvalMode() {
            return this.oralEvalMode;
        }

        public void setOralEvalMode(OralEvalEnum oralEvalMode) {
            this.oralEvalMode = oralEvalMode;
        }

        public String getOnline_ip() {
            return this.online_ip;
        }

        public void setOnline_ip(String online_ip) {
            this.online_ip = online_ip;
        }

        public String getHost_ip() {
            return this.host_ip;
        }

        public void setHost_ip(String host_ip) {
            this.host_ip = host_ip;
        }

        public int getSocket_timeout() {
            return this.socket_timeout;
        }

        public void setSocket_timeout(int socket_timeout) {
            this.socket_timeout = socket_timeout;
        }

        public float getScoreAdjuest() {
            return this._scoreAdjuest;
        }

        public void setScoreAdjuest(float _scoreAdjuest) {
            this._scoreAdjuest = _scoreAdjuest;
        }

        public int getLowEnergy() {
            return this.lowEnergy;
        }

        public void setLowEnergy(int lowEnergy) {
            if (lowEnergy < 0) {
                lowEnergy = 0;
            }
            this.lowEnergy = lowEnergy;
        }

        public float getLowEnergyPenalty() {
            return this.lowEnergyPenalty;
        }

        public void setLowEnergyPenalty(float lowEnergyPenalty) {
            if (lowEnergyPenalty < 0.0f) {
                lowEnergyPenalty = 0.0f;
            }
            if (lowEnergyPenalty > 1.0f) {
                lowEnergyPenalty = 1.0f;
            }
            this.lowEnergyPenalty = lowEnergyPenalty;
        }

        public boolean isBufferLog() {
            return this.bufferLog;
        }

        public void setBufferLog(boolean bufferLog) {
            this.bufferLog = bufferLog;
        }

        public String getSecret() {
            return TextUtils.isEmpty((CharSequence)this.secret) ? "" : this.secret;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public String getAppKey() {
            return this.appKey;
        }

        public void setAppKey(String appKey) {
            this.appKey = appKey;
        }

        StartConfig(StartConfig clone) {
            this.uid = clone.uid;
            this.vadEnable = clone.vadEnable;
            this.vadBeforeMs = clone.vadBeforeMs;
            this.vadAfterMs = clone.vadAfterMs;
            this.oralText = clone.oralText;
            this.serviceType = clone.serviceType;
            this.connectTimeout = clone.connectTimeout;
            this.autoStopTimeout = clone.autoStopTimeout;
            this.audioStream = clone.audioStream;
            this.mp3Audio = clone.mp3Audio;
            this._useOfflineWhenFailedToConnectToServer = clone._useOfflineWhenFailedToConnectToServer;
            this._scoreAdjuest = clone._scoreAdjuest;
            this.bufferLog = clone.bufferLog;
            this.asyncRecognize = clone.asyncRecognize;
        }

        public boolean isMp3Audio() {
            return this.mp3Audio;
        }

        public void setMp3Audio(boolean mp3Audio) {
            this.mp3Audio = mp3Audio;
        }

        public boolean isReTry() {
            return this.reTry;
        }

        public void setReTry(boolean reTry) {
            this.reTry = reTry;
        }

        public boolean isAsyncRecognize() {
            return this.asyncRecognize;
        }

        public void setAsyncRecognize(boolean asyncRecognize) {
            this.asyncRecognize = asyncRecognize;
        }

        public boolean is_useOfflineWhenFailedToConnectToServer() {
            return this._useOfflineWhenFailedToConnectToServer;
        }

        public void set_useOfflineWhenFailedToConnectToServer(boolean _useOfflineWhenFailedToConnectToServer) {
            this._useOfflineWhenFailedToConnectToServer = _useOfflineWhenFailedToConnectToServer;
        }

        public StartConfig(String oralText) {
            this.serviceType = "A";
            this.connectTimeout = 1000;
            this.oralText = oralText;
            this.vadBeforeMs = 2000;
            this.vadAfterMs = 2000;
            this._useOfflineWhenFailedToConnectToServer = false;
        }

        public StartConfig(String oralText, String fileFullName) throws IOException {
            this.serviceType = "A";
            this.connectTimeout = 1000;
            this.oralText = oralText;
            this.vadBeforeMs = 2000;
            this.vadAfterMs = 2000;
            this._useOfflineWhenFailedToConnectToServer = false;
            this.audioStream = new FileInputStream(fileFullName);
        }

        public StartConfig(String oralText, String serviceType, int connectTimeout, int autoStopTimeout, InputStream audioStream, boolean mp3Audio, boolean useOfflineWhenFailedToConnectToServer) {
            this.oralText = oralText;
            this.serviceType = serviceType;
            this.connectTimeout = connectTimeout;
            this.autoStopTimeout = autoStopTimeout;
            this.audioStream = audioStream;
            this.mp3Audio = mp3Audio;
            this._useOfflineWhenFailedToConnectToServer = useOfflineWhenFailedToConnectToServer;
        }

        public int getVadBeforeMs() {
            return this.vadBeforeMs;
        }

        public void setVadBeforeMs(int vadBeforeMs) {
            this.vadBeforeMs = vadBeforeMs;
        }

        public int getVadAfterMs() {
            return this.vadAfterMs;
        }

        public void setVadAfterMs(int vadAfterMs) {
            this.vadAfterMs = vadAfterMs;
        }

        public String getOralText() {
            return this.oralText;
        }

        public String getServiceType() {
            if (this._scoreAdjuest != 1.0f) {
                if (this.serviceType == null) {
                    this.serviceType = "A";
                }
                if (this.serviceType.length() > 30) {
                    if (this.serviceType.contains("OUT_SCORE_COEFFICIENT")) {
                        Log.w((String)OralEvalSDKFactory.TAG, (String)"igonre scoreAdjuest, use OUT_SCORE_COEFFICIENT in serviceType");
                        return this.serviceType;
                    }
                    return this.serviceType + "#OUT_SCORE_COEFFICIENT=" + String.valueOf(this._scoreAdjuest);
                }
                return StartConfig.getServiceParametersByMode(this.serviceType) + "#OUT_SCORE_COEFFICIENT=" + String.valueOf(this._scoreAdjuest);
            }
            return this.serviceType;
        }

        private static String getServiceParametersByMode(String mode) {
            if (mode == null) {
                mode = "A";
            }
            if (mode.equals("enstar")) {
                return "enstar,1,IN_ACCENT#OUT_SENT_REF_TEXT#OUT_SENT_ASR_TEXT#OUT_SENT_TIMESTAMP#OUT_SENT_SCORE#OUT_WORD_TEXT#OUT_WORD_CLASS#OUT_WORD_TIMESTAMP#OUT_WORD_SCORE#OUT_WORD_VOLUME#OUT_PHONE_TEXT#OUT_PHONE_TIMESTAMP#OUT_PHONE_VOLUME#OUT_PHONE_ACCENT#OUT_SENT_FLUENCY#OUT_SENT_INTEGRITY#OUT_SENT_PRONUNCIATION#OUT_WORD_STRESS#OUT_SENT_SYNTACTICAL_TEXT#OUT_SENT_SYNTACTICAL_ALL#OUT_SENT_SYNTACTICAL_PRO#OUT_SENT_SYNTACTICAL_FLU#OUT_SENT_SYNTACTICAL_INT#OUT_SENT_KEYWORDS_TEXT#OUT_SENT_KEYWORDS_ALL#OUT_SENT_KEYWORDS_SCORE#OUT_SENT_KEYWORDS_INT#OUT_SENT_KEYWORDS_FLU";
            }
            if (mode.equals("B") || mode.equals("E")) {
                return mode + ",1,OUT_SENT_REF_TEXT#OUT_SENT_ASR_TEXT#OUT_SENT_TIMESTAMP#OUT_SENT_SCORE#OUT_WORD_TEXT#OUT_WORD_CLASS#OUT_WORD_TIMESTAMP#OUT_WORD_SCORE#OUT_WORD_VOLUME#OUT_PHONE_TEXT#OUT_PHONE_TIMESTAMP#OUT_PHONE_VOLUME#OUT_SENT_FLUENCY#OUT_SENT_INTEGRITY#OUT_SENT_PRONUNCIATION#OUT_WORD_STRESS#OUT_SENT_SYNTACTICAL_TEXT#OUT_SENT_SYNTACTICAL_ALL#OUT_SENT_SYNTACTICAL_PRO#OUT_SENT_SYNTACTICAL_FLU#OUT_SENT_SYNTACTICAL_INT#OUT_SENT_KEYWORDS_TEXT#OUT_SENT_KEYWORDS_ALL#OUT_SENT_KEYWORDS_SCORE#OUT_SENT_KEYWORDS_INT#OUT_SENT_KEYWORDS_FLU";
            }
            if (mode.equals("C")) {
                return "C,1,OUT_SENT_REF_TEXT#OUT_SENT_ASR_TEXT#OUT_SENT_TIMESTAMP#OUT_SENT_SCORE#OUT_WORD_TEXT#OUT_WORD_CLASS#OUT_WORD_TIMESTAMP#OUT_WORD_SCORE#OUT_WORD_VOLUME#OUT_SENT_FLUENCY#OUT_SENT_INTEGRITY#OUT_SENT_PRONUNCIATION#OUT_WORD_STRESS#OUT_SENT_SYNTACTICAL_TEXT#OUT_SENT_SYNTACTICAL_ALL#OUT_SENT_SYNTACTICAL_PRO#OUT_SENT_SYNTACTICAL_FLU#OUT_SENT_SYNTACTICAL_INT#OUT_SENT_KEYWORDS_TEXT#OUT_SENT_KEYWORDS_ALL#OUT_SENT_KEYWORDS_SCORE#OUT_SENT_KEYWORDS_INT#OUT_SENT_KEYWORDS_FLU#OUT_TOTAL_SCORE";
            }
            if (mode.equals("D")) {
                return "D,0,OUT_SENT_REF_TEXT#OUT_SENT_ASR_TEXT#OUT_SENT_TIMESTAMP#OUT_SENT_SCORE#OUT_WORD_TEXT#OUT_WORD_CLASS#OUT_WORD_TIMESTAMP#OUT_WORD_SCORE#OUT_WORD_VOLUME#OUT_PHONE_TEXT#OUT_PHONE_TIMESTAMP#OUT_PHONE_VOLUME#OUT_SENT_FLUENCY#OUT_SENT_INTEGRITY#OUT_SENT_PRONUNCIATION#OUT_WORD_STRESS#OUT_SENT_SYNTACTICAL_TEXT#OUT_SENT_SYNTACTICAL_ALL#OUT_SENT_SYNTACTICAL_PRO#OUT_SENT_SYNTACTICAL_FLU#OUT_SENT_SYNTACTICAL_INT#OUT_SENT_KEYWORDS_TEXT#OUT_SENT_KEYWORDS_ALL#OUT_SENT_KEYWORDS_SCORE#OUT_SENT_KEYWORDS_INT#OUT_SENT_KEYWORDS_FLU#OUT_PHONE_SCORE";
            }
            if (mode.equals("gzedunet") || mode.equals("G")) {
                return mode + ",1,OUT_SENT_REF_TEXT#OUT_SENT_ASR_TEXT#OUT_SENT_TIMESTAMP#OUT_SENT_SCORE#OUT_WORD_TEXT#OUT_WORD_CLASS#OUT_WORD_TIMESTAMP#OUT_WORD_SCORE#OUT_WORD_VOLUME#OUT_PHONE_TEXT#OUT_PHONE_TIMESTAMP#OUT_PHONE_SCORE#OUT_PHONE_VOLUME#OUT_SENT_FLUENCY#OUT_SENT_INTEGRITY#OUT_SENT_PRONUNCIATION#OUT_WORD_STRESS#OUT_SENT_SYNTACTICAL_TEXT#OUT_SENT_SYNTACTICAL_ALL#OUT_SENT_SYNTACTICAL_PRO#OUT_SENT_SYNTACTICAL_FLU#OUT_SENT_SYNTACTICAL_INT#OUT_SENT_KEYWORDS_TEXT#OUT_SENT_KEYWORDS_ALL#OUT_SENT_KEYWORDS_SCORE#OUT_SENT_KEYWORDS_INT#OUT_SENT_KEYWORDS_FLU";
            }
            if (mode.equals("gzedunet_answer") || mode.equals("H")) {
                return mode + ",2,OUT_SENT_REF_TEXT#OUT_SENT_ASR_TEXT#OUT_SENT_TIMESTAMP#OUT_SENT_SCORE#OUT_WORD_TEXT#OUT_WORD_CLASS#OUT_WORD_TIMESTAMP#OUT_WORD_SCORE#OUT_WORD_VOLUME#OUT_PHONE_TEXT#OUT_PHONE_TIMESTAMP#OUT_PHONE_SCORE#OUT_PHONE_VOLUME#OUT_SENT_FLUENCY#OUT_SENT_INTEGRITY#OUT_SENT_PRONUNCIATION#OUT_WORD_STRESS";
            }
            return "A,0,OUT_SENT_REF_TEXT#OUT_SENT_ASR_TEXT#OUT_SENT_TIMESTAMP#OUT_SENT_SCORE#OUT_WORD_TEXT#OUT_WORD_CLASS#OUT_WORD_TIMESTAMP#OUT_WORD_SCORE#OUT_WORD_VOLUME#OUT_SENT_FLUENCY#OUT_SENT_INTEGRITY#OUT_SENT_PRONUNCIATION#OUT_WORD_STRESS#OUT_SENT_SYNTACTICAL_TEXT#OUT_SENT_SYNTACTICAL_ALL#OUT_SENT_SYNTACTICAL_PRO#OUT_SENT_SYNTACTICAL_FLU#OUT_SENT_SYNTACTICAL_INT#OUT_SENT_KEYWORDS_TEXT#OUT_SENT_KEYWORDS_ALL#OUT_SENT_KEYWORDS_SCORE#OUT_SENT_KEYWORDS_INT#OUT_SENT_KEYWORDS_FLU";
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public int getAutoStopTimeout() {
            return this.autoStopTimeout;
        }

        public InputStream getAudioStream() {
            return this.audioStream;
        }

        public void setOralText(String oralText) {
            this.oralText = oralText;
        }

        public void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        public void setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public void setAutoStopTimeout(int autoStopTimeout) {
            this.autoStopTimeout = autoStopTimeout;
        }

        public void setAudioStream(InputStream audioStream) {
            this.audioStream = audioStream;
        }

        public void setVolumeReport(boolean on) {
            this.volumeReport = on;
        }

        public boolean getVolumeReport() {
            return this.volumeReport;
        }
    }
}

