/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.cybergarage.http;

import com.hpplay.component.common.utils.CLog;
import com.hpplay.cybergarage.http.HTTPRequest;
import com.hpplay.cybergarage.http.HTTPRequestListener;
import com.hpplay.cybergarage.http.HTTPServerThread;
import com.hpplay.cybergarage.util.ListenerList;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class HTTPServer
implements Runnable {
    private static final String TAG = "Cyber-HTTPServer";
    public static final String NAME = "CyberHTTP";
    public static final String VERSION = "1.0";
    public static final int DEFAULT_PORT = 80;
    private boolean isRunning;
    public static final int DEFAULT_TIMEOUT = 80000;
    private ServerSocket serverSock = null;
    private InetAddress bindAddr = null;
    private int bindPort = 0;
    protected int timeout = 80000;
    private ListenerList httpRequestListenerList = new ListenerList();
    private Thread httpServerThread = null;

    public static String getName() {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.version");
        return string + "/" + string2 + " " + NAME + "/" + VERSION;
    }

    public ServerSocket getServerSock() {
        return this.serverSock;
    }

    public String getBindAddress() {
        if (this.bindAddr == null) {
            return "";
        }
        return this.bindAddr.toString();
    }

    public int getBindPort() {
        return this.bindPort;
    }

    public synchronized int getTimeout() {
        return this.timeout;
    }

    public synchronized void setTimeout(int n2) {
        this.timeout = n2;
    }

    public boolean open(InetAddress inetAddress, int n2) {
        if (this.serverSock != null) {
            return true;
        }
        try {
            this.serverSock = new ServerSocket(this.bindPort, 0, this.bindAddr);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public boolean open(String string, int n2) {
        if (this.serverSock != null) {
            return true;
        }
        try {
            this.bindAddr = InetAddress.getByName(string);
            this.bindPort = n2;
            this.serverSock = new ServerSocket(this.bindPort, 0, this.bindAddr);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public boolean close() {
        if (this.serverSock == null) {
            return true;
        }
        try {
            this.serverSock.close();
            this.serverSock = null;
            this.bindAddr = null;
            this.bindPort = 0;
        }
        catch (Exception exception) {
            CLog.d(TAG, null, exception);
            return false;
        }
        return true;
    }

    public Socket accept() {
        if (this.serverSock == null) {
            return null;
        }
        try {
            Socket socket = this.serverSock.accept();
            socket.setSoTimeout(this.getTimeout());
            return socket;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isOpened() {
        return this.serverSock != null;
    }

    public void addRequestListener(HTTPRequestListener hTTPRequestListener) {
        this.httpRequestListenerList.add(hTTPRequestListener);
    }

    public void removeRequestListener(HTTPRequestListener hTTPRequestListener) {
        this.httpRequestListenerList.remove(hTTPRequestListener);
    }

    public void performRequestListener(HTTPRequest hTTPRequest) {
        int n2 = this.httpRequestListenerList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            HTTPRequestListener hTTPRequestListener = (HTTPRequestListener)this.httpRequestListenerList.get(i2);
            hTTPRequestListener.httpRequestRecieved(hTTPRequest);
        }
    }

    @Override
    public void run() {
        if (!this.isOpened()) {
            return;
        }
        Thread thread = Thread.currentThread();
        while (this.httpServerThread == thread) {
            Socket socket;
            this.isRunning = true;
            Thread.yield();
            try {
                CLog.d(TAG, "accept ...");
                socket = this.accept();
                if (socket == null) break;
                CLog.d(TAG, "new http connection");
            }
            catch (Exception exception) {
                CLog.d(TAG, null, exception);
                break;
            }
            HTTPServerThread hTTPServerThread = new HTTPServerThread(this, socket);
            hTTPServerThread.start();
            CLog.d(TAG, "httpServThread ...");
        }
        this.isRunning = false;
    }

    public boolean start() {
        StringBuffer stringBuffer = new StringBuffer("Cyber.HTTPServer/");
        stringBuffer.append(this.serverSock.getLocalSocketAddress());
        this.httpServerThread = new Thread((Runnable)this, stringBuffer.toString());
        this.httpServerThread.start();
        return true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean stop() {
        this.isRunning = false;
        this.httpServerThread = null;
        return true;
    }
}

