/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import com.hpplay.sdk.source.mdns.utils.Misc;
import com.hpplay.sdk.source.mdns.xbill.dns.Header;
import com.hpplay.sdk.source.mdns.xbill.dns.Message;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.Options;
import com.hpplay.sdk.source.mdns.xbill.dns.RRset;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.SingleNameBase;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MulticastDNSUtils {
    private static final Logger logger = Misc.getLogger(MulticastDNSUtils.class, Options.check("mdns_verbose"));
    public static final Record[] EMPTY_RECORDS = new Record[0];

    public static boolean answersAll(Message message, Message message2) {
        switch (message2.getHeader().getOpcode()) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                int n2 = 0;
                Record[] recordArray = MulticastDNSUtils.extractRecords(message, 0);
                Record[] recordArray2 = MulticastDNSUtils.extractRecords(message2, 0);
                boolean[] blArray = new boolean[recordArray.length];
                for (Record record : recordArray) {
                    blArray[n2] = false;
                    for (Record record2 : recordArray2) {
                        if (!record.getName().equals(record2.getName()) || record2.getType() != 255 && record.getType() != record2.getType()) continue;
                        blArray[n2] = true;
                        break;
                    }
                    ++n2;
                }
                for (boolean bl : blArray) {
                    if (bl) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean answersAny(Message message, Message message2) {
        Header header = message2.getHeader();
        if (!header.getFlag(0)) {
            return false;
        }
        switch (header.getOpcode()) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                if (message == null) {
                    return false;
                }
                Record[] recordArray = MulticastDNSUtils.extractRecords(message, 0);
                Record[] recordArray2 = MulticastDNSUtils.extractRecords(message2, 1, 3, 2);
                for (Record record : recordArray) {
                    for (Record record2 : recordArray2) {
                        if (!record.getName().equals(record2.getName()) || record.getType() != 255 && record.getType() != record2.getType()) continue;
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    public static Record clone(Record record) {
        return record.cloneRecord();
    }

    public static Record[] extractRecords(Message message, int ... nArray) {
        Record[] recordArray = EMPTY_RECORDS;
        for (int n2 : nArray) {
            Record[] recordArray2 = message.getSectionArray(n2);
            if (recordArray2 == null || recordArray2.length <= 0) continue;
            int n3 = recordArray.length + recordArray2.length;
            Record[] recordArray3 = new Record[n3];
            System.arraycopy(recordArray, 0, recordArray3, 0, recordArray.length);
            System.arraycopy(recordArray2, 0, recordArray3, recordArray.length, recordArray2.length);
            recordArray = recordArray3;
        }
        return recordArray;
    }

    public static final Record[] extractRecords(RRset rRset) {
        if (rRset == null) {
            return new Record[0];
        }
        Record[] recordArray = new Record[rRset.size()];
        if (recordArray.length > 0) {
            int n2 = 0;
            Iterator iterator = rRset.rrs(false);
            if (iterator != null) {
                while (iterator.hasNext()) {
                    recordArray[n2++] = (Record)iterator.next();
                }
            }
        }
        return recordArray;
    }

    public static final Record[] extractRecords(RRset[] rRsetArray) {
        if (rRsetArray == null || rRsetArray.length == 0) {
            return EMPTY_RECORDS;
        }
        int n2 = 0;
        for (RRset rRset : rRsetArray) {
            n2 += rRset.size();
        }
        Serializable[] serializableArray = new Record[n2];
        int n3 = 0;
        for (RRset rRset : rRsetArray) {
            Record[] recordArray;
            for (Record record : recordArray = MulticastDNSUtils.extractRecords(rRset)) {
                serializableArray[n3++] = record;
            }
        }
        return serializableArray;
    }

    public static String getHostName() {
        String string = System.getenv().get("HOSTNAME");
        if (string == null || string.trim().length() == 0) {
            string = System.getenv().get("COMPUTERNAME");
        }
        if (string == null || string.trim().length() == 0) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                string = inetAddress.getHostName();
                if (string == null || string.startsWith("unknown")) {
                    string = inetAddress.getCanonicalHostName();
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return string;
    }

    public static InetAddress[] getLocalAddresses() {
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (networkInterface.isLoopback()) continue;
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    arrayList.add(enumeration2.nextElement());
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return arrayList.toArray(new InetAddress[arrayList.size()]);
    }

    public static String getMachineName() {
        String string = null;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            block2: while (enumeration.hasMoreElements() && string == null) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (networkInterface.isLoopback()) continue;
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.getCanonicalHostName().equalsIgnoreCase(inetAddress.getHostAddress())) continue;
                    string = inetAddress.getCanonicalHostName();
                    continue block2;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return string;
    }

    public static Name getTargetFromRecord(Record record) {
        if (record instanceof SingleNameBase) {
            return ((SingleNameBase)record).getSingleName();
        }
        try {
            Object object;
            Method method = record.getClass().getMethod("getTarget", new Class[0]);
            if (method != null && (object = method.invoke((Object)record, new Object[0])) instanceof Name) {
                return (Name)object;
            }
        }
        catch (Exception exception) {
            logger.logp(Level.FINE, MulticastDNSUtils.class.getName(), "getTargetFromRecord", "No target specified in record " + record.getClass().getSimpleName() + ": " + record);
        }
        return null;
    }

    public static boolean messagesEqual(Message message, Message message2) {
        boolean bl;
        Header header;
        if (message == message2) {
            return true;
        }
        if (message == null || message2 == null) {
            return false;
        }
        Header header2 = message.getHeader();
        if (header2 == (header = message2.getHeader())) {
            bl = false;
        } else if (header2 == null || header == null) {
            bl = false;
        } else {
            boolean[] blArray;
            boolean[] blArray2 = header2.getFlags();
            if (!Arrays.equals(blArray2, blArray = header.getFlags())) {
                return false;
            }
            bl = header2.getOpcode() == header.getOpcode() && header2.getRcode() == header.getRcode();
        }
        return bl && Arrays.equals(MulticastDNSUtils.extractRecords(message2, 0, 1, 2, 3), MulticastDNSUtils.extractRecords(message, 0, 1, 2, 3));
    }

    public static Message newQueryResponse(Record[] recordArray, int n2) {
        Message message = new Message();
        Header header = message.getHeader();
        header.setRcode(0);
        header.setOpcode(0);
        header.setFlag(0);
        for (int i2 = 0; i2 < recordArray.length; ++i2) {
            message.addRecord(recordArray[i2], n2);
        }
        return message;
    }

    public static void setDClassForRecord(Record record, int n2) {
        record.dclass = n2;
    }

    public static void setTLLForRecord(Record record, long l2) {
        record.setTTL(l2);
    }

    public static Message[] splitMessage(Message message) {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        int n2 = Options.intValue("mdns_max_records_per_message");
        if (n2 > 1) {
            n2 = 10;
        }
        Message message2 = null;
        for (int n3 : new int[]{0, 1, 2, 3}) {
            Record[] recordArray = message.getSectionArray(n3);
            for (int i2 = 0; i2 < recordArray.length; ++i2) {
                if (message2 == null) {
                    message2 = new Message();
                    Header header = (Header)message.getHeader().clone();
                    header.setCount(0, 0);
                    header.setCount(1, 0);
                    header.setCount(2, 0);
                    header.setCount(3, 0);
                    message2.setHeader(header);
                    message2.addRecord(recordArray[i2], n3);
                } else {
                    message2.addRecord(recordArray[i2], n3);
                }
                if (i2 == 0 || i2 % n2 != 0) continue;
                arrayList.add(message2);
                message2 = null;
            }
        }
        return arrayList.toArray(new Message[arrayList.size()]);
    }
}

