/*
 * Decompiled with CFR 0.152.
 */
package com.unisound.edu.oraleval.sdk.sep15.threads;

import android.os.HandlerThread;
import android.os.Message;
import android.util.Log;
import cn.yunzhisheng.oralEdu;
import com.unisound.edu.oraleval.sdk.sep15.IOralEvalSDK;
import com.unisound.edu.oraleval.sdk.sep15.OralEvalSDKFactory;
import com.unisound.edu.oraleval.sdk.sep15.threads.AutoStartHandlerThread;
import com.unisound.edu.oraleval.sdk.sep15.threads.ThreadGetterHandler;
import com.unisound.edu.oraleval.sdk.sep15.utils.LogBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Offline
extends ThreadGetterHandler {
    public static final String TAG = "Offline-Thread";
    private HandlerThread _ht;
    private boolean stopped = true;
    static final int MSG_START = 1;
    static final int MSG_STOP = 2;
    static final int MSG_SEND_VOICE = 3;
    static final int MSG_QUIT = 4;
    ConcurrentHashMap<String, Object> _status = new ConcurrentHashMap(3);
    public static final String K_RESULT = "result";
    public static final String K_ERROR = "error";

    public Offline() {
        super(new AutoStartHandlerThread("offline"));
        this._ht = this.getThread();
    }

    public void start(String serviceType, String text) {
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("mode", serviceType);
        p.put("text", text);
        this.obtainMessage(1, p).sendToTarget();
    }

    public void sendVoice(List<byte[]> pcm) {
        this.obtainMessage(3, pcm).sendToTarget();
    }

    public void stop() {
        this.sendEmptyMessage(2);
    }

    public void quit() {
        this.sendEmptyMessage(4);
        try {
            this._ht.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._ht = null;
    }

    public void handleMessage(Message msg) {
        LogBuffer.ONE.i(TAG, "to handle " + msg.what);
        switch (msg.what) {
            case 1: {
                if (!this.stopped) break;
                Map p = (Map)msg.obj;
                int r = oralEdu.start((String)p.get("mode"), (String)p.get("text"), OralEvalSDKFactory.OFFLINE_SDK_WORKING_DIR);
                this.tryAddError(r);
                if (this.hasError()) break;
                this.stopped = false;
                break;
            }
            case 3: {
                List v = (List)msg.obj;
                try {
                    if (v == null) {
                        this.tryAddError(-4);
                        return;
                    }
                    for (byte[] b : v) {
                        int r = oralEdu.recognize(b, b.length);
                        Log.i((String)TAG, (String)("Store.THIS.pcm.packCount():r:" + r));
                        this.tryAddError(r);
                        if (!this.hasError()) continue;
                    }
                }
                catch (Exception e) {
                    LogBuffer.ONE.e(TAG, "MSG_SEND_VOICE:", e);
                }
                break;
            }
            case 2: {
                if (this.hasError()) break;
                int r = oralEdu.stop();
                this.tryAddError(r);
                if (this.hasError()) break;
                this._status.put(K_RESULT, oralEdu.getResult());
                break;
            }
            case 4: {
                this.safeClose();
                this._ht.quit();
                break;
            }
            default: {
                LogBuffer.ONE.w(TAG, "unhandled message:" + msg.what);
            }
        }
    }

    private boolean hasError() {
        return this._status.containsKey(K_ERROR);
    }

    private void tryAddError(int r) {
        IOralEvalSDK.OfflineSDKError err = oralEdu.getError(r);
        if (err != IOralEvalSDK.OfflineSDKError.NOERROR) {
            LogBuffer.ONE.e(TAG, "offline error :" + (Object)((Object)err));
            this._status.put(K_ERROR, (Object)err);
            this.stopped = true;
        }
    }

    private void safeClose() {
        if (!this.stopped) {
            oralEdu.stop();
        }
    }

    public Map<String, Object> getResult() {
        return this._status;
    }
}

