/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.Context;
import android.os.Handler;
import android.view.View;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.backends.android.AndroidApplicationBase;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidApplicationLogger;
import com.badlogic.gdx.backends.android.AndroidAudio;
import com.badlogic.gdx.backends.android.AndroidClipboard;
import com.badlogic.gdx.backends.android.AndroidFiles;
import com.badlogic.gdx.backends.android.AndroidGraphics;
import com.badlogic.gdx.backends.android.AndroidInputFactory;
import com.badlogic.gdx.backends.android.AndroidNet;
import com.badlogic.gdx.backends.android.SpineViewCompatBaseApplication;
import com.badlogic.gdx.backends.android.surfaceview.FillResolutionStrategy;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.lang.reflect.Method;

public class SpineViewCompatViewCompat
extends SpineViewCompatBaseApplication {
    public SpineViewCompatViewCompat(Context context) {
        super(context);
    }

    public View initializeForView(ApplicationListener listener, AndroidApplicationConfiguration config) {
        this.init(listener, config);
        return this.graphics.getView();
    }

    private void init(ApplicationListener listener, AndroidApplicationConfiguration config) {
        if (this.getVersion() < 9) {
            throw new GdxRuntimeException("LibGDX requires Android API Level 9 or later.");
        }
        this.setApplicationLogger(new AndroidApplicationLogger());
        this.graphics = new AndroidGraphics(this, config, config.resolutionStrategy == null ? new FillResolutionStrategy() : config.resolutionStrategy);
        this.input = AndroidInputFactory.newAndroidInput(this, this.mContext, this.graphics.view, config);
        this.audio = new AndroidAudio(this.mContext, config);
        this.mContext.getFilesDir();
        this.files = new AndroidFiles(this.mContext.getAssets(), this.mContext.getFilesDir().getAbsolutePath());
        this.net = new AndroidNet(this);
        this.listener = listener;
        this.handler = new Handler();
        this.useImmersiveMode = config.useImmersiveMode;
        this.hideStatusBar = config.hideStatusBar;
        this.clipboard = new AndroidClipboard(this.mContext);
        this.addLifecycleListener(new LifecycleListener(){

            public void resume() {
            }

            public void pause() {
                SpineViewCompatViewCompat.this.audio.pause();
            }

            public void dispose() {
                SpineViewCompatViewCompat.this.audio.dispose();
            }
        });
        Gdx.app = this;
        Gdx.input = this.getInput();
        Gdx.audio = this.getAudio();
        Gdx.files = this.getFiles();
        Gdx.graphics = this.getGraphics();
        Gdx.net = this.getNet();
        this.useImmersiveMode(this.useImmersiveMode);
        if (this.useImmersiveMode && this.getVersion() >= 19) {
            try {
                Class<?> vlistener = Class.forName("com.badlogic.gdx.backends.android.AndroidVisibilityListener");
                Object o = vlistener.newInstance();
                Method method = vlistener.getDeclaredMethod("createListener", AndroidApplicationBase.class);
                method.invoke(o, this);
            }
            catch (Exception e) {
                this.log("AndroidApplication", "Failed to create AndroidVisibilityListener", e);
            }
        }
    }

    public void release() {
        this.onDestroy();
    }

    @Override
    public void onPause() {
        super.onPause();
    }
}

