/*
 * Decompiled with CFR 0.152.
 */
package com.unisound.edu.oraleval.sdk.sep15.utils;

import cn.yunzhisheng.oraleval.sdk.OpusEncoder;
import com.unisound.edu.oraleval.sdk.sep15.handlers.VoiceSource;
import com.unisound.edu.oraleval.sdk.sep15.intf.ISDK;
import com.unisound.edu.oraleval.sdk.sep15.utils.LogBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;

public class Store {
    public static Store THIS;
    public PCMStore pcm;
    public OpusStore opus;
    static final String TAG = "Store";

    public Store() {
        THIS = this;
        this.pcm = new PCMStore();
        this.opus = new OpusStore();
    }

    public void clear() {
        this.opus.encoder.destory();
        this.opus.encoder = null;
        this.pcm._pcms = null;
        this.opus._opus = null;
        this.pcm = null;
        this.opus = null;
    }

    public static class OpusStore {
        public LinkedList<byte[]> _opus = new LinkedList();
        OpusEncoder encoder = new OpusEncoder();
        int totalByteCount = 0;

        public void encodeAppend(byte[] pcm, ISDK parent) {
            assert (pcm.length % 640 == 0);
            byte[] output = new byte[1024];
            byte[] input = new byte[640];
            int totalLen = 0;
            for (int i = 0; i < pcm.length; i += 640) {
                System.arraycopy(pcm, i, input, 0, 640);
                int oneOpusLen = this.encoder.encode(input, output);
                byte[] toAdd = new byte[oneOpusLen + 2];
                if (toAdd.length > 0) {
                    toAdd[0] = (byte)(oneOpusLen & 0xFF);
                }
                if (toAdd.length > 1) {
                    toAdd[1] = (byte)((oneOpusLen & 0xFF00) >> 8);
                }
                System.arraycopy(output, 0, toAdd, 2, oneOpusLen);
                totalLen += oneOpusLen + 2;
                this._opus.add(toAdd);
                parent.cb().onOpusData(parent, toAdd, 0, toAdd.length);
                this.totalByteCount += toAdd.length;
            }
            LogBuffer.ONE.i(Store.TAG, "store " + totalLen + " opus");
        }

        public int byteCount() {
            return this.totalByteCount;
        }

        public int packCount() {
            return this._opus.size();
        }

        public byte[] get(int idx, Consumer com) {
            return this._opus.get(idx);
        }

        class OpusStream
        extends InputStream {
            private Consumer _com;
            int _idx = 0;

            public OpusStream(Consumer com) {
                this._com = com;
            }

            @Override
            public int available() throws IOException {
                int ava = 0;
                for (int i = this._idx; i < OpusStore.this.packCount(); ++i) {
                    ava += OpusStore.this.get(i, this._com).length;
                }
                return ava;
            }

            @Override
            public int read() throws IOException {
                byte[] b = new byte[1];
                int ret = this.read(b);
                if (ret > 0) {
                    return b[0];
                }
                return ret;
            }

            @Override
            public int read(byte[] b, int off, int len) {
                byte[] opus;
                int totalLen = 0;
                while (this._idx < OpusStore.this.packCount() && len >= (opus = OpusStore.this.get(this._idx, this._com)).length) {
                    System.arraycopy(opus, 0, b, off, opus.length);
                    off += opus.length;
                    len -= opus.length;
                    totalLen += opus.length;
                    ++this._idx;
                }
                return totalLen;
            }

            @Override
            public void close() throws IOException {
            }
        }
    }

    public static class PCMStore {
        LinkedList<byte[]> _pcms = new LinkedList();

        public void append(byte[] pcm) {
            assert (pcm.length == VoiceSource.PCM_PACK_LEN);
            LogBuffer.ONE.i(Store.TAG, "store " + pcm.length + "pcm");
            this._pcms.add(pcm);
        }

        public int byteCount() {
            return this._pcms.size() * VoiceSource.PCM_PACK_LEN;
        }

        public int packCount() {
            return this._pcms.size();
        }

        public byte[] get(int idx, Consumer com) {
            byte[] ret = this._pcms.get(idx);
            if (com.equals((Object)Consumer.offline)) {
                this._pcms.set(idx, null);
            }
            return ret;
        }

        public void free(int idx) {
            this._pcms.set(idx, new byte[0]);
        }
    }

    public static enum Consumer {
        onlinePriv,
        onlineHttp,
        offline;

    }
}

