/*
 * Decompiled with CFR 0.152.
 */
package com.unisound.edu.oraleval.sdk.sep15.threads;

import android.os.HandlerThread;
import android.os.Message;
import com.unisound.edu.oraleval.sdk.sep15.SDKError;
import com.unisound.edu.oraleval.sdk.sep15.threads.AutoStartHandlerThread;
import com.unisound.edu.oraleval.sdk.sep15.threads.ThreadGetterHandler;
import com.unisound.edu.oraleval.sdk.sep15.utils.LogBuffer;
import com.unisound.edu.oraleval.sdk.sep15.utils.SimpleReadWriteStream;
import com.unisound.edu.oraleval.sdk.sep15.utils.http.HttpConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Http
extends ThreadGetterHandler {
    public static final String TAG = "HTTP-Thread";
    private HttpConnection _con;
    private HandlerThread _ht;
    SimpleReadWriteStream _voiceRDWR;
    ConcurrentHashMap<String, Object> _status = new ConcurrentHashMap(3);
    static final int MSG_START = 1;
    static final int MSG_STOP = 2;
    static final int MSG_SEND_VOICE = 3;
    static final int MSG_QUIT = 4;
    private final String _host;
    public static final String K_HTTP_CODE = "code";
    public static final String K_HTTP_RESULT = "result";
    public static final String K_HTTP_CONNECTED = "isconnected";
    public static final String K_HTTP_ERROR = "error";
    public static final String K_SDK_EXCEPTION = "exception";
    public static final String K_URL = "url";

    public Http(String host) {
        super(new AutoStartHandlerThread("http"));
        this._host = host;
        this._ht = this.getThread();
    }

    public void handleMessage(Message msg) {
        LogBuffer.ONE.i(TAG, "to handle " + msg.what);
        switch (msg.what) {
            case 1: {
                try {
                    this._con.connect(this._host);
                    this._status.put(K_HTTP_CONNECTED, true);
                    this._voiceRDWR = new SimpleReadWriteStream();
                    this._con.setVoice(this._voiceRDWR);
                }
                catch (Exception e) {
                    this._status.put(K_SDK_EXCEPTION, new SDKError(SDKError.Category.Network, -7, e));
                    this._status.put(K_HTTP_CONNECTED, false);
                    this.safeClose();
                }
                break;
            }
            case 2: {
                this._voiceRDWR.endWrite();
                try {
                    this._con.connect();
                }
                catch (Exception e) {
                    this._status.put(K_SDK_EXCEPTION, new SDKError(SDKError.Category.Network, -7, e));
                    return;
                }
                try {
                    this._con.send();
                    this._con.flush();
                }
                catch (Exception e) {
                    this._status.put(K_SDK_EXCEPTION, new SDKError(SDKError.Category.Network, -9, e));
                    return;
                }
                try {
                    HashMap<Integer, Object> rst = this._con.getResponse();
                    if (rst.get(HttpConnection.PLAY_URL) != null) {
                        LogBuffer.ONE.i(TAG, "url:" + rst.get(HttpConnection.PLAY_URL));
                        this._status.put(K_URL, rst.get(HttpConnection.PLAY_URL));
                    }
                    if (rst.get(HttpConnection.CODE) != null) {
                        LogBuffer.ONE.i(TAG, "http status code:" + rst.get(HttpConnection.CODE));
                        this._status.put(K_HTTP_CODE, rst.get(HttpConnection.CODE));
                    }
                    if (rst.get(HttpConnection.ERROR) != null) {
                        LogBuffer.ONE.i(TAG, "error msg:" + rst.get(HttpConnection.ERROR));
                        this._status.put(K_HTTP_ERROR, rst.get(HttpConnection.ERROR));
                    }
                    if (rst.get(HttpConnection.EVAL_RESULT) == null) break;
                    LogBuffer.ONE.i(TAG, "result:" + rst.get(HttpConnection.EVAL_RESULT));
                    this._status.put(K_HTTP_RESULT, rst.get(HttpConnection.EVAL_RESULT));
                }
                catch (Exception e) {
                    this._status.put(K_SDK_EXCEPTION, new SDKError(SDKError.Category.Network, -8, e));
                }
                break;
            }
            case 3: {
                if (this._voiceRDWR.isEndWrite()) break;
                List voices = (List)msg.obj;
                int totalLen = 0;
                for (byte[] v : voices) {
                    this._voiceRDWR.write(v, 0, v.length);
                    totalLen += v.length;
                }
                LogBuffer.ONE.i(TAG, "send " + totalLen + " bytes voices to buffer");
                break;
            }
            case 4: {
                this.safeClose();
                this._ht.quit();
                break;
            }
            default: {
                LogBuffer.ONE.w(TAG, "unhandled message:" + msg.what);
            }
        }
    }

    private void safeClose() {
        try {
            this._con.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start(HttpConnection con) {
        this._con = con;
        this.sendEmptyMessage(1);
    }

    public void stop() {
        this.sendEmptyMessage(2);
    }

    public void quit() {
        this._ht.quit();
        this.safeClose();
    }

    public boolean isConnected() {
        return Boolean.TRUE.equals(this._status.get(K_HTTP_CONNECTED));
    }

    public void sendVoice(List<byte[]> voice) {
        this.obtainMessage(3, voice).sendToTarget();
    }

    public Map<String, Object> getResult() {
        return this._status;
    }

    public void close() {
        this.sendEmptyMessage(1);
    }
}

