/*
 * Decompiled with CFR 0.152.
 */
package com.unisound.edu.oraleval.sdk.sep15.privprotocol;

import com.unisound.edu.oraleval.sdk.sep15.privprotocol.Attribute;
import com.unisound.edu.oraleval.sdk.sep15.utils.LogBuffer;
import com.unisound.edu.oraleval.sdk.sep15.utils.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;

public class Response {
    private static final String TAG = "Server Response";
    List<Attribute> _attrs;
    public String Value;
    public int Code;
    public int BodyLen;
    public boolean FillDone = false;

    public Attribute[] getAttributes() {
        return this._attrs.toArray(new Attribute[0]);
    }

    public static String getMp3URL(String s) {
        try {
            String[] ssArray = s.split(":");
            return "https://edu.hivoice.cn/WebAudio-1.0-SNAPSHOT/audio/play/" + ssArray[2] + "/" + ssArray[1] + "/" + ssArray[0];
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getResultURL(String s) {
        try {
            String[] ssArray = s.split(":");
            return "http://edu.hivoice.cn:9088/WebAudio-1.0-SNAPSHOT/result/" + ssArray[2] + "/" + ssArray[1] + "/" + ssArray[0];
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getMp3URL() {
        if (this._attrs != null) {
            for (Attribute a : this._attrs) {
                if (a.Code != 28) continue;
                if (a.Value == null) break;
                return Response.getMp3URL(a.Value);
            }
        }
        return null;
    }

    public String getResultURL() {
        if (this._attrs != null) {
            for (Attribute a : this._attrs) {
                if (a.Code != 28) continue;
                if (a.Value == null) break;
                return Response.getResultURL(a.Value);
            }
        }
        return null;
    }

    public void setHead(byte[] head) throws NetworkHajackException {
        this.Code = Utils.IntfromByte(head, 0);
        this.BodyLen = Utils.IntfromByte(head, 4);
        if (this.BodyLen == 0 || this.BodyLen >= 0xA00000) {
            long value = 0L;
            for (int i = 0; i < head.length; ++i) {
                value += ((long)head[i] & 0xFFL) << 8 * i;
            }
            throw new NetworkHajackException(value);
        }
    }

    public void setBody(byte[] buf) {
        int totalLen = this.BodyLen;
        ByteBuffer bb = ByteBuffer.wrap(buf);
        boolean read = false;
        LogBuffer.ONE.i(TAG, "to read " + totalLen + " bytes for result");
        int attrNum = Utils.ReadInt(bb);
        totalLen -= 4;
        this._attrs = new ArrayList<Attribute>(attrNum);
        for (int i = 0; i < attrNum; ++i) {
            byte code = bb.get();
            bb.get();
            bb.get();
            bb.get();
            int len = Utils.ReadInt(bb);
            totalLen -= 8;
            Attribute attr = new Attribute(len);
            attr.Code = code;
            this._attrs.add(attr);
        }
        for (Attribute a : this._attrs) {
            byte[] b = new byte[a.getBodyLength()];
            bb.get(b, 0, a.getBodyLength());
            totalLen -= a.getBodyLength();
            int i = 0;
            while (i < a.getBodyLength()) {
                int n = i++;
                b[n] = (byte)(b[n] ^ 0x40);
            }
            a.Value = new String(b);
        }
        if (totalLen > 0) {
            int strLen = 0;
            byte[] b = new byte[totalLen];
            bb.get(b, 0, totalLen);
            int i = 0;
            while (i < totalLen && b[i] != 0 && b[i] != 1) {
                int n = i++;
                b[n] = (byte)(b[n] ^ 1);
                ++strLen;
            }
            this.Value = new String(b, 0, strLen);
        }
        this.FillDone = true;
    }

    public Response() {
    }

    public Response(ReadableByteChannel s) throws IOException {
        int totalLen = 0;
        byte[] buf = new byte[8];
        ByteBuffer bb = ByteBuffer.wrap(buf);
        s.read(bb);
        buf = bb.array();
        this.Code = Utils.IntfromByte(buf, 0);
        totalLen = Utils.IntfromByte(buf, 4);
        if (totalLen == 0) {
            LogBuffer.ONE.i(TAG, "response length 0. return");
            return;
        }
        if (totalLen >= 0xA00000) {
            throw new RuntimeException("can not alloc too much bytes:" + totalLen);
        }
        buf = new byte[totalLen];
        bb = ByteBuffer.wrap(buf);
        int read = 0;
        LogBuffer.ONE.i(TAG, "to read " + totalLen + " bytes for result");
        while ((read += s.read(bb)) < totalLen) {
        }
        bb.rewind();
        int attrNum = Utils.ReadInt(bb);
        totalLen -= 4;
        this._attrs = new ArrayList<Attribute>(attrNum);
        for (int i = 0; i < attrNum; ++i) {
            byte code = bb.get();
            bb.get();
            bb.get();
            bb.get();
            int len = Utils.ReadInt(bb);
            totalLen -= 8;
            Attribute attr = new Attribute(len);
            attr.Code = code;
            this._attrs.add(attr);
        }
        for (Attribute a : this._attrs) {
            byte[] b = new byte[a.getBodyLength()];
            bb.get(b, 0, a.getBodyLength());
            totalLen -= a.getBodyLength();
            int i = 0;
            while (i < a.getBodyLength()) {
                int n = i++;
                b[n] = (byte)(b[n] ^ 0x40);
            }
            a.Value = new String(b);
        }
        if (totalLen > 0) {
            int strLen = 0;
            byte[] b = new byte[totalLen];
            bb.get(b, 0, totalLen);
            int i = 0;
            while (i < totalLen && b[i] != 0 && b[i] != 1) {
                int n = i++;
                b[n] = (byte)(b[n] ^ 1);
                ++strLen;
            }
            this.Value = new String(b, 0, strLen);
        }
    }

    public static class NetworkHajackException
    extends IOException {
        private long _head;

        public NetworkHajackException(long head) {
            this._head = head;
        }

        @Override
        public String toString() {
            return super.toString() + "-unexpected length" + this._head;
        }
    }
}

