/*
 * Decompiled with CFR 0.152.
 */
package com.unisound.edu.oraleval.sdk.sep15.handlers;

import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import au.com.ds.ef.EasyFlow;
import au.com.ds.ef.EventEnum;
import au.com.ds.ef.FlowBuilder;
import au.com.ds.ef.StateEnum;
import au.com.ds.ef.StatefulContext;
import au.com.ds.ef.call.ContextHandler;
import com.unisound.edu.oraleval.sdk.sep15.IOralEvalSDK;
import com.unisound.edu.oraleval.sdk.sep15.SDKError;
import com.unisound.edu.oraleval.sdk.sep15.handlers.Arbitrator;
import com.unisound.edu.oraleval.sdk.sep15.intf.IHandler;
import com.unisound.edu.oraleval.sdk.sep15.intf.ISDK;
import com.unisound.edu.oraleval.sdk.sep15.intf.MessageProcessor;
import com.unisound.edu.oraleval.sdk.sep15.threads.Offline;
import com.unisound.edu.oraleval.sdk.sep15.utils.LogBuffer;
import com.unisound.edu.oraleval.sdk.sep15.utils.Store;
import com.unisound.edu.oraleval.sdk.sep15.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class OfflineEval
implements IHandler<ExternalEvents> {
    static final String TAG = "OfflineEngine";
    EasyFlow<Context> _sm;
    Context _cxt;
    Handler _adrH;
    boolean _adrHStopped = false;
    static final int MSG_CHECK_RESULT = 5;
    static final int MSG_SEND_VOICE = 6;
    public static OfflineEval THIS;
    static final int RESULT_TIMEOUT_PER_10_CHARS = 1000;
    static final int CHECK_RESULT_INTERVAL = 50;

    @Override
    public void trigger(ExternalEvents event, HashMap<String, Object> params) {
        if (this._adrHStopped) {
            return;
        }
        LogBuffer.ONE.i(TAG, "to handle external event:" + (Object)((Object)event));
        if (ExternalEvents.eGetResult.equals((Object)event)) {
            this._cxt.safeTrigger(Events.getResult);
        } else {
            LogBuffer.ONE.w(TAG, "unhandled event:" + (Object)((Object)event));
        }
    }

    @Override
    public void quit() {
        this._adrHStopped = true;
        this._cxt.quit();
    }

    public OfflineEval(final ISDK parent) {
        Log.i((String)TAG, (String)("new " + this.getClass().getSimpleName() + "@ t" + Thread.currentThread().getId()));
        THIS = this;
        this._adrH = parent.newHandler(this.getClass().getSimpleName(), new MessageProcessor(){

            @Override
            public void handleMessage(Message msg) {
                if (OfflineEval.this._adrHStopped) {
                    LogBuffer.ONE.w(OfflineEval.TAG, "received message " + msg.what + " after handler stopped");
                    return;
                }
                switch (msg.what) {
                    case 6: {
                        if (OfflineEval.this._cxt.checkError()) {
                            OfflineEval.this._cxt.safeTrigger(Events.error);
                            break;
                        }
                        OfflineEval.this._cxt.sendVoice();
                        OfflineEval.this._adrH.sendEmptyMessageDelayed(6, 200L);
                        break;
                    }
                    case 5: {
                        if (OfflineEval.this._cxt.checkError()) {
                            OfflineEval.this._cxt.safeTrigger(Events.error);
                            break;
                        }
                        if (!TextUtils.isEmpty((CharSequence)OfflineEval.this._cxt.getResult())) {
                            OfflineEval.this._cxt.safeTrigger(Events.gotResult);
                            break;
                        }
                        if (OfflineEval.this._cxt._checkTimes > 0) {
                            --OfflineEval.this._cxt._checkTimes;
                            OfflineEval.this._adrH.sendEmptyMessageDelayed(5, 50L);
                            break;
                        }
                        OfflineEval.this._cxt.setLastError(IOralEvalSDK.OfflineSDKError.TIMEOUT);
                        OfflineEval.this._cxt.safeTrigger(Events.error);
                        break;
                    }
                    default: {
                        LogBuffer.ONE.e(OfflineEval.TAG, "unknown msg " + msg.what);
                    }
                }
            }
        });
        this._cxt = new Context();
        this._sm = FlowBuilder.from(States.running).transit(FlowBuilder.on(Events.error).finish(States.stopped), FlowBuilder.on(Events.getResult).to(States.waittingResult).transit(FlowBuilder.on(Events.error).finish(States.stopped), FlowBuilder.on(Events.gotResult).finish(States.stopped)));
        this._sm.whenEnter(States.running, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(OfflineEval.TAG, "SM>>" + States.running.toString());
                _this.start(parent);
                OfflineEval.this._adrH.sendEmptyMessageDelayed(6, 200L);
            }
        });
        this._sm.whenEnter(States.waittingResult, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(OfflineEval.TAG, "SM>>" + States.waittingResult.toString());
                OfflineEval.this._adrH.removeMessages(6);
                _this.sendVoice();
                _this.stop();
                OfflineEval.this._adrH.sendEmptyMessageDelayed(5, 50L);
            }
        });
        this._sm.whenEnter(States.stopped, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(OfflineEval.TAG, "SM>>" + States.stopped.toString());
                OfflineEval.this._adrHStopped = true;
                if (_this.getLastError() != null) {
                    LogBuffer.ONE.e(OfflineEval.TAG, "error:" + (Object)((Object)_this.getLastError()));
                    Arbitrator.THIS.trigger(Arbitrator.ExternalEvents.exOfflineError, Utils.getParam((Object)_this.getLastError(), "error"));
                    return;
                }
                if (_this.getResult() == null) {
                    LogBuffer.ONE.e(OfflineEval.TAG, "nor error neither result");
                    Arbitrator.THIS.trigger(Arbitrator.ExternalEvents.exOfflineError, Utils.getParam(new SDKError(SDKError.Category.Network, -1, new RuntimeException("nor error neither result")), "error"));
                }
                LogBuffer.ONE.i(OfflineEval.TAG, "result:" + _this.getResult());
                Arbitrator.THIS.trigger(Arbitrator.ExternalEvents.exOfflineResult, Utils.getParam(_this.getResult(), "result"));
            }
        });
        this._sm.start(this._cxt);
    }

    static class Context
    extends StatefulContext {
        Offline _offline;
        private int _nextOpusIdx;
        int _checkTimes = 20000;
        IOralEvalSDK.OfflineSDKError lastError;
        String _result;

        Context() {
        }

        void start(ISDK parent) {
            this._offline = new Offline();
            this._offline.start(parent.getCfg().getServiceType(), parent.getCfg().getOralText());
        }

        void sendVoice() {
            try {
                if (Store.THIS.pcm.packCount() - this._nextOpusIdx < 0) {
                    this._offline.sendVoice(null);
                    LogBuffer.ONE.e(OfflineEval.TAG, "some unknown problem: opus is empty");
                    return;
                }
                ArrayList<byte[]> opus = new ArrayList<byte[]>(Store.THIS.pcm.packCount() - this._nextOpusIdx);
                while (this._nextOpusIdx < Store.THIS.pcm.packCount()) {
                    opus.add(Store.THIS.pcm.get(this._nextOpusIdx, Store.Consumer.offline));
                    ++this._nextOpusIdx;
                }
                this._offline.sendVoice(opus);
            }
            catch (Exception e) {
                this._offline.sendVoice(null);
                LogBuffer.ONE.e(OfflineEval.TAG, "some unknown problem:", e);
            }
        }

        void stop() {
            this._offline.stop();
        }

        void quit() {
            if (this._offline != null) {
                this._offline.quit();
            }
            this._offline = null;
        }

        public IOralEvalSDK.OfflineSDKError getLastError() {
            return this.lastError;
        }

        public void setLastError(IOralEvalSDK.OfflineSDKError lastError) {
            this.lastError = lastError;
        }

        boolean checkError() {
            Map<String, Object> result = this._offline.getResult();
            if (result.containsKey("error")) {
                IOralEvalSDK.OfflineSDKError err = (IOralEvalSDK.OfflineSDKError)((Object)result.get("error"));
                this.setLastError(err);
                return true;
            }
            if (result.containsKey("result")) {
                this.setResult((String)result.get("result"));
            }
            return false;
        }

        void setResult(String result) {
            this._result = result;
        }

        String getResult() {
            return this._result;
        }
    }

    public static enum ExternalEvents {
        eGetResult;

    }

    public static enum Events implements EventEnum
    {
        error,
        getResult,
        gotResult;

    }

    public static enum States implements StateEnum
    {
        running,
        waittingResult,
        stopped;

    }
}

