/*
 * Decompiled with CFR 0.152.
 */
package com.unisound.edu.oraleval.sdk.sep15;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.unisound.edu.oraleval.sdk.sep15.IOralEvalSDK;
import com.unisound.edu.oraleval.sdk.sep15.OralEvalModel;
import com.unisound.edu.oraleval.sdk.sep15.OralEvalSDKFactory;
import com.unisound.edu.oraleval.sdk.sep15.SDKError;
import com.unisound.edu.oraleval.sdk.sep15.handlers.Arbitrator;
import com.unisound.edu.oraleval.sdk.sep15.handlers.VoiceSource;
import com.unisound.edu.oraleval.sdk.sep15.intf.ISDK;
import com.unisound.edu.oraleval.sdk.sep15.intf.MessageProcessor;
import com.unisound.edu.oraleval.sdk.sep15.utils.JsonParseUtil;
import com.unisound.edu.oraleval.sdk.sep15.utils.LogBuffer;
import com.unisound.edu.oraleval.sdk.sep15.utils.OralEvalEnum;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

class OralEvalSDK
implements IOralEvalSDK,
ISDK {
    private Context _cxt;
    private OralEvalSDKFactory.StartConfig _startCfg;
    private IOralEvalSDK.ICallback _cb;
    HandlerThread _ht;
    Handler _handler;
    public static String SERVER = null;
    public static int PORT = 0;
    static String DID;
    static String INFO;
    private boolean isNewOralEvalObject = true;

    OralEvalSDK(Context cxt, OralEvalSDKFactory.StartConfig cfg, final IOralEvalSDK.ICallback cb) {
        if (TextUtils.isEmpty((CharSequence)cfg.getAppKey())) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    cb.onError(OralEvalSDK.this, new SDKError(SDKError.Category.Device, 65295, new RuntimeException("appKey can not be null")), null);
                }
            }).start();
            return;
        }
        if (VoiceSource.THIS != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    cb.onError(OralEvalSDK.this, new SDKError(SDKError.Category.Device, -1002, new Throwable()), IOralEvalSDK.OfflineSDKError.WRONG_STATE);
                }
            }).start();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)cfg.getOralText())) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    cb.onError(OralEvalSDK.this, new SDKError(SDKError.Category.Device, 65528, new Throwable()), IOralEvalSDK.OfflineSDKError.NOERROR);
                }
            }).start();
            return;
        }
        if (cfg.getOralEvalMode() != OralEvalEnum.OnlineUS) {
            OralEvalModel oralEvalModel;
            if (OralEvalSDK.isGoodJson(cfg.getOralText())) {
                oralEvalModel = JsonParseUtil.json2Object(cfg.getOralText(), OralEvalModel.class);
                if (oralEvalModel == null) {
                    oralEvalModel = new OralEvalModel();
                }
                if (TextUtils.isEmpty((CharSequence)oralEvalModel.getDisplayText())) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            cb.onError(OralEvalSDK.this, new SDKError(SDKError.Category.Device, 65528, new Throwable()), IOralEvalSDK.OfflineSDKError.NOERROR);
                        }
                    }).start();
                    return;
                }
                JSONObject oralText = null;
                try {
                    oralText = new JSONObject(cfg.getOralText());
                    oralText.put("Language", (Object)cfg.getOralEvalMode().getMode());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                if (oralText == null) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            cb.onError(OralEvalSDK.this, new SDKError(SDKError.Category.Device, 65528, new Throwable()), IOralEvalSDK.OfflineSDKError.NOERROR);
                        }
                    }).start();
                    return;
                }
                cfg.setOralText(oralText.toString());
            } else {
                oralEvalModel = new OralEvalModel();
                oralEvalModel.setDisplayText(cfg.getOralText());
                oralEvalModel.setLanguage(cfg.getOralEvalMode().getMode());
                cfg.setOralText(JsonParseUtil.object2Json(oralEvalModel));
            }
        }
        Runtime.getRuntime().gc();
        Pattern pattern = Pattern.compile("^\\{.*\\}$");
        Matcher matcher = pattern.matcher(cfg.getOralText());
        boolean b = matcher.matches();
        if (b) {
            cfg.set_useOfflineWhenFailedToConnectToServer(false);
        }
        this._cxt = cxt;
        this._startCfg = cfg;
        this._cb = cb;
        this._ht = new HandlerThread("OralEvalSDK-BGT");
        this._ht.start();
        this._handler = new Handler(this._ht.getLooper());
        LogBuffer.SETONE(cfg.isBufferLog());
        this._handler.post(new Runnable(){

            @Override
            public void run() {
                new Arbitrator(OralEvalSDK.this);
            }
        });
    }

    private static boolean isGoodJson(String json) {
        if (TextUtils.isEmpty((CharSequence)json)) {
            return false;
        }
        try {
            new JsonParser().parse(json);
            return json.startsWith("{") || json.startsWith("[");
        }
        catch (JsonParseException e) {
            return false;
        }
    }

    @Override
    public String getServer() {
        return SERVER;
    }

    @Override
    public int getPort() {
        return PORT;
    }

    @Override
    public String getDeviceInfo() {
        if (INFO == null) {
            OralEvalSDK.getDeviceInfo(this._cxt);
        }
        return INFO;
    }

    @Override
    public void quit() {
        Arbitrator.THIS = null;
        this._ht.quit();
    }

    @Override
    public String getDeviceID() {
        if (DID == null) {
            OralEvalSDK.getDeviceInfo(this._cxt);
        }
        return DID;
    }

    @Override
    public String getUploadUrl() {
        return "";
    }

    @Override
    public IOralEvalSDK.ICallback cb() {
        return this._cb;
    }

    @Override
    public void join() {
        try {
            this._ht.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public Handler newHandler(String name, final MessageProcessor h) {
        HandlerThread t = this._ht;
        Log.i((String)"SDK", (String)("new  " + name + "handler @ t" + t.getId()));
        return new Handler(t.getLooper()){

            public void handleMessage(Message msg) {
                h.handleMessage(msg);
            }
        };
    }

    @Override
    public Handler getWorkingHandler() {
        return this._handler;
    }

    @Override
    public OralEvalSDKFactory.StartConfig getCfg() {
        return this._startCfg;
    }

    @Override
    public void stop() {
        try {
            if (this._ht != null && this._ht.isAlive()) {
                this._handler.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (Arbitrator.THIS != null) {
                                Arbitrator.THIS.trigger(Arbitrator.ExternalEvents.exStop, null);
                            }
                        }
                        catch (Exception ex) {
                            LogBuffer.ONE.e("OralEvalSDK", "ERROR-----ERROR---------------", ex);
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            LogBuffer.ONE.e("OralEvalSDK", "ERROR-----ERROR---------------", ex);
        }
    }

    @Override
    public void cancel() {
        try {
            if (this._ht != null && this._ht.isAlive()) {
                this._handler.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (Arbitrator.THIS != null) {
                                Arbitrator.THIS.trigger(Arbitrator.ExternalEvents.exCancel, null);
                            }
                        }
                        catch (Exception ex) {
                            LogBuffer.ONE.e("OralEvalSDK", "ERROR-----ERROR---------------", ex);
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            LogBuffer.ONE.e("OralEvalSDK", "ERROR-----ERROR---------------", ex);
        }
    }

    @Override
    public String getLog() {
        return LogBuffer.ONE.getString();
    }

    @Override
    public Context get_cxt() {
        return this._cxt;
    }

    private static void getDeviceInfo(Context cxt) {
        WifiManager manager = (WifiManager)cxt.getSystemService("wifi");
        WifiInfo info = manager.getConnectionInfo();
        DID = "MAC-" + info.getMacAddress();
        INFO = "Android 3.6.54 " + Build.BRAND + " " + Build.MODEL + Build.VERSION.SDK + " " + cxt.getPackageName() + " ";
        try {
            PackageInfo pi = cxt.getPackageManager().getPackageInfo(cxt.getPackageName(), 0);
            INFO = INFO + " " + pi.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            LogBuffer.ONE.e("SDK", "SHOULD NOT SHOWN because we are looking for current package information", e);
        }
    }

    @Override
    public void setNewOralEvalObject(boolean newOralEvalObject) {
        this.isNewOralEvalObject = newOralEvalObject;
    }

    @Override
    public boolean isNewOralEvalObject() {
        return this.isNewOralEvalObject;
    }
}

