/*
 * Decompiled with CFR 0.152.
 */
package au.com.ds.ef;

import au.com.ds.ef.EventEnum;
import au.com.ds.ef.StateEnum;
import au.com.ds.ef.Transition;
import au.com.ds.ef.err.DefinitionError;
import com.unisound.edu.oraleval.sdk.sep15.utils.googlebase.HashMultimap;
import com.unisound.edu.oraleval.sdk.sep15.utils.googlebase.Multimap;
import com.unisound.edu.oraleval.sdk.sep15.utils.googlebase.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class TransitionCollection {
    private Multimap<StateEnum, Transition> transitionFromState = HashMultimap.create();
    private Set<StateEnum> finalStates = new HashSet<StateEnum>();

    protected TransitionCollection(Collection<Transition> transitions, boolean validate) {
        if (transitions != null) {
            for (Transition transition : transitions) {
                this.transitionFromState.put(transition.getStateFrom(), transition);
                if (!transition.isFinal()) continue;
                this.finalStates.add(transition.getStateTo());
            }
        }
        if (validate) {
            if (transitions == null || transitions.isEmpty()) {
                throw new DefinitionError("No transitions defined");
            }
            HashSet<Transition> processedTransitions = new HashSet<Transition>();
            for (Transition transition : transitions) {
                StateEnum stateFrom = transition.getStateFrom();
                if (this.finalStates.contains(stateFrom)) {
                    throw new DefinitionError("Some events defined for final State: " + stateFrom);
                }
                if (processedTransitions.contains(transition)) {
                    throw new DefinitionError("Ambiguous transitions: " + transition);
                }
                StateEnum stateTo = transition.getStateTo();
                if (!this.finalStates.contains(stateTo) && !this.transitionFromState.containsKey(stateTo)) {
                    throw new DefinitionError("No events defined for non-final State: " + stateTo);
                }
                if (stateFrom.equals(stateTo)) {
                    throw new DefinitionError("Circular transition: " + transition);
                }
                processedTransitions.add(transition);
            }
        }
    }

    public Transition getTransition(StateEnum stateFrom, EventEnum event) {
        if (!this.transitionFromState.containsKey(stateFrom)) {
            return null;
        }
        Collection<Transition> rets = this.transitionFromState.get(stateFrom);
        for (Transition t : rets) {
            if (!t.getEvent().equals(event)) continue;
            return t;
        }
        return null;
    }

    public List<Transition> getTransitions(StateEnum stateFrom) {
        return new ArrayList<Transition>(this.transitionFromState.get(stateFrom));
    }

    protected boolean isFinal(StateEnum state) {
        return this.finalStates.contains(state);
    }

    private static final class TransitionWithEvent
    implements Predicate<Transition> {
        private EventEnum event;

        private TransitionWithEvent(EventEnum event) {
            this.event = event;
        }

        @Override
        public boolean apply(Transition transition) {
            return transition.getEvent() == this.event;
        }
    }
}

