/*
 * Decompiled with CFR 0.152.
 */
package au.com.ds.ef;

import au.com.ds.ef.EventEnum;
import au.com.ds.ef.StateEnum;
import java.util.ArrayList;
import java.util.List;

public final class Transition {
    private static ThreadLocal<List<Transition>> transitions = new ThreadLocal();
    private EventEnum event;
    private StateEnum stateFrom;
    private StateEnum stateTo;
    private boolean isFinal;

    protected Transition(EventEnum event, StateEnum stateTo, boolean isFinal) {
        this.event = event;
        this.stateTo = stateTo;
        this.isFinal = isFinal;
        Transition.register(this);
    }

    private static void register(Transition transition) {
        List<Transition> list = transitions.get();
        if (list == null) {
            list = new ArrayList<Transition>();
            transitions.set(list);
        }
        list.add(transition);
    }

    protected EventEnum getEvent() {
        return this.event;
    }

    protected void setStateFrom(StateEnum stateFrom) {
        this.stateFrom = stateFrom;
    }

    protected StateEnum getStateFrom() {
        return this.stateFrom;
    }

    protected StateEnum getStateTo() {
        return this.stateTo;
    }

    protected boolean isFinal() {
        return this.isFinal;
    }

    public Transition transit(Transition ... transitions) {
        for (Transition transition : transitions) {
            transition.setStateFrom(this.stateTo);
        }
        return this;
    }

    public String toString() {
        return "Transition{event=" + this.event + ", stateFrom=" + this.stateFrom + ", stateTo=" + this.stateTo + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transition that = (Transition)o;
        if (!this.event.equals(that.event)) {
            return false;
        }
        return this.stateFrom.equals(that.stateFrom);
    }

    public int hashCode() {
        int result = this.event.hashCode();
        result = 31 * result + this.stateFrom.hashCode();
        return result;
    }

    protected static List<Transition> consumeTransitions() {
        List<Transition> ts = transitions.get();
        transitions.remove();
        return ts;
    }
}

