/*
 * Decompiled with CFR 0.152.
 */
package com.unisound.edu.oraleval.sdk.sep15.privprotocol;

import com.unisound.edu.oraleval.sdk.sep15.privprotocol.Attribute;
import com.unisound.edu.oraleval.sdk.sep15.utils.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class Request {
    public static final int VOICE_OVERHEAD = 18;
    Set<Attribute> _attrs;
    byte[] _body;
    public int Code;
    public static final int START = 1;
    public static final int RESUME = 17;
    public static final int STOP = 16;
    public static final int STOP_ASYNC = 224;
    public static final int CANCEL = 18;
    public static final int GET_RESULT = 19;

    public Request(int reqCode, Set<Attribute> attrs) {
        this(reqCode, attrs, new byte[0], 0, 0);
    }

    public Request(int reqCode, Set<Attribute> attrs, byte[] body, int offset, int len) {
        this.Code = reqCode;
        this._body = new byte[len];
        System.arraycopy(body, offset, this._body, 0, len);
        this._attrs = new HashSet<Attribute>(attrs);
    }

    public Set<Attribute> getAttributes() {
        HashSet<Attribute> dump = new HashSet<Attribute>(this._attrs.size());
        for (Attribute a : this._attrs) {
            dump.add((Attribute)a.clone());
        }
        return dump;
    }

    public void setAttrubites(Set<Attribute> attrs) {
        this._attrs.clear();
        for (Attribute a : attrs) {
            this._attrs.add((Attribute)a.clone());
        }
    }

    public static void putVoiceHeadButLeaveBodyLengthUnknown(ByteBuffer bb) {
        bb.put((byte)77);
        bb.put((byte)64);
        bb.put((byte)2);
        bb.put((byte)1);
        bb.put((byte)17);
        bb.put((byte)1);
        bb.put((byte)0);
        bb.put((byte)0);
        bb.putInt(0);
        bb.putInt(0);
    }

    public static void putVoiceBody(ByteBuffer bb, byte[] body) {
        bb.put(body);
    }

    public static void putVoiceTail(ByteBuffer bb) {
        bb.put((byte)33);
        bb.put((byte)64);
    }

    public static void setFinalBodyLen(ByteBuffer bb) {
        int pos = bb.position();
        bb.position(8);
        Utils.WriteInt(pos - 18 + 4 + 2, bb);
        bb.position(pos);
    }

    public byte[] ToBytes() {
        try {
            ByteArrayOutputStream ms = new ByteArrayOutputStream(1500);
            ms.write(77);
            ms.write(64);
            ms.write(2);
            ms.write(1);
            ms.write(this.Code);
            ms.write(1);
            ms.write(0);
            ms.write(0);
            int totalLen = this._body.length;
            ArrayList<byte[]> attrBytes = new ArrayList<byte[]>(this._attrs.size());
            byte[] codes = new byte[this._attrs.size()];
            totalLen += 4;
            int idx = 0;
            for (Attribute a : this._attrs) {
                totalLen += 8;
                byte[] body = a.getBody();
                attrBytes.add(body);
                codes[idx] = (byte)a.Code;
                totalLen += body.length;
                ++idx;
            }
            Utils.WriteInt(totalLen += 2, ms);
            Utils.WriteInt(this._attrs.size(), ms);
            for (int i = 0; i < attrBytes.size(); ++i) {
                byte[] body = (byte[])attrBytes.get(i);
                ms.write(codes[i]);
                ms.write(0);
                ms.write(0);
                ms.write(0);
                Utils.WriteInt(body.length, ms);
            }
            for (byte[] body : attrBytes) {
                ms.write(body, 0, body.length);
            }
            ms.write(this._body, 0, this._body.length);
            ms.write(33);
            ms.write(64);
            ms.flush();
            return ms.toByteArray();
        }
        catch (IOException ioe) {
            return null;
        }
    }
}

