/*
 * Decompiled with CFR 0.152.
 */
package com.unisound.edu.oraleval.sdk.sep15.handlers;

import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import au.com.ds.ef.EasyFlow;
import au.com.ds.ef.EventEnum;
import au.com.ds.ef.FlowBuilder;
import au.com.ds.ef.StateEnum;
import au.com.ds.ef.StatefulContext;
import au.com.ds.ef.call.ContextHandler;
import com.unisound.edu.oraleval.sdk.sep15.SDKError;
import com.unisound.edu.oraleval.sdk.sep15.handlers.Arbitrator;
import com.unisound.edu.oraleval.sdk.sep15.intf.IHandler;
import com.unisound.edu.oraleval.sdk.sep15.intf.ISDK;
import com.unisound.edu.oraleval.sdk.sep15.intf.MessageProcessor;
import com.unisound.edu.oraleval.sdk.sep15.privprotocol.Response;
import com.unisound.edu.oraleval.sdk.sep15.threads.Http;
import com.unisound.edu.oraleval.sdk.sep15.utils.LogBuffer;
import com.unisound.edu.oraleval.sdk.sep15.utils.OralEvalEnum;
import com.unisound.edu.oraleval.sdk.sep15.utils.SDKErrorException;
import com.unisound.edu.oraleval.sdk.sep15.utils.Store;
import com.unisound.edu.oraleval.sdk.sep15.utils.Utils;
import com.unisound.edu.oraleval.sdk.sep15.utils.http.HttpConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.regex.Pattern;

public class OnlineHTTP
implements IHandler<ExternalEvents> {
    static final String TAG = "OnlineHttp";
    public static final int CONNECT_FAIL = -7;
    public static final int READ_FAIL = -8;
    public static final int SEND_FAIL = -9;
    public static final int STOP_TIMEOUT = -10;
    private String _host;
    private int _port;
    EasyFlow<Context> _sm;
    Context _cxt;
    Handler _adrH;
    boolean _adrHStopped = false;
    static final int MSG_STOP = 1;
    static final int MSG_CHECK_CONNECT = 3;
    static final int MSG_CHECK_RESULT = 5;
    static final int MSG_SEND_VOICE = 6;
    public static OnlineHTTP THIS;
    int _connectCheckTime = 0;
    int _stopCheckTime = 0;
    static final int CONNECT_CHECK_INTERVAL = 100;
    static final int NETWORK_READ_INTERVAL = 200;
    static final int NETWORK_WRITE_INTERVAL = 350;
    static final int RESULT_CHECK_PER_10_CHARACTERS = 1000;

    @Override
    public void trigger(ExternalEvents event, HashMap<String, Object> params) {
        if (this._adrHStopped) {
            return;
        }
        LogBuffer.ONE.i(TAG, "to handle external event:" + (Object)((Object)event));
        if (ExternalEvents.eGetResult.equals((Object)event)) {
            this._cxt.needResult(true);
            this._cxt.safeTrigger(Events.getResult);
        } else {
            LogBuffer.ONE.w(TAG, "unhandled event:" + (Object)((Object)event));
        }
    }

    @Override
    public void quit() {
        this._adrHStopped = true;
        this._cxt.deinit();
    }

    public OnlineHTTP(final ISDK parent, final String host) {
        Log.i((String)TAG, (String)("new " + this.getClass().getSimpleName() + "@ t" + Thread.currentThread().getId()));
        LogBuffer.ONE.i(TAG, "host : " + host);
        Arbitrator.THIS.getUploadLogBean().setHost(host);
        THIS = this;
        this._adrH = parent.newHandler(this.getClass().getSimpleName(), new MessageProcessor(){

            @Override
            public void handleMessage(Message msg) {
                if (OnlineHTTP.this._adrHStopped) {
                    LogBuffer.ONE.w(OnlineHTTP.TAG, "received message " + msg.what + " after handler stopped");
                    return;
                }
                try {
                    switch (msg.what) {
                        case 3: {
                            boolean isConnected = false;
                            try {
                                isConnected = OnlineHTTP.this._cxt.isConnected();
                            }
                            catch (Exception ioe) {
                                OnlineHTTP.this._cxt.setLastError(new SDKError(SDKError.Category.Network, -7, ioe));
                                OnlineHTTP.this._cxt.trigger(Events.connectFailed);
                                return;
                            }
                            if (isConnected) {
                                OnlineHTTP.this._cxt.trigger(Events.connectOK);
                                break;
                            }
                            if (OnlineHTTP.this._connectCheckTime * 100 < parent.getCfg().getConnectTimeout()) {
                                ++OnlineHTTP.this._connectCheckTime;
                                OnlineHTTP.this._adrH.sendEmptyMessageDelayed(3, 100L);
                                break;
                            }
                            OnlineHTTP.this._cxt.setLastError(new SDKError(SDKError.Category.Network, -7, new RuntimeException("connect timeout " + OnlineHTTP.this._connectCheckTime * 100)));
                            OnlineHTTP.this._cxt.trigger(Events.connectFailed);
                            break;
                        }
                        case 5: {
                            if (OnlineHTTP.this._cxt.tryFetchResult()) {
                                OnlineHTTP.this._cxt.trigger(Events.gotResult);
                                break;
                            }
                            if (OnlineHTTP.this._cxt.isStopTimeout(OnlineHTTP.this._stopCheckTime * 200)) {
                                OnlineHTTP.this._cxt.setLastError(new SDKError(SDKError.Category.Network, -10, new RuntimeException("stop timeout in " + OnlineHTTP.this._stopCheckTime * 200)));
                                OnlineHTTP.this._cxt.trigger(Events.getResultFailed);
                                break;
                            }
                            ++OnlineHTTP.this._stopCheckTime;
                            OnlineHTTP.this._adrH.sendEmptyMessageDelayed(5, 200L);
                            break;
                        }
                        case 1: {
                            OnlineHTTP.this._cxt.trigger(Events.getResult);
                            break;
                        }
                        case 6: {
                            SDKError e = OnlineHTTP.this._cxt.hasError();
                            if (e != null) {
                                OnlineHTTP.this._cxt.setLastError(e);
                                OnlineHTTP.this._cxt.trigger(Events.sendVoiceFailed);
                                break;
                            }
                            SDKError err = OnlineHTTP.this._cxt.toSendVoice();
                            if (err != null) {
                                OnlineHTTP.this._cxt.setLastError(err);
                                OnlineHTTP.this._cxt.trigger(Events.sendVoiceFailed);
                                break;
                            }
                            if (OnlineHTTP.this._cxt.isNeedResult()) {
                                OnlineHTTP.this._cxt.trigger(Events.getResult);
                                break;
                            }
                            OnlineHTTP.this._adrH.sendEmptyMessageDelayed(6, 350L);
                            break;
                        }
                        default: {
                            LogBuffer.ONE.e(OnlineHTTP.TAG, "unknown msg " + msg.what);
                        }
                    }
                }
                catch (Exception e) {
                    LogBuffer.ONE.e(OnlineHTTP.TAG, "process message " + msg.what, e);
                }
            }
        });
        try {
            this._cxt = new Context();
        }
        catch (Exception e) {
            SDKError err = new SDKError(SDKError.Category.Device, -1003, e);
            Arbitrator.THIS.trigger(Arbitrator.ExternalEvents.exOnlineHttpError, Utils.getParam(err, "error"));
            return;
        }
        this._sm = FlowBuilder.from(States.connecting).transit(FlowBuilder.on(Events.connectOK).to(States.sendingVoice).transit(FlowBuilder.on(Events.getResult).to(States.gettingResult).transit(FlowBuilder.on(Events.gotResult).finish(States.stopped), FlowBuilder.on(Events.getResultFailed).finish(States.stopped)), FlowBuilder.on(Events.sendVoiceFailed).finish(States.stopped)), FlowBuilder.on(Events.connectFailed).finish(States.stopped));
        this._sm.whenEnter(States.connecting, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(OnlineHTTP.TAG, "SM>>" + States.connecting.toString());
                String sessionID = UUID.randomUUID().toString();
                Arbitrator.THIS.getUploadLogBean().setSID(sessionID);
                SDKError e = _this.toConnect(host, parent.getDeviceInfo(), parent.getDeviceID(), parent.getCfg().getUid(), sessionID, TextUtils.isEmpty((CharSequence)parent.getCfg().getSecret()) ? parent.getCfg().getAppKey() : parent.getCfg().getAppKey() + "@" + parent.getCfg().getSecret(), parent.getCfg().getOralText(), parent.getCfg().getServiceType(), parent.getCfg().getHost_ip(), parent.getCfg().getSocket_timeout(), parent.getCfg().getOralEvalMode());
                if (e != null) {
                    _this.setLastError(e);
                    _this.trigger(Events.connectFailed);
                } else {
                    OnlineHTTP.this._adrH.sendEmptyMessageDelayed(3, 100L);
                }
            }
        });
        this._sm.whenEnter(States.sendingVoice, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(OnlineHTTP.TAG, "SM>>" + States.sendingVoice.toString());
                OnlineHTTP.this._adrH.sendEmptyMessageDelayed(6, 350L);
            }
        });
        this._sm.whenEnter(States.gettingResult, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(OnlineHTTP.TAG, "SM>>" + States.gettingResult.toString());
                OnlineHTTP.this._adrH.removeMessages(6);
                _this.toSendVoice();
                _this.toStop();
                OnlineHTTP.this._adrH.sendEmptyMessageDelayed(5, 200L);
            }
        });
        this._sm.whenEnter(States.stopped, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(OnlineHTTP.TAG, "SM>>" + States.stopped.toString());
                OnlineHTTP.this._adrHStopped = true;
                if (_this.getLastError() != null) {
                    LogBuffer.ONE.e(OnlineHTTP.TAG, "error:" + _this.getLastError(), _this.getLastError().exp);
                    Arbitrator.THIS.trigger(Arbitrator.ExternalEvents.exOnlineHttpError, Utils.getParam(_this.getLastError(), "error"));
                    return;
                }
                if (_this.getResult() == null) {
                    LogBuffer.ONE.e(OnlineHTTP.TAG, "nor error neither result");
                    Arbitrator.THIS.trigger(Arbitrator.ExternalEvents.exOnlineHttpError, Utils.getParam(new SDKError(SDKError.Category.Network, -8, new RuntimeException("nor error neither result")), "error"));
                }
                LogBuffer.ONE.i(OnlineHTTP.TAG, "result:" + _this.getResult());
                HashMap<String, Object> p = Utils.getParam(_this.getResult(), "result");
                p.put("url", _this.getURL());
                Arbitrator.THIS.trigger(Arbitrator.ExternalEvents.exOnlineHttpResult, p);
            }
        });
        this._sm.start(this._cxt);
    }

    static class Context
    extends StatefulContext {
        static Pattern IP4 = Pattern.compile("([0-9.]+){4}");
        int _nextOpusIdx;
        int stopTimeout;
        private boolean _needResult;
        private String _result;
        Http _http;
        SDKError lastError;
        private String _mp3URL;

        public SDKError getLastError() {
            return this.lastError;
        }

        public void setLastError(SDKError lastError) {
            this.lastError = lastError;
        }

        Context() {
            super("cOnlineHttp");
        }

        boolean isStopTimeout(int duration) {
            return duration > this.stopTimeout;
        }

        SDKError toSendVoice() {
            try {
                ArrayList<byte[]> opus = new ArrayList<byte[]>(Store.THIS.opus.packCount() - this._nextOpusIdx);
                while (this._nextOpusIdx < Store.THIS.opus.packCount()) {
                    opus.add(Store.THIS.opus.get(this._nextOpusIdx, Store.Consumer.onlineHttp));
                    ++this._nextOpusIdx;
                }
                this._http.sendVoice(opus);
            }
            catch (Exception ioe) {
                return new SDKError(SDKError.Category.Network, -9, ioe);
            }
            return null;
        }

        void toStop() throws SDKErrorException {
            this._http.stop();
        }

        SDKError toConnect(String host, String info, String did, String uid, String sessionid, String appkey, String text, String serviceType, String local_host, int socket_timeout, OralEvalEnum oralEvalMode) {
            this.stopTimeout = 1000 * ((text.length() + 9) / 10);
            if (this.stopTimeout < 2000) {
                this.stopTimeout = 2000;
            }
            int readTimeout = this.stopTimeout + 1000;
            if (socket_timeout != 0) {
                readTimeout = socket_timeout;
            }
            LogBuffer.ONE.d(OnlineHTTP.TAG, "SM>>INFO : host-> " + host);
            try {
                HttpConnection con = HttpConnection.newInstance(readTimeout, readTimeout, TextUtils.isEmpty((CharSequence)uid) ? did : uid, appkey, text, serviceType, sessionid, local_host, oralEvalMode);
                this._http = new Http(host);
                this._http.start(con);
            }
            catch (Exception e) {
                return new SDKError(SDKError.Category.Network, -7, e);
            }
            return null;
        }

        boolean isConnected() throws IOException {
            return this._http.isConnected();
        }

        public void needResult(boolean b) {
            this._needResult = b;
        }

        public boolean isNeedResult() {
            return this._needResult;
        }

        public void deinit() {
            if (this._http != null) {
                this._http.quit();
                this._http = null;
            }
        }

        public boolean tryFetchResult() {
            int httpCode;
            SDKError sdkerror = (SDKError)this._http.getResult().get("exception");
            String httpError = (String)this._http.getResult().get("error");
            String httpResult = (String)this._http.getResult().get("result");
            String url = (String)this._http.getResult().get("url");
            Object o = this._http.getResult().get("code");
            int n = httpCode = o == null ? 0 : (Integer)o;
            if (sdkerror != null) {
                this.setLastError(sdkerror);
                return true;
            }
            if (200 != httpCode && 0 != httpCode) {
                if (httpCode == 501) {
                    this.setLastError(new SDKError(SDKError.Category.Unknown_word, -8, new RuntimeException("http code:" + httpCode + " message:" + httpError)));
                } else {
                    this.setLastError(new SDKError(SDKError.Category.Network, -8, new RuntimeException("http code:" + httpCode + " message:" + httpError)));
                }
                return true;
            }
            if (TextUtils.isEmpty((CharSequence)httpResult)) {
                return false;
            }
            this.setResult(httpResult);
            this.setURL(Response.getMp3URL(url));
            return true;
        }

        public void setURL(String mp3URL) {
            this._mp3URL = mp3URL;
        }

        public String getURL() {
            return this._mp3URL;
        }

        void setResult(String result) {
            this._result = result;
        }

        String getResult() {
            return this._result;
        }

        public SDKError hasError() {
            return (SDKError)this._http.getResult().get("exception");
        }
    }

    public static enum ExternalEvents {
        eGetResult;

    }

    public static enum Events implements EventEnum
    {
        connectFailed,
        connectOK,
        sendVoiceFailed,
        getResult,
        gotResult,
        getResultFailed;

    }

    public static enum States implements StateEnum
    {
        connecting,
        sendingVoice,
        gettingResult,
        stopped;

    }
}

