/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.utils;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.hpplay.common.asyncmanager.AsyncHttpParameter;
import com.hpplay.common.asyncmanager.AsyncHttpRequestListener;
import com.hpplay.common.asyncmanager.AsyncManager;
import com.hpplay.common.asyncmanager.AsyncUploadFileListener;
import com.hpplay.common.asyncmanager.AsyncUploadFileParameter;
import com.hpplay.common.asyncmanager.HttpMethod;
import com.hpplay.common.utils.DeviceUtil;
import com.hpplay.logwriter.g;
import com.hpplay.sdk.source.api.IUploadLogQueryListener;
import com.hpplay.sdk.source.business.cloud.CloudAPI;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.common.utils.HapplayUtils;
import com.hpplay.sdk.source.log.LogCache;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.utils.UploadLogCallback;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class LogUpload {
    private static final String TAG = "LogUpload";
    private static boolean isUploadLog = false;

    public static void uploadLogFile(Context context, String string, String string2, String string3, String string4, String string5, UploadLogCallback uploadLogCallback) {
        SourceLog.i(TAG, "uploadLogFile");
        if (!isUploadLog) {
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("a", "2004");
                hashMap.put("aid", Session.getInstance().appKey);
                hashMap.put("uid", Session.getInstance().getUID());
                hashMap.put("mac", Session.getInstance().getMac());
                hashMap.put("hid", Session.getInstance().getHID());
                hashMap.put("cid", DeviceUtil.getIMEI(context));
                hashMap.put("j", Build.MODEL);
                hashMap.put("osv", Build.VERSION.RELEASE);
                hashMap.put("appv", HapplayUtils.getAppVersion(context) + "");
                hashMap.put("sdkv", "4.07.19");
                hashMap.put("ls", System.currentTimeMillis() + "");
                hashMap.put("et", string4);
                hashMap.put("pn", string5);
                hashMap.put("version", "1.1");
                SourceLog.debug(TAG, "param:" + HapplayUtils.getJsonParams(hashMap));
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    hashMap.put("eid", string2);
                    AsyncManager.getInstance().exeRunnable(LogUpload.createUploadLogRunnable(string, string2, hashMap, uploadLogCallback), null);
                }
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    hashMap.put("euqid", string3);
                    AsyncManager.getInstance().exeRunnable(LogUpload.createUploadLogRunnable(string, string3, hashMap, uploadLogCallback), null);
                }
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
        } else if (uploadLogCallback != null) {
            uploadLogCallback.uploadStatus(6);
        }
    }

    private static Runnable createUploadLogRunnable(final String string, String string2, final Map<String, String> map, final UploadLogCallback uploadLogCallback) {
        return new Runnable(){

            @Override
            public void run() {
                isUploadLog = true;
                SourceLog.flushLogWriter();
                String string2 = LogCache.getLogOutputFilePath();
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    g.a().c(string2);
                    String[] stringArray = new String[]{string2};
                    LogUpload.upload(string, stringArray, map, uploadLogCallback);
                } else if (uploadLogCallback != null) {
                    uploadLogCallback.uploadStatus(5);
                }
                isUploadLog = false;
            }
        };
    }

    private static void upload(String string, String[] stringArray, Map<String, String> map, final UploadLogCallback uploadLogCallback) {
        AsyncUploadFileParameter asyncUploadFileParameter = new AsyncUploadFileParameter(string, stringArray, map);
        asyncUploadFileParameter.in.httpMethod = HttpMethod.POST;
        AsyncUploadFileListener asyncUploadFileListener = new AsyncUploadFileListener(){

            @Override
            public void onRequestResult(AsyncUploadFileParameter asyncUploadFileParameter) {
                block8: {
                    if (asyncUploadFileParameter.out == null) {
                        return;
                    }
                    SourceLog.i(LogUpload.TAG, "upload response :" + asyncUploadFileParameter.out.getResult());
                    if (uploadLogCallback == null) {
                        return;
                    }
                    try {
                        String string = (String)asyncUploadFileParameter.out.getResult();
                        if (!TextUtils.isEmpty((CharSequence)string)) {
                            try {
                                JSONObject jSONObject = new JSONObject(string);
                                String string2 = jSONObject.optString("code");
                                if (!TextUtils.isEmpty((CharSequence)string2)) {
                                    int n2 = Integer.parseInt(string2);
                                    uploadLogCallback.uploadStatus(n2);
                                }
                                break block8;
                            }
                            catch (Exception exception) {
                                uploadLogCallback.uploadStatus(-1);
                                SourceLog.w(LogUpload.TAG, exception);
                            }
                            break block8;
                        }
                        uploadLogCallback.uploadStatus(-1);
                    }
                    catch (Exception exception) {
                        uploadLogCallback.uploadStatus(-1);
                        SourceLog.w(LogUpload.TAG, exception);
                    }
                }
            }
        };
        AsyncManager.getInstance().exeUploadFileTask(asyncUploadFileParameter, asyncUploadFileListener);
    }

    public static void uploadLogFileQuery(Context context, final IUploadLogQueryListener iUploadLogQueryListener) {
        SourceLog.i(TAG, "uploadLogFileQuery");
        try {
            AsyncHttpParameter asyncHttpParameter = new AsyncHttpParameter(CloudAPI.sLogReportQueryUrl, "{}");
            if (asyncHttpParameter.in.requestHeaders == null) {
                asyncHttpParameter.in.requestHeaders = new HashMap<String, String>();
            }
            asyncHttpParameter.in.requestHeaders.put("appid", Session.getInstance().appKey);
            asyncHttpParameter.in.requestHeaders.put("uid", Session.getInstance().getUID());
            asyncHttpParameter.in.requestMethod = 1;
            AsyncManager.getInstance().exeHttpTask(asyncHttpParameter, new AsyncHttpRequestListener(){

                @Override
                public void onRequestResult(AsyncHttpParameter asyncHttpParameter) {
                    if (asyncHttpParameter.out.resultType == 0) {
                        String string = asyncHttpParameter.out.result;
                        if (iUploadLogQueryListener != null) {
                            iUploadLogQueryListener.onQueryResult(string);
                        }
                    } else if (iUploadLogQueryListener != null) {
                        iUploadLogQueryListener.onError();
                    }
                }
            });
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }
}

