/*
 * Decompiled with CFR 0.152.
 */
package com.unisound.edu.oraleval.sdk.sep15.handlers;

import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import au.com.ds.ef.EasyFlow;
import au.com.ds.ef.EventEnum;
import au.com.ds.ef.FlowBuilder;
import au.com.ds.ef.StateEnum;
import au.com.ds.ef.StatefulContext;
import au.com.ds.ef.call.ContextHandler;
import com.unisound.edu.oraleval.sdk.sep15.IOralEvalSDK;
import com.unisound.edu.oraleval.sdk.sep15.OralEvalSDKFactory;
import com.unisound.edu.oraleval.sdk.sep15.SDKError;
import com.unisound.edu.oraleval.sdk.sep15.bean.UploadLogBean;
import com.unisound.edu.oraleval.sdk.sep15.handlers.OfflineEval;
import com.unisound.edu.oraleval.sdk.sep15.handlers.OnlineHTTP;
import com.unisound.edu.oraleval.sdk.sep15.handlers.OnlinePriv;
import com.unisound.edu.oraleval.sdk.sep15.handlers.VoiceSource;
import com.unisound.edu.oraleval.sdk.sep15.intf.IHandler;
import com.unisound.edu.oraleval.sdk.sep15.intf.ISDK;
import com.unisound.edu.oraleval.sdk.sep15.intf.MessageProcessor;
import com.unisound.edu.oraleval.sdk.sep15.utils.JsonParseUtil;
import com.unisound.edu.oraleval.sdk.sep15.utils.LogBuffer;
import com.unisound.edu.oraleval.sdk.sep15.utils.OnlineHostAddressPool;
import com.unisound.edu.oraleval.sdk.sep15.utils.OralEvalEnum;
import com.unisound.edu.oraleval.sdk.sep15.utils.Store;
import com.unisound.edu.oraleval.sdk.sep15.utils.SubmitLogDataUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.UUID;
import net.sourceforge.lame.Lame;

public class Arbitrator
implements IHandler<ExternalEvents> {
    public static final String K_ERROR = "error";
    public static final String K_REASON = "reason";
    public static final String K_RESULT = "result";
    public static final String K_URL = "url";
    public static final String K_DNS_OK = "dns";
    public static final String K_PORT_OK = "port";
    public static final String K_AUDIO_SESS_ID = "audioSessionId";
    public static final String K_VOICE_DATA = "voiceData";
    public static final String K_RESULT_URL = "online_result_url";
    public static final String TAG = "Arbitrator";
    public static Arbitrator THIS;
    private UploadLogBean uploadLogBean;
    EasyFlow<Context> _sm;
    Context _cxt;
    Handler _adrH;
    boolean _adrHStopped = false;
    ISDK _parent;
    static final int MSG_STOP = 1;
    static final int MSG_DELAY_GET_RESULT = 2;
    static long STEP_SET_TIME;
    static String IP_PORT_STEP_HOST;
    static FirstStep FIRST_STEP;
    static int RETRYTIME;
    static final long BACKUP_RESET = 900000000000L;
    boolean _startReported = false;

    public UploadLogBean getUploadLogBean() {
        return this.uploadLogBean;
    }

    private static boolean isContentError(SDKError e) {
        if (e.category.equals((Object)SDKError.Category.Unknown_word)) {
            return true;
        }
        if (e.category.equals((Object)SDKError.Category.Server) && e.errno == 57351) {
            return true;
        }
        if (e.category.equals((Object)SDKError.Category.Server) && e.errno == 65527) {
            return true;
        }
        if (e.category.equals((Object)SDKError.Category.Server) && e.errno == 8195) {
            return true;
        }
        if (e.category.equals((Object)SDKError.Category.Server) && e.errno == 57352) {
            return true;
        }
        if (e.category.equals((Object)SDKError.Category.Server) && e.errno == 44851) {
            return true;
        }
        if (e.category.equals((Object)SDKError.Category.Server) && e.errno == 57353) {
            return true;
        }
        if (e.category.equals((Object)SDKError.Category.Server) && e.errno == 65295) {
            return true;
        }
        if (e.category.equals((Object)SDKError.Category.Server) && e.errno == 65533) {
            return true;
        }
        if (e.category.equals((Object)SDKError.Category.Server) && e.errno == 44855) {
            return true;
        }
        if (e.category.equals((Object)SDKError.Category.Server) && e.errno == 44849) {
            return true;
        }
        if (e.category.equals((Object)SDKError.Category.Server) && e.errno == 44853) {
            return true;
        }
        return e.category.equals((Object)SDKError.Category.Server) && e.errno == 65534;
    }

    @Override
    public void trigger(ExternalEvents event, HashMap<String, Object> params) {
        if (this._adrHStopped) {
            LogBuffer.ONE.i(TAG, "ignore external event:" + (Object)((Object)event));
            return;
        }
        LogBuffer.ONE.i(TAG, "to handle external event:" + (Object)((Object)event) + "@" + this._cxt.getState());
        boolean handled = false;
        if (this._parent.getCfg().is_useOfflineWhenFailedToConnectToServer()) {
            if (event.equals((Object)ExternalEvents.exOnlinePrivError_other) || event.equals((Object)ExternalEvents.exOnlinePrivError_dns) || event.equals((Object)ExternalEvents.exOnlinePrivError_conn)) {
                this._cxt.setOnlineError((SDKError)params.get(K_ERROR));
                if (this._cxt.getOfflineResult() != null) {
                    this._cxt.safeTrigger(Events.gotResult);
                }
                handled = true;
            }
            if (event.equals((Object)ExternalEvents.exOfflineError)) {
                this._cxt.setOfflineError((IOralEvalSDK.OfflineSDKError)((Object)params.get(K_ERROR)));
                handled = true;
            }
            if (this._cxt.getOnlineError() != null && this._cxt.getOfflineError() != null) {
                this._cxt.safeTrigger(Events.offlineAndOnlineAllError);
                return;
            }
            if (event.equals((Object)ExternalEvents.exOnlinePrivResult)) {
                this._cxt.setOnlineResult((String)params.get(K_RESULT));
                this._cxt.setOnlineUrl((String)params.get(K_URL));
                this._cxt.safeTrigger(Events.gotResult);
                return;
            }
            if (event.equals((Object)ExternalEvents.exOfflineResult)) {
                handled = true;
                this._cxt.setOfflineResult((String)params.get(K_RESULT));
                if (this._cxt.getOnlineError() != null) {
                    this._cxt.safeTrigger(Events.gotResult);
                }
            }
        }
        if ((event.equals((Object)ExternalEvents.exOnlinePrivError_dns) || event.equals((Object)ExternalEvents.exOnlinePrivError_conn) || event.equals((Object)ExternalEvents.exOnlinePrivError_other)) && !Boolean.TRUE.equals(params.get(K_PORT_OK))) {
            this._cxt.setOnlineError((SDKError)params.get(K_ERROR));
            if (Arbitrator.isContentError(this._cxt.getOnlineError())) {
                this._cxt.safeTrigger(Events.contentError);
            } else {
                this._cxt.safeTrigger(Events.privErr2);
            }
            handled = true;
        }
        if (handled) {
            return;
        }
        switch (event) {
            case exOnlinePrivError_dns: {
                this._cxt.setOnlineError((SDKError)params.get(K_ERROR));
                this._cxt.safeTrigger(Events.privDNSErr);
                break;
            }
            case exOnlinePrivError_conn: {
                this._cxt.setLastSocketAddr((String)params.get(K_DNS_OK));
                this._cxt.setOnlineError((SDKError)params.get(K_ERROR));
                this._cxt.safeTrigger(Events.privConnErr);
                break;
            }
            case exOnlinePrivError_other: {
                this._cxt.setOnlineError((SDKError)params.get(K_ERROR));
                if (Arbitrator.isContentError(this._cxt.getOnlineError())) {
                    this._cxt.safeTrigger(Events.contentError);
                    break;
                }
                this._cxt.safeTrigger(Events.privErr);
                break;
            }
            case exOnlineHttpError: {
                this._cxt.setOnlineError((SDKError)params.get(K_ERROR));
                this._cxt.safeTrigger(Events.httpErr);
                FIRST_STEP = FirstStep.fsPriv;
                IP_PORT_STEP_HOST = null;
                break;
            }
            case exOfflineResult: {
                this._cxt.safeTrigger(Events.gotOfflineResult);
                break;
            }
            case exOfflineError: {
                this._cxt.safeTrigger(Events.offlineErr);
                break;
            }
            case exOnlinePrivResult: {
                FirstStep firstStep = FIRST_STEP = Boolean.TRUE.equals(params.get(K_PORT_OK)) ? FirstStep.fsPriv : FirstStep.fsPriv2;
                if (FIRST_STEP.equals((Object)FirstStep.fsPriv2)) {
                    IP_PORT_STEP_HOST = (String)params.get(K_DNS_OK);
                    if (STEP_SET_TIME == 0L) {
                        STEP_SET_TIME = System.nanoTime();
                        LogBuffer.ONE.d(TAG, "switch 2 backup at " + STEP_SET_TIME);
                    }
                }
                this._cxt.setOnlineResult((String)params.get(K_RESULT));
                this._cxt.setOnlineUrl((String)params.get(K_URL));
                this._cxt.setOnlineResultURL((String)params.get(K_RESULT_URL));
                this._cxt.safeTrigger(Events.gotOnlineResult);
                break;
            }
            case exOnlineHttpResult: {
                if (!this._parent.getCfg().isReTry()) {
                    FIRST_STEP = FirstStep.fsHttp;
                    IP_PORT_STEP_HOST = null;
                    if (STEP_SET_TIME == 0L) {
                        STEP_SET_TIME = System.nanoTime();
                        LogBuffer.ONE.d(TAG, "switch 2 backup at " + STEP_SET_TIME);
                    }
                }
                this._cxt.setOnlineResult((String)params.get(K_RESULT));
                this._cxt.setOnlineUrl((String)params.get(K_URL));
                this._cxt.safeTrigger(Events.gotOnlineResult);
                break;
            }
            case exVoiceSourceEnd: {
                byte[] mp3;
                this._parent.cb().onStartOralEval();
                if (this._parent.getCfg().isMp3Audio() && !this._parent.getCfg().isReTry() && (mp3 = this._cxt.flushMp3()) != null && mp3.length > 0) {
                    this._parent.cb().onAudioData(this._parent, mp3, 0, mp3.length);
                }
                if (params != null && params.get(K_REASON) != null) {
                    this._cxt.setStopReason((IOralEvalSDK.EndReason)((Object)params.get(K_REASON)));
                }
            }
            case exStop: {
                this._cxt.needResult(true);
                this._cxt.safeTrigger(Events.stop);
                break;
            }
            case exVoiceData: {
                byte[] pcm = (byte[])params.get(K_VOICE_DATA);
                if (!this._startReported) {
                    this._parent.cb().onStart(this._parent, (Integer)params.get(K_AUDIO_SESS_ID));
                    this._startReported = true;
                }
                if (this._parent.getCfg().is_useOfflineWhenFailedToConnectToServer()) {
                    Store.THIS.pcm.append(pcm);
                }
                Store.THIS.opus.encodeAppend(pcm, this._parent);
                if (this._parent.getCfg().isMp3Audio()) {
                    byte[] mp3 = this._cxt.getMp3(pcm);
                    if (mp3 != null && mp3.length > 0) {
                        this._parent.cb().onAudioData(this._parent, mp3, 0, mp3.length);
                    }
                } else {
                    this._parent.cb().onAudioData(this._parent, pcm, 0, pcm.length);
                }
                if (!this._parent.getCfg().getVolumeReport()) break;
                this._parent.cb().onVolume(this._parent, Arbitrator.getVolume(pcm, pcm.length));
                break;
            }
            case exOpusData: {
                byte[] opus = (byte[])params.get(K_VOICE_DATA);
                Store.THIS.opus._opus.add(opus);
                break;
            }
            case exVoiceSourceError: {
                this._parent.cb().onStartOralEval();
                this._cxt.setOnlineError((SDKError)params.get(K_ERROR));
                this._cxt.safeTrigger(Events.voiceError);
                break;
            }
            case exCancel: {
                this._adrHStopped = true;
                VoiceSource.THIS.quit();
                VoiceSource.THIS = null;
                SDKError onlineError = this._cxt.getOnlineError();
                IOralEvalSDK.OfflineSDKError offlineError = this._cxt.getOfflineError();
                String onlineResult = this._cxt.getOnlineResult();
                String offlineResult = this._cxt.getOfflineResult();
                IOralEvalSDK.EndReason endReason = this._cxt.getStopReason();
                String onlineUrl = this._cxt.getOnlineUrl();
                if (OnlineHTTP.THIS != null) {
                    OnlineHTTP.THIS.quit();
                    OnlineHTTP.THIS = null;
                }
                if (OnlinePriv.THIS != null) {
                    OnlinePriv.THIS.quit();
                    OnlinePriv.THIS = null;
                }
                if (OfflineEval.THIS != null) {
                    OfflineEval.THIS.quit();
                    OfflineEval.THIS = null;
                }
                Store.THIS.clear();
                Store.THIS = null;
                final IOralEvalSDK.ICallback cb = this._parent.cb();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        cb.onCancel();
                    }
                }).start();
                break;
            }
            default: {
                LogBuffer.ONE.e(TAG, "unhandled event:" + (Object)((Object)event));
            }
        }
    }

    private static int getVolume(byte[] buffer, int len) {
        int value = 0;
        float energy = 0.0f;
        float tmp = 0.0f;
        for (int i = 0; i < len && i + 1 < len; i += 2) {
            int v1 = buffer[i] & 0xFF;
            int v2 = buffer[i + 1] & 0xFF;
            short bufShort = (short)(v1 + (v2 << 8));
            tmp += (float)bufShort;
            energy += (float)(bufShort * bufShort);
        }
        value = (int)(Math.pow(energy = energy / (float)len - tmp / (float)len * (tmp / (float)len), 0.2f) * 2.0);
        if (value < 0) {
            value = 0;
        }
        if (value > 100) {
            value = 100;
        }
        return value;
    }

    @Override
    public void quit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadLog() {
        block24: {
            this.uploadLogBean = new UploadLogBean();
            if (TextUtils.isEmpty((CharSequence)this._parent.getUploadUrl())) {
                return;
            }
            this.uploadLogBean.setTS(System.currentTimeMillis());
            this.uploadLogBean.setDID(this._parent.getDeviceID() + " " + this._parent.getDeviceInfo());
            this.uploadLogBean.setKey(this._parent.getCfg().getAppKey());
            this.uploadLogBean.setVer("3.6.54");
            File filePath = new File(OralEvalSDKFactory.WORKINGDIR);
            try {
                File file;
                if (!filePath.exists() || !(file = new File(OralEvalSDKFactory.WORKINGDIR + "log.dat")).exists()) break block24;
                Log.d((String)TAG, (String)("file length = " + file.length()));
                if (file.length() < 10000L) break block24;
                File fileTemp = new File(OralEvalSDKFactory.WORKINGDIR + "log_temp.dat");
                if (!fileTemp.exists()) {
                    try {
                        fileTemp.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (fileTemp.length() > 100000L) {
                    fileTemp.delete();
                    try {
                        fileTemp.createNewFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                BufferedReader bufferedReader = null;
                OutputStreamWriter writer = null;
                try {
                    String fileInfo;
                    bufferedReader = new BufferedReader(new FileReader(file.getAbsolutePath()));
                    writer = new FileWriter(fileTemp.getAbsolutePath(), true);
                    while ((fileInfo = bufferedReader.readLine()) != null) {
                        Log.d((String)TAG, (String)("file info " + fileInfo));
                        writer.write(fileInfo + "\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Log.d((String)TAG, (String)("uploadLog Exception" + e.getMessage()));
                }
                finally {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        file.delete();
                        Log.d((String)TAG, (String)("fileTemp length = " + fileTemp.length()));
                        String appKey = "appKey";
                        if (this.uploadLogBean.getKey().length() > 6) {
                            appKey = this.uploadLogBean.getKey().substring(0, 6);
                        }
                        SubmitLogDataUtils.submit(fileTemp, this._parent.getUploadUrl() + "/a-" + this.uploadLogBean.getVer() + "/" + appKey + "/" + this._parent.getDeviceID() + "/" + UUID.randomUUID().toString());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Log.d((String)TAG, (String)("uploadLog Exception" + e.getMessage()));
                    }
                }
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)("uploadLog Exception" + e.getMessage()));
            }
        }
    }

    private void writeLog() {
        if (TextUtils.isEmpty((CharSequence)this._parent.getUploadUrl())) {
            return;
        }
        this.uploadLogBean.setCost(System.currentTimeMillis() - this.uploadLogBean.getTS());
        try {
            File file;
            File filePath = new File(OralEvalSDKFactory.WORKINGDIR);
            if (!filePath.exists()) {
                filePath.mkdirs();
            }
            if (!(file = new File(OralEvalSDKFactory.WORKINGDIR + "log.dat")).exists()) {
                file.createNewFile();
            }
            Log.d((String)TAG, (String)("uploadLogBean info : " + JsonParseUtil.object2Json(this.uploadLogBean)));
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file, true)));
            out.write(JsonParseUtil.object2Json(this.uploadLogBean) + "\r\n");
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Arbitrator(final ISDK parent) {
        Log.i((String)TAG, (String)("new " + this.getClass().getSimpleName() + "@ t" + Thread.currentThread().getId()));
        THIS = this;
        this._parent = parent;
        this.uploadLog();
        new Store();
        new VoiceSource(parent, parent.getCfg().getAudioStream(), parent.getCfg().isReTry());
        this._adrH = parent.newHandler(this.getClass().getSimpleName(), new MessageProcessor(){

            @Override
            public void handleMessage(Message msg) {
                if (Arbitrator.this._adrHStopped) {
                    LogBuffer.ONE.w(Arbitrator.TAG, "received message " + msg.what + " after handler stopped");
                    return;
                }
                try {
                    switch (msg.what) {
                        case 2: {
                            Arbitrator.this._cxt.reqResult();
                            break;
                        }
                        case 1: {
                            Arbitrator.this._cxt.trigger(Events.stop);
                            break;
                        }
                        default: {
                            LogBuffer.ONE.e(Arbitrator.TAG, "unknown msg " + msg.what);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    LogBuffer.ONE.e(Arbitrator.TAG, "process message " + msg.what, e);
                }
            }
        });
        this._cxt = new Context(parent.getCfg().isMp3Audio());
        LogBuffer.ONE.d(TAG, "current nanoTime:" + System.nanoTime());
        if (parent.getCfg().isReTry()) {
            this._sm = FlowBuilder.from(States.httpRunning).transit(FlowBuilder.on(Events.stop).to(States.waittingResult).transit(FlowBuilder.on(Events.httpErr).finish(States.stopped), FlowBuilder.on(Events.gotOnlineResult).finish(States.stopped), FlowBuilder.on(Events.voiceError).finish(States.stopped)), FlowBuilder.on(Events.httpErr).finish(States.stopped), FlowBuilder.on(Events.voiceError).finish(States.stopped));
        } else if (!TextUtils.isEmpty((CharSequence)parent.getServer()) && parent.getPort() > 0) {
            LogBuffer.ONE.d(TAG, "using user specified addr " + parent.getServer() + ":" + parent.getPort());
            this._sm = FlowBuilder.from(States.privRunning).transit(FlowBuilder.on(Events.privDNSErr).finish(States.stopped), FlowBuilder.on(Events.privConnErr).finish(States.stopped), FlowBuilder.on(Events.stop).to(States.waittingResult).transit(FlowBuilder.on(Events.privDNSErr).finish(States.stopped), FlowBuilder.on(Events.privConnErr).finish(States.stopped), FlowBuilder.on(Events.privErr).finish(States.stopped), FlowBuilder.on(Events.gotOnlineResult).finish(States.stopped)), FlowBuilder.on(Events.voiceError).finish(States.stopped), FlowBuilder.on(Events.privErr).finish(States.stopped));
        } else if (parent.getCfg().isAsyncRecognize()) {
            boolean usingOffline = parent.getCfg().is_useOfflineWhenFailedToConnectToServer();
            if (usingOffline) {
                parent.getCfg().set_useOfflineWhenFailedToConnectToServer(false);
            }
            this._sm = FlowBuilder.from(States.privRunning).transit(FlowBuilder.on(Events.privDNSErr).finish(States.stopped), FlowBuilder.on(Events.privConnErr).finish(States.stopped), FlowBuilder.on(Events.stop).to(States.waittingResult).transit(FlowBuilder.on(Events.privDNSErr).finish(States.stopped), FlowBuilder.on(Events.privConnErr).finish(States.stopped), FlowBuilder.on(Events.privErr).finish(States.stopped), FlowBuilder.on(Events.gotOnlineResult).finish(States.stopped)), FlowBuilder.on(Events.voiceError).finish(States.stopped), FlowBuilder.on(Events.privErr).finish(States.stopped));
        } else if (parent.getCfg().is_useOfflineWhenFailedToConnectToServer()) {
            this._sm = FlowBuilder.from(States.privAndOfflineRunning).transit(FlowBuilder.on(Events.stop).to(States.waittingResult).transit(FlowBuilder.on(Events.gotResult).finish(States.stopped), FlowBuilder.on(Events.offlineAndOnlineAllError).finish(States.stopped), FlowBuilder.on(Events.voiceError).finish(States.stopped)), FlowBuilder.on(Events.gotResult).finish(States.stopped), FlowBuilder.on(Events.offlineAndOnlineAllError).finish(States.stopped), FlowBuilder.on(Events.voiceError).finish(States.stopped));
        } else if (FIRST_STEP.equals((Object)FirstStep.fsHttp) && System.nanoTime() - STEP_SET_TIME < 900000000000L) {
            LogBuffer.ONE.d(TAG, "using http backup");
            this._sm = FlowBuilder.from(States.httpRunning).transit(FlowBuilder.on(Events.stop).to(States.waittingResult).transit(FlowBuilder.on(Events.httpErr).finish(States.stopped), FlowBuilder.on(Events.gotOnlineResult).finish(States.stopped), FlowBuilder.on(Events.voiceError).finish(States.stopped)), FlowBuilder.on(Events.httpErr).finish(States.stopped), FlowBuilder.on(Events.voiceError).finish(States.stopped));
        } else if (FIRST_STEP.equals((Object)FirstStep.fsPriv2) && System.nanoTime() - STEP_SET_TIME < 900000000000L) {
            LogBuffer.ONE.d(TAG, "using ip and backup port " + IP_PORT_STEP_HOST + ":" + OnlineHostAddressPool.CURRENT_PORT(parent.getCfg().getOralEvalMode() == OralEvalEnum.OnlineCH));
            this._sm = FlowBuilder.from(States.privRunning_ip_port2).transit(FlowBuilder.on(Events.contentError).finish(States.stopped), FlowBuilder.on(Events.privErr2).to(States.httpRunning).transit(FlowBuilder.on(Events.stop).to(States.waittingResult).transit(FlowBuilder.on(Events.contentError).finish(States.stopped), FlowBuilder.on(Events.privErr2).to(States.httpRunning), FlowBuilder.on(Events.httpErr).finish(States.stopped), FlowBuilder.on(Events.gotOnlineResult).finish(States.stopped), FlowBuilder.on(Events.voiceError).finish(States.stopped)), FlowBuilder.on(Events.httpErr).finish(States.stopped), FlowBuilder.on(Events.voiceError).finish(States.stopped)), FlowBuilder.on(Events.stop).to(States.waittingResult), FlowBuilder.on(Events.voiceError).finish(States.stopped));
        } else {
            FIRST_STEP = FirstStep.fsPriv;
            STEP_SET_TIME = 0L;
            IP_PORT_STEP_HOST = null;
            LogBuffer.ONE.d(TAG, "using full backup");
            this._sm = FlowBuilder.from(States.privRunning).transit(FlowBuilder.on(Events.contentError).finish(States.stopped), FlowBuilder.on(Events.privDNSErr).to(States.privRunning_ip_port2).transit(FlowBuilder.on(Events.contentError).finish(States.stopped), FlowBuilder.on(Events.privErr2).to(States.httpRunning).transit(FlowBuilder.on(Events.stop).to(States.waittingResult), FlowBuilder.on(Events.httpErr).finish(States.stopped), FlowBuilder.on(Events.voiceError).finish(States.stopped), FlowBuilder.on(Events.gotOnlineResult).finish(States.stopped)), FlowBuilder.on(Events.stop).to(States.waittingResult), FlowBuilder.on(Events.privDNSErr).to(States.httpRunning), FlowBuilder.on(Events.privConnErr).to(States.httpRunning), FlowBuilder.on(Events.voiceError).finish(States.stopped)), FlowBuilder.on(Events.privConnErr).to(States.privRunning_ip_port2), FlowBuilder.on(Events.privErr).to(States.httpRunning), FlowBuilder.on(Events.stop).to(States.waittingResult).transit(FlowBuilder.on(Events.contentError).finish(States.stopped), FlowBuilder.on(Events.privConnErr).to(States.privRunning_ip_port2), FlowBuilder.on(Events.privDNSErr).to(States.privRunning_ip_port2), FlowBuilder.on(Events.privErr).to(States.privRunning_ip_port2), FlowBuilder.on(Events.privErr2).to(States.httpRunning), FlowBuilder.on(Events.httpErr).finish(States.stopped), FlowBuilder.on(Events.gotOnlineResult).finish(States.stopped), FlowBuilder.on(Events.voiceError).finish(States.stopped)), FlowBuilder.on(Events.voiceError).finish(States.stopped));
        }
        this._sm.whenEnter(States.privRunning, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(Arbitrator.TAG, "SM>>" + States.privRunning.toString());
                if (!TextUtils.isEmpty((CharSequence)parent.getServer()) && parent.getPort() > 0) {
                    new OnlinePriv(parent, parent.getServer(), parent.getPort(), true);
                } else {
                    new OnlinePriv(parent, OnlineHostAddressPool.CURRENT((boolean)(parent.getCfg().getOralEvalMode() == OralEvalEnum.OnlineCH ? true : false)).host, OnlineHostAddressPool.CURRENT((boolean)(parent.getCfg().getOralEvalMode() == OralEvalEnum.OnlineCH ? true : false)).port, true);
                }
            }
        });
        this._sm.whenEnter(States.privRunning_ip_port2, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(Arbitrator.TAG, "SM>>" + States.privRunning_ip_port2.toString());
                LogBuffer.ONE.w(Arbitrator.TAG, "switch to ip_port2 from private protocol, caused by:" + Arbitrator.this._cxt.getOnlineError());
                if (OnlinePriv.THIS != null) {
                    OnlinePriv.THIS.quit();
                    OnlinePriv.THIS = null;
                }
                if (IP_PORT_STEP_HOST == null) {
                    new OnlinePriv(parent, OnlineHostAddressPool.RANDOM_IP((String)_this.getLastSocketAddr(), (boolean)(parent.getCfg().getOralEvalMode() == OralEvalEnum.OnlineCH ? true : false)).host, OnlineHostAddressPool.CURRENT_PORT(parent.getCfg().getOralEvalMode() == OralEvalEnum.OnlineCH), false);
                } else {
                    new OnlinePriv(parent, IP_PORT_STEP_HOST, OnlineHostAddressPool.CURRENT_PORT(parent.getCfg().getOralEvalMode() == OralEvalEnum.OnlineCH), false);
                }
                if (_this.isNeedResult()) {
                    int delay = Store.THIS.opus.byteCount() / 6;
                    LogBuffer.ONE.e(Arbitrator.TAG, "delay checking result " + delay);
                    Arbitrator.this._adrH.sendEmptyMessageDelayed(1, (long)delay);
                }
            }
        });
        this._sm.whenEnter(States.httpRunning, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(Arbitrator.TAG, "SM>>" + States.httpRunning.toString());
                LogBuffer.ONE.w(Arbitrator.TAG, "switch to http from private protocol, caused by:" + Arbitrator.this._cxt.getOnlineError());
                if (OnlinePriv.THIS != null) {
                    OnlinePriv.THIS.quit();
                }
                if (parent.getCfg().isReTry()) {
                    new OnlineHTTP(parent, OnlineHostAddressPool.RANDOM_HTTP_IP(++RETRYTIME % 2, parent.getCfg().getOralEvalMode() == OralEvalEnum.OnlineCH));
                } else if (parent.getCfg().getOnline_ip() != null && parent.getCfg().getOnline_ip().trim().length() > 0) {
                    new OnlineHTTP(parent, parent.getCfg().getOnline_ip());
                } else {
                    new OnlineHTTP(parent, OnlineHostAddressPool.RANDOM_HTTP_IP(parent.getCfg().getOralEvalMode() == OralEvalEnum.OnlineCH));
                }
                Arbitrator.this._adrH.removeMessages(1);
                if (_this.isNeedResult()) {
                    int delay = Store.THIS.opus.byteCount() / 6;
                    LogBuffer.ONE.e(Arbitrator.TAG, "delay checking result " + delay);
                    Arbitrator.this._adrH.sendEmptyMessageDelayed(1, (long)delay);
                }
            }
        });
        this._sm.whenEnter(States.waittingResult, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(Arbitrator.TAG, "SM>>" + States.waittingResult.toString());
                int moreRecord = _this.getStopReason().equals((Object)IOralEvalSDK.EndReason.UserAction) ? 600 : 0;
                Arbitrator.this._adrH.sendEmptyMessageDelayed(2, (long)moreRecord);
            }
        });
        this._sm.whenEnter(States.privAndOfflineRunning, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(Arbitrator.TAG, "SM>>" + States.privRunning.toString());
                new OnlinePriv(parent, OnlineHostAddressPool.CURRENT((boolean)(parent.getCfg().getOralEvalMode() == OralEvalEnum.OnlineCH ? true : false)).host, OnlineHostAddressPool.CURRENT((boolean)(parent.getCfg().getOralEvalMode() == OralEvalEnum.OnlineCH ? true : false)).port, false);
                new OfflineEval(parent);
            }
        });
        this._sm.whenEnter(States.stopped, new ContextHandler<Context>(){

            @Override
            public void call(Context _this) throws Exception {
                LogBuffer.ONE.d(Arbitrator.TAG, "SM>>" + States.stopped.toString());
                Arbitrator.this._adrHStopped = true;
                VoiceSource.THIS.quit();
                VoiceSource.THIS = null;
                final SDKError onlineError = Arbitrator.this._cxt.getOnlineError();
                final IOralEvalSDK.OfflineSDKError offlineError = Arbitrator.this._cxt.getOfflineError();
                final String onlineResult = Arbitrator.this._cxt.getOnlineResult();
                final String offlineResult = Arbitrator.this._cxt.getOfflineResult();
                final IOralEvalSDK.EndReason endReason = Arbitrator.this._cxt.getStopReason();
                final IOralEvalSDK.ICallback cb = parent.cb();
                final String onlineUrl = Arbitrator.this._cxt.getOnlineUrl();
                if (OnlineHTTP.THIS != null) {
                    OnlineHTTP.THIS.quit();
                    OnlineHTTP.THIS = null;
                }
                if (OnlinePriv.THIS != null) {
                    OnlinePriv.THIS.quit();
                    OnlinePriv.THIS = null;
                }
                if (OfflineEval.THIS != null) {
                    OfflineEval.THIS.quit();
                    OfflineEval.THIS = null;
                }
                Store.THIS.clear();
                Store.THIS = null;
                parent.quit();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        parent.join();
                        if (!TextUtils.isEmpty((CharSequence)onlineResult)) {
                            boolean isAsyncRecog = parent.getCfg().isAsyncRecognize();
                            if (isAsyncRecog) {
                                String onlineResultURL = Arbitrator.this._cxt.getOnlineResultURL();
                                cb.onAsyncResult(parent, onlineResultURL);
                                cb.onStop(parent, "", false, onlineUrl, endReason);
                            } else {
                                cb.onStop(parent, onlineResult, false, onlineUrl, endReason);
                            }
                        } else if (!TextUtils.isEmpty((CharSequence)Arbitrator.this._cxt.getOfflineResult())) {
                            cb.onStop(parent, offlineResult, true, null, endReason);
                        } else {
                            cb.onError(parent, onlineError, offlineError);
                            if (onlineError != null) {
                                Arbitrator.this.uploadLogBean.seteID(String.valueOf(onlineError.errno));
                                Arbitrator.this.uploadLogBean.seteMsg(onlineError.toString());
                            } else if (offlineError != null) {
                                Arbitrator.this.uploadLogBean.seteID(String.valueOf(offlineError.getCode()));
                                Arbitrator.this.uploadLogBean.seteMsg(offlineError.toString());
                            }
                        }
                        Arbitrator.this.writeLog();
                    }
                }).start();
            }
        });
        this._sm.start(true, this._cxt);
    }

    static {
        FIRST_STEP = FirstStep.fsPriv;
        RETRYTIME = 0;
    }

    static enum FirstStep {
        fsPriv,
        fsPriv2,
        fsHttp;

    }

    static class Context
    extends StatefulContext {
        private boolean _needResult;
        private IOralEvalSDK.OfflineSDKError _offlineError;
        private String _offlineResult;
        private IOralEvalSDK.EndReason _stopReason = IOralEvalSDK.EndReason.UserAction;
        boolean _hasMp3;
        private final byte[] _mp3OutputBuf = new byte[10240];
        String onlineResult;
        SDKError onPrivError;
        String onlineUrl;
        String onlineResultURL;
        String lastSocketAddr;

        public Context(boolean hasMp3) {
            super("cArbitrator");
            if (hasMp3) {
                this._hasMp3 = hasMp3;
                if (0 != Lame.initializeEncoder(16000, 1)) {
                    LogBuffer.ONE.e(Arbitrator.TAG, "can not initialize mp3 encoder. give up, use pcm instead");
                    this._hasMp3 = false;
                }
            }
        }

        public byte[] getMp3(byte[] pcm) {
            int mp3BufLen = Lame.encode(pcm, pcm, pcm.length / 2, this._mp3OutputBuf, this._mp3OutputBuf.length);
            if (mp3BufLen < 0) {
                LogBuffer.ONE.e(Arbitrator.TAG, "mp3 encoder error:" + mp3BufLen);
                return null;
            }
            byte[] ret = new byte[mp3BufLen];
            System.arraycopy(this._mp3OutputBuf, 0, ret, 0, mp3BufLen);
            return ret;
        }

        public byte[] flushMp3() {
            int mp3BufLen = Lame.flushEncoder(this._mp3OutputBuf, this._mp3OutputBuf.length);
            Lame.closeEncoder();
            if (mp3BufLen < 0) {
                LogBuffer.ONE.e(Arbitrator.TAG, "flush mp3 encoder error:" + mp3BufLen);
                return new byte[0];
            }
            byte[] ret = new byte[mp3BufLen];
            System.arraycopy(this._mp3OutputBuf, 0, ret, 0, mp3BufLen);
            return ret;
        }

        public String getOnlineResult() {
            return this.onlineResult;
        }

        public void setOnlineResult(String onlineResult) {
            this.onlineResult = onlineResult;
        }

        public SDKError getOnlineError() {
            return this.onPrivError;
        }

        public void setOnlineError(SDKError onPrivError) {
            this.onPrivError = onPrivError;
        }

        public String getOnlineUrl() {
            return this.onlineUrl;
        }

        public void setOnlineUrl(String onlineUrl) {
            this.onlineUrl = onlineUrl;
        }

        public String getOnlineResultURL() {
            return this.onlineResultURL;
        }

        public void setOnlineResultURL(String onlineResultURL) {
            this.onlineResultURL = onlineResultURL;
        }

        public String getLastSocketAddr() {
            return this.lastSocketAddr;
        }

        public void setLastSocketAddr(String lastSocketAddr) {
            this.lastSocketAddr = lastSocketAddr;
        }

        public void needResult(boolean b) {
            this._needResult = b;
        }

        public boolean isNeedResult() {
            return this._needResult;
        }

        public void setOfflineError(IOralEvalSDK.OfflineSDKError sdkError) {
            this._offlineError = sdkError;
        }

        public IOralEvalSDK.OfflineSDKError getOfflineError() {
            return this._offlineError;
        }

        public void setOfflineResult(String s) {
            this._offlineResult = s;
        }

        public String getOfflineResult() {
            return this._offlineResult;
        }

        public void setStopReason(IOralEvalSDK.EndReason sr) {
            this._stopReason = sr;
        }

        public IOralEvalSDK.EndReason getStopReason() {
            return this._stopReason;
        }

        public void reqResult() {
            VoiceSource.THIS.trigger(VoiceSource.Events.stop, (HashMap<String, Object>)null);
            if (OnlineHTTP.THIS != null) {
                OnlineHTTP.THIS.trigger(OnlineHTTP.ExternalEvents.eGetResult, null);
            }
            if (OnlinePriv.THIS != null) {
                OnlinePriv.THIS.trigger(OnlinePriv.ExternalEvents.eGetResult, null);
            }
            if (OfflineEval.THIS != null) {
                OfflineEval.THIS.trigger(OfflineEval.ExternalEvents.eGetResult, null);
            }
        }
    }

    public static enum ExternalEvents {
        exOnlinePrivError_dns,
        exOnlinePrivError_conn,
        exOnlinePrivError_other,
        exVoiceSourceError,
        exVoiceSourceEnd,
        exOnlineHttpError,
        exOnlineHttpResult,
        exStop,
        exOnlinePrivResult,
        exVoiceData,
        exOfflineResult,
        exOfflineError,
        exCancel,
        exOpusData;

    }

    static enum Events implements EventEnum
    {
        stop,
        privDNSErr,
        privConnErr,
        privErr,
        contentError,
        privErr2,
        httpErr,
        gotOnlineResult,
        gotOfflineResult,
        gotResult,
        offlineErr,
        offlineAndOnlineAllError,
        voiceError;

    }

    public static enum States implements StateEnum
    {
        privRunning,
        privRunning_ip_port2,
        httpRunning,
        waittingResult,
        privAndOfflineRunning,
        stopped;

    }
}

