/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.utils;

public class ByteUtils {
    public static String bytesToHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            String string = Integer.toHexString(by & 0xFF);
            if (string.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static float bytesToFloat(byte[] byArray, int n2) {
        int n3 = byArray[n2];
        n3 &= 0xFF;
        n3 = (int)((long)n3 | (long)byArray[n2 + 1] << 8);
        n3 &= 0xFFFF;
        n3 = (int)((long)n3 | (long)byArray[n2 + 2] << 16);
        n3 &= 0xFFFFFF;
        n3 = (int)((long)n3 | (long)byArray[n2 + 3] << 24);
        return Float.intBitsToFloat(n3);
    }

    public static byte[] hexToBytes(String string) {
        if (string == null || string.trim().equals("")) {
            return new byte[0];
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i2 = 0; i2 < string.length() / 2; ++i2) {
            String string2 = string.substring(i2 * 2, i2 * 2 + 2);
            byArray[i2] = (byte)Integer.parseInt(string2, 16);
        }
        return byArray;
    }

    public static byte[] float2byte(float f2) {
        int n2;
        int n3 = Float.floatToIntBits(f2);
        byte[] byArray = new byte[4];
        for (n2 = 0; n2 < 4; ++n2) {
            byArray[n2] = (byte)(n3 >> 24 - n2 * 8);
        }
        n2 = byArray.length;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        for (int i2 = 0; i2 < n2 / 2; ++i2) {
            byte by = byArray2[i2];
            byArray2[i2] = byArray2[n2 - i2 - 1];
            byArray2[n2 - i2 - 1] = by;
        }
        return byArray2;
    }
}

