/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.protocol.connect;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.hpplay.common.utils.DeviceUtil;
import com.hpplay.common.utils.ScreenUtil;
import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.protocol.IConnector;
import com.hpplay.component.modulelinker.api.ModuleLinker;
import com.hpplay.sdk.source.api.IConnectListener;
import com.hpplay.sdk.source.bean.PassBean;
import com.hpplay.sdk.source.bean.PassCacheBean;
import com.hpplay.sdk.source.browse.api.LelinkServiceInfo;
import com.hpplay.sdk.source.browse.data.BrowserInfo;
import com.hpplay.sdk.source.business.BusinessEntity;
import com.hpplay.sdk.source.business.PlayController;
import com.hpplay.sdk.source.business.cloud.SourceDataReport;
import com.hpplay.sdk.source.common.store.Preference;
import com.hpplay.sdk.source.common.store.Session;
import com.hpplay.sdk.source.common.utils.HapplayUtils;
import com.hpplay.sdk.source.localserver.LelinkServerInstance;
import com.hpplay.sdk.source.log.SourceLog;
import com.hpplay.sdk.source.pass.Parser;
import com.hpplay.sdk.source.pass.PassSender;
import com.hpplay.sdk.source.pass.bean.DescribeBean;
import com.hpplay.sdk.source.protocol.LelinkProtocolListener;
import com.hpplay.sdk.source.protocol.connect.AbsConnectBridge;
import com.hpplay.sdk.source.utils.CastUtil;
import com.hpplay.sdk.source.utils.CreateUtil;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONObject;

public class LocalConnectBridge
extends AbsConnectBridge {
    private static final String TAG = "LocalConnectBridge";
    public static final String NEW_HAPPYCAST_AGENT = "HappyCast5,0/500.0";
    private static final int WHAT_DELAY_PASS = 1;
    private static final int WHAT_SEND_PASS = 2;
    private static final int DELAY_PASS = 100;
    private ModuleLinker mModuleLinker;
    private IConnector mConnector;
    private final Context mContext;
    private boolean isRelease = false;
    private boolean isPassConnected = false;
    private boolean isCallConnectSuccess = false;
    private boolean isCallConnectFailed = false;
    private boolean isCallDisconnect = false;
    private boolean isCallbackDisconnectSuccess = false;
    private boolean isReportDisconnect = false;
    private boolean isCallConnect = false;
    private boolean isSendPassReconnect = false;
    private int mFeature;
    private List<PassCacheBean> mCacheList = new LinkedList<PassCacheBean>();
    private LelinkServiceInfo mServiceInfo;
    private BrowserInfo mConnectBrowserInfo;
    private LelinkProtocolListener mConnectListener = new LelinkProtocolListener(){

        @Override
        public void onResult(int n2, String ... stringArray) {
            SourceLog.i(LocalConnectBridge.TAG, "onResult " + n2);
            switch (n2) {
                case 11: {
                    LocalConnectBridge.this.resolveConnectResult(n2, stringArray);
                    break;
                }
                case 18: {
                    LocalConnectBridge.this.mHandler.removeMessages(1);
                    LocalConnectBridge.this.mHandler.sendEmptyMessageDelayed(1, 100L);
                    break;
                }
                case 19: {
                    if (stringArray.length < 2) {
                        SourceLog.w(LocalConnectBridge.TAG, "CMD_PASSTH_RESULT ignore");
                        break;
                    }
                    DescribeBean describeBean = DescribeBean.formJson(stringArray[0]);
                    String string = stringArray[1];
                    Parser.getInstance().parseByLocalCast(describeBean, string);
                }
            }
        }
    };
    private final Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message message) {
            block1 : switch (message.what) {
                case 1: {
                    LocalConnectBridge.this.isPassConnected = true;
                    PassSender.getInstance().sendConnectMsg(LocalConnectBridge.this.mServiceInfo);
                    break;
                }
                case 2: {
                    try {
                        if (LocalConnectBridge.this.mCacheList.size() <= 0) break;
                        Iterator iterator = LocalConnectBridge.this.mCacheList.iterator();
                        while (iterator.hasNext()) {
                            PassCacheBean passCacheBean = (PassCacheBean)iterator.next();
                            if (passCacheBean == null) {
                                iterator.remove();
                                continue;
                            }
                            iterator.remove();
                            LocalConnectBridge.this.sendPassData(passCacheBean);
                            break block1;
                        }
                        break;
                    }
                    catch (Exception exception) {
                        SourceLog.w(LocalConnectBridge.TAG, exception);
                    }
                }
            }
            return false;
        }
    });

    public LocalConnectBridge(Context context) {
        this.mContext = context;
    }

    public IConnector getConnector() {
        return this.mConnector;
    }

    @Override
    public void setConnectListener(IConnectListener iConnectListener) {
        this.mAppListener = iConnectListener;
    }

    @Override
    public void connect(LelinkServiceInfo lelinkServiceInfo) {
        super.connect(lelinkServiceInfo);
        BrowserInfo browserInfo = CastUtil.getPreConnectInfo(lelinkServiceInfo);
        this.connect(lelinkServiceInfo, browserInfo);
    }

    @Override
    public boolean isSupportUrlList() {
        int n2 = this.mFeature & 0x800;
        return n2 != 0;
    }

    @Override
    public boolean isSupportTrack() {
        int n2 = this.mFeature & 0x1000;
        return n2 != 0;
    }

    public void connect(LelinkServiceInfo lelinkServiceInfo, BrowserInfo browserInfo) {
        String string;
        int[] nArray;
        if (this.isCallConnect) {
            this.disconnect(2);
        }
        this.mServiceInfo = lelinkServiceInfo;
        this.mConnectBrowserInfo = browserInfo;
        this.mConnectSession = CreateUtil.createSessionId();
        this.isCallConnect = true;
        this.isCallDisconnect = false;
        this.isCallbackDisconnectSuccess = false;
        this.isReportDisconnect = false;
        this.isCallConnectSuccess = false;
        this.isCallConnectFailed = false;
        this.mConnectBrowserInfo = browserInfo;
        SourceLog.i(TAG, "connect");
        if (browserInfo == null) {
            SourceLog.w(TAG, "connect ignore, has no used browser info");
            return;
        }
        SourceLog.i(TAG, "connect " + lelinkServiceInfo.getIp() + "/" + browserInfo.getExtras().get("lelinkport") + "/" + lelinkServiceInfo.getName());
        ParamsMap paramsMap = ParamsMap.create();
        paramsMap.putParam("uid", browserInfo.getUid());
        paramsMap.putParam("ip", browserInfo.getIp());
        paramsMap.putParam("sink_name", this.mConnectBrowserInfo.getName());
        switch (browserInfo.getType()) {
            case 1: {
                nArray = new int[]{1};
                if (CastUtil.isSupportLelinkV2(browserInfo)) {
                    paramsMap.putParam("port", browserInfo.getExtras().get("lelinkport"));
                    paramsMap.putParam("lelink_port", browserInfo.getExtras().get("lelinkport"));
                    paramsMap.putParam("vv", "2");
                    SourceDataReport.getInstance().onLocalConnect(this.mConnectSession, 5, this.mServiceInfo);
                    break;
                }
                if (TextUtils.isEmpty((CharSequence)browserInfo.getExtras().get("airplay"))) {
                    paramsMap.putParam("port", browserInfo.getExtras().get("lelinkport"));
                } else {
                    paramsMap.putParam("port", browserInfo.getExtras().get("airplay"));
                }
                SourceDataReport.getInstance().onLocalConnect(this.mConnectSession, 1, this.mServiceInfo);
                break;
            }
            case 3: {
                paramsMap.putParam("port", browserInfo.getPort());
                nArray = new int[]{3};
                try {
                    string = browserInfo.getExtras().get("dlna_location");
                    paramsMap.putParam("location_uri", string);
                }
                catch (Exception exception) {
                    SourceLog.w(TAG, exception);
                }
                SourceDataReport.getInstance().onLocalConnect(this.mConnectSession, 3, this.mServiceInfo);
                break;
            }
            default: {
                SourceLog.w(TAG, "connect ignore," + browserInfo.getType());
                return;
            }
        }
        paramsMap.putParam("connect_support", nArray);
        string = new JSONObject();
        try {
            Object object;
            string.put("lelinkVer", (Object)NEW_HAPPYCAST_AGENT);
            string.put("sdkVer", (Object)"4.07.19");
            try {
                object = Preference.getInstance().get("key_username");
                object = TextUtils.isEmpty((CharSequence)object) ? URLEncoder.encode(DeviceUtil.getBluetoothName()) : URLEncoder.encode((String)object);
                string.put("name", object);
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
            string.put("cu", (Object)Session.getInstance().getUID());
            string.put("hid", (Object)Session.getInstance().getHID());
            string.put("appID", (Object)Session.getInstance().appKey);
            object = ScreenUtil.getRelScreenSize(this.mContext);
            string.put("sWidth", (int)object[0]);
            string.put("sHeight", (int)object[1]);
            try {
                string.put("uuid", (Object)Session.getInstance().getIMEI());
                String string2 = Session.getInstance().getMac();
                string.put("mac", (Object)string2);
                string.put("appVer", HapplayUtils.getAppVersion(this.mContext));
            }
            catch (Exception exception) {
                SourceLog.w(TAG, exception);
            }
            string.put("OSVer", Build.VERSION.SDK_INT);
            string.put("model", (Object)(Build.MANUFACTURER + " " + Build.MODEL));
            string.put("platform", (Object)"100");
            string.put("vuuid", (Object)Preference.getInstance().get("key_uuid"));
            string.put("vsession", (Object)Preference.getInstance().get("key_session"));
            string.put("tid", (Object)Session.getInstance().tid);
            string.put("s_oaid", (Object)DeviceUtil.getOAID(this.mContext));
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        paramsMap.putParam("cjson", string);
        try {
            this.mModuleLinker = ModuleLinker.getNewInstance();
            this.mConnector = (IConnector)this.mModuleLinker.loadModule("C78BFFFD55819CAEC2AAEF8BAB82DA5A");
            this.mConnector.connect(paramsMap, this.mConnectListener);
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
    }

    private void resolveConnectResult(int n2, String ... stringArray) {
        SourceLog.i(TAG, "resolveConnectResult" + Arrays.toString(stringArray));
        String string = stringArray[0];
        if ("connection_disconnect".equals(string)) {
            this.callbackDisconnectSuccess();
        }
        if (this.isCallDisconnect) {
            SourceLog.i(TAG, "resolveConnectResult ignore," + string);
            return;
        }
        int n3 = 0;
        if (stringArray.length > 1) {
            n3 = Integer.parseInt(stringArray[1]);
            if (1 == n3) {
                if (CastUtil.isSupportLelinkV2(this.mConnectBrowserInfo)) {
                    n3 = 5;
                }
            } else {
                n3 = 3;
            }
        }
        SourceLog.i(TAG, "resolveConnectResult " + string);
        if ("successful".equals(string)) {
            try {
                this.mFeature = Integer.parseInt(stringArray[2]);
            }
            catch (Exception exception) {
                SourceLog.i(TAG, "resolveConnectResult get feature error: " + exception.getMessage());
            }
            this.setConnected(true);
            SourceDataReport.getInstance().onLocalConnectSuccess(this.mConnectSession, n3, this.mServiceInfo);
            if (!LelinkServerInstance.getInstance().isAlive()) {
                LelinkServerInstance.getInstance().startServer();
            }
            this.isCallConnectSuccess = true;
            if (this.mAppListener == null) {
                SourceLog.w(TAG, "connect success, invalid listener");
                return;
            }
            this.mAppListener.onConnect(this.mServiceInfo, n3);
        } else if ("failed".equals(string)) {
            if (this.retry()) {
                this.connect(this.mServiceInfo, this.mConnectBrowserInfo);
                return;
            }
            if (this.isCallConnectFailed) {
                SourceLog.w(TAG, "ignore notify connect failed, is already called");
                return;
            }
            this.isCallConnectFailed = true;
            this.setConnected(false);
            this.isPassConnected = false;
            if (!this.isCallConnectSuccess) {
                SourceDataReport.getInstance().onLocalConnectFailed(this.mConnectSession, n3, this.mServiceInfo, "212010");
            } else {
                SourceLog.w(TAG, "this connector already callback connect success");
            }
            if (this.mAppListener == null) {
                SourceLog.w(TAG, "connect failed, invalid listener");
                return;
            }
            this.mAppListener.onDisconnect(this.mServiceInfo, 212010, 212011);
        }
    }

    private void callbackDisconnectSuccess() {
        if (this.isCallbackDisconnectSuccess) {
            return;
        }
        this.setConnected(false);
        this.isPassConnected = false;
        this.isCallbackDisconnectSuccess = true;
        if (this.mAppListener == null) {
            SourceLog.w(TAG, "disconnect, invalid listener");
            return;
        }
        this.mAppListener.onDisconnect(this.mServiceInfo, 212000, 212001);
    }

    private boolean retry() {
        if (this.mConnectBrowserInfo == null) {
            return false;
        }
        if (this.mConnectBrowserInfo.getType() == 1) {
            BrowserInfo browserInfo = CastUtil.getBrowserInfo(this.mServiceInfo, 3);
            if (browserInfo == null) {
                return false;
            }
            this.mConnectBrowserInfo = browserInfo;
            SourceLog.i(TAG, "connect retry by dlna");
            return true;
        }
        return false;
    }

    @Override
    public synchronized void sendPassData(int n2, String string, String string2) {
        if (n2 == 4) {
            this.mCacheList.add(0, new PassCacheBean(n2, string, string2));
        } else {
            this.mCacheList.add(new PassCacheBean(n2, string, string2));
        }
        if (this.isPassConnected) {
            if (this.mHandler != null) {
                this.mHandler.removeMessages(2);
                this.mHandler.sendEmptyMessage(2);
            }
        } else {
            SourceLog.w(TAG, "sendPassData wait connect " + n2);
        }
    }

    private void sendPassData(final PassCacheBean passCacheBean) {
        if (passCacheBean == null) {
            SourceLog.w(TAG, "sendPassData ignore");
            return;
        }
        SourceLog.i(TAG, "sendPassData " + passCacheBean.type);
        this.mConnector.sendPassthroughData(passCacheBean.type, passCacheBean.header, passCacheBean.body, new LelinkProtocolListener(){

            @Override
            public void onResult(int n2, String ... stringArray) {
                if (LocalConnectBridge.this.mHandler != null) {
                    LocalConnectBridge.this.mHandler.removeMessages(2);
                    LocalConnectBridge.this.mHandler.sendEmptyMessage(2);
                }
                if (stringArray == null || stringArray.length <= 0) {
                    return;
                }
                PassBean passBean = new PassBean();
                passBean.cmd = n2;
                passBean.action = 1;
                try {
                    JSONObject jSONObject = new JSONObject(passCacheBean.body);
                    if (jSONObject.has("regist")) {
                        passBean.action = jSONObject.getInt("regist");
                    }
                }
                catch (Exception exception) {
                    SourceLog.w(LocalConnectBridge.TAG, "get regist error");
                }
                if ("successful".equals(stringArray[0])) {
                    passBean.result = 1;
                    SourceLog.i(LocalConnectBridge.TAG, "option: " + n2 + " \u900f\u4f20\u6570\u636e\u53d1\u9001\u6210\u529f ");
                } else {
                    passBean.result = 0;
                    SourceLog.i(LocalConnectBridge.TAG, "option: " + n2 + " \u900f\u4f20\u6570\u636e\u53d1\u9001\u5931\u8d25 ");
                    LocalConnectBridge.this.checkPassConnect(passCacheBean);
                }
                LocalConnectBridge.this.callbackPass(passBean);
            }
        });
    }

    public void checkPassConnect(PassCacheBean passCacheBean) {
        PlayController playController;
        if (!this.isSendPassReconnect && this.isPassConnected && this.mServiceInfo != null && this.mConnectBrowserInfo != null && (playController = BusinessEntity.getInstance().getCurrentPlayController()) != null && playController.isInPlaybackState()) {
            SourceLog.i(TAG, "checkPassConnect reconnect");
            this.isSendPassReconnect = true;
            this.connect(this.mServiceInfo, this.mConnectBrowserInfo);
            this.mCacheList.add(passCacheBean);
        }
    }

    @Override
    public void disconnect(int n2) {
        super.disconnect(n2);
        if (this.isCallDisconnect) {
            return;
        }
        this.isPassConnected = false;
        this.isCallDisconnect = true;
        this.isSendPassReconnect = false;
        if (this.mServiceInfo != null) {
            SourceLog.i(TAG, "disconnect " + this.mServiceInfo.getIp() + "/" + this.mServiceInfo.getName() + " by " + n2);
        } else {
            SourceLog.i(TAG, "disconnect by " + n2);
        }
        try {
            if (this.isCallConnect && this.mConnector != null) {
                this.mConnector.disConnect();
            }
        }
        catch (Exception exception) {
            SourceLog.w(TAG, exception);
        }
        this.setConnected(false);
        this.mCacheList.clear();
        int n3 = 0;
        if (this.mConnectBrowserInfo != null) {
            n3 = this.mConnectBrowserInfo.getType();
            if (CastUtil.isSupportLelinkV2(this.mConnectBrowserInfo)) {
                n3 = 5;
            }
        }
        this.isCallConnect = false;
        if (n2 != 2) {
            this.callbackDisconnectSuccess();
        }
        if (this.isReportDisconnect) {
            return;
        }
        this.isReportDisconnect = true;
        SourceDataReport.getInstance().onLocalDisconnect(this.mConnectSession, n3, this.mServiceInfo, n2);
    }

    @Override
    public void release() {
        SourceLog.i(TAG, "release");
        if (this.isRelease) {
            return;
        }
        this.isRelease = true;
        this.disconnect(100);
        if (this.mModuleLinker != null) {
            this.mModuleLinker.removeObjOfMemory("C0621B15996CEEC4E9996C843BFB3A59");
            this.mModuleLinker = null;
        }
        this.mConnectListener = null;
    }
}

