/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns.xbill.dns;

import android.util.Log;
import com.hpplay.sdk.source.mdns.xbill.dns.Client;
import java.io.EOFException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.security.SecureRandom;

final class UDPClient
extends Client {
    private static final int EPHEMERAL_START = 1024;
    private static final int EPHEMERAL_STOP = 65535;
    private static final int EPHEMERAL_RANGE = 64511;
    private static final String TAG = "UDPClient";
    private static SecureRandom prng = new SecureRandom();
    private static volatile boolean prng_initializing = true;
    private boolean bound = false;

    public UDPClient(long l2) {
        super(DatagramChannel.open(), l2);
    }

    private void bind_random(InetSocketAddress inetSocketAddress) {
        if (prng_initializing) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (prng_initializing) {
                return;
            }
        }
        DatagramChannel datagramChannel = (DatagramChannel)this.key.channel();
        for (int i2 = 0; i2 < 1024; ++i2) {
            try {
                int n2 = prng.nextInt(64511) + 1024;
                InetSocketAddress inetSocketAddress2 = inetSocketAddress != null ? new InetSocketAddress(inetSocketAddress.getAddress(), n2) : new InetSocketAddress(n2);
                datagramChannel.socket().bind(inetSocketAddress2);
                this.bound = true;
                return;
            }
            catch (SocketException socketException) {
                continue;
            }
        }
    }

    void bind(SocketAddress socketAddress) {
        if (socketAddress == null || socketAddress instanceof InetSocketAddress && ((InetSocketAddress)socketAddress).getPort() == 0) {
            this.bind_random((InetSocketAddress)socketAddress);
            if (this.bound) {
                return;
            }
        }
        if (socketAddress != null) {
            DatagramChannel datagramChannel = (DatagramChannel)this.key.channel();
            datagramChannel.socket().bind(socketAddress);
            this.bound = true;
        }
    }

    void connect(SocketAddress socketAddress) {
        if (!this.bound) {
            this.bind(null);
        }
        DatagramChannel datagramChannel = (DatagramChannel)this.key.channel();
        datagramChannel.connect(socketAddress);
    }

    void send(byte[] byArray) {
        try {
            DatagramChannel datagramChannel = (DatagramChannel)this.key.channel();
            datagramChannel.write(ByteBuffer.wrap(byArray));
        }
        catch (Exception exception) {
            Log.i((String)TAG, (String)(" udp client + " + exception.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] recv(int n2) {
        DatagramChannel datagramChannel = (DatagramChannel)this.key.channel();
        byte[] byArray = new byte[n2];
        this.key.interestOps(1);
        try {
            while (!this.key.isReadable()) {
                UDPClient.blockUntil(this.key, this.endTime);
            }
        }
        finally {
            if (this.key.isValid()) {
                this.key.interestOps(0);
            }
        }
        long l2 = datagramChannel.read(ByteBuffer.wrap(byArray));
        if (l2 <= 0L) {
            throw new EOFException();
        }
        int n3 = (int)l2;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] sendrecv(SocketAddress socketAddress, SocketAddress socketAddress2, byte[] byArray, int n2, long l2) {
        byte[] byArray2;
        UDPClient uDPClient = new UDPClient(l2);
        try {
            uDPClient.bind(socketAddress);
            uDPClient.connect(socketAddress2);
            uDPClient.send(byArray);
            byArray2 = uDPClient.recv(n2);
        }
        finally {
            uDPClient.cleanup();
        }
        return byArray2;
    }
}

