/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.os.Build;
import android.os.Bundle;
import android.service.wallpaper.WallpaperService;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.WindowManager;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidLiveWallpaper;
import com.badlogic.gdx.backends.android.AndroidWallpaperListener;
import com.badlogic.gdx.utils.GdxNativesLoader;

public abstract class AndroidLiveWallpaperService
extends WallpaperService {
    static final String TAG = "WallpaperService";
    static boolean DEBUG;
    protected volatile AndroidLiveWallpaper app = null;
    protected SurfaceHolder.Callback view = null;
    protected int viewFormat;
    protected int viewWidth;
    protected int viewHeight;
    protected int engines = 0;
    protected int visibleEngines = 0;
    protected volatile AndroidWallpaperEngine linkedEngine = null;
    protected volatile boolean isPreviewNotified = false;
    protected volatile boolean notifiedPreviewState = false;
    volatile int[] sync = new int[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLinkedEngine(AndroidWallpaperEngine linkedEngine) {
        int[] nArray = this.sync;
        synchronized (this.sync) {
            this.linkedEngine = linkedEngine;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void onCreate() {
        if (DEBUG) {
            Log.d((String)TAG, (String)(" > AndroidLiveWallpaperService - onCreate() " + ((Object)((Object)this)).hashCode()));
        }
        Log.i((String)TAG, (String)"service created");
        super.onCreate();
    }

    public WallpaperService.Engine onCreateEngine() {
        if (DEBUG) {
            Log.d((String)TAG, (String)" > AndroidLiveWallpaperService - onCreateEngine()");
        }
        Log.i((String)TAG, (String)"engine created");
        return new AndroidWallpaperEngine();
    }

    public void onCreateApplication() {
        if (DEBUG) {
            Log.d((String)TAG, (String)" > AndroidLiveWallpaperService - onCreateApplication()");
        }
    }

    public void initialize(ApplicationListener listener) {
        AndroidApplicationConfiguration config = new AndroidApplicationConfiguration();
        this.initialize(listener, config);
    }

    public void initialize(ApplicationListener listener, AndroidApplicationConfiguration config) {
        if (DEBUG) {
            Log.d((String)TAG, (String)" > AndroidLiveWallpaperService - initialize()");
        }
        this.app.initialize(listener, config);
        if (config.getTouchEventsForLiveWallpaper && Integer.parseInt(Build.VERSION.SDK) >= 7) {
            this.linkedEngine.setTouchEventsEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SurfaceHolder getSurfaceHolder() {
        if (DEBUG) {
            Log.d((String)TAG, (String)" > AndroidLiveWallpaperService - getSurfaceHolder()");
        }
        int[] nArray = this.sync;
        synchronized (this.sync) {
            if (this.linkedEngine == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.linkedEngine.getSurfaceHolder();
        }
    }

    public void onDeepPauseApplication() {
        if (DEBUG) {
            Log.d((String)TAG, (String)" > AndroidLiveWallpaperService - onDeepPauseApplication()");
        }
        if (this.app != null) {
            this.app.graphics.clearManagedCaches();
        }
    }

    public void onDestroy() {
        if (DEBUG) {
            Log.d((String)TAG, (String)(" > AndroidLiveWallpaperService - onDestroy() " + ((Object)((Object)this)).hashCode()));
        }
        Log.i((String)TAG, (String)"service destroyed");
        super.onDestroy();
        if (this.app != null) {
            this.app.onDestroy();
            this.app = null;
            this.view = null;
        }
    }

    protected void finalize() throws Throwable {
        Log.i((String)TAG, (String)"service finalized");
        super.finalize();
    }

    public AndroidLiveWallpaper getLiveWallpaper() {
        return this.app;
    }

    public WindowManager getWindowManager() {
        return (WindowManager)this.getSystemService("window");
    }

    static {
        GdxNativesLoader.load();
        DEBUG = false;
    }

    public class AndroidWallpaperEngine
    extends WallpaperService.Engine {
        protected boolean engineIsVisible;
        protected int engineFormat;
        protected int engineWidth;
        protected int engineHeight;
        boolean iconDropConsumed;
        int xIconDrop;
        int yIconDrop;
        boolean offsetsConsumed;
        float xOffset;
        float yOffset;
        float xOffsetStep;
        float yOffsetStep;
        int xPixelOffset;
        int yPixelOffset;

        public AndroidWallpaperEngine() {
            super((WallpaperService)AndroidLiveWallpaperService.this);
            this.engineIsVisible = false;
            this.iconDropConsumed = true;
            this.offsetsConsumed = true;
            this.xOffset = 0.0f;
            this.yOffset = 0.0f;
            this.xOffsetStep = 0.0f;
            this.yOffsetStep = 0.0f;
            this.xPixelOffset = 0;
            this.yPixelOffset = 0;
            if (DEBUG) {
                Log.d((String)AndroidLiveWallpaperService.TAG, (String)(" > AndroidWallpaperEngine() " + ((Object)((Object)this)).hashCode()));
            }
        }

        public void onCreate(SurfaceHolder surfaceHolder) {
            if (DEBUG) {
                Log.d((String)AndroidLiveWallpaperService.TAG, (String)(" > AndroidWallpaperEngine - onCreate() " + ((Object)((Object)this)).hashCode() + " running: " + AndroidLiveWallpaperService.this.engines + ", linked: " + (AndroidLiveWallpaperService.this.linkedEngine == this) + ", thread: " + Thread.currentThread().toString()));
            }
            super.onCreate(surfaceHolder);
        }

        public void onSurfaceCreated(SurfaceHolder holder) {
            ++AndroidLiveWallpaperService.this.engines;
            AndroidLiveWallpaperService.this.setLinkedEngine(this);
            if (DEBUG) {
                Log.d((String)AndroidLiveWallpaperService.TAG, (String)(" > AndroidWallpaperEngine - onSurfaceCreated() " + ((Object)((Object)this)).hashCode() + ", running: " + AndroidLiveWallpaperService.this.engines + ", linked: " + (AndroidLiveWallpaperService.this.linkedEngine == this)));
            }
            Log.i((String)AndroidLiveWallpaperService.TAG, (String)"engine surface created");
            super.onSurfaceCreated(holder);
            if (AndroidLiveWallpaperService.this.engines == 1) {
                AndroidLiveWallpaperService.this.visibleEngines = 0;
            }
            if (AndroidLiveWallpaperService.this.engines == 1 && AndroidLiveWallpaperService.this.app == null) {
                AndroidLiveWallpaperService.this.viewFormat = 0;
                AndroidLiveWallpaperService.this.viewWidth = 0;
                AndroidLiveWallpaperService.this.viewHeight = 0;
                AndroidLiveWallpaperService.this.app = new AndroidLiveWallpaper(AndroidLiveWallpaperService.this);
                AndroidLiveWallpaperService.this.onCreateApplication();
                if (AndroidLiveWallpaperService.this.app.graphics == null) {
                    throw new Error("You must override 'AndroidLiveWallpaperService.onCreateApplication' method and call 'initialize' from its body.");
                }
            }
            AndroidLiveWallpaperService.this.view = (SurfaceHolder.Callback)AndroidLiveWallpaperService.this.app.graphics.view;
            this.getSurfaceHolder().removeCallback(AndroidLiveWallpaperService.this.view);
            this.engineFormat = AndroidLiveWallpaperService.this.viewFormat;
            this.engineWidth = AndroidLiveWallpaperService.this.viewWidth;
            this.engineHeight = AndroidLiveWallpaperService.this.viewHeight;
            if (AndroidLiveWallpaperService.this.engines == 1) {
                AndroidLiveWallpaperService.this.view.surfaceCreated(holder);
            } else {
                AndroidLiveWallpaperService.this.view.surfaceDestroyed(holder);
                this.notifySurfaceChanged(this.engineFormat, this.engineWidth, this.engineHeight, false);
                AndroidLiveWallpaperService.this.view.surfaceCreated(holder);
            }
            this.notifyPreviewState();
            this.notifyOffsetsChanged();
            if (!Gdx.graphics.isContinuousRendering()) {
                Gdx.graphics.requestRendering();
            }
        }

        public void onSurfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            if (DEBUG) {
                Log.d((String)AndroidLiveWallpaperService.TAG, (String)(" > AndroidWallpaperEngine - onSurfaceChanged() isPreview: " + this.isPreview() + ", " + ((Object)((Object)this)).hashCode() + ", running: " + AndroidLiveWallpaperService.this.engines + ", linked: " + (AndroidLiveWallpaperService.this.linkedEngine == this) + ", sufcace valid: " + this.getSurfaceHolder().getSurface().isValid()));
            }
            Log.i((String)AndroidLiveWallpaperService.TAG, (String)"engine surface changed");
            super.onSurfaceChanged(holder, format, width, height);
            this.notifySurfaceChanged(format, width, height, true);
        }

        private void notifySurfaceChanged(int format, int width, int height, boolean forceUpdate) {
            if (!forceUpdate && format == AndroidLiveWallpaperService.this.viewFormat && width == AndroidLiveWallpaperService.this.viewWidth && height == AndroidLiveWallpaperService.this.viewHeight) {
                if (DEBUG) {
                    Log.d((String)AndroidLiveWallpaperService.TAG, (String)" > surface is current, skipping surfaceChanged event");
                }
            } else {
                this.engineFormat = format;
                this.engineWidth = width;
                this.engineHeight = height;
                if (AndroidLiveWallpaperService.this.linkedEngine == this) {
                    AndroidLiveWallpaperService.this.viewFormat = this.engineFormat;
                    AndroidLiveWallpaperService.this.viewWidth = this.engineWidth;
                    AndroidLiveWallpaperService.this.viewHeight = this.engineHeight;
                    AndroidLiveWallpaperService.this.view.surfaceChanged(this.getSurfaceHolder(), AndroidLiveWallpaperService.this.viewFormat, AndroidLiveWallpaperService.this.viewWidth, AndroidLiveWallpaperService.this.viewHeight);
                } else if (DEBUG) {
                    Log.d((String)AndroidLiveWallpaperService.TAG, (String)" > engine is not active, skipping surfaceChanged event");
                }
            }
        }

        public void onVisibilityChanged(boolean visible) {
            boolean reportedVisible = this.isVisible();
            if (DEBUG) {
                Log.d((String)AndroidLiveWallpaperService.TAG, (String)(" > AndroidWallpaperEngine - onVisibilityChanged(paramVisible: " + visible + " reportedVisible: " + reportedVisible + ") " + ((Object)((Object)this)).hashCode() + ", sufcace valid: " + this.getSurfaceHolder().getSurface().isValid()));
            }
            super.onVisibilityChanged(visible);
            if (!reportedVisible && visible) {
                if (DEBUG) {
                    Log.d((String)AndroidLiveWallpaperService.TAG, (String)" > fake visibilityChanged event! Android WallpaperService likes do that!");
                }
                return;
            }
            this.notifyVisibilityChanged(visible);
        }

        private void notifyVisibilityChanged(boolean visible) {
            if (this.engineIsVisible != visible) {
                this.engineIsVisible = visible;
                if (this.engineIsVisible) {
                    this.onResume();
                } else {
                    this.onPause();
                }
            } else if (DEBUG) {
                Log.d((String)AndroidLiveWallpaperService.TAG, (String)" > visible state is current, skipping visibilityChanged event!");
            }
        }

        public void onResume() {
            ++AndroidLiveWallpaperService.this.visibleEngines;
            if (DEBUG) {
                Log.d((String)AndroidLiveWallpaperService.TAG, (String)(" > AndroidWallpaperEngine - onResume() " + ((Object)((Object)this)).hashCode() + ", running: " + AndroidLiveWallpaperService.this.engines + ", linked: " + (AndroidLiveWallpaperService.this.linkedEngine == this) + ", visible: " + AndroidLiveWallpaperService.this.visibleEngines));
            }
            Log.i((String)AndroidLiveWallpaperService.TAG, (String)"engine resumed");
            if (AndroidLiveWallpaperService.this.linkedEngine != null) {
                if (AndroidLiveWallpaperService.this.linkedEngine != this) {
                    AndroidLiveWallpaperService.this.setLinkedEngine(this);
                    AndroidLiveWallpaperService.this.view.surfaceDestroyed(this.getSurfaceHolder());
                    this.notifySurfaceChanged(this.engineFormat, this.engineWidth, this.engineHeight, false);
                    AndroidLiveWallpaperService.this.view.surfaceCreated(this.getSurfaceHolder());
                } else {
                    this.notifySurfaceChanged(this.engineFormat, this.engineWidth, this.engineHeight, false);
                }
                if (AndroidLiveWallpaperService.this.visibleEngines == 1) {
                    AndroidLiveWallpaperService.this.app.onResume();
                }
                this.notifyPreviewState();
                this.notifyOffsetsChanged();
                if (!Gdx.graphics.isContinuousRendering()) {
                    Gdx.graphics.requestRendering();
                }
            }
        }

        public void onPause() {
            --AndroidLiveWallpaperService.this.visibleEngines;
            if (DEBUG) {
                Log.d((String)AndroidLiveWallpaperService.TAG, (String)(" > AndroidWallpaperEngine - onPause() " + ((Object)((Object)this)).hashCode() + ", running: " + AndroidLiveWallpaperService.this.engines + ", linked: " + (AndroidLiveWallpaperService.this.linkedEngine == this) + ", visible: " + AndroidLiveWallpaperService.this.visibleEngines));
            }
            Log.i((String)AndroidLiveWallpaperService.TAG, (String)"engine paused");
            if (AndroidLiveWallpaperService.this.visibleEngines >= AndroidLiveWallpaperService.this.engines) {
                Log.e((String)AndroidLiveWallpaperService.TAG, (String)"wallpaper lifecycle error, counted too many visible engines! repairing..");
                AndroidLiveWallpaperService.this.visibleEngines = Math.max(AndroidLiveWallpaperService.this.engines - 1, 0);
            }
            if (AndroidLiveWallpaperService.this.linkedEngine != null && AndroidLiveWallpaperService.this.visibleEngines == 0) {
                AndroidLiveWallpaperService.this.app.onPause();
            }
            if (DEBUG) {
                Log.d((String)AndroidLiveWallpaperService.TAG, (String)" > AndroidWallpaperEngine - onPause() done!");
            }
        }

        public void onSurfaceDestroyed(SurfaceHolder holder) {
            --AndroidLiveWallpaperService.this.engines;
            if (DEBUG) {
                Log.d((String)AndroidLiveWallpaperService.TAG, (String)(" > AndroidWallpaperEngine - onSurfaceDestroyed() " + ((Object)((Object)this)).hashCode() + ", running: " + AndroidLiveWallpaperService.this.engines + " ,linked: " + (AndroidLiveWallpaperService.this.linkedEngine == this) + ", isVisible: " + this.engineIsVisible));
            }
            Log.i((String)AndroidLiveWallpaperService.TAG, (String)"engine surface destroyed");
            if (AndroidLiveWallpaperService.this.engines == 0) {
                AndroidLiveWallpaperService.this.onDeepPauseApplication();
            }
            if (AndroidLiveWallpaperService.this.linkedEngine == this && AndroidLiveWallpaperService.this.view != null) {
                AndroidLiveWallpaperService.this.view.surfaceDestroyed(holder);
            }
            this.engineFormat = 0;
            this.engineWidth = 0;
            this.engineHeight = 0;
            if (AndroidLiveWallpaperService.this.engines == 0) {
                AndroidLiveWallpaperService.this.linkedEngine = null;
            }
            super.onSurfaceDestroyed(holder);
        }

        public void onDestroy() {
            super.onDestroy();
        }

        public Bundle onCommand(String pAction, int pX, int pY, int pZ, Bundle pExtras, boolean pResultRequested) {
            if (DEBUG) {
                Log.d((String)AndroidLiveWallpaperService.TAG, (String)(" > AndroidWallpaperEngine - onCommand(" + pAction + " " + pX + " " + pY + " " + pZ + " " + pExtras + " " + pResultRequested + "), linked: " + (AndroidLiveWallpaperService.this.linkedEngine == this)));
            }
            if (pAction.equals("android.home.drop")) {
                this.iconDropConsumed = false;
                this.xIconDrop = pX;
                this.yIconDrop = pY;
                this.notifyIconDropped();
            }
            return super.onCommand(pAction, pX, pY, pZ, pExtras, pResultRequested);
        }

        protected void notifyIconDropped() {
            if (AndroidLiveWallpaperService.this.linkedEngine == this && AndroidLiveWallpaperService.this.app.listener instanceof AndroidWallpaperListener && !this.iconDropConsumed) {
                this.iconDropConsumed = true;
                AndroidLiveWallpaperService.this.app.postRunnable(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean isCurrent = false;
                        int[] nArray = AndroidLiveWallpaperService.this.sync;
                        synchronized (AndroidLiveWallpaperService.this.sync) {
                            isCurrent = AndroidLiveWallpaperService.this.linkedEngine == AndroidWallpaperEngine.this;
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            if (isCurrent) {
                                ((AndroidWallpaperListener)AndroidLiveWallpaperService.this.app.listener).iconDropped(AndroidWallpaperEngine.this.xIconDrop, AndroidWallpaperEngine.this.yIconDrop);
                            }
                            return;
                        }
                    }
                });
            }
        }

        public void onTouchEvent(MotionEvent event) {
            if (AndroidLiveWallpaperService.this.linkedEngine == this) {
                AndroidLiveWallpaperService.this.app.input.onTouch(null, event);
            }
        }

        public void onOffsetsChanged(float xOffset, float yOffset, float xOffsetStep, float yOffsetStep, int xPixelOffset, int yPixelOffset) {
            this.offsetsConsumed = false;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.xOffsetStep = xOffsetStep;
            this.yOffsetStep = yOffsetStep;
            this.xPixelOffset = xPixelOffset;
            this.yPixelOffset = yPixelOffset;
            this.notifyOffsetsChanged();
            if (!Gdx.graphics.isContinuousRendering()) {
                Gdx.graphics.requestRendering();
            }
            super.onOffsetsChanged(xOffset, yOffset, xOffsetStep, yOffsetStep, xPixelOffset, yPixelOffset);
        }

        protected void notifyOffsetsChanged() {
            if (AndroidLiveWallpaperService.this.linkedEngine == this && AndroidLiveWallpaperService.this.app.listener instanceof AndroidWallpaperListener && !this.offsetsConsumed) {
                this.offsetsConsumed = true;
                AndroidLiveWallpaperService.this.app.postRunnable(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean isCurrent = false;
                        int[] nArray = AndroidLiveWallpaperService.this.sync;
                        synchronized (AndroidLiveWallpaperService.this.sync) {
                            isCurrent = AndroidLiveWallpaperService.this.linkedEngine == AndroidWallpaperEngine.this;
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            if (isCurrent) {
                                ((AndroidWallpaperListener)AndroidLiveWallpaperService.this.app.listener).offsetChange(AndroidWallpaperEngine.this.xOffset, AndroidWallpaperEngine.this.yOffset, AndroidWallpaperEngine.this.xOffsetStep, AndroidWallpaperEngine.this.yOffsetStep, AndroidWallpaperEngine.this.xPixelOffset, AndroidWallpaperEngine.this.yPixelOffset);
                            }
                            return;
                        }
                    }
                });
            }
        }

        protected void notifyPreviewState() {
            if (AndroidLiveWallpaperService.this.linkedEngine == this && AndroidLiveWallpaperService.this.app.listener instanceof AndroidWallpaperListener) {
                final boolean currentPreviewState = AndroidLiveWallpaperService.this.linkedEngine.isPreview();
                AndroidLiveWallpaperService.this.app.postRunnable(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean shouldNotify = false;
                        int[] nArray = AndroidLiveWallpaperService.this.sync;
                        synchronized (AndroidLiveWallpaperService.this.sync) {
                            AndroidLiveWallpaper currentApp;
                            if (!AndroidLiveWallpaperService.this.isPreviewNotified || AndroidLiveWallpaperService.this.notifiedPreviewState != currentPreviewState) {
                                AndroidLiveWallpaperService.this.notifiedPreviewState = currentPreviewState;
                                AndroidLiveWallpaperService.this.isPreviewNotified = true;
                                shouldNotify = true;
                            }
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            if (shouldNotify && (currentApp = AndroidLiveWallpaperService.this.app) != null) {
                                ((AndroidWallpaperListener)currentApp.listener).previewStateChange(currentPreviewState);
                            }
                            return;
                        }
                    }
                });
            }
        }
    }
}

