/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.utils;

import android.content.Context;
import android.os.Build;
import android.os.Process;
import com.hpplay.sdk.source.business.cloud.SourceDataReport;
import com.hpplay.sdk.source.log.SourceLog;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class CrashHandler
implements Thread.UncaughtExceptionHandler {
    public static final String TAG = "CrashHandlerUtil";
    private Thread.UncaughtExceptionHandler mDefaultHandler;
    private static CrashHandler mCrashHandler;
    private Context mContext;
    private Map<String, String> infos = new HashMap<String, String>();
    private static final String CRASH_JAVA = "209001";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CrashHandler getInstance() {
        Class<CrashHandler> clazz = CrashHandler.class;
        synchronized (CrashHandler.class) {
            if (mCrashHandler == null) {
                mCrashHandler = new CrashHandler();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mCrashHandler;
        }
    }

    public void init(Context context) {
        this.mContext = context;
        this.mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        if (throwable != null) {
            SourceLog.i(TAG, "uncaughtException " + throwable.toString());
        } else {
            SourceLog.i(TAG, "uncaughtException ex is null");
        }
        if (!this.handleException(throwable) && this.mDefaultHandler != null) {
            this.mDefaultHandler.uncaughtException(thread, throwable);
        } else {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                SourceLog.w(TAG, "error : ", interruptedException);
            }
            Process.killProcess((int)Process.myPid());
        }
    }

    private boolean handleException(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        SourceLog.w(TAG, "handleException :  " + throwable.toString());
        this.collectDeviceInfo();
        this.uploadToServer(throwable);
        return true;
    }

    public void collectDeviceInfo() {
        try {
            Field[] fieldArray;
            String string = "4.07.19";
            this.infos.put("versionName", string);
            for (Field field : fieldArray = Build.class.getDeclaredFields()) {
                field.setAccessible(true);
                this.infos.put(field.getName(), field.get(null).toString());
            }
        }
        catch (Exception exception) {
            SourceLog.w("an error occured when collect package info", exception);
        }
    }

    private HashMap<String, String> getDeviceInfos() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("st", "6");
        hashMap.put("sn", "1");
        hashMap.put("et", CRASH_JAVA);
        hashMap.put("logt", "1");
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<String, String> entry : this.infos.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            stringBuffer.append(string + "=" + string2 + "\n");
            switch (string) {
                case "BOARD": {
                    hashMap.put("bo", string2);
                    break;
                }
                case "versionName": {
                    hashMap.put("vn", string2);
                    break;
                }
                case "CPU_ABI": {
                    hashMap.put("ca", string2);
                    break;
                }
                case "PRODUCT": {
                    hashMap.put("p", string2);
                    break;
                }
                case "ID": {
                    hashMap.put("i", string2);
                    break;
                }
                case "MODEL": {
                    hashMap.put("m", string2);
                    break;
                }
                case "MANUFACTURER": {
                    hashMap.put("mf", string2);
                    break;
                }
                case "BRAND": {
                    hashMap.put("br", string2);
                }
            }
        }
        return hashMap;
    }

    private void uploadToServer(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        for (Throwable throwable2 = throwable.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
            throwable2.printStackTrace(printWriter);
        }
        printWriter.close();
        String string = ((Object)stringWriter).toString();
        HashMap<String, String> hashMap = this.getDeviceInfos();
        SourceLog.i(TAG, "crashInfo  --- > " + string);
        hashMap.put("cd", string);
        SourceDataReport.getInstance().crashDataUpload(hashMap);
    }

    public void uploadExceptionToServer(String string) {
        HashMap<String, String> hashMap = this.getDeviceInfos();
        SourceLog.i(TAG, "crashInfo  --- > " + string);
        hashMap.put("cd", "Exception-----------> " + string);
        SourceDataReport.getInstance().crashDataUpload(hashMap);
    }
}

