/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol;

import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.ProtocolInfo;
import java.util.LinkedList;
import java.util.List;

public class ProtocolQueue {
    private static final String TAG = "ProtocolQueue";
    private List<ProtocolInfo> mQueue = new LinkedList<ProtocolInfo>();
    private int mLimitSize = 30;

    public synchronized void enqueue(ProtocolInfo protocolInfo) {
        if (this.mQueue.size() >= this.mLimitSize) {
            try {
                this.mQueue.remove(0);
            }
            catch (Exception exception) {
                CLog.w(TAG, exception);
            }
        }
        if (this.mQueue.size() == 0) {
            this.notifyAll();
        }
        this.mQueue.add(protocolInfo);
    }

    public synchronized ProtocolInfo next() {
        while (this.mQueue.size() == 0) {
            this.wait();
        }
        if (this.mQueue.size() >= this.mLimitSize) {
            this.notifyAll();
        }
        try {
            return this.mQueue.remove(0);
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
            return null;
        }
    }

    public void release() {
        this.mQueue.clear();
    }

    public int queueSize() {
        return this.mQueue.size();
    }
}

