/*
 * Decompiled with CFR 0.152.
 */
package com.unisound.edu.oraleval.sdk.sep15.utils.http;

import com.unisound.edu.oraleval.sdk.sep15.utils.LogBuffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HttpBody
extends InputStream {
    static final String TAG = "HttpBody";
    static final String CRLF = new String(new byte[]{13, 10});
    private InputStream _voice;
    private final String _bound;
    private final String _realBound;
    private final ByteArrayInputStream _beforeVoice;
    private final ByteArrayInputStream _afterVoice;
    private final long _prefixLen;
    private final long _postfixLen;
    private long _voiceLen = 0L;
    private long _pos;

    public HttpBody(String bound, String text, String mode, InputStream voice) {
        this._voice = voice;
        this._bound = bound;
        this._realBound = CRLF + "--" + this._bound + CRLF;
        StringBuilder sb = new StringBuilder();
        this.append(sb, "text", text);
        this.append(sb, "mode", mode);
        sb.append(this._realBound);
        sb.append("Content-Disposition: form-data; name=\"voice\"; filename=\"opus.bin\"");
        sb.append(CRLF);
        sb.append("Content-Type: application/octet-stream");
        sb.append(CRLF);
        sb.append(CRLF);
        byte[] prefix = sb.toString().getBytes();
        this._prefixLen = prefix.length;
        this._beforeVoice = new ByteArrayInputStream(prefix);
        sb = new StringBuilder();
        sb.append(CRLF);
        sb.append("--");
        sb.append(this._bound);
        sb.append("--");
        sb.append(CRLF);
        byte[] postfix = sb.toString().getBytes();
        this._afterVoice = new ByteArrayInputStream(postfix);
        this._postfixLen = postfix.length;
        this._pos = 0L;
    }

    private void append(StringBuilder sb, String key, String value) {
        sb.append(this._realBound);
        sb.append("Content-Disposition: form-data; name=\"");
        sb.append(key);
        sb.append("\"");
        sb.append(CRLF);
        sb.append(CRLF);
        sb.append(value);
    }

    @Override
    public int available() throws IOException {
        if (this._pos < this._prefixLen) {
            return this._beforeVoice.available();
        }
        if (this._voice != null) {
            return this._voice.available();
        }
        if (this._pos <= this._prefixLen + this._voiceLen + this._postfixLen) {
            return this._afterVoice.available();
        }
        return 0;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int rd = this.read(b, 0, 1);
        if (rd == 1) {
            return b[0];
        }
        return rd;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int rd;
        if (this._pos < this._prefixLen) {
            rd = this._beforeVoice.read(b, off, len);
            LogBuffer.ONE.i(TAG, "read " + rd + "@" + len + " before voice");
        } else if (this._voice != null) {
            rd = this._voice.read(b, off, len);
            if (rd <= 0) {
                this._voice.close();
                this._voice = null;
                rd = this._afterVoice.read(b, off, len);
                LogBuffer.ONE.i(TAG, "read " + rd + "@" + len + " after voice");
            } else {
                LogBuffer.ONE.i(TAG, "read " + rd + "@" + len + " in voice");
                this._voiceLen += (long)rd;
            }
        } else {
            rd = this._afterVoice.read(b, off, len);
            LogBuffer.ONE.i(TAG, "read " + rd + "@" + len + " after voice");
        }
        if (rd > 0) {
            this._pos += (long)rd;
        }
        return rd;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("not supported skip");
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("not supported reset");
    }

    @Override
    public void close() throws IOException {
        if (this._voice != null) {
            this._voice.close();
            this._voice = null;
        }
    }
}

