/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.sdk.source.mdns;

import android.util.Log;
import com.hpplay.sdk.source.mdns.DNSSDListener;
import com.hpplay.sdk.source.mdns.Querier;
import com.hpplay.sdk.source.mdns.ServiceInstance;
import com.hpplay.sdk.source.mdns.ServiceName;
import com.hpplay.sdk.source.mdns.ServiceRecodSorter;
import com.hpplay.sdk.source.mdns.xbill.dns.AAAARecord;
import com.hpplay.sdk.source.mdns.xbill.dns.ARecord;
import com.hpplay.sdk.source.mdns.xbill.dns.Header;
import com.hpplay.sdk.source.mdns.xbill.dns.Message;
import com.hpplay.sdk.source.mdns.xbill.dns.MulticastDNSUtils;
import com.hpplay.sdk.source.mdns.xbill.dns.Name;
import com.hpplay.sdk.source.mdns.xbill.dns.PTRRecord;
import com.hpplay.sdk.source.mdns.xbill.dns.Record;
import com.hpplay.sdk.source.mdns.xbill.dns.ResolverListener;
import com.hpplay.sdk.source.mdns.xbill.dns.SRVRecord;
import com.hpplay.sdk.source.mdns.xbill.dns.TXTRecord;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

class BrowseOperation
extends Thread
implements ResolverListener {
    private static final String TAG = "BrowseOperation";
    private int broadcastDelay = 0;
    private ResolverListener resolverListener;
    private DNSSDListener dnssdListener;
    protected Message[] mMessages;
    protected Querier mQuerier;
    private int dclass;
    private final AtomicBoolean isQuit = new AtomicBoolean();
    private final Map services = new LinkedHashMap();
    private String mErrorMsg;

    public BrowseOperation(ResolverListener resolverListener, Message[] messageArray, Querier querier, int n2) {
        this.setName(TAG);
        if (resolverListener != null) {
            this.registerListener(resolverListener);
        }
        this.mMessages = messageArray;
        this.mQuerier = querier;
        this.dclass = n2;
    }

    public void setDNSSDListener(DNSSDListener dNSSDListener) {
        this.dnssdListener = dNSSDListener;
    }

    Message[] getQueries() {
        return this.mMessages;
    }

    synchronized boolean answersQuery(Record record) {
        if (this.isQuit.get()) {
            return false;
        }
        if (record != null && this.mMessages != null) {
            for (Message message : this.mMessages) {
                for (Record record2 : MulticastDNSUtils.extractRecords(message, 0)) {
                    Name name = record2.getName();
                    Name name2 = record.getName();
                    int n2 = record2.getType();
                    int n3 = record.getType();
                    int n4 = record2.getDClass();
                    int n5 = record.getDClass();
                    if (n2 != 255 && n2 != n3 || !name.equals(name2) && !name.subdomain(name2) && !name2.toString().endsWith("." + name.toString()) || n4 != 255 && (n4 & Short.MAX_VALUE) != (n5 & Short.MAX_VALUE)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    boolean matchesBrowse(Message message) {
        Record[] recordArray;
        for (Record record : recordArray = MulticastDNSUtils.extractRecords(message, 1, 2, 3)) {
            if (!this.answersQuery(record)) continue;
            return true;
        }
        return false;
    }

    ResolverListener registerListener(ResolverListener resolverListener) {
        this.resolverListener = resolverListener;
        return this.resolverListener;
    }

    ResolverListener unregisterListener(ResolverListener resolverListener) {
        this.resolverListener = null;
        return null;
    }

    @Override
    public void receiveMessage(Object object, Message message) {
        Header header;
        if (message != null && ((header = message.getHeader()).getFlag(0) || header.getFlag(5)) && this.matchesBrowse(message)) {
            try {
                this.convertMassge(object, message);
            }
            catch (Exception exception) {
                Log.w((String)TAG, (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void convertMassge(Object object, Message message) {
        ServiceInstance[] serviceInstanceArray;
        PTRRecord pTRRecord;
        Serializable serializable;
        if (message == null || this.isQuit.get()) {
            return;
        }
        LinkedHashSet<Name> linkedHashSet = new LinkedHashSet<Name>();
        LinkedList<Record> linkedList = new LinkedList<Record>();
        LinkedList<Record> linkedList2 = new LinkedList<Record>();
        Record[] recordArray = MulticastDNSUtils.extractRecords(message, 1, 2, 3);
        for (Serializable serializable2 : recordArray) {
            if (this.answersQuery((Record)serializable2)) {
                serializable = serializable2.getAdditionalName();
                if (serializable != null) {
                    linkedHashSet.add((Name)serializable);
                }
                switch (serializable2.getType()) {
                    case 12: {
                        pTRRecord = (PTRRecord)serializable2;
                        linkedHashSet.add(pTRRecord.getTarget());
                        break;
                    }
                    case 33: {
                        serviceInstanceArray = (SRVRecord)serializable2;
                        linkedHashSet.add(serviceInstanceArray.getTarget());
                        break;
                    }
                }
                linkedList2.add((Record)serializable2);
                continue;
            }
            linkedList.add((Record)serializable2);
        }
        for (Record record : linkedList) {
            if (!linkedHashSet.contains(record.getName())) continue;
            linkedList2.add(record);
        }
        if (linkedList2.size() > 0) {
            if (this.dnssdListener != null) {
                this.dnssdListener.receiveMessage(object, message);
            }
            HashMap hashMap = new HashMap();
            HashMap<ServiceName, Serializable> hashMap2 = new HashMap<ServiceName, Serializable>();
            block21: for (Serializable serializable2 : linkedList2) {
                try {
                    serializable = null;
                    switch (serializable2.getType()) {
                        case 12: {
                            if (this.isQuit.get()) {
                                return;
                            }
                            pTRRecord = (PTRRecord)serializable2;
                            if (pTRRecord.getTTL() > 0L) {
                                serviceInstanceArray = this.extractServiceInstances(this.mQuerier.send(Message.newQuery(Record.newRecord(pTRRecord.getTarget(), 255, this.dclass))));
                                if (serviceInstanceArray.length <= 0) continue block21;
                                Map map = this.services;
                                synchronized (map) {
                                    for (int i2 = 0; i2 < serviceInstanceArray.length; ++i2) {
                                        if (this.services.containsKey(serviceInstanceArray[i2].getName())) continue;
                                        this.services.put(serviceInstanceArray[i2].getName(), serviceInstanceArray[i2]);
                                        hashMap.put(serviceInstanceArray[i2].getName(), serviceInstanceArray[i2]);
                                    }
                                    break;
                                }
                            }
                            serviceInstanceArray = this.services;
                            synchronized (serviceInstanceArray) {
                                serializable = (ServiceInstance)this.services.get(pTRRecord.getTarget());
                                if (serializable != null) {
                                    this.services.remove(((ServiceInstance)serializable).getName());
                                    hashMap2.put(((ServiceInstance)serializable).getName(), serializable);
                                }
                                break;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    Log.w((String)TAG, (Throwable)exception);
                }
            }
            for (Serializable serializable2 : hashMap.values()) {
                try {
                    this.dnssdListener.serviceDiscovered(object, (ServiceInstance)serializable2);
                }
                catch (Exception exception) {
                    Log.w((String)TAG, (Throwable)exception);
                }
            }
            for (Serializable serializable2 : hashMap2.values()) {
                try {
                    this.dnssdListener.serviceRemoved(object, (ServiceInstance)serializable2);
                }
                catch (Exception exception) {
                    Log.w((String)TAG, (Throwable)exception);
                }
            }
        }
    }

    @Override
    public void handleException(Object object, Exception exception) {
        if (this.resolverListener != null) {
            this.resolverListener.handleException(object, exception);
        }
    }

    public String getErrorMsg() {
        return this.mErrorMsg;
    }

    @Override
    public void run() {
        boolean bl = false;
        try {
            bl = this.mQuerier.initNetWorkState();
        }
        catch (Exception exception) {
            this.mErrorMsg = Log.getStackTraceString((Throwable)exception);
        }
        if (bl) {
            try {
                this.mQuerier.registerListener(this);
                while (!this.isQuit.get() && !this.isInterrupted()) {
                    try {
                        this.broadcastDelay = this.broadcastDelay > 0 ? Math.min(this.broadcastDelay * 2, 3600) : 1;
                        for (Message message : this.mMessages) {
                            this.mQuerier.broadcast((Message)message.clone(), false);
                        }
                    }
                    catch (Exception exception) {
                        Log.w((String)TAG, (Throwable)exception);
                    }
                    Thread.sleep(this.broadcastDelay);
                }
            }
            catch (Exception exception) {
                Log.w((String)TAG, (String)"browseOperation exit ...");
            }
        }
    }

    protected ServiceInstance[] extractServiceInstances(Message ... messageArray) {
        Record[] recordArray = null;
        for (Message message : messageArray) {
            Record[] recordArray2 = MulticastDNSUtils.extractRecords(message, 2, 1, 3);
            if (recordArray == null) {
                recordArray = recordArray2;
                continue;
            }
            Record[] recordArray3 = recordArray;
            recordArray = new Record[recordArray.length + recordArray2.length];
            System.arraycopy(recordArray3, 0, recordArray, 0, recordArray.length);
            System.arraycopy(recordArray2, 0, recordArray, recordArray.length, recordArray2.length);
        }
        return this.extractServiceInstances(recordArray);
    }

    protected ServiceInstance[] extractServiceInstances(Record[] recordArray) {
        HashMap<ServiceName, ServiceInstance> hashMap = new HashMap<ServiceName, ServiceInstance>();
        Arrays.sort(recordArray, new ServiceRecodSorter());
        block9: for (Record record : recordArray) {
            switch (record.getType()) {
                case 33: {
                    ServiceInstance serviceInstance;
                    try {
                        serviceInstance = new ServiceInstance((SRVRecord)record);
                        hashMap.put(serviceInstance.getName(), serviceInstance);
                    }
                    catch (Exception exception) {
                        Log.w((String)TAG, (Throwable)exception);
                    }
                    continue block9;
                }
                case 12: {
                    PTRRecord pTRRecord = (PTRRecord)record;
                    ServiceInstance serviceInstance = (ServiceInstance)hashMap.get(pTRRecord.getTarget());
                    if (serviceInstance == null) continue block9;
                    if (pTRRecord.getTTL() > 0L) {
                        serviceInstance.addPointer(pTRRecord.getName());
                        continue block9;
                    }
                    serviceInstance.removePointer(pTRRecord.getName());
                    continue block9;
                }
                case 16: {
                    TXTRecord tXTRecord = (TXTRecord)record;
                    ServiceInstance serviceInstance = (ServiceInstance)hashMap.get(tXTRecord.getName());
                    if (serviceInstance == null) continue block9;
                    if (tXTRecord.getTTL() > 0L) {
                        serviceInstance.addTextRecords(tXTRecord);
                        continue block9;
                    }
                    serviceInstance.removeTextRecords(tXTRecord);
                    continue block9;
                }
                case 1: {
                    ServiceInstance serviceInstance;
                    ARecord aRecord = (ARecord)record;
                    for (Iterator<Object> iterator : hashMap.values()) {
                        serviceInstance = (ServiceInstance)((Object)iterator);
                        if (!aRecord.getName().equals(serviceInstance.getHost())) continue;
                        if (aRecord.getTTL() > 0L) {
                            serviceInstance.addAddress(aRecord.getAddress());
                            continue;
                        }
                        serviceInstance.removeAddress(aRecord.getAddress());
                    }
                    continue block9;
                }
                case 28: {
                    Iterator<Object> iterator;
                    ServiceInstance serviceInstance;
                    AAAARecord aAAARecord = (AAAARecord)record;
                    iterator = hashMap.values().iterator();
                    while (iterator.hasNext()) {
                        Object v2 = iterator.next();
                        serviceInstance = (ServiceInstance)v2;
                        if (!aAAARecord.getName().equals(serviceInstance.getHost())) continue;
                        if (aAAARecord.getTTL() > 0L) {
                            serviceInstance.addAddress(aAAARecord.getAddress());
                            continue;
                        }
                        serviceInstance.removeAddress(aAAARecord.getAddress());
                    }
                    continue block9;
                }
            }
        }
        return hashMap.values().toArray(new ServiceInstance[hashMap.size()]);
    }

    public AtomicBoolean getQuitSwitch() {
        return this.isQuit;
    }

    public void release() {
        this.resolverListener = null;
        this.dnssdListener = null;
        this.interrupt();
        Log.i((String)TAG, (String)" browse release ");
        try {
            this.mQuerier.close();
            this.mQuerier = null;
            this.mMessages = null;
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)"udp release ");
        }
    }
}

