/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol.connection;

import com.hpplay.component.common.ParamsMap;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.protocol.ProtocolSender;
import com.hpplay.component.protocol.ProtocolUtils;

public abstract class IConnection {
    private static final String TAG = "IConnection";
    public static final String SUPPORT_LOW_RECEIVER_APK_VERSION_NUM = "5.0";
    public static final String SUPPORT_LOW_RECEIVER_APK_VERSION_NUM_1 = "3.";
    public static final String SUPPORT_NEW_LELINK_PROTOCOL_VERSION_NUM = "5.5";
    public String mHid;
    public String mDeviceName;
    public ProtocolSender mProtocolSender;
    public String sessionId;
    public ParamsMap paramsMap;
    public String mIp;
    public int mPort;

    public IConnection(ParamsMap paramsMap) {
        this.paramsMap = paramsMap;
        this.mProtocolSender = new ProtocolSender();
        this.mIp = paramsMap.getIp();
        this.mPort = paramsMap.getPort();
        CLog.i(TAG, Thread.currentThread() + "  ip == >  " + paramsMap.getIp().replace(".", "") + " port == > " + paramsMap.getPort());
        this.mProtocolSender.setConnectInfo(this.mIp, this.mPort);
        this.sessionId = ProtocolUtils.createSessionId(paramsMap.getCuid());
    }

    String getSessionId() {
        return this.sessionId;
    }

    abstract boolean startConnect();

    abstract boolean checkConnection();

    public ProtocolSender getProtocolSender() {
        return this.mProtocolSender;
    }

    void disConnect() {
        this.mProtocolSender.release();
    }
}

