/*
 * Decompiled with CFR 0.152.
 */
package com.hpplay.component.protocol;

import android.text.TextUtils;
import com.hpplay.component.common.dlna.IDLNAController;
import com.hpplay.component.common.protocol.ProtocolListener;
import com.hpplay.component.common.utils.CLog;
import com.hpplay.component.modulelinker.api.ModuleLinker;
import com.hpplay.component.protocol.DataReceiveListener;
import com.hpplay.component.protocol.ProtocolCore;
import com.hpplay.component.protocol.ProtocolInfo;
import com.hpplay.component.protocol.ProtocolQueue;
import com.hpplay.component.protocol.encrypt.LelinkEncrypt;
import java.io.IOException;
import org.json.JSONObject;

public class ProtocolSender
extends ProtocolCore {
    private static final String TAG = "ProtocolSender";
    private static final String CMD_CONNECT = "connect";
    private static final int MAX_RETRY_COUNT = 1;
    private final ProtocolQueue mProtocolQueues = new ProtocolQueue();
    private SocketThread mSocketThread;
    private int mRetryCount;

    public void setConnectInfo(String string, int n2) {
        this.mIP = string;
        this.mPort = n2;
    }

    public void protocolEnqueue(ProtocolListener protocolListener, byte[] ... byArray) {
        ProtocolInfo protocolInfo = new ProtocolInfo();
        protocolInfo.setProtocolData(byArray);
        protocolInfo.setProtocolListener(protocolListener);
        try {
            this.mProtocolQueues.enqueue(protocolInfo);
        }
        catch (InterruptedException interruptedException) {
            CLog.w(TAG, interruptedException);
        }
    }

    public void startConnect(String string, String string2, int n2, ProtocolListener protocolListener) {
        try {
            if (!this.isConnect() || this.mSocketThread != null && this.mSocketThread.getType() != n2) {
                CLog.i("pushlink", "reconnect    " + this.mProtocolQueues.queueSize());
                this.release();
                this.mSocketThread = new SocketThread(protocolListener, n2);
                this.mSocketThread.start();
            }
            CLog.i("pushlink", "startConnect  type: " + n2 + "   " + this.mProtocolQueues.queueSize());
            ProtocolInfo protocolInfo = new ProtocolInfo();
            byte[][] byArrayArray = !TextUtils.isEmpty((CharSequence)string) ? new byte[][]{CMD_CONNECT.getBytes(), string.getBytes(), string2 == null ? "".getBytes() : string2.getBytes()} : new byte[][]{CMD_CONNECT.getBytes()};
            protocolInfo.setProtocolData(byArrayArray);
            this.mProtocolQueues.enqueue(protocolInfo);
        }
        catch (Exception exception) {
            CLog.w(TAG, exception);
        }
    }

    public boolean isConnect() {
        if (this.mSocketThread != null) {
            return this.mSocketThread.isStartListen();
        }
        return false;
    }

    public synchronized void release() {
        long l2 = System.currentTimeMillis();
        if (this.mSocketThread != null) {
            this.mSocketThread.clearCallbackListener();
            this.mSocketThread.interrupt();
            this.mSocketThread.closeSender();
            this.mSocketThread = null;
        }
        this.mProtocolQueues.release();
        CLog.i(TAG, "closeSender  ==== >hashCode " + this.hashCode() + "   close time " + (System.currentTimeMillis() - l2));
    }

    class SocketThread
    extends Thread {
        private ProtocolListener socketConnectListener;
        private LelinkEncrypt lelinkEncrypt;
        private int type;
        private boolean mStartListen = true;
        private IDLNAController mDlnaController;
        private ModuleLinker mModuleLinker;

        public SocketThread(ProtocolListener protocolListener, int n2) {
            this.socketConnectListener = protocolListener;
            this.type = n2;
            this.setName(ProtocolSender.TAG);
        }

        public int getType() {
            return this.type;
        }

        public void clearCallbackListener() {
            this.socketConnectListener = null;
            this.mStartListen = false;
            if (this.lelinkEncrypt != null) {
                this.lelinkEncrypt.release();
                this.lelinkEncrypt = null;
            }
        }

        public boolean isStartListen() {
            return this.mStartListen;
        }

        @Override
        public void run() {
            super.run();
            CLog.i(ProtocolSender.TAG, "protocol run  ");
            this.mStartListen = true;
            if (3 == this.type) {
                this.DLNAHandle();
            } else {
                this.lelinkHandle();
            }
            ProtocolSender.this.release();
        }

        private void DLNAHandle() {
            try {
                CLog.i(ProtocolSender.TAG, " start DLNA Handle ... ");
                while (this.mStartListen) {
                    try {
                        ProtocolInfo protocolInfo = ProtocolSender.this.mProtocolQueues.next();
                        String string = new String(protocolInfo.getProtocolData()[0]);
                        if (TextUtils.equals((CharSequence)string, (CharSequence)ProtocolSender.CMD_CONNECT)) {
                            this.mStartListen = this.connectDLNA(protocolInfo);
                            CLog.i(ProtocolSender.TAG, " connect result " + this.mStartListen);
                            continue;
                        }
                        String[] stringArray = this.mDlnaController.sendAction(new String(protocolInfo.getProtocolData()[0]));
                        if (protocolInfo.getProtocolListener() == null) continue;
                        protocolInfo.getProtocolListener().onResult(protocolInfo.getProtocolListener().cmdType, stringArray);
                    }
                    catch (Exception exception) {
                        CLog.w(ProtocolSender.TAG, exception);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                CLog.w(ProtocolSender.TAG, exception);
            }
            CLog.i(ProtocolSender.TAG, "   DLNA Handle exit... ");
            this.mStartListen = false;
        }

        private boolean connectDLNA(ProtocolInfo protocolInfo) {
            try {
                this.closeSender();
                this.mModuleLinker = ModuleLinker.getNewInstance();
                this.mDlnaController = (IDLNAController)this.mModuleLinker.loadModule("B1F46D77496F190485B51E2EAA834265");
                String string = new String(protocolInfo.getProtocolData()[1]);
                String string2 = new String(protocolInfo.getProtocolData()[2]);
                this.mDlnaController = (IDLNAController)this.mModuleLinker.loadModule("B1F46D77496F190485B51E2EAA834265");
                boolean bl = this.mDlnaController.connect(string, string2, this.socketConnectListener);
                if (!bl) {
                    this.socketConnectListener.onResult(this.socketConnectListener.cmdType, "failed");
                } else if (bl) {
                    this.socketConnectListener.onResult(this.socketConnectListener.cmdType, "successful");
                }
                return bl;
            }
            catch (Exception exception) {
                CLog.w(ProtocolSender.TAG, exception);
                return false;
            }
        }

        private void lelinkHandle() {
            while (this.mStartListen) {
                try {
                    String string;
                    ProtocolInfo protocolInfo;
                    block11: {
                        protocolInfo = ProtocolSender.this.mProtocolQueues.next();
                        String string2 = new String(protocolInfo.getProtocolData()[0]);
                        if (TextUtils.equals((CharSequence)string2, (CharSequence)ProtocolSender.CMD_CONNECT)) {
                            this.mStartListen = this.connectLelink(protocolInfo);
                            continue;
                        }
                        if (this.lelinkEncrypt != null) {
                            try {
                                string = this.lelinkV2SendData(this.lelinkEncrypt, protocolInfo);
                                if (string.equals("failed") && ProtocolSender.this.mRetryCount < 1) {
                                    ProtocolSender.this.mRetryCount++;
                                    ProtocolSender.this.mProtocolQueues.enqueue(protocolInfo);
                                    CLog.i("IPushHandler", "========RESULT_FAILED   RESULT_FAILEDRESULT_FAILEDRESULT_FAILEDRESULT_FAILED========");
                                    continue;
                                }
                                ProtocolSender.this.mRetryCount = 0;
                                break block11;
                            }
                            catch (Exception exception) {
                                ProtocolSender.this.mErrorCode = 120103102;
                                ProtocolSender.this.mErrorMsg = CLog.getExceptionStr(exception);
                                this.resultCallback(protocolInfo, "failed");
                                break;
                            }
                        }
                        if (protocolInfo.getProtocolListener() != null && protocolInfo.getProtocolListener() instanceof DataReceiveListener) {
                            byte[] byArray = ProtocolSender.this.interactiveDataNoHeader(protocolInfo.getProtocolData());
                            ((DataReceiveListener)protocolInfo.getProtocolListener()).onDataResult(1, byArray);
                            continue;
                        }
                        try {
                            string = this.lelinkV1SendData(protocolInfo);
                        }
                        catch (Exception exception) {
                            ProtocolSender.this.mErrorCode = 120103101;
                            ProtocolSender.this.mErrorMsg = CLog.getExceptionStr(exception);
                            this.resultCallback(protocolInfo, "failed");
                            break;
                        }
                    }
                    this.resultCallback(protocolInfo, string);
                }
                catch (Exception exception) {
                    CLog.w(ProtocolSender.TAG, "InterruptedException thread exit ...");
                    break;
                }
            }
            this.mStartListen = false;
        }

        private boolean connectLelink(ProtocolInfo protocolInfo) {
            this.closeSender();
            long l2 = System.currentTimeMillis();
            boolean bl = false;
            try {
                bl = ProtocolSender.this.connectServer();
            }
            catch (Exception exception) {
                CLog.w(ProtocolSender.TAG, exception);
            }
            CLog.i(ProtocolSender.TAG, "create local socket " + bl + "  connected time " + (System.currentTimeMillis() - l2) + "   hashCode " + this.hashCode());
            if (bl) {
                if (protocolInfo.getProtocolData().length > 1) {
                    String string = new String(protocolInfo.getProtocolData()[1]);
                    String string2 = new String(protocolInfo.getProtocolData()[2]);
                    this.lelinkEncrypt = new LelinkEncrypt(string);
                    this.lelinkEncrypt.setSrpPassword(string2);
                }
                if (this.lelinkEncrypt != null) {
                    long l3 = System.currentTimeMillis();
                    this.mStartListen = ProtocolSender.this.checkEncrypt(this.lelinkEncrypt, ProtocolSender.TAG);
                    CLog.d(ProtocolSender.TAG, System.currentTimeMillis() - l3 + "   " + this.mStartListen + " thread name " + Thread.currentThread().getName());
                }
                if (this.socketConnectListener != null) {
                    this.lelinkConnectStateCallback(this.lelinkEncrypt, this.socketConnectListener);
                }
                return true;
            }
            if (this.socketConnectListener != null) {
                this.socketConnectListener.onResult(this.socketConnectListener.cmdType, "failed");
            }
            return false;
        }

        private void resultCallback(ProtocolInfo protocolInfo, String string) {
            if (protocolInfo.getProtocolListener() != null && protocolInfo.getProtocolListener() instanceof ProtocolListener) {
                String string2 = null;
                if (protocolInfo.getProtocolListener().cmdType == 1 && string.equals("failed")) {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("errMsg", (Object)ProtocolSender.this.mErrorMsg);
                    jSONObject.put("errCode", ProtocolSender.this.mErrorCode);
                    string2 = jSONObject.toString();
                }
                protocolInfo.getProtocolListener().onResult(protocolInfo.getProtocolListener().cmdType, string, string2);
            }
        }

        private String lelinkV1SendData(ProtocolInfo protocolInfo) {
            String string;
            byte[] byArray = ProtocolSender.this.interactiveData(protocolInfo.getProtocolData());
            if (byArray == null || byArray.length == 0) {
                string = "failed";
                ProtocolSender.this.mErrorCode = 120103101;
                ProtocolSender.this.mErrorMsg = "sink is not response";
            } else {
                string = new String(byArray);
            }
            return string;
        }

        private String lelinkV2SendData(LelinkEncrypt lelinkEncrypt, ProtocolInfo protocolInfo) {
            String string;
            long l2 = System.currentTimeMillis();
            byte[] byArray = lelinkEncrypt.buildEncryptData(protocolInfo.getProtocolData());
            byte[] byArray2 = null;
            String string2 = new String(protocolInfo.getProtocolData()[0]).split("\r\n")[0];
            if (byArray != null) {
                byArray2 = ProtocolSender.this.interactiveEncryptData(new byte[][]{byArray});
            }
            if (System.currentTimeMillis() - l2 > 1000L) {
                CLog.i(ProtocolSender.TAG, "============= timeout===> " + (System.currentTimeMillis() - l2) + " " + string2 + "  " + this.hashCode());
            }
            if (byArray2 == null || byArray2.length == 0) {
                CLog.i(ProtocolSender.TAG, " request failed  " + (System.currentTimeMillis() - l2) + "====hashCode==== " + this.hashCode() + "  " + string2 + "    hashCode  " + this.hashCode());
                string = "failed";
                ProtocolSender.this.mErrorCode = 120103102;
                ProtocolSender.this.mErrorMsg = "sink is not response";
            } else {
                byte[] byArray3 = null;
                try {
                    byArray3 = lelinkEncrypt.decryptData(byArray2);
                }
                catch (Exception exception) {
                    ProtocolSender.this.mErrorCode = 120103102;
                    ProtocolSender.this.mErrorMsg = CLog.getExceptionStr(exception);
                    CLog.w(ProtocolSender.TAG, exception);
                }
                string = byArray3 != null ? new String(byArray3) : "failed";
            }
            return string;
        }

        private void lelinkConnectStateCallback(LelinkEncrypt lelinkEncrypt, ProtocolListener protocolListener) {
            if (!this.mStartListen) {
                if (lelinkEncrypt.getEncryptState().equals("failed")) {
                    protocolListener.onResult(protocolListener.cmdType, "encrypt_failed");
                } else if (lelinkEncrypt.getEncryptState().equals("603")) {
                    protocolListener.onResult(protocolListener.cmdType, "603");
                } else if (lelinkEncrypt.getEncryptState().equals("453")) {
                    protocolListener.onResult(protocolListener.cmdType, "453");
                }
            } else {
                protocolListener.onResult(protocolListener.cmdType, "successful");
            }
        }

        private void closeSender() {
            if (ProtocolSender.this.mLocalFileOutputStream != null) {
                try {
                    ProtocolSender.this.mLocalFileOutputStream.close();
                }
                catch (IOException iOException) {
                    CLog.w(ProtocolSender.TAG, iOException);
                }
            }
            if (ProtocolSender.this.mLocalAutoCloseInputStream != null) {
                try {
                    ProtocolSender.this.mLocalAutoCloseInputStream.close();
                }
                catch (IOException iOException) {
                    CLog.w(ProtocolSender.TAG, iOException);
                }
            }
            if (ProtocolSender.this.mSocket != null) {
                try {
                    ProtocolSender.this.mSocket.close();
                    CLog.d(ProtocolSender.TAG, ProtocolSender.this.mSocket.isClosed() + "");
                }
                catch (IOException iOException) {
                    CLog.w(ProtocolSender.TAG, iOException);
                }
            }
            ProtocolSender.this.mSocket = null;
            ProtocolSender.this.mLocalFileOutputStream = null;
            ProtocolSender.this.mLocalAutoCloseInputStream = null;
            if (this.mDlnaController != null) {
                this.mDlnaController.close();
                this.mDlnaController = null;
            }
            if (this.mModuleLinker != null) {
                this.mModuleLinker.removeObjOfMemory("B1F46D77496F190485B51E2EAA834265");
                this.mModuleLinker = null;
            }
        }
    }
}

